/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Supplier;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Suppliers;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ArrayListMultimap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.analysis.TypeChecker;
import shadow.bundletool.com.android.tools.r8.ir.analysis.constant.SparseConditionalConstantPropagation;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldaccess.FieldBitAccessAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.FieldValueAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.AlwaysMaterializingDefinition;
import shadow.bundletool.com.android.tools.r8.ir.code.AlwaysMaterializingUser;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CodeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.conversion.LambdaMethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.LensCodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.conversion.MethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.PostMethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.PrimaryMethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.StringSwitchRemover;
import shadow.bundletool.com.android.tools.r8.ir.desugar.BackportedMethodRewriter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.CovariantReturnTypeAnnotationTransformer;
import shadow.bundletool.com.android.tools.r8.ir.desugar.D8NestBasedAccessDesugaring;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryAPIConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaRewriter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.StringConcatRewriter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.TwrCloseResourceRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.AliasIntroducer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.AssertionsRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Assumer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.ClassInitializerDefaultsOptimization;
import shadow.bundletool.com.android.tools.r8.ir.optimize.CodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.ConstantCanonicalizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.DeadCodeRemover;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Devirtualizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.DynamicTypeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.optimize.IdempotentFunctionCallCanonicalizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.MemberValuePropagation;
import shadow.bundletool.com.android.tools.r8.ir.optimize.NonNullTracker;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Outliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.PeepholeOptimizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.RedundantFieldLoadElimination;
import shadow.bundletool.com.android.tools.r8.ir.optimize.ReflectionOptimizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.ServiceLoaderRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.UninstantiatedTypeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.ClassInliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.MethodOptimizationInfoCollector;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackDelayed;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaMerger;
import shadow.bundletool.com.android.tools.r8.ir.optimize.library.LibraryMethodOptimizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.staticizer.ClassStaticizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.string.StringBuilderOptimizer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.string.StringOptimizer;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.naming.IdentifierNameStringMarker;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.MethodPosition;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.LibraryMethodOverrideAnalysis;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexClasses;
import shadow.bundletool.com.android.tools.r8.utils.Action;
import shadow.bundletool.com.android.tools.r8.utils.CfgPrinter;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class IRConverter {
    private static final int PEEPHOLE_OPTIMIZATION_PASSES = 2;
    public final AppView<?> appView;
    public final Set<DexType> mainDexClasses;
    private final Timing timing;
    private final Outliner outliner;
    private final ClassInitializerDefaultsOptimization classInitializerDefaultsOptimization;
    private final FieldBitAccessAnalysis fieldBitAccessAnalysis;
    private final LibraryMethodOptimizer libraryMethodOptimizer;
    private final LibraryMethodOverrideAnalysis libraryMethodOverrideAnalysis;
    private final StringConcatRewriter stringConcatRewriter;
    private final StringOptimizer stringOptimizer;
    private final StringBuilderOptimizer stringBuilderOptimizer;
    private final IdempotentFunctionCallCanonicalizer idempotentFunctionCallCanonicalizer;
    private final LambdaRewriter lambdaRewriter;
    private final D8NestBasedAccessDesugaring d8NestBasedAccessDesugaring;
    private final InterfaceMethodRewriter interfaceMethodRewriter;
    private final TwrCloseResourceRewriter twrCloseResourceRewriter;
    private final BackportedMethodRewriter backportedMethodRewriter;
    private final LambdaMerger lambdaMerger;
    private final ClassInliner classInliner;
    private final ClassStaticizer classStaticizer;
    private final InternalOptions options;
    private final CfgPrinter printer;
    private final CodeRewriter codeRewriter;
    private final ConstantCanonicalizer constantCanonicalizer;
    private final MemberValuePropagation memberValuePropagation;
    private final LensCodeRewriter lensCodeRewriter;
    private final Inliner inliner;
    private final IdentifierNameStringMarker identifierNameStringMarker;
    private final Devirtualizer devirtualizer;
    private final CovariantReturnTypeAnnotationTransformer covariantReturnTypeAnnotationTransformer;
    private final StringSwitchRemover stringSwitchRemover;
    private final UninstantiatedTypeOptimization uninstantiatedTypeOptimization;
    private final TypeChecker typeChecker;
    private final DesugaredLibraryAPIConverter desugaredLibraryAPIConverter;
    private final ServiceLoaderRewriter serviceLoaderRewriter;
    public final Collection<Assumer> assumers = new ArrayList<Assumer>();
    private final DynamicTypeOptimization dynamicTypeOptimization;
    final AssertionsRewriter assertionsRewriter;
    final DeadCodeRemover deadCodeRemover;
    private final MethodOptimizationInfoCollector methodOptimizationInfoCollector;
    private final OptimizationFeedbackDelayed delayedOptimizationFeedback = new OptimizationFeedbackDelayed();
    private final OptimizationFeedback simpleOptimizationFeedback = OptimizationFeedbackSimple.getInstance();
    private DexString highestSortingString;
    private List<Action> onWaveDoneActions = null;
    private final List<DexString> neverMergePrefixes;
    boolean seenNotNeverMergePrefix = false;
    boolean seenNeverMergePrefix = false;

    public IRConverter(AppView<?> appView, Timing timing, CfgPrinter printer, MainDexClasses mainDexClasses) {
        assert (((AppInfo)appView.appInfo()).hasLiveness() || appView.graphLense().isIdentityLense());
        assert (appView.options() != null);
        assert (appView.options().programConsumer != null);
        this.timing = timing != null ? timing : new Timing("internal");
        this.appView = appView;
        this.options = appView.options();
        this.printer = printer;
        this.mainDexClasses = mainDexClasses.getClasses();
        this.codeRewriter = new CodeRewriter(appView, this);
        this.constantCanonicalizer = new ConstantCanonicalizer();
        this.classInitializerDefaultsOptimization = this.options.debug ? null : new ClassInitializerDefaultsOptimization(appView, this);
        this.stringConcatRewriter = new StringConcatRewriter(appView);
        this.stringOptimizer = new StringOptimizer(appView);
        this.stringBuilderOptimizer = new StringBuilderOptimizer(appView);
        this.deadCodeRemover = new DeadCodeRemover(appView, this.codeRewriter);
        this.assertionsRewriter = new AssertionsRewriter(appView);
        this.idempotentFunctionCallCanonicalizer = new IdempotentFunctionCallCanonicalizer(appView);
        this.neverMergePrefixes = this.options.neverMergePrefixes.stream().map(prefix -> "L" + DescriptorUtils.getPackageBinaryNameFromJavaType(prefix)).map(this.options.itemFactory::createString).collect(Collectors.toList());
        if (this.options.isDesugaredLibraryCompilation()) {
            this.backportedMethodRewriter = new BackportedMethodRewriter(appView, this);
            this.interfaceMethodRewriter = this.options.desugaredLibraryConfiguration.getEmulateLibraryInterface().isEmpty() ? null : new InterfaceMethodRewriter(appView, this);
            this.lambdaRewriter = new LambdaRewriter(appView);
            this.desugaredLibraryAPIConverter = new DesugaredLibraryAPIConverter(appView);
            this.twrCloseResourceRewriter = null;
            this.lambdaMerger = null;
            this.covariantReturnTypeAnnotationTransformer = null;
            this.dynamicTypeOptimization = null;
            this.classInliner = null;
            this.classStaticizer = null;
            this.fieldBitAccessAnalysis = null;
            this.libraryMethodOptimizer = null;
            this.libraryMethodOverrideAnalysis = null;
            this.inliner = null;
            this.outliner = null;
            this.memberValuePropagation = null;
            this.lensCodeRewriter = null;
            this.identifierNameStringMarker = null;
            this.devirtualizer = null;
            this.uninstantiatedTypeOptimization = null;
            this.typeChecker = null;
            this.d8NestBasedAccessDesugaring = null;
            this.stringSwitchRemover = null;
            this.serviceLoaderRewriter = null;
            this.methodOptimizationInfoCollector = null;
            return;
        }
        this.lambdaRewriter = this.options.enableDesugaring ? new LambdaRewriter(appView) : null;
        this.interfaceMethodRewriter = this.options.isInterfaceMethodDesugaringEnabled() ? new InterfaceMethodRewriter(appView, this) : null;
        this.twrCloseResourceRewriter = this.options.enableDesugaring && this.enableTwrCloseResourceDesugaring() ? new TwrCloseResourceRewriter(appView, this) : null;
        this.backportedMethodRewriter = this.options.enableDesugaring ? new BackportedMethodRewriter(appView, this) : null;
        CovariantReturnTypeAnnotationTransformer covariantReturnTypeAnnotationTransformer = this.covariantReturnTypeAnnotationTransformer = this.options.processCovariantReturnTypeAnnotations ? new CovariantReturnTypeAnnotationTransformer(this, appView.dexItemFactory()) : null;
        if (this.options.testing.forceAssumeNoneInsertion) {
            this.assumers.add(new AliasIntroducer(appView));
        }
        if (this.options.enableNonNullTracking) {
            this.assumers.add(new NonNullTracker(appView));
        }
        DesugaredLibraryAPIConverter desugaredLibraryAPIConverter = this.desugaredLibraryAPIConverter = appView.rewritePrefix.isRewriting() ? new DesugaredLibraryAPIConverter(appView) : null;
        if (appView.enableWholeProgramOptimizations()) {
            assert (((AppInfo)appView.appInfo()).hasLiveness());
            assert (appView.rootSet() != null);
            AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
            this.classInliner = this.options.enableClassInlining && this.options.enableInlining ? new ClassInliner(this.lambdaRewriter) : null;
            this.classStaticizer = this.options.enableClassStaticizer ? new ClassStaticizer(appViewWithLiveness, this) : null;
            DynamicTypeOptimization dynamicTypeOptimization = this.dynamicTypeOptimization = this.options.enableDynamicTypeOptimization ? new DynamicTypeOptimization(appViewWithLiveness) : null;
            if (this.dynamicTypeOptimization != null) {
                this.assumers.add(this.dynamicTypeOptimization);
            }
            this.fieldBitAccessAnalysis = this.options.enableFieldBitAccessAnalysis ? new FieldBitAccessAnalysis(appViewWithLiveness) : null;
            this.libraryMethodOptimizer = new LibraryMethodOptimizer(appViewWithLiveness);
            this.libraryMethodOverrideAnalysis = this.options.enableTreeShakingOfLibraryMethodOverrides ? new LibraryMethodOverrideAnalysis(appViewWithLiveness) : null;
            this.lambdaMerger = this.options.enableLambdaMerging ? new LambdaMerger(appViewWithLiveness) : null;
            this.lensCodeRewriter = new LensCodeRewriter(appViewWithLiveness);
            this.inliner = new Inliner(appViewWithLiveness, mainDexClasses, this.lambdaMerger, this.lensCodeRewriter);
            this.outliner = new Outliner(appViewWithLiveness);
            this.memberValuePropagation = this.options.enableValuePropagation ? new MemberValuePropagation(appViewWithLiveness) : null;
            this.methodOptimizationInfoCollector = new MethodOptimizationInfoCollector(appViewWithLiveness);
            this.identifierNameStringMarker = this.options.isMinifying() ? new IdentifierNameStringMarker(appViewWithLiveness) : null;
            this.devirtualizer = this.options.enableDevirtualization ? new Devirtualizer(appViewWithLiveness) : null;
            this.uninstantiatedTypeOptimization = this.options.enableUninstantiatedTypeOptimization ? new UninstantiatedTypeOptimization(appViewWithLiveness) : null;
            this.typeChecker = new TypeChecker(appView.withLiveness());
            this.d8NestBasedAccessDesugaring = null;
            this.serviceLoaderRewriter = this.options.enableServiceLoaderRewriting ? new ServiceLoaderRewriter(appView.withLiveness()) : null;
        } else {
            this.classInliner = null;
            this.classStaticizer = null;
            this.dynamicTypeOptimization = null;
            this.fieldBitAccessAnalysis = null;
            this.libraryMethodOptimizer = null;
            this.libraryMethodOverrideAnalysis = null;
            this.inliner = null;
            this.lambdaMerger = null;
            this.outliner = null;
            this.memberValuePropagation = null;
            this.lensCodeRewriter = null;
            this.identifierNameStringMarker = null;
            this.devirtualizer = null;
            this.uninstantiatedTypeOptimization = null;
            this.typeChecker = null;
            this.d8NestBasedAccessDesugaring = this.options.shouldDesugarNests() ? new D8NestBasedAccessDesugaring(appView) : null;
            this.serviceLoaderRewriter = null;
            this.methodOptimizationInfoCollector = null;
        }
        this.stringSwitchRemover = this.options.isStringSwitchConversionEnabled() ? new StringSwitchRemover(appView, this.identifierNameStringMarker) : null;
    }

    public Set<DexCallSite> getDesugaredCallSites() {
        if (this.lambdaRewriter != null) {
            return this.lambdaRewriter.getDesugaredCallSites();
        }
        return Collections.emptySet();
    }

    public IRConverter(AppView<?> appView, Timing timing) {
        this(appView, timing, null, MainDexClasses.NONE);
    }

    public IRConverter(AppView<?> appView, Timing timing, CfgPrinter printer) {
        this(appView, timing, printer, MainDexClasses.NONE);
    }

    public IRConverter(AppInfo appInfo, InternalOptions options, Timing timing, CfgPrinter printer) {
        this(AppView.createForD8(appInfo, options), timing, printer, MainDexClasses.NONE);
    }

    private boolean enableTwrCloseResourceDesugaring() {
        return this.enableTryWithResourcesDesugaring() && !this.options.canUseTwrCloseResourceMethod();
    }

    private boolean enableTryWithResourcesDesugaring() {
        switch (this.options.tryWithResourcesDesugaring) {
            case Off: {
                return false;
            }
            case Auto: {
                return !this.options.canUseSuppressedExceptions();
            }
        }
        throw new Unreachable();
    }

    private boolean removeLambdaDeserializationMethods() {
        if (this.lambdaRewriter != null) {
            return this.lambdaRewriter.removeLambdaDeserializationMethods(((AppInfo)this.appView.appInfo()).classes());
        }
        return false;
    }

    private void desugarNestBasedAccess(DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.d8NestBasedAccessDesugaring != null) {
            this.d8NestBasedAccessDesugaring.desugarNestBasedAccess(builder, executorService, this);
        }
    }

    private void synthesizeLambdaClasses(DexApplication.Builder<?> builder, OptimizationFeedback feedback, ExecutorService executorService) throws ExecutionException {
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.adjustAccessibility(this, feedback);
            this.lambdaRewriter.synthesizeLambdaClasses(builder);
            this.lambdaRewriter.optimizeSynthesizedClasses(this, executorService);
        }
    }

    private void staticizeClasses(OptimizationFeedback feedback, ExecutorService executorService) throws ExecutionException {
        if (this.classStaticizer != null) {
            this.classStaticizer.staticizeCandidates(feedback, executorService);
        }
    }

    private void collectStaticizerCandidates(DexApplication application) {
        if (this.classStaticizer != null) {
            this.classStaticizer.collectCandidates(application);
        }
    }

    private void desugarInterfaceMethods(DexApplication.Builder<?> builder, OptimizationFeedback feedback, InterfaceMethodRewriter.Flavor includeAllResources, ExecutorService executorService) throws ExecutionException {
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.desugarInterfaceMethods(builder, feedback, includeAllResources, executorService);
        }
    }

    private void synthesizeTwrCloseResourceUtilityClass(DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.twrCloseResourceRewriter != null) {
            this.twrCloseResourceRewriter.synthesizeUtilityClass(builder, executorService, this.options);
        }
    }

    private void synthesizeJava8UtilityClass(DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.backportedMethodRewriter != null) {
            this.backportedMethodRewriter.synthesizeUtilityClasses(builder, executorService);
        }
    }

    private void processCovariantReturnTypeAnnotations(DexApplication.Builder<?> builder) {
        if (this.covariantReturnTypeAnnotationTransformer != null) {
            this.covariantReturnTypeAnnotationTransformer.process(builder);
        }
    }

    public DexApplication convert(DexApplication application, ExecutorService executor) throws ExecutionException {
        this.removeLambdaDeserializationMethods();
        this.timing.begin("IR conversion");
        ThreadUtils.processItems(application.classes(), this::convertMethods, executor);
        DexApplication.Builder<?> builder = application.builder();
        builder.setHighestSortingString(this.highestSortingString);
        this.desugarNestBasedAccess(builder, executor);
        this.synthesizeLambdaClasses(builder, this.simpleOptimizationFeedback, executor);
        this.desugarInterfaceMethods(builder, this.simpleOptimizationFeedback, InterfaceMethodRewriter.Flavor.ExcludeDexResources, executor);
        this.synthesizeTwrCloseResourceUtilityClass(builder, executor);
        this.synthesizeJava8UtilityClass(builder, executor);
        this.processCovariantReturnTypeAnnotations(builder);
        this.generateDesugaredLibraryAPIWrappers(builder, executor);
        this.handleSynthesizedClassMapping(builder);
        this.timing.end();
        return builder.build();
    }

    private void handleSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        if (this.options.intermediate) {
            this.updateSynthesizedClassMapping(builder);
        }
        this.updateMainDexListWithSynthesizedClassMap(builder);
        if (!this.options.intermediate) {
            this.clearSynthesizedClassMapping(builder);
        }
    }

    private void updateMainDexListWithSynthesizedClassMap(DexApplication.Builder<?> builder) {
        Set<DexType> inputMainDexList = builder.getMainDexList();
        if (!inputMainDexList.isEmpty()) {
            Map programClasses = builder.getProgramClasses().stream().collect(Collectors.toMap(programClass -> programClass.type, Function.identity()));
            ArrayList<DexType> synthesized = new ArrayList<DexType>();
            for (DexType dexType : inputMainDexList) {
                DexProgramClass programClass2 = (DexProgramClass)programClasses.get(dexType);
                if (programClass2 == null) continue;
                synthesized.addAll(DexAnnotation.readAnnotationSynthesizedClassMap(programClass2, builder.dexItemFactory));
            }
            builder.addToMainDexList(synthesized);
        }
    }

    private void clearSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        for (DexProgramClass programClass : builder.getProgramClasses()) {
            programClass.annotations = programClass.annotations.getWithout(builder.dexItemFactory.annotationSynthesizedClassMap);
        }
    }

    private void updateSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        ArrayListMultimap<DexProgramClass, DexProgramClass> originalToSynthesized = ArrayListMultimap.create();
        for (DexProgramClass dexProgramClass2 : builder.getSynthesizedClasses()) {
            for (DexProgramClass original : dexProgramClass2.getSynthesizedFrom()) {
                originalToSynthesized.put(original, dexProgramClass2);
            }
        }
        for (Map.Entry entry : originalToSynthesized.asMap().entrySet()) {
            DexProgramClass original = (DexProgramClass)entry.getKey();
            TreeSet<DexType> synthesized = new TreeSet<DexType>(DexType::slowCompareTo);
            ((Collection)entry.getValue()).stream().map(dexProgramClass -> dexProgramClass.type).forEach(synthesized::add);
            synthesized.addAll(DexAnnotation.readAnnotationSynthesizedClassMap(original, builder.dexItemFactory));
            DexAnnotation updatedAnnotation = DexAnnotation.createAnnotationSynthesizedClassMap(synthesized, builder.dexItemFactory);
            original.annotations = original.annotations.getWithAddedOrReplaced(updatedAnnotation);
        }
    }

    private void convertMethods(DexProgramClass clazz) {
        boolean isReachabilitySensitive = clazz.hasReachabilitySensitiveAnnotation(this.options.itemFactory);
        for (DexEncodedMethod method2 : clazz.directMethods()) {
            if (!method2.isClassInitializer()) continue;
            method2.getMutableOptimizationInfo().setReachabilitySensitive(isReachabilitySensitive);
            this.convertMethod(method2);
            break;
        }
        clazz.forEachMethod(method -> {
            if (!method.isClassInitializer()) {
                method.getMutableOptimizationInfo().setReachabilitySensitive(isReachabilitySensitive);
                this.convertMethod((DexEncodedMethod)method);
            }
        });
    }

    private void convertMethod(DexEncodedMethod method) {
        boolean matchesMethodFilter;
        if (method.getCode() != null && (matchesMethodFilter = this.options.methodMatchesFilter(method))) {
            if (this.appView.options().enableNeverMergePrefixes) {
                for (DexString neverMergePrefix : this.neverMergePrefixes) {
                    if (method.method.holder.isD8R8SynthesizedClassType()) continue;
                    if (method.method.holder.descriptor.startsWith(neverMergePrefix)) {
                        this.seenNeverMergePrefix = true;
                    } else {
                        this.seenNotNeverMergePrefix = true;
                    }
                    if (!this.seenNeverMergePrefix || !this.seenNotNeverMergePrefix) continue;
                    StringBuilder message = new StringBuilder();
                    message.append("Merging dex file containing classes with prefix").append(this.neverMergePrefixes.size() > 1 ? "es " : " ");
                    for (int i = 0; i < this.neverMergePrefixes.size(); ++i) {
                        message.append("'").append(this.neverMergePrefixes.get(0).toString().substring(1).replace('/', '.')).append("'").append(i < this.neverMergePrefixes.size() - 1 ? ", " : "");
                    }
                    message.append(" with classes with any other prefixes is not allowed.");
                    throw new CompilationError(message.toString());
                }
            }
            if (this.options.isGeneratingClassFiles() || !this.options.passthroughDexCode || !method.getCode().isDexCode()) {
                this.rewriteCode(method, this.simpleOptimizationFeedback, OneTimeMethodProcessor.getInstance(ImmutableList.of(method)));
            } else assert (method.getCode().isDexCode());
            if (!this.options.isGeneratingClassFiles()) {
                this.updateHighestSortingStrings(method);
            }
        }
    }

    public DexApplication optimize() throws ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            DexApplication dexApplication = this.optimize(executor);
            return dexApplication;
        }
        finally {
            executor.shutdown();
        }
    }

    public DexApplication optimize(ExecutorService executorService) throws ExecutionException {
        if (this.options.isShrinking()) {
            assert (!this.removeLambdaDeserializationMethods());
        } else {
            this.removeLambdaDeserializationMethods();
        }
        DexApplication application = ((AppInfo)this.appView.appInfo()).app();
        this.computeReachabilitySensitivity(application);
        this.collectLambdaMergingCandidates(application);
        this.collectStaticizerCandidates(application);
        this.printPhase("Primary optimization pass");
        GraphLense graphLenseForIR = this.appView.graphLense();
        OptimizationFeedbackDelayed feedback = this.delayedOptimizationFeedback;
        PostMethodProcessor.Builder postMethodProcessorBuilder = new PostMethodProcessor.Builder(this.getOptimizationsForPostIRProcessing());
        this.timing.begin("Build call graph");
        PrimaryMethodProcessor primaryMethodProcessor = PrimaryMethodProcessor.create(this.appView.withLiveness(), postMethodProcessorBuilder, executorService, this.timing);
        this.timing.end();
        this.timing.begin("IR conversion phase 1");
        if (this.outliner != null) {
            this.outliner.createOutlineMethodIdentifierGenerator();
        }
        primaryMethodProcessor.forEachMethod(method -> this.processMethod((DexEncodedMethod)method, feedback, primaryMethodProcessor), this::waveStart, this::waveDone, executorService);
        this.timing.end();
        assert (graphLenseForIR == this.appView.graphLense());
        assert (feedback.noUpdatesLeft());
        this.appView.setAllCodeProcessed();
        if (this.libraryMethodOverrideAnalysis != null) {
            this.libraryMethodOverrideAnalysis.finish();
        }
        this.printPhase("Post optimization pass");
        if (this.appView.callSiteOptimizationInfoPropagator() != null) {
            postMethodProcessorBuilder.put(this.appView.callSiteOptimizationInfoPropagator());
        }
        if (this.inliner != null) {
            postMethodProcessorBuilder.put(this.inliner);
        }
        this.timing.begin("IR conversion phase 2");
        assert (graphLenseForIR == this.appView.graphLense());
        PostMethodProcessor postMethodProcessor = postMethodProcessorBuilder.build(this.appView.withLiveness(), executorService, this.timing);
        if (postMethodProcessor != null) {
            postMethodProcessor.forEachWave(feedback, executorService);
            feedback.updateVisibleOptimizationInfo();
            assert (graphLenseForIR == this.appView.graphLense());
        }
        this.timing.end();
        if (!this.options.isGeneratingClassFiles()) {
            this.printPhase("Class staticizer post processing");
            this.staticizeClasses(feedback, executorService);
            feedback.updateVisibleOptimizationInfo();
        }
        DexApplication.Builder<?> builder = application.builder();
        builder.setHighestSortingString(this.highestSortingString);
        this.printPhase("Lambda class synthesis");
        this.synthesizeLambdaClasses(builder, feedback, executorService);
        this.printPhase("Interface method desugaring");
        this.desugarInterfaceMethods(builder, feedback, InterfaceMethodRewriter.Flavor.IncludeAllResources, executorService);
        feedback.updateVisibleOptimizationInfo();
        this.printPhase("Twr close resource utility class synthesis");
        this.synthesizeTwrCloseResourceUtilityClass(builder, executorService);
        this.synthesizeJava8UtilityClass(builder, executorService);
        this.handleSynthesizedClassMapping(builder);
        this.printPhase("Lambda merging finalization");
        this.finalizeLambdaMerging(application, feedback, builder, executorService);
        this.printPhase("Desugared library API Conversion finalization");
        this.generateDesugaredLibraryAPIWrappers(builder, executorService);
        if (this.serviceLoaderRewriter != null && this.serviceLoaderRewriter.getSynthesizedClass() != null) {
            this.processSynthesizedServiceLoaderMethods(this.serviceLoaderRewriter.getSynthesizedClass(), executorService);
            builder.addSynthesizedClass(this.serviceLoaderRewriter.getSynthesizedClass(), true);
        }
        feedback.updateVisibleOptimizationInfo();
        if (this.outliner != null) {
            this.printPhase("Outlining");
            this.timing.begin("IR conversion phase 3");
            if (this.outliner.selectMethodsForOutlining()) {
                this.forEachSelectedOutliningMethod(code -> {
                    this.printMethod((IRCode)code, "IR before outlining (SSA)", null);
                    this.outliner.identifyOutlineSites((IRCode)code);
                }, executorService);
                DexProgramClass outlineClass = this.outliner.buildOutlinerClass(this.computeOutlineClassType());
                ((AppInfo)this.appView.appInfo()).addSynthesizedClass(outlineClass);
                this.optimizeSynthesizedClass(outlineClass, executorService);
                this.forEachSelectedOutliningMethod(code -> {
                    this.outliner.applyOutliningCandidate((IRCode)code);
                    this.printMethod((IRCode)code, "IR after outlining (SSA)", null);
                    this.finalizeIR(code.method, (IRCode)code, OptimizationFeedbackIgnore.getInstance());
                }, executorService);
                feedback.updateVisibleOptimizationInfo();
                assert (this.outliner.checkAllOutlineSitesFoundAgain());
                builder.addSynthesizedClass(outlineClass, true);
                this.clearDexMethodCompilationState(outlineClass);
            }
            this.timing.end();
        }
        this.clearDexMethodCompilationState();
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInFields(executorService);
        }
        if (Log.ENABLED) {
            if (this.appView.callSiteOptimizationInfoPropagator() != null) {
                this.appView.callSiteOptimizationInfoPropagator().logResults();
            }
            this.constantCanonicalizer.logResults();
            if (this.idempotentFunctionCallCanonicalizer != null) {
                this.idempotentFunctionCallCanonicalizer.logResults();
            }
            if (this.libraryMethodOverrideAnalysis != null) {
                this.libraryMethodOverrideAnalysis.logResults();
            }
            if (this.uninstantiatedTypeOptimization != null) {
                this.uninstantiatedTypeOptimization.logResults();
            }
            if (this.stringOptimizer != null) {
                this.stringOptimizer.logResult();
            }
            if (this.stringBuilderOptimizer != null) {
                this.stringBuilderOptimizer.logResults();
            }
        }
        assert (feedback.noUpdatesLeft());
        assert (((AppInfo)this.appView.appInfo()).getSynthesizedClassesForSanityCheck().containsAll(builder.getSynthesizedClasses()) && builder.getSynthesizedClasses().containsAll(((AppInfo)this.appView.appInfo()).getSynthesizedClassesForSanityCheck()));
        return builder.build();
    }

    private void waveStart(Collection<DexEncodedMethod> wave, ExecutorService executorService) throws ExecutionException {
        this.onWaveDoneActions = Collections.synchronizedList(new ArrayList());
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.synthesizeLambdaClassesForWave(wave, executorService, this.delayedOptimizationFeedback, this.lensCodeRewriter, this);
        }
    }

    private void waveDone() {
        this.delayedOptimizationFeedback.updateVisibleOptimizationInfo();
        this.onWaveDoneActions.forEach(Action::execute);
        this.onWaveDoneActions = null;
    }

    public void addWaveDoneAction(Action action) {
        if (!this.appView.enableWholeProgramOptimizations()) {
            throw new Unreachable("addWaveDoneAction() should never be used in D8.");
        }
        if (!this.isInWave()) {
            throw new Unreachable("Attempt to call addWaveDoneAction() outside of wave.");
        }
        this.onWaveDoneActions.add(action);
    }

    public boolean isInWave() {
        return this.onWaveDoneActions != null;
    }

    private void computeReachabilitySensitivity(DexApplication application) {
        application.classes().forEach(c -> {
            if (c.hasReachabilitySensitiveAnnotation(this.options.itemFactory)) {
                c.methods().forEach(m -> m.getMutableOptimizationInfo().setReachabilitySensitive(true));
            }
        });
    }

    private void forEachSelectedOutliningMethod(Consumer<IRCode> consumer, ExecutorService executorService) throws ExecutionException {
        assert (!this.options.skipIR);
        Set<DexEncodedMethod> methods = this.outliner.getMethodsSelectedForOutlining();
        ThreadUtils.processItems(methods, method -> {
            IRCode code = method.buildIR(this.appView, ((AppInfo)this.appView.appInfo()).originFor(method.method.holder));
            assert (code != null);
            assert (!method.getCode().isOutlineCode());
            this.codeRewriter.rewriteMoveResult(code);
            this.deadCodeRemover.run(code);
            CodeRewriter.removeAssumeInstructions(this.appView, code);
            consumer.accept(code);
        }, executorService);
    }

    private void processSynthesizedServiceLoaderMethods(DexClass synthesizedClass, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(synthesizedClass.methods(), this::forEachSynthesizedServiceLoaderMethod, executorService);
    }

    private void forEachSynthesizedServiceLoaderMethod(DexEncodedMethod method) {
        IRCode code = method.buildIR(this.appView, ((AppInfo)this.appView.appInfo()).originFor(method.method.holder));
        assert (code != null);
        this.codeRewriter.rewriteMoveResult(code);
        this.finalizeIR(method, code, OptimizationFeedbackIgnore.getInstance());
    }

    private void collectLambdaMergingCandidates(DexApplication application) {
        if (this.lambdaMerger != null) {
            this.lambdaMerger.collectGroupCandidates(application);
        }
    }

    private void finalizeLambdaMerging(DexApplication application, OptimizationFeedback feedback, DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.lambdaMerger != null) {
            this.lambdaMerger.applyLambdaClassMapping(application, this, feedback, builder, executorService);
        }
    }

    private void generateDesugaredLibraryAPIWrappers(DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.desugaredLibraryAPIConverter != null) {
            this.desugaredLibraryAPIConverter.generateWrappers(builder, this, executorService);
        }
    }

    private void clearDexMethodCompilationState() {
        ((AppInfo)this.appView.appInfo()).classes().forEach(this::clearDexMethodCompilationState);
    }

    private void clearDexMethodCompilationState(DexProgramClass clazz) {
        clazz.forEachMethod(DexEncodedMethod::markNotProcessed);
    }

    public void replaceCodeForTesting(DexEncodedMethod method, IRCode code) {
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Initial (SSA) flow graph for %s:\n%s", method.toSourceString(), code);
        }
        assert (code.isConsistentSSA());
        code.traceBlocks();
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.appView);
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Resulting dex code for %s:\n%s", method.toSourceString(), this.logCode(this.options, method));
        }
    }

    private DexType computeOutlineClassType() {
        String name;
        DexType result;
        int count = 0;
        String tempPrefix = this.appView.options().desugaredLibraryConfiguration.getSynthesizedLibraryClassesPackagePrefix(this.appView);
        String prefix = tempPrefix.replace('/', '.');
        do {
            name = prefix + "shadow.bundletool.com.android.tools.r8.GeneratedOutlineSupport" + (count == 0 ? "" : Integer.toString(count));
            ++count;
        } while (this.appView.definitionFor(result = this.appView.dexItemFactory().createType(DescriptorUtils.javaTypeToDescriptor(name))) != null);
        return result;
    }

    public void optimizeSynthesizedClass(DexProgramClass clazz, ExecutorService executorService) throws ExecutionException {
        Set<DexEncodedMethod> methods = Sets.newIdentityHashSet();
        clazz.forEachMethod(methods::add);
        this.processMethodsConcurrently(methods, executorService);
    }

    public void optimizeSynthesizedClasses(Collection<DexProgramClass> classes, ExecutorService executorService) throws ExecutionException {
        Set<DexEncodedMethod> methods = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : classes) {
            clazz.forEachMethod(methods::add);
        }
        this.processMethodsConcurrently(methods, executorService);
    }

    public void optimizeSynthesizedLambdaClasses(Collection<DexProgramClass> classes, ExecutorService executorService) throws ExecutionException {
        assert (this.appView.enableWholeProgramOptimizations());
        Set<DexEncodedMethod> methods = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : classes) {
            clazz.forEachMethod(methods::add);
        }
        LambdaMethodProcessor processor = new LambdaMethodProcessor(this.appView.withLiveness(), methods, executorService, this.timing);
        processor.forEachMethod(method -> this.processMethod((DexEncodedMethod)method, this.delayedOptimizationFeedback, processor), this.delayedOptimizationFeedback::updateVisibleOptimizationInfo, executorService);
    }

    public void optimizeSynthesizedMethod(DexEncodedMethod method) {
        if (!method.isProcessed()) {
            this.processMethod(method, this.delayedOptimizationFeedback, OneTimeMethodProcessor.getInstance());
        }
    }

    public void processMethodsConcurrently(Collection<DexEncodedMethod> methods, ExecutorService executorService) throws ExecutionException {
        OneTimeMethodProcessor processor = OneTimeMethodProcessor.getInstance(methods);
        processor.forEachWave(method -> this.processMethod((DexEncodedMethod)method, this.delayedOptimizationFeedback, processor), executorService);
    }

    private String logCode(InternalOptions options, DexEncodedMethod method) {
        return options.useSmaliSyntax ? method.toSmaliString(null) : method.codeToString();
    }

    List<CodeOptimization> getOptimizationsForPrimaryIRProcessing() {
        return ImmutableList.of(this::optimize);
    }

    List<CodeOptimization> getOptimizationsForPostIRProcessing() {
        return ImmutableList.of(this::optimize);
    }

    public void processMethod(DexEncodedMethod method, OptimizationFeedback feedback, MethodProcessor methodProcessor) {
        Code code = method.getCode();
        boolean matchesMethodFilter = this.options.methodMatchesFilter(method);
        if (code != null && matchesMethodFilter) {
            this.rewriteCode(method, feedback, methodProcessor);
        } else {
            method.markProcessed(Inliner.ConstraintWithTarget.NEVER);
        }
    }

    private static void invertConditionalsForTesting(IRCode code) {
        for (BasicBlock block : code.blocks) {
            if (!block.exit().isIf()) continue;
            block.exit().asIf().invert();
        }
    }

    private void rewriteCode(DexEncodedMethod method, OptimizationFeedback feedback, MethodProcessor methodProcessor) {
        Origin origin = ((AppInfo)this.appView.appInfo()).originFor(method.method.holder);
        try {
            this.rewriteCodeInternal(method, feedback, methodProcessor, origin);
        }
        catch (CompilationError e) {
            throw e.withAdditionalOriginAndPositionInfo(origin, new MethodPosition(method.method));
        }
        catch (NullPointerException e) {
            throw new CompilationError("NullPointerException during IR Conversion", (Throwable)e, origin, new MethodPosition(method.method));
        }
    }

    private void rewriteCodeInternal(DexEncodedMethod method, OptimizationFeedback feedback, MethodProcessor methodProcessor, Origin origin) {
        if (this.options.verbose) {
            this.options.reporter.info(new StringDiagnostic("Processing: " + method.toSourceString()));
        }
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Original code for %s:\n%s", method.toSourceString(), this.logCode(this.options, method));
        }
        if (this.options.skipIR) {
            feedback.markProcessed(method, Inliner.ConstraintWithTarget.NEVER);
            return;
        }
        IRCode code = method.buildIR(this.appView, origin);
        if (code == null) {
            feedback.markProcessed(method, Inliner.ConstraintWithTarget.NEVER);
            return;
        }
        this.optimize(code, feedback, methodProcessor);
    }

    private void optimize(IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor) {
        boolean isDebugMode;
        DexEncodedMethod method = code.method;
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Initial (SSA) flow graph for %s:\n%s", method.toSourceString(), code);
        }
        this.printC1VisualizerHeader(method);
        String previous = this.printMethod(code, "Initial IR (SSA)", null);
        if (this.options.testing.irModifier != null) {
            this.options.testing.irModifier.accept(code);
        }
        if (this.options.canHaveArtStringNewInitBug()) {
            CodeRewriter.ensureDirectStringNewToInit(code, this.appView.dexItemFactory());
        }
        boolean bl = isDebugMode = this.options.debug || method.getOptimizationInfo().isReachabilitySensitive();
        if (isDebugMode) {
            this.codeRewriter.simplifyDebugLocals(code);
        }
        if (!method.isProcessed()) {
            if (this.lensCodeRewriter != null) {
                this.lensCodeRewriter.rewrite(code, method);
            } else assert (this.appView.graphLense().isIdentityLense());
            if (this.lambdaRewriter != null) {
                this.lambdaRewriter.desugarLambdas(method, code);
                assert (code.isConsistentSSA());
            }
        }
        if (this.lambdaMerger != null) {
            this.lambdaMerger.rewriteCode(method, code, this.inliner);
            assert (code.isConsistentSSA());
        }
        if (this.typeChecker != null && !this.typeChecker.check(code)) {
            assert (this.appView.enableWholeProgramOptimizations());
            assert (this.options.testing.allowTypeErrors);
            StringDiagnostic warning = new StringDiagnostic("The method `" + method.toSourceString() + "` does not type check and will be assumed to be unreachable.");
            this.options.reporter.warning(warning);
            this.finalizeEmptyThrowingCode(method, feedback);
            return;
        }
        assert (code.verifyTypes(this.appView));
        if (this.serviceLoaderRewriter != null) {
            assert (((AppInfo)this.appView.appInfo()).hasLiveness());
            this.serviceLoaderRewriter.rewrite(code);
        }
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInMethod(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.memberValuePropagation != null) {
            this.memberValuePropagation.rewriteWithConstantValues(code, method.method.holder);
        }
        if (this.options.enableEnumValueOptimization) {
            assert (this.appView.enableWholeProgramOptimizations());
            this.codeRewriter.removeSwitchMaps(code);
        }
        this.assertionsRewriter.run(method, code);
        previous = this.printMethod(code, "IR after disable assertions (SSA)", previous);
        CodeRewriter.insertAssumeInstructions(code, this.assumers);
        previous = this.printMethod(code, "IR after inserting assume instructions (SSA)", previous);
        this.appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.rewriteCode(method, code));
        previous = this.printMethod(code, "IR after generated extension registry shrinking (SSA)", previous);
        this.appView.withGeneratedMessageLiteShrinker(shrinker -> shrinker.run(method, code));
        previous = this.printMethod(code, "IR after generated message lite shrinking (SSA)", previous);
        if (!isDebugMode && this.options.enableInlining && this.inliner != null) {
            this.inliner.performInlining(method, code, feedback, methodProcessor);
            assert (code.verifyTypes(this.appView));
        }
        previous = this.printMethod(code, "IR after inlining (SSA)", previous);
        if (((AppInfo)this.appView.appInfo()).hasLiveness()) {
            ReflectionOptimizer.rewriteGetClassOrForNameToConstClass(this.appView.withLiveness(), code);
        }
        if (!isDebugMode) {
            if (this.options.enableNameReflectionOptimization || this.options.testing.forceNameReflectionOptimization) {
                this.stringOptimizer.rewriteClassGetName(this.appView, code);
            }
            this.stringOptimizer.computeTrivialOperationsOnConstString(code);
            this.stringOptimizer.removeTrivialConversions(code);
            if (this.libraryMethodOptimizer != null) {
                this.libraryMethodOptimizer.optimize(code, feedback, methodProcessor);
            }
            assert (code.isConsistentSSA());
        }
        if (this.devirtualizer != null) {
            assert (code.verifyTypes(this.appView));
            this.devirtualizer.devirtualizeInvokeInterface(code, method.method.holder);
        }
        if (this.uninstantiatedTypeOptimization != null) {
            this.uninstantiatedTypeOptimization.rewrite(code);
        }
        assert (code.verifyTypes(this.appView));
        this.codeRewriter.removeTrivialCheckCastAndInstanceOfInstructions(code);
        if (this.options.enableEnumValueOptimization) {
            assert (this.appView.enableWholeProgramOptimizations());
            this.codeRewriter.rewriteConstantEnumMethodCalls(code);
        }
        this.codeRewriter.rewriteKnownArrayLengthCalls(code);
        this.codeRewriter.rewriteAssertionErrorTwoArgumentConstructor(code, this.options);
        this.codeRewriter.commonSubexpressionElimination(code);
        this.codeRewriter.simplifyArrayConstruction(code);
        this.codeRewriter.rewriteMoveResult(code);
        if (this.options.enableStringConcatenationOptimization && !isDebugMode && this.options.isGeneratingDex()) {
            this.stringBuilderOptimizer.computeTrivialStringConcatenation(code);
        }
        this.codeRewriter.splitRangeInvokeConstants(code);
        new SparseConditionalConstantPropagation(code).run();
        if (this.stringSwitchRemover != null) {
            this.stringSwitchRemover.run(method, code);
        }
        this.codeRewriter.processMethodsNeverReturningNormally(code);
        if (this.codeRewriter.simplifyControlFlow(code)) {
            this.codeRewriter.removeTrivialCheckCastAndInstanceOfInstructions(code);
        }
        if (this.options.enableRedundantConstNumberOptimization) {
            this.codeRewriter.redundantConstNumberRemoval(code);
        }
        if (RedundantFieldLoadElimination.shouldRun(this.appView, code)) {
            new RedundantFieldLoadElimination(this.appView, code).run();
        }
        if (this.options.testing.invertConditionals) {
            IRConverter.invertConditionalsForTesting(code);
        }
        this.codeRewriter.rewriteThrowNullPointerException(code);
        if (this.classInitializerDefaultsOptimization != null && !isDebugMode) {
            this.classInitializerDefaultsOptimization.optimize(method, code);
        }
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Intermediate (SSA) flow graph for %s:\n%s", method.toSourceString(), code);
        }
        this.deadCodeRemover.run(code);
        assert (code.isConsistentSSA());
        if (this.options.enableDesugaring && this.enableTryWithResourcesDesugaring()) {
            this.codeRewriter.rewriteThrowableAddAndGetSuppressed(code);
        }
        if (this.backportedMethodRewriter != null) {
            this.backportedMethodRewriter.desugar(code);
        }
        this.stringConcatRewriter.desugarStringConcats(method.method, code);
        previous = this.printMethod(code, "IR after lambda desugaring (SSA)", previous);
        assert (code.verifyTypes(this.appView));
        previous = this.printMethod(code, "IR before class inlining (SSA)", previous);
        if (this.classInliner != null) {
            assert (this.options.enableInlining && this.inliner != null);
            this.classInliner.processMethodCode(this.appView.withLiveness(), this.codeRewriter, this.stringOptimizer, method, code, methodProcessor::isProcessedConcurrently, this.inliner, Suppliers.memoize(() -> this.inliner.createDefaultOracle(method, code, methodProcessor, this.options.classInliningInstructionLimit, -1)));
            assert (code.isConsistentSSA());
            assert (code.verifyTypes(this.appView));
        }
        previous = this.printMethod(code, "IR after class inlining (SSA)", previous);
        if (this.d8NestBasedAccessDesugaring != null) {
            this.d8NestBasedAccessDesugaring.rewriteNestBasedAccesses(method, code, this.appView);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after nest based access desugaring (SSA)", previous);
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.rewriteMethodReferences(method, code);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after interface method rewriting (SSA)", previous);
        if (this.desugaredLibraryAPIConverter != null && (!this.appView.enableWholeProgramOptimizations() || methodProcessor.isPrimary())) {
            this.desugaredLibraryAPIConverter.desugar(code);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after desugared library API Conversion (SSA)", previous);
        if (this.twrCloseResourceRewriter != null) {
            this.twrCloseResourceRewriter.rewriteMethodCode(code);
        }
        assert (code.verifyTypes(this.appView));
        previous = this.printMethod(code, "IR after twr close resource rewriter (SSA)", previous);
        if (this.lambdaMerger != null) {
            this.lambdaMerger.analyzeCode(method, code);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after lambda merger (SSA)", previous);
        if (this.options.outline.enabled && this.outliner != null && methodProcessor.isPrimary()) {
            this.outliner.getOutlineMethodIdentifierGenerator().accept(code);
            assert (code.isConsistentSSA());
        }
        assert (code.verifyTypes(this.appView));
        previous = this.printMethod(code, "IR after outline handler (SSA)", previous);
        if (!this.options.isGeneratingClassFiles()) {
            this.constantCanonicalizer.canonicalize(this.appView, code);
            this.codeRewriter.useDedicatedConstantForLitInstruction(code);
            this.codeRewriter.shortenLiveRanges(code);
        }
        this.idempotentFunctionCallCanonicalizer.canonicalize(code);
        previous = this.printMethod(code, "IR after idempotent function call canonicalization (SSA)", previous);
        if (this.options.methodMatchesLogArgumentsFilter(method)) {
            this.codeRewriter.logArgumentTypes(method, code);
            assert (code.isConsistentSSA());
        }
        previous = this.printMethod(code, "IR after argument type logging (SSA)", previous);
        if (this.classStaticizer != null) {
            this.classStaticizer.examineMethodCode(method, code);
        }
        assert (code.verifyTypes(this.appView));
        if (this.appView.enableWholeProgramOptimizations()) {
            if (this.libraryMethodOverrideAnalysis != null) {
                this.libraryMethodOverrideAnalysis.analyze(code);
            }
            if (this.fieldBitAccessAnalysis != null) {
                this.fieldBitAccessAnalysis.recordFieldAccesses(code, feedback);
            }
            if (!isDebugMode && this.appView.callSiteOptimizationInfoPropagator() != null) {
                this.appView.callSiteOptimizationInfoPropagator().collectCallSiteOptimizationInfo(code);
            }
            this.collectOptimizationInfo(code, feedback);
        }
        if (!this.assumers.isEmpty()) {
            CodeRewriter.removeAssumeInstructions(this.appView, code);
            assert (code.isConsistentSSA());
        }
        assert (code.verifyNoNullabilityBottomTypes());
        assert (code.verifyTypes(this.appView));
        previous = this.printMethod(code, "IR after computation of optimization info summary (SSA)", previous);
        if (this.options.canHaveNumberConversionRegisterAllocationBug()) {
            this.codeRewriter.workaroundNumberConversionRegisterAllocationBug(code);
        }
        if (methodProcessor.isPrimary()) assert (!method.getOptimizationInfo().useIdentifierNameString());
        this.printMethod(code, "Optimized IR (SSA)", previous);
        this.finalizeIR(method, code, feedback);
    }

    public void collectIdentifierNameStringUse(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            if (!((Instruction)iterator2.next()).isDexItemBasedConstString()) continue;
            feedback.markUseIdentifierNameString(method);
            break;
        }
    }

    public void collectOptimizationInfo(IRCode code, OptimizationFeedback feedback) {
        if (((AppInfo)this.appView.appInfo()).withLiveness().isPinned(code.method.method)) {
            return;
        }
        this.methodOptimizationInfoCollector.collectMethodOptimizationInfo(code.method, code, feedback, this.dynamicTypeOptimization);
        FieldValueAnalysis.run(this.appView, code, feedback, code.method);
    }

    public void finalizeIR(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        this.collectIdentifierNameStringUse(method, code, feedback);
        code.traceBlocks();
        if (this.options.isGeneratingClassFiles()) {
            this.finalizeToCf(method, code, feedback);
        } else {
            assert (this.options.isGeneratingDex());
            this.finalizeToDex(method, code, feedback);
        }
    }

    private void finalizeEmptyThrowingCode(DexEncodedMethod method, OptimizationFeedback feedback) {
        assert (this.options.isGeneratingClassFiles() || this.options.isGeneratingDex());
        Code emptyThrowingCode = this.options.isGeneratingClassFiles() ? method.buildEmptyThrowingCfCode() : method.buildEmptyThrowingDexCode();
        method.setCode(emptyThrowingCode, this.appView);
        feedback.markProcessed(method, Inliner.ConstraintWithTarget.ALWAYS);
    }

    private void finalizeToCf(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        assert (!method.getCode().isDexCode());
        CfBuilder builder = new CfBuilder(this.appView, method, code);
        CfCode result = builder.build(this.codeRewriter);
        method.setCode(result, this.appView);
        this.markProcessed(method, code, feedback);
    }

    private void finalizeToDex(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        CodeRewriter.disableDex2OatInliningForSelfRecursiveMethods(this.appView, code);
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.appView);
        this.updateHighestSortingStrings(method);
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Resulting dex code for %s:\n%s", method.toSourceString(), this.logCode(this.options, method));
        }
        this.printMethod(code, "Final IR (non-SSA)", null);
        this.markProcessed(method, code, feedback);
    }

    private void markProcessed(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        Inliner.ConstraintWithTarget state = !this.options.enableInlining || this.inliner == null || method.getOptimizationInfo().isReachabilitySensitive() ? Inliner.ConstraintWithTarget.NEVER : this.inliner.computeInliningConstraint(code, method);
        feedback.markProcessed(method, state);
    }

    private synchronized void updateHighestSortingStrings(DexEncodedMethod method) {
        DexString highestSortingReferencedString = method.getCode().asDexCode().highestSortingString;
        if (highestSortingReferencedString != null && (this.highestSortingString == null || highestSortingReferencedString.slowCompareTo(this.highestSortingString) > 0)) {
            this.highestSortingString = highestSortingReferencedString;
        }
    }

    private RegisterAllocator performRegisterAllocation(IRCode code, DexEncodedMethod method) {
        this.deadCodeRemover.run(code);
        this.materializeInstructionBeforeLongOperationsWorkaround(code);
        this.workaroundForwardingInitializerBug(code);
        LinearScanRegisterAllocator registerAllocator = new LinearScanRegisterAllocator(this.appView, code);
        registerAllocator.allocateRegisters();
        if (this.options.canHaveExceptionTargetingLoopHeaderBug()) {
            this.codeRewriter.workaroundExceptionTargetingLoopHeaderBug(code);
        }
        this.printMethod(code, "After register allocation (non-SSA)", null);
        for (int i = 0; i < 2; ++i) {
            CodeRewriter.collapseTrivialGotos(code);
            PeepholeOptimizer.optimize(code, registerAllocator);
        }
        CodeRewriter.removeUnneededMovesOnExitingPaths(code, registerAllocator);
        CodeRewriter.collapseTrivialGotos(code);
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Final (non-SSA) flow graph for %s:\n%s", method.toSourceString(), code);
        }
        return registerAllocator;
    }

    private void workaroundForwardingInitializerBug(IRCode code) {
        if (!this.options.canHaveForwardingInitInliningBug()) {
            return;
        }
        if (!code.method.isInstanceInitializer()) {
            return;
        }
        DexTypeList paramTypes = code.method.method.proto.parameters;
        if (paramTypes.size() != 3 || paramTypes.values[0] != this.options.itemFactory.doubleType || paramTypes.values[1] != this.options.itemFactory.doubleType || !paramTypes.values[2].isClassType()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator(code);
            Instruction superConstructorCall = it.nextUntil(i -> i.isInvokeDirect() && i.asInvokeDirect().getInvokedMethod().name == this.options.itemFactory.constructorMethodName && i.asInvokeDirect().arguments().size() == 4 && i.asInvokeDirect().arguments().stream().allMatch(Value::isArgument));
            if (superConstructorCall == null) continue;
            IRConverter.ensureInstructionBefore(code, superConstructorCall, it);
            break;
        }
    }

    private void materializeInstructionBeforeLongOperationsWorkaround(IRCode code) {
        if (!this.options.canHaveDex2OatLinkedListBug()) {
            return;
        }
        DexItemFactory factory = this.options.itemFactory;
        Supplier<DexMethod> javaLangLangSignum = Suppliers.memoize(() -> factory.createMethod(factory.createString("Ljava/lang/Long;"), factory.createString("signum"), factory.intDescriptor, new DexString[]{factory.longDescriptor}));
        for (BasicBlock block : code.blocks) {
            Instruction secondMaterializing;
            InstructionListIterator it = block.listIterator(code);
            Instruction firstMaterializing = it.nextUntil(IRConverter::isNotPseudoInstruction);
            if (!IRConverter.isLongMul(firstMaterializing) || !IRConverter.isLongAddOrSub(secondMaterializing = it.nextUntil(IRConverter::isNotPseudoInstruction)) || IRConverter.isFallthoughTarget(block)) continue;
            Value outOfMul = firstMaterializing.outValue();
            for (Value inOfAddOrSub : secondMaterializing.inValues()) {
                if (!IRConverter.isAliasOf(inOfAddOrSub, outOfMul)) continue;
                it = block.listIterator(code);
                it.nextUntil(i -> i == firstMaterializing);
                Value longValue = firstMaterializing.inValues().get(0);
                InvokeStatic invokeLongSignum = new InvokeStatic((DexMethod)javaLangLangSignum.get(), null, Collections.singletonList(longValue));
                this.ensureThrowingInstructionBefore(code, firstMaterializing, it, invokeLongSignum);
                return;
            }
        }
    }

    private static boolean isAliasOf(Value usedValue, Value definingValue) {
        while (usedValue != definingValue) {
            Instruction definition = usedValue.definition;
            if (definition == null || !definition.isMove()) {
                return false;
            }
            usedValue = definition.asMove().src();
        }
        return true;
    }

    private static boolean isNotPseudoInstruction(Instruction instruction) {
        return !instruction.isDebugInstruction() && !instruction.isMove();
    }

    private static boolean isLongMul(Instruction instruction) {
        return instruction != null && instruction.isMul() && instruction.asBinop().getNumericType() == NumericType.LONG && instruction.outValue() != null;
    }

    private static boolean isLongAddOrSub(Instruction instruction) {
        return instruction != null && (instruction.isAdd() || instruction.isSub()) && instruction.asBinop().getNumericType() == NumericType.LONG;
    }

    private static boolean isFallthoughTarget(BasicBlock block) {
        for (BasicBlock pred : block.getPredecessors()) {
            if (pred.exit().fallthroughBlock() != block) continue;
            return true;
        }
        return false;
    }

    private void ensureThrowingInstructionBefore(IRCode code, Instruction addBefore, InstructionListIterator it, Instruction instruction) {
        Instruction check = (Instruction)it.previous();
        assert (addBefore == check);
        BasicBlock block = check.getBlock();
        if (block.hasCatchHandlers()) {
            BasicBlock split = it.split(code);
            assert (split.hasCatchHandlers());
            assert (!block.hasCatchHandlers());
            it = block.listIterator(code, block.getInstructions().size() - 1);
        }
        instruction.setPosition(addBefore.getPosition());
        it.add(instruction);
    }

    private static void ensureInstructionBefore(IRCode code, Instruction addBefore, InstructionListIterator it) {
        Instruction check = (Instruction)it.previous();
        assert (addBefore == check);
        Value fixitValue = code.createValue(TypeLatticeElement.INT);
        AlwaysMaterializingDefinition fixitDefinition = new AlwaysMaterializingDefinition(fixitValue);
        fixitDefinition.setBlock(addBefore.getBlock());
        fixitDefinition.setPosition(addBefore.getPosition());
        it.add(fixitDefinition);
        AlwaysMaterializingUser fixitUser = new AlwaysMaterializingUser(fixitValue);
        fixitUser.setBlock(addBefore.getBlock());
        fixitUser.setPosition(addBefore.getPosition());
        it.add(fixitUser);
    }

    private void printC1VisualizerHeader(DexEncodedMethod method) {
        if (this.printer != null) {
            this.printer.begin("compilation");
            this.printer.print("name \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("method \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("date 0").ln();
            this.printer.end("compilation");
        }
    }

    private void printPhase(String phase) {
        if (!this.options.extensiveLoggingFilter.isEmpty()) {
            System.out.println("Entering phase: " + phase);
        }
    }

    private String printMethod(IRCode code, String title, String previous) {
        if (this.printer != null) {
            this.printer.resetUnusedValue();
            this.printer.begin("cfg");
            this.printer.print("name \"").append(title).append("\"\n");
            code.print(this.printer);
            this.printer.end("cfg");
        }
        if (this.options.extensiveLoggingFilter.size() > 0 && this.options.extensiveLoggingFilter.contains(code.method.method.toSourceString())) {
            String current = code.toString();
            System.out.println();
            System.out.println("-----------------------------------------------------------------------");
            System.out.println(title);
            System.out.println("-----------------------------------------------------------------------");
            if (previous != null && previous.equals(current)) {
                System.out.println("Unchanged");
            } else {
                System.out.println(current);
            }
            System.out.println("-----------------------------------------------------------------------");
            return current;
        }
        return previous;
    }
}

