/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.com.google.gson.JsonArray;
import shadow.bundletool.com.android.tools.r8.com.google.gson.JsonElement;
import shadow.bundletool.com.android.tools.r8.com.google.gson.JsonObject;
import shadow.bundletool.com.android.tools.r8.com.google.gson.JsonParser;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryConfiguration;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class DesugaredLibraryConfigurationParser {
    private static final int MAX_SUPPORTED_VERSION = 3;
    private final DesugaredLibraryConfiguration.Builder configurationBuilder;
    private final Reporter reporter;
    private final boolean libraryCompilation;
    private final int minAPILevel;

    public DesugaredLibraryConfigurationParser(DexItemFactory dexItemFactory, Reporter reporter, boolean libraryCompilation, int minAPILevel) {
        this.reporter = reporter;
        this.configurationBuilder = DesugaredLibraryConfiguration.builder(dexItemFactory);
        this.minAPILevel = minAPILevel;
        this.libraryCompilation = libraryCompilation;
        if (libraryCompilation) {
            this.configurationBuilder.setLibraryCompilation();
        } else {
            this.configurationBuilder.setProgramCompilation();
        }
    }

    public DesugaredLibraryConfiguration parse(StringResource stringResource) {
        String jsonConfigString;
        try {
            jsonConfigString = stringResource.getString();
        }
        catch (Exception e) {
            throw this.reporter.fatalError(new StringDiagnostic("Cannot access desugared library configuration."));
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonConfig = parser.parse(jsonConfigString).getAsJsonObject();
        int version = jsonConfig.get("configuration_format_version").getAsInt();
        if (version > 3) {
            throw this.reporter.fatalError(new StringDiagnostic("Unsupported desugared library configuration version, please upgrade the D8/R8 compiler."));
        }
        if (version == 1) {
            this.reporter.warning(new StringDiagnostic("You are using an experimental version of the desugared library configuration, distributed only in the early canary versions. Please update for production releases and to fix this warning."));
        }
        if (jsonConfig.has("synthesized_library_classes_package_prefix")) {
            this.configurationBuilder.setSynthesizedLibraryClassesPackagePrefix(jsonConfig.get("synthesized_library_classes_package_prefix").getAsString());
        } else {
            this.reporter.warning(new StringDiagnostic("Missing package_prefix, falling back to j$/ prefix, update desugared library configuration."));
        }
        int required_compilation_api_level = jsonConfig.get("required_compilation_api_level").getAsInt();
        this.configurationBuilder.setRequiredCompilationAPILevel(AndroidApiLevel.getAndroidApiLevel(required_compilation_api_level));
        JsonArray jsonFlags = this.libraryCompilation ? jsonConfig.getAsJsonArray("library_flags") : jsonConfig.getAsJsonArray("program_flags");
        for (JsonElement jsonFlagSet : jsonFlags) {
            int api_level_below_or_equal = jsonFlagSet.getAsJsonObject().get("api_level_below_or_equal").getAsInt();
            if (this.minAPILevel > api_level_below_or_equal) continue;
            this.parseFlags(jsonFlagSet.getAsJsonObject());
        }
        if (jsonConfig.has("shrinker_config")) {
            JsonArray jsonKeepRules = jsonConfig.get("shrinker_config").getAsJsonArray();
            ArrayList<String> extraKeepRules = new ArrayList<String>(jsonKeepRules.size());
            for (JsonElement keepRule : jsonKeepRules) {
                extraKeepRules.add(keepRule.getAsString());
            }
            this.configurationBuilder.setExtraKeepRules(extraKeepRules);
        }
        return this.configurationBuilder.build();
    }

    private void parseFlags(JsonObject jsonFlagSet) {
        if (jsonFlagSet.has("rewrite_prefix")) {
            for (Map.Entry<String, JsonElement> rewritePrefix : jsonFlagSet.get("rewrite_prefix").getAsJsonObject().entrySet()) {
                this.configurationBuilder.putRewritePrefix(rewritePrefix.getKey(), rewritePrefix.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has("retarget_lib_member")) {
            for (Map.Entry<String, JsonElement> retarget : jsonFlagSet.get("retarget_lib_member").getAsJsonObject().entrySet()) {
                this.configurationBuilder.putRetargetCoreLibMember(retarget.getKey(), retarget.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has("backport")) {
            for (Map.Entry<String, JsonElement> backport : jsonFlagSet.get("backport").getAsJsonObject().entrySet()) {
                this.configurationBuilder.putBackportCoreLibraryMember(backport.getKey(), backport.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has("emulate_interface")) {
            for (Map.Entry<String, JsonElement> itf : jsonFlagSet.get("emulate_interface").getAsJsonObject().entrySet()) {
                this.configurationBuilder.putEmulateLibraryInterface(itf.getKey(), itf.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has("custom_conversion")) {
            for (Map.Entry<String, JsonElement> conversion : jsonFlagSet.get("custom_conversion").getAsJsonObject().entrySet()) {
                this.configurationBuilder.putCustomConversion(conversion.getKey(), conversion.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has("dont_rewrite")) {
            JsonArray dontRewrite = jsonFlagSet.get("dont_rewrite").getAsJsonArray();
            for (JsonElement rewrite : dontRewrite) {
                this.configurationBuilder.addDontRewriteInvocation(rewrite.getAsString());
            }
        }
    }
}

