/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.backports.BackportedMethods;
import shadow.bundletool.com.android.tools.r8.origin.SynthesizedOrigin;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public final class TwrCloseResourceRewriter {
    public static final String UTILITY_CLASS_NAME = "$r8$twr$utility";
    public static final String UTILITY_CLASS_DESCRIPTOR = "L$r8$twr$utility;";
    private final AppView<?> appView;
    private final IRConverter converter;
    private final DexMethod twrCloseResourceMethod;
    private final Set<DexProgramClass> referencingClasses = Sets.newConcurrentHashSet();

    public TwrCloseResourceRewriter(AppView<?> appView, IRConverter converter) {
        this.appView = appView;
        this.converter = converter;
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexType twrUtilityClass = dexItemFactory.createType(UTILITY_CLASS_DESCRIPTOR);
        DexProto twrCloseResourceProto = dexItemFactory.createProto(dexItemFactory.voidType, dexItemFactory.throwableType, dexItemFactory.objectType);
        this.twrCloseResourceMethod = dexItemFactory.createMethod(twrUtilityClass, twrCloseResourceProto, dexItemFactory.twrCloseResourceMethodName);
    }

    public static boolean isUtilityClassDescriptor(DexType type) {
        return type.descriptor.toString().equals(UTILITY_CLASS_DESCRIPTOR);
    }

    public void rewriteMethodCode(IRCode code) {
        InstructionListIterator iterator2 = code.instructionListIterator();
        Object appInfo = this.appView.appInfo();
        while (iterator2.hasNext()) {
            InvokeStatic invoke;
            Instruction instruction = (Instruction)iterator2.next();
            if (!instruction.isInvokeStatic() || !TwrCloseResourceRewriter.isSynthesizedCloseResourceMethod((invoke = instruction.asInvokeStatic()).getInvokedMethod(), this.appView)) continue;
            assert (invoke.outValue() == null);
            assert (invoke.inValues().size() == 2);
            iterator2.replaceCurrentInstruction(new InvokeStatic(this.twrCloseResourceMethod, null, invoke.inValues()));
            this.referencingClasses.add(((AppInfo)appInfo).definitionFor(code.method.method.holder).asProgramClass());
        }
    }

    public static boolean isSynthesizedCloseResourceMethod(DexMethod method, AppView<?> appView) {
        DexMethod original = appView.graphLense().getOriginalMethodSignature(method);
        assert (original != null);
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return original.name == dexItemFactory.twrCloseResourceMethodName && original.proto == dexItemFactory.twrCloseResourceMethodProto;
    }

    public void synthesizeUtilityClass(DexApplication.Builder<?> builder, ExecutorService executorService, InternalOptions options) throws ExecutionException {
        if (this.referencingClasses.isEmpty()) {
            return;
        }
        CfCode code = BackportedMethods.CloseResourceMethod_closeResourceImpl(options, this.twrCloseResourceMethod);
        MethodAccessFlags flags = MethodAccessFlags.fromSharedAccessFlags(4105, false);
        DexEncodedMethod method = new DexEncodedMethod(this.twrCloseResourceMethod, flags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)code, true);
        DexProgramClass utilityClass = new DexProgramClass(this.twrCloseResourceMethod.holder, null, new SynthesizedOrigin("twr utility class", this.getClass()), ClassAccessFlags.fromSharedAccessFlags(4097), this.appView.dexItemFactory().objectType, DexTypeList.empty(), null, null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, new DexEncodedMethod[]{method}, DexEncodedMethod.EMPTY_ARRAY, this.appView.dexItemFactory().getSkipNameValidationForTesting(), DexProgramClass::checksumFromType, this.referencingClasses);
        Object appInfo = this.appView.appInfo();
        boolean addToMainDexList = this.referencingClasses.stream().anyMatch(clazz -> appInfo.isInMainDexList(clazz.type));
        ((AppInfo)appInfo).addSynthesizedClass(utilityClass);
        this.converter.optimizeSynthesizedClass(utilityClass, executorService);
        builder.addSynthesizedClass(utilityClass, addToMainDexList);
    }
}

