/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

final class FieldValueHelper {
    private final DexField field;
    private final IRCode code;
    private final Instruction root;
    private final AppView<?> appView;
    private Value defaultValue = null;
    private final Map<BasicBlock, Value> ins = new IdentityHashMap<BasicBlock, Value>();
    private final Map<BasicBlock, Value> outs = new IdentityHashMap<BasicBlock, Value>();

    FieldValueHelper(DexField field, IRCode code, Instruction root, AppView<?> appView) {
        this.field = field;
        this.code = code;
        this.root = root;
        this.appView = appView;
        assert (root.hasOutValue());
        assert (root.outValue() == root.outValue().getAliasedValue());
    }

    void replaceValue(Value oldValue, Value newValue) {
        for (Map.Entry<BasicBlock, Value> entry : this.ins.entrySet()) {
            if (entry.getValue() != oldValue) continue;
            entry.setValue(newValue);
        }
        for (Map.Entry<BasicBlock, Value> entry : this.outs.entrySet()) {
            if (entry.getValue() != oldValue) continue;
            entry.setValue(newValue);
        }
    }

    Value getValueForFieldRead(BasicBlock block, Instruction valueUser) {
        assert (valueUser != null);
        Value value = this.getValueDefinedInTheBlock(block, valueUser);
        return value != null ? value : this.getOrCreateInValue(block);
    }

    private Value getOrCreateOutValue(BasicBlock block) {
        Value value = this.outs.get(block);
        if (value != null) {
            return value;
        }
        value = this.getValueDefinedInTheBlock(block, null);
        if (value == null) {
            value = this.getOrCreateInValue(block);
        }
        assert (value != null);
        this.outs.put(block, value);
        return value;
    }

    private Value getOrCreateInValue(BasicBlock block) {
        Value value = this.ins.get(block);
        if (value != null) {
            return value;
        }
        List<BasicBlock> predecessors = block.getPredecessors();
        if (predecessors.size() == 1) {
            value = this.getOrCreateOutValue(predecessors.get(0));
            this.ins.put(block, value);
        } else {
            Phi phi = new Phi(this.code.valueNumberGenerator.next(), block, TypeLatticeElement.fromDexType(this.field.type, Nullability.maybeNull(), this.appView), null, Phi.RegisterReadType.NORMAL);
            this.ins.put(block, phi);
            ArrayList<Value> operands = new ArrayList<Value>();
            for (BasicBlock predecessor : block.getPredecessors()) {
                operands.add(this.getOrCreateOutValue(predecessor));
            }
            phi.addOperands(operands, false);
            TypeLatticeElement phiType = phi.computePhiType(this.appView);
            assert (phiType.lessThanOrEqual(phi.getTypeLattice(), this.appView));
            phi.setTypeLattice(phiType);
            value = phi;
        }
        assert (value != null);
        return value;
    }

    private Value getValueDefinedInTheBlock(BasicBlock block, Instruction stopAt) {
        InstructionIterator iterator2 = stopAt == null ? block.iterator(block.getInstructions().size()) : block.iterator(stopAt);
        Instruction valueProducingInsn = null;
        while (iterator2.hasPrevious()) {
            Instruction instruction = iterator2.previous();
            assert (instruction != null);
            if (instruction != this.root && (!instruction.isInstancePut() || instruction.asInstancePut().getField() != this.field || instruction.asInstancePut().object().getAliasedValue() != this.root.outValue())) continue;
            valueProducingInsn = instruction;
            break;
        }
        if (valueProducingInsn == null) {
            return null;
        }
        if (valueProducingInsn.isInstancePut()) {
            return valueProducingInsn.asInstancePut().value();
        }
        assert (this.root == valueProducingInsn);
        if (this.defaultValue == null) {
            InstructionListIterator it = block.listIterator(this.code, this.root);
            if (this.field.type.isPrimitiveType()) {
                this.defaultValue = this.code.createValue(TypeLatticeElement.fromDexType(this.field.type, Nullability.definitelyNotNull(), this.appView));
                ConstNumber defaultValueInsn = new ConstNumber(this.defaultValue, 0L);
                defaultValueInsn.setPosition(this.root.getPosition());
                it.add(defaultValueInsn);
            } else {
                this.defaultValue = it.insertConstNullInstruction(this.code, this.appView.options());
            }
        }
        return this.defaultValue;
    }
}

