/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.inliner;

import java.util.IdentityHashMap;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueNumberGenerator;
import shadow.bundletool.com.android.tools.r8.origin.Origin;

public class InliningIRProvider {
    private final AppView<?> appView;
    private final DexEncodedMethod context;
    private final ValueNumberGenerator valueNumberGenerator;
    private final Map<InvokeMethod, IRCode> cache = new IdentityHashMap<InvokeMethod, IRCode>();

    public InliningIRProvider(AppView<?> appView, DexEncodedMethod context, IRCode code) {
        this.appView = appView;
        this.context = context;
        this.valueNumberGenerator = code.valueNumberGenerator;
    }

    public IRCode getInliningIR(InvokeMethod invoke, DexEncodedMethod method) {
        IRCode cached = this.cache.remove(invoke);
        if (cached != null) {
            return cached;
        }
        Position position = Position.getPositionForInlining(this.appView, invoke, this.context);
        Origin origin = ((AppInfo)this.appView.appInfo()).originFor(method.method.holder);
        return method.buildInliningIR(this.context, this.appView, this.valueNumberGenerator, position, origin);
    }

    public IRCode getAndCacheInliningIR(InvokeMethod invoke, DexEncodedMethod method) {
        IRCode inliningIR = this.getInliningIR(invoke, method);
        this.cacheInliningIR(invoke, inliningIR);
        return inliningIR;
    }

    public void cacheInliningIR(InvokeMethod invoke, IRCode code) {
        IRCode existing = this.cache.put(invoke, code);
        assert (existing == null);
    }

    public boolean verifyIRCacheIsEmpty() {
        assert (this.cache.isEmpty());
        return true;
    }
}

