/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.library;

import java.util.Set;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.library.LibraryMethodModelCollection;

public class BooleanMethodOptimizer
implements LibraryMethodModelCollection {
    private final AppView<? extends AppInfoWithSubtyping> appView;
    private final DexItemFactory dexItemFactory;

    BooleanMethodOptimizer(AppView<? extends AppInfoWithSubtyping> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
    }

    @Override
    public DexType getType() {
        return this.dexItemFactory.boxedBooleanType;
    }

    @Override
    public void optimize(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke, DexEncodedMethod singleTarget, Set<Value> affectedValues) {
        if (singleTarget.method == this.dexItemFactory.booleanMembers.booleanValue) {
            this.optimizeBooleanValue(code, instructionIterator, invoke);
        } else if (singleTarget.method == this.dexItemFactory.booleanMembers.valueOf) {
            this.optimizeValueOf(code, instructionIterator, invoke, affectedValues);
        }
    }

    private void optimizeBooleanValue(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke) {
        Instruction definition;
        Value argument = invoke.arguments().get(0).getAliasedValue();
        if (!argument.isPhi() && (definition = argument.definition).isStaticGet()) {
            StaticGet staticGet = definition.asStaticGet();
            DexField field = staticGet.getField();
            if (field == this.dexItemFactory.booleanMembers.TRUE) {
                instructionIterator.replaceCurrentInstructionWithConstInt(this.appView, code, 1);
            } else if (field == this.dexItemFactory.booleanMembers.FALSE) {
                instructionIterator.replaceCurrentInstructionWithConstInt(this.appView, code, 0);
            }
        }
    }

    private void optimizeValueOf(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke, Set<Value> affectedValues) {
        Value argument = invoke.arguments().get(0);
        AbstractValue abstractValue = argument.getAbstractValue(this.appView, code.method.method.holder);
        if (abstractValue.isSingleNumberValue()) {
            instructionIterator.replaceCurrentInstructionWithStaticGet(this.appView, code, abstractValue.asSingleNumberValue().getBooleanValue() ? this.dexItemFactory.booleanMembers.TRUE : this.dexItemFactory.booleanMembers.FALSE, affectedValues);
        }
    }
}

