/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Load;
import shadow.bundletool.com.android.tools.r8.ir.code.StackValue;
import shadow.bundletool.com.android.tools.r8.ir.code.StackValues;
import shadow.bundletool.com.android.tools.r8.ir.code.Store;
import shadow.bundletool.com.android.tools.r8.ir.code.Swap;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.Match;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.Point;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.Wildcard;

public class StoreSequenceLoadPeephole
implements BasicBlockPeephole {
    private Store store;
    private int stackHeight = 0;
    private final Point storeExp = new Point(i -> {
        if (!i.isStore() || i.asStore().src().getTypeLattice().isWidePrimitive() || i.outValue().hasLocalInfo() || i.asStore().outValue().numberOfAllUsers() != 1) {
            return false;
        }
        this.store = i.asStore();
        this.stackHeight = 0;
        return true;
    });
    private final Wildcard seqExp = new Wildcard(i -> {
        if (this.stackHeight == 1 && i.isLoad() && i.asLoad().src() == this.store.outValue()) {
            return false;
        }
        this.stackHeight -= PeepholeHelper.numberOfValuesConsumedFromStack(i);
        if (this.stackHeight < 0) {
            this.store = null;
            return false;
        }
        this.stackHeight += PeepholeHelper.numberOfValuesPutOnStack(i);
        return true;
    });
    private final Point loadExp = new Point(i -> this.store != null && i.isLoad() && !i.asLoad().src().hasLocalInfo() && i.asLoad().src() == this.store.outValue());
    private final PeepholeLayout layout = PeepholeLayout.lookForward(this.storeExp, this.seqExp, this.loadExp);

    @Override
    public boolean match(InstructionListIterator it) {
        Match match = this.layout.test(it);
        if (match == null || this.store == null) {
            return false;
        }
        Store store = this.storeExp.get(match).asStore();
        List<Instruction> seq = this.seqExp.get(match);
        Load load = this.loadExp.get(match).asLoad();
        Instruction last = seq.get(seq.size() - 1);
        StackValue lastOut = null;
        if (last.outValue() instanceof StackValue) {
            lastOut = (StackValue)last.outValue();
        } else if (last.outValue() instanceof StackValues) {
            StackValue[] stackValues = ((StackValues)last.outValue()).getStackValues();
            lastOut = stackValues[stackValues.length - 1];
        }
        if (lastOut == null || lastOut.getTypeLattice().isWidePrimitive()) {
            return false;
        }
        StackValue source = (StackValue)store.src();
        store.outValue().removeUser(load);
        load.outValue().replaceUsers(source);
        it.removeOrReplaceByDebugLocalRead();
        it.nextUntil(i -> i == load);
        StackValue swapLastOut = lastOut.duplicate(source.getHeight());
        StackValue swapSource = source.duplicate(swapLastOut.getHeight() + 1);
        source.replaceUsers(swapSource);
        lastOut.replaceUsers(swapLastOut);
        it.replaceCurrentInstruction(new Swap(swapLastOut, swapSource, source, lastOut));
        PeepholeHelper.resetNext(it, 2);
        return true;
    }

    @Override
    public boolean resetAfterMatch() {
        return false;
    }
}

