/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashBiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinMetadataRewriter;
import shadow.bundletool.com.android.tools.r8.naming.ApplyMappingError;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMinifier;
import shadow.bundletool.com.android.tools.r8.naming.ClassNamingForMapApplier;
import shadow.bundletool.com.android.tools.r8.naming.FieldNameMinifier;
import shadow.bundletool.com.android.tools.r8.naming.IdentifierMinifier;
import shadow.bundletool.com.android.tools.r8.naming.InternalNamingState;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.naming.MethodNameMinifier;
import shadow.bundletool.com.android.tools.r8.naming.MinifiedRenaming;
import shadow.bundletool.com.android.tools.r8.naming.Minifier;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.naming.SeedMapper;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.Timing;
import shadow.bundletool.com.android.tools.r8.utils.TriFunction;

public class ProguardMapMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory factory;
    private final SeedMapper seedMapper;
    private final Set<DexCallSite> desugaredCallSites;
    private final BiMap<DexType, DexString> mappedNames = HashBiMap.create();
    private final Set<DexClass> mappedClasses = new TreeSet<DexClass>((a, b) -> a.type.slowCompareTo(b.type));
    private final Map<DexReference, MemberNaming> memberNames = Maps.newIdentityHashMap();
    private final Map<DexType, DexString> syntheticCompanionClasses = Maps.newIdentityHashMap();
    private final Map<DexMethod, DexString> defaultInterfaceMethodImplementationNames = Maps.newIdentityHashMap();
    private final Map<DexMethod, DexString> additionalMethodNamings = Maps.newIdentityHashMap();
    private final Map<DexField, DexString> additionalFieldNamings = Maps.newIdentityHashMap();

    public ProguardMapMinifier(AppView<AppInfoWithLiveness> appView, SeedMapper seedMapper, Set<DexCallSite> desugaredCallSites) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.seedMapper = seedMapper;
        this.desugaredCallSites = desugaredCallSites;
    }

    public NamingLens run(ExecutorService executorService, Timing timing) throws ExecutionException {
        ArrayDeque<Map<DexReference, MemberNaming>> nonPrivateMembers = new ArrayDeque<Map<DexReference, MemberNaming>>();
        timing.begin("MappingInterfaces");
        TreeSet<DexClass> interfaces = new TreeSet<DexClass>((a, b) -> a.type.slowCompareTo(b.type));
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        for (DexClass dexClass : appInfo.app().asDirect().allClasses()) {
            if (!dexClass.isInterface()) continue;
            if (dexClass.interfaces.isEmpty()) {
                this.computeMapping(dexClass.type, nonPrivateMembers);
            }
            interfaces.add(dexClass);
        }
        assert (nonPrivateMembers.isEmpty());
        timing.end();
        timing.begin("MappingClasses");
        appInfo.forAllImmediateExtendsSubtypes(this.factory.objectType, subType -> {
            DexClass dexClass = this.appView.definitionFor((DexType)subType);
            if (dexClass != null && !dexClass.isInterface()) {
                this.computeMapping((DexType)subType, (Deque<Map<DexReference, MemberNaming>>)nonPrivateMembers);
            }
        });
        assert (nonPrivateMembers.isEmpty());
        timing.end();
        timing.begin("MappingDefaultInterfaceMethods");
        this.computeDefaultInterfaceMethodMethods();
        timing.end();
        this.appView.options().reporter.failIfPendingErrors();
        timing.begin("MinifyClasses");
        ClassNameMinifier classNameMinifier = new ClassNameMinifier(this.appView, new ApplyMappingClassNamingStrategy(this.appView, this.mappedNames), new Minifier.MinificationPackageNamingStrategy(this.appView), this.mappedClasses);
        ClassNameMinifier.ClassRenaming classRenaming = classNameMinifier.computeRenaming(timing, this.syntheticCompanionClasses);
        timing.end();
        ApplyMappingMemberNamingStrategy nameStrategy = new ApplyMappingMemberNamingStrategy(this.appView, this.memberNames);
        timing.begin("MinifyMethods");
        MethodNameMinifier.MethodRenaming methodRenaming = new MethodNameMinifier(this.appView, nameStrategy).computeRenaming(interfaces, this.desugaredCallSites, timing);
        methodRenaming.renaming.putAll(this.defaultInterfaceMethodImplementationNames);
        methodRenaming.renaming.putAll(this.additionalMethodNamings);
        timing.end();
        timing.begin("MinifyFields");
        FieldNameMinifier.FieldRenaming fieldRenaming = new FieldNameMinifier(this.appView, nameStrategy).computeRenaming(interfaces, timing);
        fieldRenaming.renaming.putAll(this.additionalFieldNamings);
        timing.end();
        this.appView.options().reporter.failIfPendingErrors();
        MinifiedRenaming lens = new MinifiedRenaming(this.appView, classRenaming, methodRenaming, fieldRenaming);
        timing.begin("MinifyIdentifiers");
        new IdentifierMinifier(this.appView, lens).run(executorService);
        timing.end();
        timing.begin("MinifyKotlinMetadata");
        new KotlinMetadataRewriter(this.appView, lens).run(executorService);
        timing.end();
        return lens;
    }

    private void computeMapping(DexType type, Deque<Map<DexReference, MemberNaming>> buildUpNames) {
        ClassNamingForMapApplier classNaming = this.seedMapper.getClassNaming(type);
        DexClass dexClass = this.appView.definitionFor(type);
        if (dexClass != null && (classNaming != null || dexClass.isProgramClass())) {
            this.mappedClasses.add(dexClass);
        }
        IdentityHashMap<DexReference, MemberNaming> nonPrivateMembers = new IdentityHashMap<DexReference, MemberNaming>();
        if (classNaming != null) {
            DexString mappedName = this.factory.createString(classNaming.renamedName);
            this.checkAndAddMappedNames(type, mappedName, classNaming.position);
            if (dexClass != null) {
                KotlinMetadataRewriter.removeKotlinMetadataFromRenamedClass(this.appView, dexClass);
            }
            classNaming.forAllMemberNaming(memberNaming -> this.addMemberNamings(type, (MemberNaming)memberNaming, (Map<DexReference, MemberNaming>)nonPrivateMembers, false));
        } else if (dexClass == null || !this.appView.options().isMinifying()) {
            this.checkAndAddMappedNames(type, type.descriptor, Position.UNKNOWN);
        } else if (this.appView.options().isMinifying() && this.appView.rootSet().mayNotBeMinified(type, this.appView)) {
            this.checkAndAddMappedNames(type, type.descriptor, Position.UNKNOWN);
        }
        for (Map<DexReference, MemberNaming> parentMembers : buildUpNames) {
            for (DexReference key : parentMembers.keySet()) {
                Descriptor parentReferenceOnCurrentType;
                Descriptor parentReference;
                if (key.isDexMethod()) {
                    parentReference = key.asDexMethod();
                    parentReferenceOnCurrentType = this.factory.createMethod(type, parentReference.proto, parentReference.name);
                    if (!this.memberNames.containsKey(parentReferenceOnCurrentType)) {
                        this.addMemberNaming(parentReferenceOnCurrentType, parentMembers.get(key), this.additionalMethodNamings);
                        continue;
                    }
                    DexEncodedMethod encodedMethod = this.appView.definitionFor((DexMethod)parentReferenceOnCurrentType);
                    assert (encodedMethod == null || encodedMethod.accessFlags.isStatic() || this.memberNames.get(parentReferenceOnCurrentType).getRenamedName().equals(parentMembers.get(key).getRenamedName()));
                    continue;
                }
                parentReference = key.asDexField();
                parentReferenceOnCurrentType = this.factory.createField(type, ((DexField)parentReference).type, ((DexField)parentReference).name);
                if (this.memberNames.containsKey(parentReferenceOnCurrentType)) continue;
                this.addMemberNaming(parentReferenceOnCurrentType, parentMembers.get(key), this.additionalFieldNamings);
            }
        }
        if (dexClass != null && (dexClass.isProgramClass() || dexClass.isAbstract())) {
            this.addNonPrivateInterfaceMappings(type, nonPrivateMembers, dexClass.interfaces.values);
        }
        if (nonPrivateMembers.size() > 0) {
            buildUpNames.addLast(nonPrivateMembers);
            this.appView.appInfo().forAllImmediateExtendsSubtypes(type, subType -> this.computeMapping((DexType)subType, buildUpNames));
            buildUpNames.removeLast();
        } else {
            this.appView.appInfo().forAllImmediateExtendsSubtypes(type, subType -> this.computeMapping((DexType)subType, buildUpNames));
        }
    }

    private void addNonPrivateInterfaceMappings(DexType type, Map<DexReference, MemberNaming> nonPrivateMembers, DexType[] interfaces) {
        for (DexType iface : interfaces) {
            DexClass ifaceClass;
            ClassNamingForMapApplier interfaceNaming = this.seedMapper.getClassNaming(iface);
            if (interfaceNaming != null) {
                interfaceNaming.forAllMemberNaming(memberNaming -> this.addMemberNamings(type, (MemberNaming)memberNaming, nonPrivateMembers, true));
            }
            if ((ifaceClass = this.appView.definitionFor(iface)) == null) continue;
            this.addNonPrivateInterfaceMappings(type, nonPrivateMembers, ifaceClass.interfaces.values);
        }
    }

    private void addMemberNamings(DexType type, MemberNaming memberNaming, Map<DexReference, MemberNaming> nonPrivateMembers, boolean addToAdditionalMaps) {
        MemberNaming.Signature signature = memberNaming.getOriginalSignature();
        assert (!signature.isQualified());
        if (signature instanceof MemberNaming.MethodSignature) {
            DexMethod originalMethod = ((MemberNaming.MethodSignature)signature).toDexMethod(this.factory, type);
            this.addMemberNaming(originalMethod, memberNaming, addToAdditionalMaps ? this.additionalMethodNamings : null);
            DexEncodedMethod encodedMethod = this.appView.definitionFor(originalMethod);
            if (encodedMethod == null || !encodedMethod.accessFlags.isPrivate()) {
                nonPrivateMembers.put(originalMethod, memberNaming);
            }
        } else {
            DexField originalField = ((MemberNaming.FieldSignature)signature).toDexField(this.factory, type);
            this.addMemberNaming(originalField, memberNaming, addToAdditionalMaps ? this.additionalFieldNamings : null);
            DexEncodedField encodedField = this.appView.definitionFor(originalField);
            if (encodedField == null || !encodedField.accessFlags.isPrivate()) {
                nonPrivateMembers.put(originalField, memberNaming);
            }
        }
    }

    private <T extends DexReference> void addMemberNaming(T member, MemberNaming memberNaming, Map<T, DexString> additionalMemberNamings) {
        assert (!this.memberNames.containsKey(member) || this.memberNames.get(member).getRenamedName().equals(memberNaming.getRenamedName()));
        this.memberNames.put(member, memberNaming);
        if (additionalMemberNamings != null) {
            DexString renamedName = this.factory.createString(memberNaming.getRenamedName());
            additionalMemberNamings.put(member, renamedName);
        }
    }

    private void checkAndAddMappedNames(DexType type, DexString mappedName, Position position) {
        if (this.mappedNames.inverse().containsKey(mappedName) && this.mappedNames.inverse().get(mappedName) != type) {
            this.appView.options().reporter.error(ApplyMappingError.mapToExistingClass(type.toString(), mappedName.toString(), position));
        } else {
            this.mappedNames.put(type, mappedName);
        }
    }

    private void computeDefaultInterfaceMethodMethods() {
        for (String key : this.seedMapper.getKeyset()) {
            DexClass dexClass;
            ClassNamingForMapApplier classNaming = this.seedMapper.getMapping(key);
            DexType type = this.factory.lookupType(this.factory.createString(key));
            if (type == null || (dexClass = this.appView.definitionFor(type)) != null) continue;
            this.computeDefaultInterfaceMethodMappingsForType(type, classNaming, this.syntheticCompanionClasses, this.defaultInterfaceMethodImplementationNames);
        }
    }

    private void computeDefaultInterfaceMethodMappingsForType(DexType type, ClassNamingForMapApplier classNaming, Map<DexType, DexString> syntheticCompanionClasses, Map<DexMethod, DexString> defaultInterfaceMethodImplementationNames) {
        if (!InterfaceMethodRewriter.isCompanionClassType(type)) {
            return;
        }
        DexClass interfaceType = this.appView.definitionFor(InterfaceMethodRewriter.getInterfaceClassType(type, this.factory));
        if (interfaceType == null || !interfaceType.isClasspathClass()) {
            return;
        }
        syntheticCompanionClasses.put(type, this.factory.createString(classNaming.renamedName));
        for (List namings : classNaming.getQualifiedMethodMembers().values()) {
            if (namings.size() != 1) continue;
            MemberNaming naming = (MemberNaming)namings.get(0);
            MemberNaming.MethodSignature signature = (MemberNaming.MethodSignature)naming.getOriginalSignature();
            if (!signature.name.startsWith(interfaceType.type.toSourceString())) continue;
            DexMethod defaultMethod = InterfaceMethodRewriter.defaultAsMethodOfCompanionClass(signature.toUnqualified().toDexMethod(this.factory, interfaceType.type), this.factory);
            assert (defaultMethod.holder == type);
            defaultInterfaceMethodImplementationNames.put(defaultMethod, this.factory.createString(naming.getRenamedName()));
        }
    }

    static class ApplyMappingMemberNamingStrategy
    extends Minifier.MinifierMemberNamingStrategy {
        private final Map<DexReference, MemberNaming> mappedNames;
        private final DexItemFactory factory;
        private final Reporter reporter;

        public ApplyMappingMemberNamingStrategy(AppView<?> appView, Map<DexReference, MemberNaming> mappedNames) {
            super(appView);
            this.mappedNames = mappedNames;
            this.factory = appView.dexItemFactory();
            this.reporter = appView.options().reporter;
        }

        @Override
        public DexString next(DexMethod method, InternalNamingState internalState, BiPredicate<DexString, DexMethod> isAvailable) {
            DexEncodedMethod definition = this.appView.definitionFor(method);
            DexString nextName = this.nextName(method, definition, method.name, method.holder, internalState, isAvailable, (x$0, x$1, x$2) -> super.next((DexMethod)x$0, (InternalNamingState)x$1, (BiPredicate<DexString, DexMethod>)x$2));
            assert (nextName == method.name || !definition.isClassInitializer());
            assert (nextName == method.name || !this.appView.definitionFor((DexType)method.holder).accessFlags.isAnnotation());
            return nextName;
        }

        @Override
        public DexString next(DexField field, InternalNamingState internalState, BiPredicate<DexString, DexField> isAvailable) {
            return this.nextName(field, this.appView.definitionFor(field), field.name, field.holder, internalState, isAvailable, (x$0, x$1, x$2) -> super.next((DexField)x$0, (InternalNamingState)x$1, (BiPredicate<DexString, DexField>)x$2));
        }

        private <T extends DexReference> DexString nextName(T reference, DexDefinition definition, DexString name, DexType holderType, InternalNamingState internalState, BiPredicate<DexString, T> isAvailable, TriFunction<T, InternalNamingState, BiPredicate<DexString, T>, DexString> generateName) {
            assert (definition.isDexEncodedMethod() || definition.isDexEncodedField());
            assert (definition.toReference() == reference);
            DexClass holder = this.appView.definitionFor(holderType);
            assert (holder != null);
            DexString reservedName = this.getReservedName(definition, name, holder);
            if (reservedName != null) {
                if (!isAvailable.test(reservedName, (DexString)((Object)reference))) {
                    this.reportReservationError(definition.toReference(), reservedName);
                }
                return reservedName;
            }
            assert (!this.mappedNames.containsKey(reference));
            assert (this.appView.rootSet().mayBeMinified(reference, this.appView));
            return generateName.apply(reference, internalState, isAvailable);
        }

        @Override
        public DexString getReservedName(DexEncodedMethod method, DexClass holder) {
            return this.getReservedName(method, method.method.name, holder);
        }

        @Override
        public DexString getReservedName(DexEncodedField field, DexClass holder) {
            return this.getReservedName(field, field.field.name, holder);
        }

        private DexString getReservedName(DexDefinition definition, DexString name, DexClass holder) {
            DexString reservedName;
            assert (definition.isDexEncodedMethod() || definition.isDexEncodedField());
            DexReference reference = definition.toReference();
            if (holder.isNotProgramClass()) {
                if (this.mappedNames.containsKey(reference)) {
                    return this.factory.createString(this.mappedNames.get(reference).getRenamedName());
                }
                return name;
            }
            assert (holder.isProgramClass());
            DexString dexString = reservedName = definition.isDexEncodedMethod() ? super.getReservedName(definition.asDexEncodedMethod(), holder) : super.getReservedName(definition.asDexEncodedField(), holder);
            if (reservedName != null) {
                return reservedName;
            }
            if (this.mappedNames.containsKey(reference)) {
                return this.factory.createString(this.mappedNames.get(reference).getRenamedName());
            }
            return null;
        }

        @Override
        public boolean allowMemberRenaming(DexClass holder) {
            return true;
        }

        void reportReservationError(DexReference source, DexString name) {
            MemberNaming memberNaming = this.mappedNames.get(source);
            assert (source.isDexMethod() || source.isDexField());
            ApplyMappingError applyMappingError = ApplyMappingError.mapToExistingMember(source.toSourceString(), name.toString(), memberNaming == null ? Position.UNKNOWN : memberNaming.position);
        }
    }

    static class ApplyMappingClassNamingStrategy
    extends Minifier.MinificationClassNamingStrategy {
        private final Map<DexType, DexString> mappings;

        ApplyMappingClassNamingStrategy(AppView<?> appView, Map<DexType, DexString> mappings) {
            super(appView);
            this.mappings = mappings;
        }

        @Override
        public DexString next(DexType type, char[] packagePrefix, InternalNamingState state, Predicate<DexString> isUsed) {
            assert (!this.mappings.containsKey(type));
            assert (this.appView.rootSet().mayBeMinified(type, this.appView));
            return super.next(type, packagePrefix, state, isUsed);
        }

        @Override
        public DexString reservedDescriptor(DexType type) {
            DexClass clazz = this.appView.definitionFor(type);
            if (clazz == null) {
                return type.descriptor;
            }
            if (clazz.isNotProgramClass() && this.mappings.containsKey(type)) {
                return this.mappings.get(type);
            }
            if (clazz.isProgramClass() && this.appView.rootSet().mayBeMinified(type, this.appView)) {
                if (this.mappings.containsKey(type)) {
                    return this.mappings.get(type);
                }
                return null;
            }
            if (!clazz.isProgramClass() || this.appView.rootSet().mayBeMinified(type, this.appView) || this.mappings.containsKey(type)) {
                // empty if block
            }
            return type.descriptor;
        }

        @Override
        public boolean isRenamedByApplyMapping(DexType type) {
            return this.mappings.containsKey(type);
        }
    }
}

