/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.shaking.ClassInlineRule;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.shaking.InlineRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardIfRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardMemberRule;
import shadow.bundletool.com.android.tools.r8.shaking.RootSetBuilder;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class IfRuleEvaluator {
    private final AppView<? extends AppInfoWithSubtyping> appView;
    private final ExecutorService executorService;
    private final List<Future<?>> futures = new ArrayList();
    private final Map<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>> ifRules;
    private final Set<DexEncodedField> liveFields;
    private final Set<DexEncodedMethod> liveMethods;
    private final Set<DexProgramClass> liveTypes;
    private final Enqueuer.Mode mode;
    private final RootSetBuilder rootSetBuilder;
    private final Set<DexEncodedMethod> targetedMethods;

    IfRuleEvaluator(AppView<? extends AppInfoWithSubtyping> appView, ExecutorService executorService, Map<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>> ifRules, Set<DexEncodedField> liveFields, Set<DexEncodedMethod> liveMethods, Set<DexProgramClass> liveTypes, Enqueuer.Mode mode, RootSetBuilder rootSetBuilder, Set<DexEncodedMethod> targetedMethods) {
        this.appView = appView;
        this.executorService = executorService;
        this.ifRules = ifRules;
        this.liveFields = liveFields;
        this.liveMethods = liveMethods;
        this.liveTypes = liveTypes;
        this.mode = mode;
        this.rootSetBuilder = rootSetBuilder;
        this.targetedMethods = targetedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootSetBuilder.ConsequentRootSet run() throws ExecutionException {
        this.appView.appInfo().app().timing.begin("Find consequent items for -if rules...");
        try {
            if (this.ifRules != null && !this.ifRules.isEmpty()) {
                Iterator<Map.Entry<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>>> it = this.ifRules.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>> ifRuleEntry = it.next();
                    ProguardIfRule ifRule = ifRuleEntry.getKey().get();
                    for (DexProgramClass clazz : ifRule.relevantCandidatesForRule(this.appView, this.appView.appInfo().classes())) {
                        if (!this.isEffectivelyLive(clazz)) continue;
                        if (this.appView.options().testing.measureProguardIfRuleEvaluations) {
                            ++this.appView.options().testing.proguardIfRuleEvaluationData.numberOfProguardIfRuleClassEvaluations;
                        }
                        if (this.evaluateClassForIfRule(ifRule, clazz, clazz)) {
                            ifRuleEntry.getValue().removeIf(memberRule -> {
                                this.registerClassCapture((ProguardIfRule)memberRule, clazz, clazz);
                                if (this.appView.options().testing.measureProguardIfRuleEvaluations) {
                                    ++this.appView.options().testing.proguardIfRuleEvaluationData.numberOfProguardIfRuleMemberEvaluations;
                                }
                                return this.evaluateIfRuleMembersAndMaterialize((ProguardIfRule)memberRule, clazz, clazz) && this.canRemoveSubsequentKeepRule((ProguardIfRule)memberRule);
                            });
                        }
                        if (!this.appView.options().enableVerticalClassMerging || this.appView.verticallyMergedClasses() == null) continue;
                        List<DexType> sources = this.appView.verticallyMergedClasses().getSourcesFor(clazz.type);
                        for (DexType sourceType : sources) {
                            DexClass sourceClass = this.appView.definitionFor(sourceType);
                            assert (sourceClass != null);
                            if (this.appView.options().testing.measureProguardIfRuleEvaluations) {
                                ++this.appView.options().testing.proguardIfRuleEvaluationData.numberOfProguardIfRuleClassEvaluations;
                            }
                            if (!this.evaluateClassForIfRule(ifRule, sourceClass, clazz)) continue;
                            ifRuleEntry.getValue().removeIf(memberRule -> {
                                this.registerClassCapture((ProguardIfRule)memberRule, sourceClass, clazz);
                                if (this.appView.options().testing.measureProguardIfRuleEvaluations) {
                                    ++this.appView.options().testing.proguardIfRuleEvaluationData.numberOfProguardIfRuleMemberEvaluations;
                                }
                                return this.evaluateIfRuleMembersAndMaterialize((ProguardIfRule)memberRule, sourceClass, clazz) && this.canRemoveSubsequentKeepRule((ProguardIfRule)memberRule);
                            });
                        }
                    }
                    if (!ifRuleEntry.getValue().isEmpty()) continue;
                    it.remove();
                }
                ThreadUtils.awaitFutures(this.futures);
            }
        }
        finally {
            this.appView.appInfo().app().timing.end();
        }
        return this.rootSetBuilder.buildConsequentRootSet();
    }

    private boolean canRemoveSubsequentKeepRule(ProguardIfRule rule) {
        return Iterables.isEmpty(rule.subsequentRule.getWildcards()) && this.appView.options().keptGraphConsumer == null;
    }

    private void registerClassCapture(ProguardIfRule memberRule, DexClass source, DexClass target) {
        boolean classNameResult = memberRule.getClassNames().matches(source.type);
        assert (classNameResult);
        if (memberRule.hasInheritanceClassName()) {
            boolean inheritanceResult = this.rootSetBuilder.satisfyInheritanceRule(target, memberRule);
            assert (inheritanceResult);
        }
    }

    private boolean isEffectivelyLive(DexProgramClass clazz) {
        if (this.liveTypes.contains(clazz)) {
            return true;
        }
        for (DexEncodedField field : clazz.fields()) {
            if (!field.getOptimizationInfo().valueHasBeenPropagated()) continue;
            return true;
        }
        for (DexEncodedMethod method : clazz.methods()) {
            if (!method.getOptimizationInfo().returnValueHasBeenPropagated()) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateClassForIfRule(ProguardIfRule rule, DexClass sourceClass, DexClass targetClass) {
        if (!RootSetBuilder.satisfyClassType(rule, sourceClass)) {
            return false;
        }
        if (!RootSetBuilder.satisfyAccessFlag(rule, sourceClass)) {
            return false;
        }
        if (!RootSetBuilder.satisfyAnnotation(rule, sourceClass)) {
            return false;
        }
        if (!rule.getClassNames().matches(sourceClass.type)) {
            return false;
        }
        if (rule.hasInheritanceClassName()) {
            return this.rootSetBuilder.satisfyInheritanceRule(sourceClass, rule);
        }
        return true;
    }

    private boolean evaluateIfRuleMembersAndMaterialize(ProguardIfRule rule, DexClass sourceClass, DexClass targetClass) {
        List<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
        if (memberKeepRules.isEmpty()) {
            this.materializeIfRule(rule, ImmutableSet.of(sourceClass.toReference()));
            return true;
        }
        Set filteredMembers = Sets.newIdentityHashSet();
        Iterables.addAll(filteredMembers, targetClass.fields(f -> (this.liveFields.contains(f) || f.getOptimizationInfo().valueHasBeenPropagated()) && this.appView.graphLense().getOriginalFieldSignature((DexField)f.field).holder == sourceClass.type));
        Iterables.addAll(filteredMembers, targetClass.methods(m -> (this.liveMethods.contains(m) || this.targetedMethods.contains(m) || m.getOptimizationInfo().returnValueHasBeenPropagated()) && this.appView.graphLense().getOriginalMethodSignature((DexMethod)m.method).holder == sourceClass.type));
        if (filteredMembers.size() < memberKeepRules.size()) {
            return false;
        }
        for (Set combination : Sets.combinations(filteredMembers, memberKeepRules.size())) {
            Collection fieldsInCombination = DexDefinition.filterDexEncodedField(combination.stream()).collect(Collectors.toList());
            Collection methodsInCombination = DexDefinition.filterDexEncodedMethod(combination.stream()).collect(Collectors.toList());
            boolean satisfied = memberKeepRules.stream().allMatch(memberRule -> this.rootSetBuilder.ruleSatisfiedByFields((ProguardMemberRule)memberRule, fieldsInCombination) || this.rootSetBuilder.ruleSatisfiedByMethods((ProguardMemberRule)memberRule, methodsInCombination));
            if (!satisfied) continue;
            this.materializeIfRule(rule, ImmutableSet.of(sourceClass.toReference()));
            if (!this.canRemoveSubsequentKeepRule(rule)) continue;
            return true;
        }
        return false;
    }

    private void materializeIfRule(ProguardIfRule rule, Set<DexReference> preconditions) {
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        ProguardIfRule materializedRule = rule.materialize(dexItemFactory, preconditions);
        if (this.mode.isInitialTreeShaking() && !rule.isUsed()) {
            InlineRule neverInlineRuleForCondition;
            ClassInlineRule neverClassInlineRuleForCondition = materializedRule.neverClassInlineRuleForCondition(dexItemFactory);
            if (neverClassInlineRuleForCondition != null) {
                this.rootSetBuilder.runPerRule(this.executorService, this.futures, neverClassInlineRuleForCondition, null);
            }
            if ((neverInlineRuleForCondition = materializedRule.neverInlineRuleForCondition(dexItemFactory)) != null) {
                this.rootSetBuilder.runPerRule(this.executorService, this.futures, neverInlineRuleForCondition, null);
            }
        }
        this.rootSetBuilder.runPerRule(this.executorService, this.futures, materializedRule.subsequentRule, materializedRule);
        rule.markAsUsed();
    }
}

