/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphEdgeInfo;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphNode;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.shaking.GraphReporter;

public abstract class KeepReason {
    public abstract GraphEdgeInfo.EdgeKind edgeKind();

    public abstract GraphNode getSourceNode(GraphReporter var1);

    static KeepReason annotatedOn(DexDefinition definition) {
        return new AnnotatedOn(definition);
    }

    static KeepReason instantiatedIn(DexEncodedMethod method) {
        return new InstatiatedIn(method);
    }

    public static KeepReason invokedViaSuperFrom(DexEncodedMethod from) {
        return new InvokedViaSuper(from);
    }

    public static KeepReason reachableFromLiveType(DexType type) {
        return new ReachableFromLiveType(type);
    }

    public static KeepReason invokedFrom(DexProgramClass holder, DexEncodedMethod method) {
        return new InvokedFrom(holder, method);
    }

    public static KeepReason invokedFromLambdaCreatedIn(DexEncodedMethod method) {
        return new InvokedFromLambdaCreatedIn(method);
    }

    public static KeepReason isLibraryMethod(DexProgramClass implementer, DexType libraryType) {
        return new IsLibraryMethod(implementer.type, libraryType);
    }

    public static KeepReason fieldReferencedIn(DexEncodedMethod method) {
        return new ReferencedFrom(method);
    }

    public static KeepReason referencedInAnnotation(DexItem holder) {
        return new ReferencedInAnnotation(holder);
    }

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    public static KeepReason targetedBySuperFrom(DexEncodedMethod from) {
        return new TargetedBySuper(from);
    }

    public static KeepReason reflectiveUseIn(DexEncodedMethod method) {
        return new ReflectiveUseFrom(method);
    }

    public static KeepReason methodHandleReferencedIn(DexEncodedMethod method) {
        return new MethodHandleReferencedFrom(method);
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.MethodHandleUseFrom;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReflectiveUseFrom;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        private final DexDefinition holder;

        private AnnotatedOn(DexDefinition holder) {
            this.holder = holder;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.AnnotatedOn;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            if (this.holder.isDexClass()) {
                return graphReporter.getClassGraphNode(this.holder.asDexClass().type);
            }
            if (this.holder.isDexEncodedField()) {
                return graphReporter.getFieldGraphNode(this.holder.asDexEncodedField().field);
            }
            assert (this.holder.isDexEncodedMethod());
            return graphReporter.getMethodGraphNode(this.holder.asDexEncodedMethod().method);
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final DexItem holder;

        private ReferencedInAnnotation(DexItem holder) {
            this.holder = holder;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReferencedInAnnotation;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getAnnotationGraphNode(this.holder);
        }
    }

    public static class IsLibraryMethod
    extends KeepReason {
        private final DexType implementer;
        private final DexType libraryType;

        private IsLibraryMethod(DexType implementer, DexType libraryType) {
            this.implementer = implementer;
            this.libraryType = libraryType;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.IsLibraryMethod;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.implementer);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final DexType type;

        private ReachableFromLiveType(DexType type) {
            this.type = type;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReachableFromLiveType;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReferencedFrom;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InvokedFromLambdaCreatedIn;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        private InvokedFrom(DexProgramClass holder, DexEncodedMethod method) {
            super(method);
            assert (holder.type == method.method.holder);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InvokedFrom;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.TargetedBySuper;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InvokedViaSuper;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InstantiatedIn;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final DexEncodedMethod method;

        private BasedOnOtherMethod(DexEncodedMethod method) {
            this.method = method;
        }

        abstract String getKind();

        public DexMethod getMethod() {
            return this.method.method;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getMethodGraphNode(this.method.method);
        }
    }
}

