/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexClasses;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexDirectReferenceTracer;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;

public class MainDexListBuilder {
    private final Set<DexType> roots;
    private final AppInfoWithSubtyping appInfo;
    private final Map<DexType, Boolean> annotationTypeContainEnum;
    private final DexApplication dexApplication;
    private final MainDexClasses.Builder mainDexClassesBuilder;

    public MainDexListBuilder(Set<DexProgramClass> roots, DexApplication application) {
        this.dexApplication = application;
        this.appInfo = new AppInfoWithSubtyping(this.dexApplication);
        this.roots = SetUtils.mapIdentityHashSet(roots, DexClass::getType);
        this.mainDexClassesBuilder = MainDexClasses.builder(this.appInfo).addRoots(this.roots);
        DexClass enumType = this.appInfo.definitionFor(this.appInfo.dexItemFactory().enumType);
        if (enumType == null) {
            throw new CompilationError("Tracing for legacy multi dex is not possible without all classpath libraries (java.lang.Enum is missing)");
        }
        DexClass annotationType = this.appInfo.definitionFor(this.appInfo.dexItemFactory().annotationType);
        if (annotationType == null) {
            throw new CompilationError("Tracing for legacy multi dex is not possible without all classpath libraries (java.lang.annotation.Annotation is missing)");
        }
        this.annotationTypeContainEnum = Maps.newHashMapWithExpectedSize(this.appInfo.subtypes(this.appInfo.dexItemFactory().annotationType).size());
    }

    public MainDexClasses run() {
        this.traceMainDexDirectDependencies();
        this.traceRuntimeAnnotationsWithEnumForMainDex();
        return this.mainDexClassesBuilder.build();
    }

    private void traceRuntimeAnnotationsWithEnumForMainDex() {
        for (DexProgramClass clazz : this.dexApplication.classes()) {
            DexType dexType = clazz.type;
            if (this.mainDexClassesBuilder.contains(dexType)) continue;
            if (this.isAnnotation(dexType) && this.isAnnotationWithEnum(dexType)) {
                this.addAnnotationsWithEnum(clazz);
                continue;
            }
            clazz.forEachAnnotation(annotation -> {
                if (!this.mainDexClassesBuilder.contains(dexType) && annotation.visibility == 1 && this.isAnnotationWithEnum(annotation.annotation.type)) {
                    this.addClassAnnotatedWithAnnotationWithEnum(dexType);
                }
            });
        }
    }

    private boolean isAnnotationWithEnum(DexType dexType) {
        Boolean value = this.annotationTypeContainEnum.get(dexType);
        if (value == null) {
            DexClass clazz = this.appInfo.definitionFor(dexType);
            if (clazz == null) {
                value = true;
            } else {
                value = false;
                for (DexEncodedMethod method : clazz.virtualMethods()) {
                    DexProto proto = method.method.proto;
                    if (!proto.parameters.isEmpty()) continue;
                    DexType valueType = proto.returnType.toBaseType(this.appInfo.dexItemFactory());
                    if (this.isEnum(valueType)) {
                        value = true;
                        break;
                    }
                    if (!this.isAnnotation(valueType) || !this.isAnnotationWithEnum(valueType)) continue;
                    value = true;
                    break;
                }
            }
            this.annotationTypeContainEnum.put(dexType, value);
        }
        return value;
    }

    private boolean isEnum(DexType valueType) {
        return this.appInfo.isSubtype(valueType, this.appInfo.dexItemFactory().enumType);
    }

    private boolean isAnnotation(DexType valueType) {
        return this.appInfo.isSubtype(valueType, this.appInfo.dexItemFactory().annotationType);
    }

    private boolean isProgramClass(DexType dexType) {
        DexClass clazz = this.appInfo.definitionFor(dexType);
        return clazz != null && clazz.isProgramClass();
    }

    private void traceMainDexDirectDependencies() {
        new MainDexDirectReferenceTracer(this.appInfo, this::addDirectDependency).run(this.roots);
    }

    private void addAnnotationsWithEnum(DexProgramClass clazz) {
        this.addDirectDependency(clazz);
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            DexType valueType;
            DexProto proto = method.method.proto;
            if (!proto.parameters.isEmpty() || !this.isEnum(valueType = proto.returnType.toBaseType(this.appInfo.dexItemFactory()))) continue;
            this.addDirectDependency(valueType);
        }
    }

    private void addClassAnnotatedWithAnnotationWithEnum(DexType type) {
        this.addDirectDependency(type);
    }

    private void addDirectDependency(DexType type) {
        if (!(type = type.toBaseType(this.appInfo.dexItemFactory())).isClassType() || this.mainDexClassesBuilder.contains(type)) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null || clazz.isNotProgramClass()) {
            return;
        }
        this.addDirectDependency(clazz.asProgramClass());
    }

    private void addDirectDependency(DexProgramClass dexClass) {
        DexType type = dexClass.type;
        assert (!this.mainDexClassesBuilder.contains(type));
        this.mainDexClassesBuilder.addDependency(type);
        if (dexClass.superType != null) {
            this.addDirectDependency(dexClass.superType);
        }
        for (DexType interfaze : dexClass.interfaces.values) {
            this.addDirectDependency(interfaze);
        }
    }
}

