/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfPosition;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Suppliers;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEvent;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEventBuilder;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugPositionState;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinSourceDebugExtensionParser;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.ClassNaming;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.naming.Range;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.Box;
import shadow.bundletool.com.android.tools.r8.utils.CfLineToMethodMapper;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Pair;

public class LineNumberOptimizer {
    public static ClassNameMapper run(AppView<AppInfoWithSubtyping> appView, DexApplication application, AndroidApp inputApp, NamingLens namingLens) {
        CfLineToMethodMapper cfLineToMethodMapper = new CfLineToMethodMapper(inputApp);
        ClassNameMapper.Builder classNameMapperBuilder = ClassNameMapper.builder();
        for (DexProgramClass clazz : application.classes()) {
            IdentityHashMap<DexString, List<DexEncodedMethod>> methodsByRenamedName = LineNumberOptimizer.groupMethodsByRenamedName(appView.graphLense(), namingLens, clazz);
            DexType originalType = appView.graphLense().getOriginalType(clazz.type);
            DexString renamedClassName = namingLens.lookupDescriptor(clazz.getType());
            shadow.bundletool.com.android.tools.r8.com.google.common.base.Supplier<ClassNaming.Builder> onDemandClassNamingBuilder = Suppliers.memoize(() -> classNameMapperBuilder.classNamingBuilder(DescriptorUtils.descriptorToJavaType(renamedClassName.toString()), originalType.toSourceString(), shadow.bundletool.com.android.tools.r8.position.Position.UNKNOWN));
            LineNumberOptimizer.addClassToClassNaming(originalType, renamedClassName, onDemandClassNamingBuilder);
            LineNumberOptimizer.addFieldsToClassNaming(appView.graphLense(), namingLens, clazz, onDemandClassNamingBuilder);
            ArrayList<DexString> renamedMethodNames = new ArrayList<DexString>(methodsByRenamedName.keySet());
            renamedMethodNames.sort(DexString::slowCompareTo);
            for (DexString methodName : renamedMethodNames) {
                List<DexEncodedMethod> methods = methodsByRenamedName.get(methodName);
                if (methods.size() > 1) {
                    LineNumberOptimizer.sortMethods(methods);
                }
                boolean identityMapping = appView.options().lineNumberOptimization == InternalOptions.LineNumberOptimization.OFF;
                PositionRemapper positionRemapper = identityMapping ? new IdentityPositionRemapper() : new OptimizingPositionRemapper(appView.options());
                KotlinInlineFunctionPositionRemapper kotlinRemapper = new KotlinInlineFunctionPositionRemapper(appView, inputApp, positionRemapper, cfLineToMethodMapper);
                for (DexEncodedMethod method : methods) {
                    kotlinRemapper.currentMethod = method;
                    ArrayList<MappedPosition> mappedPositions = new ArrayList<MappedPosition>();
                    Code code = method.getCode();
                    if (code != null) {
                        if (code.isDexCode() && LineNumberOptimizer.doesContainPositions(code.asDexCode())) {
                            LineNumberOptimizer.optimizeDexCodePositions(method, application, kotlinRemapper, mappedPositions, identityMapping);
                        } else if (code.isCfCode() && LineNumberOptimizer.doesContainPositions(code.asCfCode())) {
                            LineNumberOptimizer.optimizeCfCodePositions(method, kotlinRemapper, mappedPositions, appView);
                        }
                    }
                    DexMethod originalMethod = appView.graphLense().getOriginalMethodSignature(method.method);
                    MemberNaming.MethodSignature originalSignature = MemberNaming.MethodSignature.fromDexMethod(originalMethod, originalMethod.holder != clazz.type);
                    DexString obfuscatedNameDexString = namingLens.lookupName(method.method);
                    String obfuscatedName = obfuscatedNameDexString.toString();
                    if (mappedPositions.isEmpty()) {
                        if (obfuscatedNameDexString == originalMethod.name && originalMethod.holder == clazz.type) continue;
                        ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMappedRange(null, originalSignature, null, obfuscatedName);
                        continue;
                    }
                    IdentityHashMap<DexMethod, MemberNaming.MethodSignature> signatures = new IdentityHashMap<DexMethod, MemberNaming.MethodSignature>();
                    signatures.put(originalMethod, originalSignature);
                    Function<DexMethod, MemberNaming.MethodSignature> getOriginalMethodSignature = m -> {
                        DexMethod original = appView.graphLense().getOriginalMethodSignature((DexMethod)m);
                        return signatures.computeIfAbsent(original, key -> MemberNaming.MethodSignature.fromDexMethod(original, original.holder != clazz.getType()));
                    };
                    MemberNaming memberNaming = new MemberNaming(originalSignature, obfuscatedName);
                    ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
                    int i = 0;
                    while (i < mappedPositions.size()) {
                        MappedPosition mp;
                        int j;
                        MappedPosition firstPosition = (MappedPosition)mappedPositions.get(i);
                        MappedPosition lastPosition = firstPosition;
                        for (j = i + 1; j < mappedPositions.size() && (mp = (MappedPosition)mappedPositions.get(j)).method == lastPosition.method && mp.originalLine - lastPosition.originalLine == mp.obfuscatedLine - lastPosition.obfuscatedLine && Objects.equals(mp.caller, lastPosition.caller); ++j) {
                            lastPosition = mp;
                        }
                        Range obfuscatedRange = new Range(firstPosition.obfuscatedLine, lastPosition.obfuscatedLine);
                        Range originalRange = new Range(firstPosition.originalLine, lastPosition.originalLine);
                        ClassNaming.Builder classNamingBuilder = (ClassNaming.Builder)onDemandClassNamingBuilder.get();
                        classNamingBuilder.addMappedRange(obfuscatedRange, getOriginalMethodSignature.apply(firstPosition.method), originalRange, obfuscatedName);
                        Position caller = firstPosition.caller;
                        while (caller != null) {
                            classNamingBuilder.addMappedRange(obfuscatedRange, getOriginalMethodSignature.apply(caller.method), Math.max(caller.line, 0), obfuscatedName);
                            caller = caller.callerPosition;
                        }
                        i = j;
                    }
                }
            }
        }
        return classNameMapperBuilder.build();
    }

    private static int getMethodStartLine(DexEncodedMethod method) {
        Code code = method.getCode();
        if (code == null) {
            return 0;
        }
        if (code.isDexCode()) {
            DexDebugInfo dexDebugInfo = code.asDexCode().getDebugInfo();
            return dexDebugInfo == null ? 0 : dexDebugInfo.startLine;
        }
        if (code.isCfCode()) {
            List<CfInstruction> instructions = code.asCfCode().getInstructions();
            for (CfInstruction instruction : instructions) {
                if (!(instruction instanceof CfPosition)) continue;
                return ((CfPosition)instruction).getPosition().line;
            }
        }
        return 0;
    }

    private static void sortMethods(List<DexEncodedMethod> methods) {
        methods.sort((lhs, rhs) -> {
            int rhsStartLine;
            int lhsStartLine = LineNumberOptimizer.getMethodStartLine(lhs);
            int startLineDiff = lhsStartLine - (rhsStartLine = LineNumberOptimizer.getMethodStartLine(rhs));
            if (startLineDiff != 0) {
                return startLineDiff;
            }
            return DexEncodedMethod.slowCompare(lhs, rhs);
        });
    }

    private static void addClassToClassNaming(DexType originalType, DexString renamedClassName, Supplier<ClassNaming.Builder> onDemandClassNamingBuilder) {
        if (originalType.descriptor != renamedClassName) {
            onDemandClassNamingBuilder.get();
        }
    }

    private static void addFieldsToClassNaming(GraphLense graphLense, NamingLens namingLens, DexProgramClass clazz, Supplier<ClassNaming.Builder> onDemandClassNamingBuilder) {
        clazz.forEachField(dexEncodedField -> {
            DexField dexField = dexEncodedField.field;
            DexField originalField = graphLense.getOriginalFieldSignature(dexField);
            DexString renamedName = namingLens.lookupName(dexField);
            if (renamedName != originalField.name || originalField.holder != clazz.type) {
                MemberNaming.FieldSignature originalSignature = MemberNaming.FieldSignature.fromDexField(originalField, originalField.holder != clazz.type);
                MemberNaming memberNaming = new MemberNaming(originalSignature, renamedName.toString());
                ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
            }
        });
    }

    private static IdentityHashMap<DexString, List<DexEncodedMethod>> groupMethodsByRenamedName(GraphLense graphLens, NamingLens namingLens, DexProgramClass clazz) {
        IdentityHashMap<DexString, List<DexEncodedMethod>> methodsByRenamedName = new IdentityHashMap<DexString, List<DexEncodedMethod>>(clazz.directMethods().size() + clazz.virtualMethods().size());
        for (DexEncodedMethod encodedMethod : clazz.methods()) {
            DexMethod method = encodedMethod.method;
            DexString renamedName = namingLens.lookupName(method);
            if (renamedName == method.name && graphLens.getOriginalMethodSignature(method) == method && !LineNumberOptimizer.doesContainPositions(encodedMethod)) continue;
            methodsByRenamedName.computeIfAbsent(renamedName, key -> new ArrayList()).add(encodedMethod);
        }
        return methodsByRenamedName;
    }

    private static boolean doesContainPositions(DexEncodedMethod method) {
        Code code = method.getCode();
        if (code == null) {
            return false;
        }
        if (code.isDexCode()) {
            return LineNumberOptimizer.doesContainPositions(code.asDexCode());
        }
        if (code.isCfCode()) {
            return LineNumberOptimizer.doesContainPositions(code.asCfCode());
        }
        return false;
    }

    private static boolean doesContainPositions(DexCode dexCode) {
        DexDebugInfo debugInfo = dexCode.getDebugInfo();
        if (debugInfo == null) {
            return false;
        }
        for (DexDebugEvent event : debugInfo.events) {
            if (!(event instanceof DexDebugEvent.Default)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesContainPositions(CfCode cfCode) {
        List<CfInstruction> instructions = cfCode.getInstructions();
        for (CfInstruction instruction : instructions) {
            if (!(instruction instanceof CfPosition)) continue;
            return true;
        }
        return false;
    }

    private static void optimizeDexCodePositions(DexEncodedMethod method, DexApplication application, final PositionRemapper positionRemapper, final List<MappedPosition> mappedPositions, boolean identityMapping) {
        DexCode dexCode = method.getCode().asDexCode();
        DexDebugInfo debugInfo = dexCode.getDebugInfo();
        final ArrayList processedEvents = new ArrayList();
        final PositionEventEmitter positionEventEmitter = new PositionEventEmitter(application.dexItemFactory, method.method, processedEvents);
        final Box<Boolean> inlinedOriginalPosition = new Box<Boolean>(false);
        DexDebugPositionState visitor = new DexDebugPositionState(debugInfo.startLine, method.method){
            private int emittedPc;
            {
                super(startLine, method);
                this.emittedPc = 0;
            }

            private void flushPc() {
                if (this.emittedPc != this.getCurrentPc()) {
                    positionEventEmitter.emitAdvancePc(this.getCurrentPc());
                    this.emittedPc = this.getCurrentPc();
                }
            }

            @Override
            public void visit(DexDebugEvent.Default defaultEvent) {
                super.visit(defaultEvent);
                assert (this.getCurrentLine() >= 0);
                Position position = new Position(this.getCurrentLine(), this.getCurrentFile(), this.getCurrentMethod(), this.getCurrentCallerPosition());
                Position currentPosition = LineNumberOptimizer.remapAndAdd(position, positionRemapper, mappedPositions);
                if (currentPosition != position) {
                    inlinedOriginalPosition.set(true);
                }
                positionEventEmitter.emitPositionEvents(this.getCurrentPc(), currentPosition);
                this.emittedPc = this.getCurrentPc();
            }

            @Override
            public void visit(DexDebugEvent.SetFile setFile) {
                processedEvents.add(setFile);
            }

            @Override
            public void visit(DexDebugEvent.SetPrologueEnd setPrologueEnd) {
                processedEvents.add(setPrologueEnd);
            }

            @Override
            public void visit(DexDebugEvent.SetEpilogueBegin setEpilogueBegin) {
                processedEvents.add(setEpilogueBegin);
            }

            @Override
            public void visit(DexDebugEvent.StartLocal startLocal) {
                this.flushPc();
                processedEvents.add(startLocal);
            }

            @Override
            public void visit(DexDebugEvent.EndLocal endLocal) {
                this.flushPc();
                processedEvents.add(endLocal);
            }

            @Override
            public void visit(DexDebugEvent.RestartLocal restartLocal) {
                this.flushPc();
                processedEvents.add(restartLocal);
            }
        };
        for (DexDebugEvent event : debugInfo.events) {
            event.accept(visitor);
        }
        DexDebugInfo optimizedDebugInfo = new DexDebugInfo(positionEventEmitter.getStartLine(), debugInfo.parameters, processedEvents.toArray(DexDebugEvent.EMPTY_ARRAY));
        if (identityMapping && !inlinedOriginalPosition.get().booleanValue()) {
            assert (optimizedDebugInfo.startLine == debugInfo.startLine);
            assert (optimizedDebugInfo.events.length == debugInfo.events.length);
            for (int i = 0; i < debugInfo.events.length; ++i) {
                assert (optimizedDebugInfo.events[i].equals(debugInfo.events[i]));
            }
        }
        dexCode.setDebugInfo(optimizedDebugInfo);
    }

    private static void optimizeCfCodePositions(DexEncodedMethod method, PositionRemapper positionRemapper, List<MappedPosition> mappedPositions, AppView<?> appView) {
        CfCode oldCode = method.getCode().asCfCode();
        List<CfInstruction> oldInstructions = oldCode.getInstructions();
        ArrayList<CfInstruction> newInstructions = new ArrayList<CfInstruction>(oldInstructions.size());
        for (int i = 0; i < oldInstructions.size(); ++i) {
            CfInstruction newInstruction;
            CfInstruction oldInstruction = oldInstructions.get(i);
            if (oldInstruction instanceof CfPosition) {
                CfPosition cfPosition = (CfPosition)oldInstruction;
                newInstruction = new CfPosition(cfPosition.getLabel(), LineNumberOptimizer.remapAndAdd(cfPosition.getPosition(), positionRemapper, mappedPositions));
            } else {
                newInstruction = oldInstruction;
            }
            newInstructions.add(newInstruction);
        }
        method.setCode(new CfCode(method.method.holder, oldCode.getMaxStack(), oldCode.getMaxLocals(), newInstructions, oldCode.getTryCatchRanges(), oldCode.getLocalVariables()), appView);
    }

    private static Position remapAndAdd(Position position, PositionRemapper remapper, List<MappedPosition> mappedPositions) {
        Pair<Position, Position> remappedPosition = remapper.createRemappedPosition(position);
        Position oldPosition = remappedPosition.getFirst();
        Position newPosition = remappedPosition.getSecond();
        mappedPositions.add(new MappedPosition(oldPosition.method, oldPosition.line, oldPosition.callerPosition, newPosition.line));
        return newPosition;
    }

    private static class MappedPosition {
        private final DexMethod method;
        private final int originalLine;
        private final Position caller;
        private final int obfuscatedLine;

        private MappedPosition(DexMethod method, int originalLine, Position caller, int obfuscatedLine) {
            this.method = method;
            this.originalLine = originalLine;
            this.caller = caller;
            this.obfuscatedLine = obfuscatedLine;
        }
    }

    private static class PositionEventEmitter {
        private final DexItemFactory dexItemFactory;
        private int startLine = -1;
        private final DexMethod method;
        private int previousPc = 0;
        private Position previousPosition = null;
        private final List<DexDebugEvent> processedEvents;

        private PositionEventEmitter(DexItemFactory dexItemFactory, DexMethod method, List<DexDebugEvent> processedEvents) {
            this.dexItemFactory = dexItemFactory;
            this.method = method;
            this.processedEvents = processedEvents;
        }

        private void emitAdvancePc(int pc) {
            this.processedEvents.add(new DexDebugEvent.AdvancePC(pc - this.previousPc));
            this.previousPc = pc;
        }

        private void emitPositionEvents(int currentPc, Position currentPosition) {
            if (this.previousPosition == null) {
                this.startLine = currentPosition.line;
                this.previousPosition = new Position(this.startLine, null, this.method, null);
            }
            DexDebugEventBuilder.emitAdvancementEvents(this.previousPc, this.previousPosition, currentPc, currentPosition, this.processedEvents, this.dexItemFactory);
            this.previousPc = currentPc;
            this.previousPosition = currentPosition;
        }

        private int getStartLine() {
            assert (this.startLine >= 0);
            return this.startLine;
        }
    }

    private static class KotlinInlineFunctionPositionRemapper
    implements PositionRemapper {
        private final AppView<?> appView;
        private final DexItemFactory factory;
        private final Map<DexType, KotlinSourceDebugExtensionParser.Result> parsedKotlinSourceDebugExtensions = new IdentityHashMap<DexType, KotlinSourceDebugExtensionParser.Result>();
        private final CfLineToMethodMapper lineToMethodMapper;
        private final PositionRemapper baseRemapper;
        private DexEncodedMethod currentMethod;
        private KotlinSourceDebugExtensionParser.Result parsedData = null;

        private KotlinInlineFunctionPositionRemapper(AppView<?> appView, AndroidApp inputApp, PositionRemapper baseRemapper, CfLineToMethodMapper lineToMethodMapper) {
            this.appView = appView;
            this.factory = appView.dexItemFactory();
            this.baseRemapper = baseRemapper;
            this.lineToMethodMapper = lineToMethodMapper;
        }

        @Override
        public Pair<Position, Position> createRemappedPosition(Position position) {
            assert (this.currentMethod != null);
            int line = position.line;
            KotlinSourceDebugExtensionParser.Result parsedData = this.getAndParseSourceDebugExtension(position.method.holder);
            if (parsedData == null) {
                return this.baseRemapper.createRemappedPosition(position);
            }
            Map.Entry<Integer, KotlinSourceDebugExtensionParser.Position> currentPosition = parsedData.lookup(line);
            if (currentPosition == null) {
                return this.baseRemapper.createRemappedPosition(position);
            }
            int delta = line - currentPosition.getKey();
            int originalPosition = currentPosition.getValue().getRange().from + delta;
            try {
                String binaryName = currentPosition.getValue().getSource().getPath();
                String nameAndDescriptor = this.lineToMethodMapper.lookupNameAndDescriptor(binaryName, originalPosition);
                if (nameAndDescriptor == null) {
                    return this.baseRemapper.createRemappedPosition(position);
                }
                String clazzDescriptor = DescriptorUtils.getDescriptorFromClassBinaryName(binaryName);
                String methodName = CfLineToMethodMapper.getName(nameAndDescriptor);
                String methodDescriptor = CfLineToMethodMapper.getDescriptor(nameAndDescriptor);
                String returnTypeDescriptor = DescriptorUtils.getReturnTypeDescriptor(methodDescriptor);
                String[] argumentDescriptors = DescriptorUtils.getArgumentTypeDescriptors(methodDescriptor);
                DexString[] argumentDexStringDescriptors = new DexString[argumentDescriptors.length];
                for (int i = 0; i < argumentDescriptors.length; ++i) {
                    argumentDexStringDescriptors[i] = this.factory.createString(argumentDescriptors[i]);
                }
                DexMethod inlinee = this.factory.createMethod(this.factory.createString(clazzDescriptor), this.factory.createString(methodName), this.factory.createString(returnTypeDescriptor), argumentDexStringDescriptors);
                if (!inlinee.equals(position.method)) {
                    return this.baseRemapper.createRemappedPosition(new Position(originalPosition, null, inlinee, position));
                }
            }
            catch (IOException | ResourceException exception) {
                // empty catch block
            }
            return this.baseRemapper.createRemappedPosition(position);
        }

        private KotlinSourceDebugExtensionParser.Result getAndParseSourceDebugExtension(DexType holder) {
            if (this.parsedData == null) {
                this.parsedData = this.parsedKotlinSourceDebugExtensions.get(holder);
            }
            if (this.parsedData != null || this.parsedKotlinSourceDebugExtensions.containsKey(holder)) {
                return this.parsedData;
            }
            DexClass clazz = this.appView.definitionFor(this.currentMethod.method.holder);
            DexValue.DexValueString dexValueString = this.appView.getSourceDebugExtensionForType(clazz);
            if (dexValueString != null) {
                this.parsedData = KotlinSourceDebugExtensionParser.parse(((DexString)dexValueString.value).toString());
            }
            this.parsedKotlinSourceDebugExtensions.put(holder, this.parsedData);
            return this.parsedData;
        }

        public void setMethod(DexEncodedMethod method) {
            this.currentMethod = method;
            this.parsedData = null;
        }
    }

    private static class OptimizingPositionRemapper
    implements PositionRemapper {
        private final int maxLineDelta;
        private DexMethod previousMethod = null;
        private int previousSourceLine = -1;
        private int nextOptimizedLineNumber = 1;

        OptimizingPositionRemapper(InternalOptions options) {
            this.maxLineDelta = options.isGeneratingClassFiles() ? Integer.MAX_VALUE : 1;
        }

        @Override
        public Pair<Position, Position> createRemappedPosition(Position position) {
            assert (position.method != null);
            if (this.previousMethod == position.method) {
                assert (this.previousSourceLine >= 0);
                if (position.line > this.previousSourceLine && position.line - this.previousSourceLine <= this.maxLineDelta) {
                    this.nextOptimizedLineNumber += position.line - this.previousSourceLine - 1;
                }
            }
            Position newPosition = new Position(this.nextOptimizedLineNumber, position.file, position.method, null);
            ++this.nextOptimizedLineNumber;
            this.previousSourceLine = position.line;
            this.previousMethod = position.method;
            return new Pair<Position, Position>(position, newPosition);
        }
    }

    private static class IdentityPositionRemapper
    implements PositionRemapper {
        private IdentityPositionRemapper() {
        }

        @Override
        public Pair<Position, Position> createRemappedPosition(Position position) {
            return new Pair<Position, Position>(position, position);
        }
    }

    private static interface PositionRemapper {
        public Pair<Position, Position> createRemappedPosition(Position var1);
    }
}

