/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AppBundleModule;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.io.ApkSerializerManager;
import com.android.tools.build.bundletool.io.ApkSetBuilderFactory;
import com.android.tools.build.bundletool.io.SplitApkSerializer;
import com.android.tools.build.bundletool.io.StandaloneApkSerializer;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.mergers.BundleModuleMerger;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.GeneratedAssetSlices;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.exceptions.IncompatibleDeviceException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.targeting.AlternativeVariantTargetingPopulator;
import com.android.tools.build.bundletool.model.utils.ModuleDependenciesUtils;
import com.android.tools.build.bundletool.model.utils.SplitsXmlInjector;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.optimizations.OptimizationsMerger;
import com.android.tools.build.bundletool.preprocessors.AppBundle64BitNativeLibrariesPreprocessor;
import com.android.tools.build.bundletool.preprocessors.EmbeddedApkSigningPreprocessor;
import com.android.tools.build.bundletool.preprocessors.EntryCompressionPreprocessor;
import com.android.tools.build.bundletool.preprocessors.LocalTestingPreprocessor;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.AssetSlicesGenerator;
import com.android.tools.build.bundletool.splitters.ResourceAnalyzer;
import com.android.tools.build.bundletool.splitters.ShardedApksGenerator;
import com.android.tools.build.bundletool.splitters.SplitApksGenerator;
import com.android.tools.build.bundletool.validation.AppBundleValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import javax.annotation.CheckReturnValue;
import javax.inject.Inject;

public final class BuildApksManager {
    private final ZipFile bundleZip;
    private final BuildApksCommand command;
    private final Version bundletoolVersion;
    private final Optional<Devices.DeviceSpec> deviceSpec;
    private final TempDirectory tempDir;
    private final SplitApkSerializer splitApkSerializer;
    private final StandaloneApkSerializer standaloneApkSerializer;
    private final ApkSerializerManager apkSerializerManager;
    private final SplitApksGenerator splitApksGenerator;
    private final ShardedApksGenerator shardedApksGenerator;
    private final OptimizationsMerger optimizationsMerger;

    @Inject
    BuildApksManager(@AppBundleModule.AppBundleZip ZipFile bundleZip, BuildApksCommand command, Version bundletoolVersion, Optional<Devices.DeviceSpec> deviceSpec, TempDirectory tempDir, SplitApkSerializer splitApkSerializer, StandaloneApkSerializer standaloneApkSerializer, ApkSerializerManager apkSerializerManager, SplitApksGenerator splitApksGenerator, ShardedApksGenerator shardedApksGenerator, OptimizationsMerger optimizationsMerger) {
        this.bundleZip = bundleZip;
        this.command = command;
        this.bundletoolVersion = bundletoolVersion;
        this.deviceSpec = deviceSpec;
        this.tempDir = tempDir;
        this.splitApkSerializer = splitApkSerializer;
        this.standaloneApkSerializer = standaloneApkSerializer;
        this.splitApksGenerator = splitApksGenerator;
        this.apkSerializerManager = apkSerializerManager;
        this.shardedApksGenerator = shardedApksGenerator;
        this.optimizationsMerger = optimizationsMerger;
    }

    public void execute() throws IOException {
        AppBundleValidator bundleValidator = AppBundleValidator.create(this.command.getExtraValidators());
        bundleValidator.validateFile(this.bundleZip);
        AppBundle appBundle = AppBundle.buildFromZip(this.bundleZip);
        bundleValidator.validate(appBundle);
        appBundle = this.applyPreprocessors(appBundle);
        ImmutableSet<BundleModule> requestedModules = this.command.getModules().isEmpty() ? ImmutableSet.of() : ModuleDependenciesUtils.getModulesIncludingDependencies(appBundle, BuildApksManager.getBundleModules(appBundle, this.command.getModules()));
        GeneratedApks.Builder generatedApksBuilder = GeneratedApks.builder();
        GeneratedAssetSlices.Builder generatedAssetSlices = GeneratedAssetSlices.builder();
        boolean enableUniversalAsFallbackForSplits = false;
        boolean enableInstallTimeNonRemovableModules = false;
        ApksToGenerate apksToGenerate = new ApksToGenerate(appBundle, this.command.getApkBuildMode(), enableUniversalAsFallbackForSplits, this.deviceSpec);
        if (apksToGenerate.generateSplitApks()) {
            AppBundle mergedAppBundle = BundleModuleMerger.mergeNonRemovableInstallTimeModules(appBundle, enableInstallTimeNonRemovableModules);
            bundleValidator.validate(mergedAppBundle);
            generatedApksBuilder.setSplitApks(this.generateSplitApks(mergedAppBundle));
        }
        if (apksToGenerate.generateInstantApks()) {
            generatedApksBuilder.setInstantApks(this.generateInstantApks(appBundle));
        }
        if (apksToGenerate.generateStandaloneApks()) {
            generatedApksBuilder.setStandaloneApks(this.generateStandaloneApks(appBundle));
        }
        if (apksToGenerate.generateUniversalApk()) {
            ImmutableList<BundleModule> modulesToFuse = requestedModules.isEmpty() ? BuildApksManager.modulesToFuse(BuildApksManager.getModulesForStandaloneApks(appBundle)) : requestedModules.asList();
            generatedApksBuilder.setStandaloneApks(this.shardedApksGenerator.generateSplits(modulesToFuse, ApkOptimizations.getOptimizationsForUniversalApk()));
        }
        if (apksToGenerate.generateSystemApks()) {
            generatedApksBuilder.setSystemApks(this.generateSystemApks(appBundle, this.deviceSpec, requestedModules));
        }
        if (apksToGenerate.generateAssetSlices()) {
            generatedAssetSlices.setAssetSlices(this.generateAssetSlices(appBundle));
        }
        GeneratedApks generatedApks = AlternativeVariantTargetingPopulator.populateAlternativeVariantTargeting(generatedApksBuilder.build(), appBundle.isAssetOnly() ? Optional.empty() : appBundle.getBaseModule().getAndroidManifest().getMaxSdkVersion());
        SplitsXmlInjector splitsXmlInjector = new SplitsXmlInjector();
        generatedApks = splitsXmlInjector.process(generatedApks);
        if (this.deviceSpec.isPresent()) {
            BuildApksManager.checkDeviceCompatibilityWithBundle(generatedApks, this.deviceSpec.get());
        }
        ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder = this.createApkSetBuilder(this.tempDir.getPath());
        this.apkSerializerManager.populateApkSetBuilder(apkSetBuilder, generatedApks, generatedAssetSlices.build(), this.command.getApkBuildMode(), this.deviceSpec, BuildApksManager.getLocalTestingInfo(appBundle));
        if (this.command.getOverwriteOutput()) {
            Files.deleteIfExists(this.command.getOutputFile());
        }
        apkSetBuilder.writeTo(this.command.getOutputFile());
    }

    private ImmutableList<ModuleSplit> generateStandaloneApks(AppBundle appBundle) {
        ImmutableList<BundleModule> allModules = BuildApksManager.getModulesForStandaloneApks(appBundle);
        return appBundle.isApex() ? this.shardedApksGenerator.generateApexSplits(BuildApksManager.modulesToFuse(allModules)) : this.shardedApksGenerator.generateSplits(BuildApksManager.modulesToFuse(allModules), this.getApkOptimizations(appBundle.getBundleConfig()));
    }

    private ImmutableList<ModuleSplit> generateAssetSlices(AppBundle appBundle) {
        ApkGenerationConfiguration assetSlicesGenerationConfiguration = BuildApksManager.getAssetSliceGenerationConfiguration(appBundle.getBundleConfig());
        AssetSlicesGenerator assetSlicesGenerator = new AssetSlicesGenerator(appBundle, assetSlicesGenerationConfiguration, this.command.getAssetModulesVersionOverride());
        return assetSlicesGenerator.generateAssetSlices();
    }

    private ImmutableList<ModuleSplit> generateInstantApks(AppBundle appBundle) {
        ImmutableList allFeatureModules = appBundle.getFeatureModules().values().asList();
        ImmutableList instantModules = (ImmutableList)allFeatureModules.stream().filter(BundleModule::isInstantModule).collect(ImmutableList.toImmutableList());
        ApkGenerationConfiguration instantApkGenerationConfiguration = this.getCommonSplitApkGenerationConfiguration(appBundle).setForInstantAppVariants(true).setEnableDexCompressionSplitter(false).build();
        return this.splitApksGenerator.generateSplits((ImmutableList<BundleModule>)instantModules, instantApkGenerationConfiguration);
    }

    private ImmutableList<ModuleSplit> generateSplitApks(AppBundle appBundle) throws IOException {
        ApkGenerationConfiguration.Builder apkGenerationConfiguration = this.getCommonSplitApkGenerationConfiguration(appBundle);
        if (VersionGuardedFeature.RESOURCES_REFERENCED_IN_MANIFEST_TO_MASTER_SPLIT.enabledForVersion(this.bundletoolVersion)) {
            apkGenerationConfiguration.setBaseManifestReachableResources(new ResourceAnalyzer(appBundle).findAllAppResourcesReachableFromBaseManifest());
        }
        ImmutableList featureModules = appBundle.getFeatureModules().values().asList();
        return this.splitApksGenerator.generateSplits((ImmutableList<BundleModule>)featureModules, apkGenerationConfiguration.build());
    }

    private ImmutableList<ModuleSplit> generateSystemApks(AppBundle appBundle, Optional<Devices.DeviceSpec> deviceSpec, ImmutableSet<BundleModule> requestedModules) {
        ImmutableList featureModules = appBundle.getFeatureModules().values().asList();
        ImmutableList modulesToFuse = requestedModules.isEmpty() ? BuildApksManager.modulesToFuse((ImmutableList<BundleModule>)featureModules) : requestedModules.asList();
        return this.shardedApksGenerator.generateSystemSplits((ImmutableList<BundleModule>)featureModules, (ImmutableSet<BundleModuleName>)((ImmutableSet)modulesToFuse.stream().map(BundleModule::getName).collect(ImmutableSet.toImmutableSet())), this.getApkOptimizations(appBundle.getBundleConfig()), deviceSpec);
    }

    private static void checkDeviceCompatibilityWithBundle(GeneratedApks generatedApks, Devices.DeviceSpec deviceSpec) {
        ApkMatcher apkMatcher = new ApkMatcher(deviceSpec);
        generatedApks.getAllApksStream().forEach(apkMatcher::checkCompatibleWithApkTargeting);
    }

    private ApkSetBuilderFactory.ApkSetBuilder createApkSetBuilder(Path tempDir) {
        if (!this.command.getCreateApkSetArchive()) {
            return ApkSetBuilderFactory.createApkSetWithoutArchiveBuilder(this.splitApkSerializer, this.standaloneApkSerializer, this.command.getOutputFile());
        }
        return ApkSetBuilderFactory.createApkSetBuilder(this.splitApkSerializer, this.standaloneApkSerializer, tempDir);
    }

    private ApkGenerationConfiguration.Builder getCommonSplitApkGenerationConfiguration(AppBundle appBundle) {
        Config.BundleConfig bundleConfig = appBundle.getBundleConfig();
        Version bundleToolVersion = Version.of(bundleConfig.getBundletool().getVersion());
        ApkOptimizations apkOptimizations = this.getApkOptimizations(bundleConfig);
        ApkGenerationConfiguration.Builder apkGenerationConfiguration = ApkGenerationConfiguration.builder().setOptimizationDimensions(apkOptimizations.getSplitDimensions());
        boolean enableNativeLibraryCompressionSplitter = apkOptimizations.getUncompressNativeLibraries();
        apkGenerationConfiguration.setEnableNativeLibraryCompressionSplitter(enableNativeLibraryCompressionSplitter);
        apkGenerationConfiguration.setInstallableOnExternalStorage(appBundle.getBaseModule().getAndroidManifest().getInstallLocationValue().map(installLocation -> installLocation.equals("auto") || installLocation.equals("preferExternal")).orElse(false));
        apkGenerationConfiguration.setMasterPinnedResourceIds(appBundle.getMasterPinnedResourceIds());
        apkGenerationConfiguration.setMasterPinnedResourceNames(appBundle.getMasterPinnedResourceNames());
        apkGenerationConfiguration.setSuffixStrippings(BuildApksManager.getSuffixStrippings(bundleConfig));
        this.command.getSigningConfiguration().map(SigningConfiguration::getRestrictV3SigningToRPlus).ifPresent(apkGenerationConfiguration::setRestrictV3SigningToRPlus);
        return apkGenerationConfiguration;
    }

    private static ApkGenerationConfiguration getAssetSliceGenerationConfiguration(Config.BundleConfig bundleConfig) {
        ApkOptimizations apkOptimizations = ApkOptimizations.getOptimizationsForAssetSlices();
        return ApkGenerationConfiguration.builder().setOptimizationDimensions(apkOptimizations.getSplitDimensions()).setSuffixStrippings(BuildApksManager.getSuffixStrippings(bundleConfig)).build();
    }

    private static ImmutableList<BundleModule> modulesToFuse(ImmutableList<BundleModule> modules) {
        return (ImmutableList)modules.stream().filter(BundleModule::isIncludedInFusing).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableMap<OptimizationDimension, Config.SuffixStripping> getSuffixStrippings(Config.BundleConfig bundleConfig) {
        return OptimizationsMerger.getSuffixStrippings(bundleConfig.getOptimizations().getSplitsConfig().getSplitDimensionList());
    }

    private ApkOptimizations getApkOptimizations(Config.BundleConfig bundleConfig) {
        return this.optimizationsMerger.mergeWithDefaults(bundleConfig, this.command.getOptimizationDimensions());
    }

    private static boolean targetsOnlyPreL(AppBundle bundle) {
        Optional<Integer> maxSdkVersion = bundle.getBaseModule().getAndroidManifest().getMaxSdkVersion();
        return maxSdkVersion.isPresent() && maxSdkVersion.get() < 21;
    }

    private static boolean targetsPreL(AppBundle bundle) {
        int baseMinSdkVersion = bundle.getBaseModule().getAndroidManifest().getEffectiveMinSdkVersion();
        return baseMinSdkVersion < 21;
    }

    private static ImmutableList<BundleModule> getBundleModules(AppBundle appBundle, ImmutableSet<String> moduleNames) {
        return (ImmutableList)moduleNames.stream().map(BundleModuleName::create).map(appBundle::getModule).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<BundleModule> getModulesForStandaloneApks(AppBundle appBundle) {
        return (ImmutableList)Stream.concat(appBundle.getFeatureModules().values().stream(), appBundle.getAssetModules().values().stream().filter(module -> module.getDeliveryType().equals((Object)BundleModule.ModuleDeliveryType.ALWAYS_INITIAL_INSTALL))).collect(ImmutableList.toImmutableList());
    }

    @CheckReturnValue
    private AppBundle applyPreprocessors(AppBundle bundle) {
        bundle = new AppBundle64BitNativeLibrariesPreprocessor(this.command.getOutputPrintStream()).preprocess(bundle);
        if (this.command.getLocalTestingMode()) {
            bundle = new LocalTestingPreprocessor().preprocess(bundle);
        }
        bundle = new EntryCompressionPreprocessor().preprocess(bundle);
        bundle = new EmbeddedApkSigningPreprocessor().preprocess(bundle);
        return bundle;
    }

    private static Commands.LocalTestingInfo getLocalTestingInfo(AppBundle bundle) {
        Commands.LocalTestingInfo.Builder localTestingInfo = Commands.LocalTestingInfo.newBuilder();
        if (bundle.isAssetOnly()) {
            return localTestingInfo.setEnabled(false).build();
        }
        bundle.getBaseModule().getAndroidManifest().getMetadataValue("local_testing_dir").ifPresent(localTestingPath -> localTestingInfo.setEnabled(true).setLocalTestingPath((String)localTestingPath));
        return localTestingInfo.build();
    }

    private static class ApksToGenerate {
        private final AppBundle appBundle;
        private final BuildApksCommand.ApkBuildMode apkBuildMode;
        private final boolean enableUniversalAsFallbackForSplits;
        private final Optional<Devices.DeviceSpec> deviceSpec;

        private ApksToGenerate(AppBundle appBundle, BuildApksCommand.ApkBuildMode apkBuildMode, boolean enableUniversalAsFallbackForSplits, Optional<Devices.DeviceSpec> deviceSpec) {
            this.appBundle = appBundle;
            this.apkBuildMode = apkBuildMode;
            this.enableUniversalAsFallbackForSplits = enableUniversalAsFallbackForSplits;
            this.deviceSpec = deviceSpec;
            this.validate();
        }

        private void validate() {
            boolean generatesAtLeastOneApk;
            if (this.appBundle.isApex() && this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.UNIVERSAL)) {
                throw InvalidCommandException.builder().withInternalMessage("APEX bundles do not support universal apks.").build();
            }
            if (this.deviceSpec.isPresent()) {
                int deviceSdk = this.deviceSpec.get().getSdkVersion();
                Optional<Integer> appMaxSdk = this.appBundle.getBaseModule().getAndroidManifest().getMaxSdkVersion();
                if (this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.PERSISTENT)) {
                    if (deviceSdk >= 21) {
                        if (!this.generateSplitApks()) {
                            throw IncompatibleDeviceException.builder().withUserMessage("App Bundle targets pre-L devices, but the device has SDK version higher or equal to L.").build();
                        }
                    } else if (!this.generateStandaloneApks()) {
                        throw IncompatibleDeviceException.builder().withUserMessage("App Bundle targets L+ devices, but the device has SDK version lower than L.").build();
                    }
                }
                if (appMaxSdk.isPresent() && deviceSdk > appMaxSdk.get()) {
                    throw IncompatibleDeviceException.builder().withUserMessage("Max SDK version of the App Bundle is lower than SDK version of the device").build();
                }
            }
            boolean bl = generatesAtLeastOneApk = this.generateStandaloneApks() || this.generateSplitApks() || this.generateInstantApks() || this.generateUniversalApk() || this.generateSystemApks() || this.generateAssetSlices();
            if (!generatesAtLeastOneApk) {
                throw InvalidCommandException.builder().withInternalMessage("No APKs to generate.").build();
            }
        }

        public boolean generateSplitApks() {
            if (this.appBundle.isApex()) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            if (!this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) && !this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.PERSISTENT)) {
                return false;
            }
            return !BuildApksManager.targetsOnlyPreL(this.appBundle) && this.deviceSpec.map(spec -> spec.getSdkVersion() >= 21).orElse(true) != false;
        }

        public boolean generateStandaloneApks() {
            if (!this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) && !this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.PERSISTENT)) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            if (this.appBundle.isApex()) {
                return true;
            }
            return BuildApksManager.targetsPreL(this.appBundle) && this.deviceSpec.map(spec -> spec.getSdkVersion() < 21).orElse(true) != false;
        }

        public boolean generateInstantApks() {
            if (this.appBundle.isApex()) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            return this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.INSTANT);
        }

        public boolean generateUniversalApk() {
            if (this.appBundle.isApex()) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            boolean shouldGenerateAsFallback = this.enableUniversalAsFallbackForSplits && this.generateSplitApks() && !this.generateStandaloneApks();
            return this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.UNIVERSAL) || shouldGenerateAsFallback;
        }

        public boolean generateSystemApks() {
            if (this.appBundle.isApex()) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            return this.apkBuildMode.isAnySystemMode();
        }

        public boolean generateAssetSlices() {
            if (this.appBundle.isApex()) {
                return false;
            }
            return this.appBundle.isAssetOnly() || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.INSTANT) || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.PERSISTENT);
        }
    }
}

