/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.io.ApkSigner;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.WearApkLocator;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.utils.GZipUtils;
import com.android.tools.build.bundletool.model.utils.PathMatcher;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import shadow.bundletool.com.android.tools.build.apkzlib.sign.SigningOptions;
import shadow.bundletool.com.android.tools.build.apkzlib.zfile.ZFiles;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.AlignmentRule;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.AlignmentRules;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFile;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFileOptions;

final class ApkSerializerHelper {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final Pattern NATIVE_LIBRARIES_PATTERN = Pattern.compile("lib/[^/]+/[^/]+\\.so");
    static final AlignmentRule APK_ALIGNMENT_RULE = AlignmentRules.compose(AlignmentRules.constantForSuffix(".so", 4096), AlignmentRules.constant(4));
    private static final Predicate<ZipPath> FILES_FOR_AAPT2 = path -> path.startsWith("res") || path.equals(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()) || path.equals(ZipPath.create("AndroidManifest.xml"));
    private static final String BUILT_BY = "BundleTool";
    private static final String CREATED_BY = "BundleTool";
    private static final ImmutableSet<String> NO_COMPRESSION_EXTENSIONS = ImmutableSet.of((Object)"3g2", (Object)"3gp", (Object)"3gpp", (Object)"3gpp2", (Object)"aac", (Object)"amr", (Object[])new String[]{"awb", "gif", "imy", "jet", "jpeg", "jpg", "m4a", "m4v", "mid", "midi", "mkv", "mp2", "mp3", "mp4", "mpeg", "mpg", "ogg", "png", "rtttl", "smf", "wav", "webm", "wma", "wmv", "xmf"});
    private final Aapt2Command aapt2Command;
    private final Version bundletoolVersion;
    private final Optional<SigningConfiguration> signingConfig;
    private final Optional<SigningConfiguration> stampSigningConfig;
    private final ImmutableList<PathMatcher> uncompressedPathMatchers;
    private final ApkSigner apkSigner;

    @Inject
    ApkSerializerHelper(Aapt2Command aapt2Command, Version bundletoolVersion, @BuildApksModule.ApkSigningConfig Optional<SigningConfiguration> signingConfig, @BuildApksModule.StampSigningConfig Optional<SigningConfiguration> stampSigningConfig, Config.BundleConfig bundleConfig, ApkSigner apkSigner) {
        this.aapt2Command = aapt2Command;
        this.bundletoolVersion = bundletoolVersion;
        this.signingConfig = signingConfig;
        this.stampSigningConfig = stampSigningConfig;
        this.uncompressedPathMatchers = (ImmutableList)bundleConfig.getCompression().getUncompressedGlobList().stream().map(PathMatcher::createFromGlob).collect(ImmutableList.toImmutableList());
        this.apkSigner = apkSigner;
    }

    Path writeToZipFile(ModuleSplit split, Path outputPath) {
        try (TempDirectory tempDirectory = new TempDirectory();){
            this.writeToZipFile(split, outputPath, tempDirectory.getPath());
        }
        return outputPath;
    }

    private void writeToZipFile(ModuleSplit split, Path outputPath, Path tempDir) {
        FilePreconditions.checkFileDoesNotExist(outputPath);
        FileUtils.createParentDirectories(outputPath);
        Path partialProtoApk = tempDir.resolve("proto.apk");
        this.writeProtoApk(split, partialProtoApk, tempDir);
        Path binaryApk = tempDir.resolve("binary.apk");
        this.aapt2Command.convertApkProtoToBinary(partialProtoApk, binaryApk);
        Preconditions.checkState((boolean)Files.exists(binaryApk, new LinkOption[0]), (Object)"No APK created by aapt2 convert command.");
        Path unsignedApkPath = tempDir.resolve("apk-unsigned.apk");
        try (ZFile zOutputApk = ZFiles.apk(unsignedApkPath.toFile(), ApkSerializerHelper.createZFileOptions(tempDir).setAlignmentRule(APK_ALIGNMENT_RULE).setCoverEmptySpaceUsingExtraField(true).setNoTimestamps(true), (com.google.common.base.Optional<SigningOptions>)com.google.common.base.Optional.absent(), "BundleTool", "BundleTool");
             ZFile zAapt2Files = new ZFile(binaryApk.toFile(), ApkSerializerHelper.createZFileOptions(tempDir), true);){
            zOutputApk.mergeFrom(zAapt2Files, (Predicate<String>)Predicates.alwaysFalse());
            this.addNonAapt2Files(zOutputApk, split);
            zOutputApk.sortZipContents();
        }
        catch (IOException e4) {
            throw new UncheckedIOException(String.format("Failed to write APK file '%s'.", unsignedApkPath), e4);
        }
        boolean signWithV1 = split.getAndroidManifest().getEffectiveMinSdkVersion() < 24 || !VersionGuardedFeature.NO_V1_SIGNING_WHEN_POSSIBLE.enabledForVersion(this.bundletoolVersion);
        int minSdkVersion = split.getAndroidManifest().getEffectiveMinSdkVersion();
        if (this.signingConfig.isPresent()) {
            this.apkSigner.signApk(unsignedApkPath, outputPath, this.signingConfig.get(), this.stampSigningConfig, signWithV1, this.shouldSignWithV3(split), minSdkVersion);
        } else {
            try {
                Files.move(unsignedApkPath, outputPath, new CopyOption[0]);
            }
            catch (IOException e5) {
                throw new UncheckedIOException(String.format("Failed to write APK file '%s'.", outputPath), e5);
            }
        }
    }

    Path writeCompressedApkToZipFile(ModuleSplit split, Path outputPath) {
        try (TempDirectory tempDirectory = new TempDirectory();){
            Path tempApkOutputPath = tempDirectory.getPath().resolve("output.apk");
            this.writeToZipFile(split, tempApkOutputPath, tempDirectory.getPath());
            this.writeCompressedApkToZipFile(tempApkOutputPath, outputPath);
        }
        return outputPath;
    }

    private void writeCompressedApkToZipFile(Path apkPath, Path outputApkGzipPath) {
        FilePreconditions.checkFileDoesNotExist(outputApkGzipPath);
        FileUtils.createParentDirectories(outputApkGzipPath);
        try {
            GZipUtils.compress(apkPath, outputApkGzipPath);
        }
        catch (IOException e4) {
            throw new UncheckedIOException(String.format("Failed to write APK file '%s' to compressed APK file '%s'.", apkPath, outputApkGzipPath), e4);
        }
    }

    private Path writeProtoApk(ModuleSplit split, Path outputPath, Path tempDir) {
        boolean extractNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true);
        ImmutableCollection<ZipPath> wear1ApkPaths = WearApkLocator.findEmbeddedWearApkPaths(split);
        ZipBuilder zipBuilder = new ZipBuilder();
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = this.toApkEntryPath(entry.getPath());
            if (!FILES_FOR_AAPT2.apply((Object)pathInApk)) continue;
            ZipBuilder.EntryOption[] entryOptions = this.entryOptionForPath(pathInApk, !extractNativeLibs, entry.getForceUncompressed());
            if (this.signingConfig.isPresent() && (entry.getShouldSign() || wear1ApkPaths.contains((Object)pathInApk))) {
                Path apkSignerOutputPath;
                try {
                    apkSignerOutputPath = Files.createTempDirectory(tempDir, "signing-", new FileAttribute[0]).resolve("signed.apk");
                }
                catch (IOException e4) {
                    throw new UncheckedIOException(String.format("Error while creating temp directory for signed APK output '%s'.", tempDir), e4);
                }
                this.apkSigner.signEmbeddedApk(entry, this.signingConfig.get(), apkSignerOutputPath, this.shouldSignWithV3(split));
                zipBuilder.addFileFromDisk(pathInApk, apkSignerOutputPath.toFile(), entryOptions);
                continue;
            }
            zipBuilder.addFile(pathInApk, entry.getContent(), entryOptions);
        }
        split.getResourceTable().ifPresent(resourceTable -> zipBuilder.addFileWithProtoContent(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath(), (MessageLite)resourceTable, new ZipBuilder.EntryOption[0]));
        zipBuilder.addFileWithProtoContent(ZipPath.create("AndroidManifest.xml"), (MessageLite)split.getAndroidManifest().getManifestRoot().getProto(), new ZipBuilder.EntryOption[0]);
        try {
            zipBuilder.writeTo(outputPath);
        }
        catch (IOException e5) {
            throw new UncheckedIOException(String.format("Error while writing APK to file '%s'.", outputPath), e5);
        }
        return outputPath;
    }

    private ZipBuilder.EntryOption[] entryOptionForPath(ZipPath path, boolean uncompressNativeLibs, boolean forceUncompressed) {
        if (this.shouldCompress(path, uncompressNativeLibs, forceUncompressed)) {
            return new ZipBuilder.EntryOption[0];
        }
        return new ZipBuilder.EntryOption[]{ZipBuilder.EntryOption.UNCOMPRESSED};
    }

    private boolean shouldCompress(ZipPath path, boolean uncompressNativeLibs, boolean forceUncompressed) {
        if (this.uncompressedPathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(path.toString()))) {
            return false;
        }
        if (forceUncompressed) {
            return false;
        }
        if (!VersionGuardedFeature.NO_DEFAULT_UNCOMPRESS_EXTENSIONS.enabledForVersion(this.bundletoolVersion) && NO_COMPRESSION_EXTENSIONS.contains((Object)FileUtils.getFileExtension(path))) {
            return false;
        }
        return !uncompressNativeLibs || !NATIVE_LIBRARIES_PATTERN.matcher(path.toString()).matches();
    }

    private void addNonAapt2Files(ZFile zFile, ModuleSplit split) throws IOException {
        boolean extractNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true);
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = this.toApkEntryPath(entry.getPath());
            if (FILES_FOR_AAPT2.apply((Object)pathInApk)) continue;
            boolean shouldCompress = this.shouldCompress(pathInApk, !extractNativeLibs, entry.getForceUncompressed());
            if (this.signingConfig.isPresent() && entry.getShouldSign()) {
                TempDirectory signingDir = new TempDirectory();
                Throwable throwable = null;
                try {
                    Path apkSignerOutputPath = Files.createTempDirectory(signingDir.getPath(), "signing-", new FileAttribute[0]).resolve("signed.apk");
                    this.apkSigner.signEmbeddedApk(entry, this.signingConfig.get(), apkSignerOutputPath, this.shouldSignWithV3(split));
                    InputStream inputStream = BufferedIo.inputStream(apkSignerOutputPath);
                    Throwable throwable2 = null;
                    try {
                        zFile.add(pathInApk.toString(), inputStream, shouldCompress);
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                        continue;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (signingDir == null) continue;
                    if (throwable != null) {
                        try {
                            signingDir.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    signingDir.close();
                    continue;
                }
            }
            this.addFile(zFile, pathInApk, entry, shouldCompress);
        }
    }

    void addFile(ZFile zFile, ZipPath pathInApk, ModuleEntry entry, boolean shouldCompress) throws IOException {
        try (InputStream entryInputStream = entry.getContent().openStream();){
            zFile.add(pathInApk.toString(), entryInputStream, shouldCompress);
        }
    }

    private ZipPath toApkEntryPath(ZipPath pathInModule) {
        if (pathInModule.startsWith(BundleModule.DEX_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() == 2 ? 1 : 0) != 0, (String)"Only files directly in the dex directory are supported but found: %s.", (Object)pathInModule);
            FilePreconditions.checkFileHasExtension("File under dex/ directory", pathInModule, ".dex");
            return pathInModule.getFileName();
        }
        if (pathInModule.startsWith(BundleModule.ROOT_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() >= 2 ? 1 : 0) != 0, (String)"Only files inside the root directory are supported but found: %s", (Object)pathInModule);
            return pathInModule.subpath(1, pathInModule.getNameCount());
        }
        if (pathInModule.startsWith(BundleModule.APEX_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() >= 2 ? 1 : 0) != 0, (String)"Only files inside the apex directory are supported but found: %s", (Object)pathInModule);
            Preconditions.checkArgument((pathInModule.toString().endsWith("img") || pathInModule.toString().endsWith("build_info.pb") ? 1 : 0) != 0, (String)"Unexpected filename in apex directory: %s", (Object)pathInModule);
            if (pathInModule.toString().endsWith("img")) {
                return ZipPath.create("apex_payload.img");
            }
            return ZipPath.create("apex_build_info.pb");
        }
        return pathInModule;
    }

    private static ZFileOptions createZFileOptions(Path tempDir) {
        ZFileOptions options = new ZFileOptions();
        return options;
    }

    private boolean shouldSignWithV3(ModuleSplit split) {
        int minApkTargetingSdkVersion;
        if (!this.signingConfig.isPresent()) {
            return false;
        }
        int minManifestSdkVersion = split.getAndroidManifest().getEffectiveMinSdkVersion();
        boolean splitIsTargetedAtRPlus = Math.max(minManifestSdkVersion, minApkTargetingSdkVersion = TargetingUtils.getMinSdk(split.getApkTargeting().getSdkVersionTargeting())) >= 30;
        return splitIsTargetedAtRPlus || !this.signingConfig.get().getRestrictV3SigningToRPlus();
    }
}

