/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.preprocessors;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.preprocessors.AppBundlePreprocessor;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.CheckReturnValue;

public class EntryCompressionPreprocessor
implements AppBundlePreprocessor {
    @Override
    public AppBundle preprocess(AppBundle bundle) {
        return bundle.toBuilder().setRawModules((Collection<BundleModule>)EntryCompressionPreprocessor.setEntryCompression((ImmutableCollection<BundleModule>)bundle.getModules().values(), bundle.getBundleConfig())).build();
    }

    @CheckReturnValue
    private static ImmutableList<BundleModule> setEntryCompression(ImmutableCollection<BundleModule> modules, Config.BundleConfig bundleConfig) {
        return (ImmutableList)modules.stream().map(module -> EntryCompressionPreprocessor.setEntryCompression(module, bundleConfig)).collect(ImmutableList.toImmutableList());
    }

    private static BundleModule setEntryCompression(BundleModule module, Config.BundleConfig bundleConfig) {
        if (EntryCompressionPreprocessor.shouldForceModuleEntriesUncompressed(module, bundleConfig)) {
            return module.toBuilder().setRawEntries((Collection)module.getEntries().stream().map(entry -> entry.toBuilder().setForceUncompressed(entry.getPath().startsWith(BundleModule.ASSETS_DIRECTORY)).build()).collect(ImmutableList.toImmutableList())).build();
        }
        return module;
    }

    private static boolean shouldForceModuleEntriesUncompressed(BundleModule module, Config.BundleConfig bundleConfig) {
        boolean shouldForceInstallTimeAssetModulesUncompressed = bundleConfig.getCompression().getInstallTimeAssetModuleDefaultCompression() != Config.Compression.AssetModuleCompression.COMPRESSED;
        boolean isInstallTimeModule = module.getDeliveryType() == BundleModule.ModuleDeliveryType.ALWAYS_INITIAL_INSTALL || module.getDeliveryType() == BundleModule.ModuleDeliveryType.CONDITIONAL_INITIAL_INSTALL;
        return module.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE) && (shouldForceInstallTimeAssetModulesUncompressed || !isInstallTimeModule);
    }
}

