/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.archive;

import com.android.tools.build.bundletool.archive.ArchivedApksGenerator;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ResourceInjector;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttributeBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public final class ArchivedResourcesUtils {
    public static final String APP_STORE_PACKAGE_NAME_RESOURCE_NAME = "reactivation_app_store_package_name";
    public static final String PLAY_STORE_PACKAGE_NAME = "shadow.bundletool.com.android.vending";
    public static final String OPACITY_LAYER_DRAWABLE_NAME = "com_android_vending_archive_icon_opacity_layer";
    public static final String CLOUD_SYMBOL_DRAWABLE_NAME = "com_android_vending_archive_icon_cloud_symbol";
    public static final String ARCHIVED_ICON_DRAWABLE_NAME = "com_android_vending_archive_application_icon";
    public static final String ARCHIVED_ROUND_ICON_DRAWABLE_NAME = "com_android_vending_archive_application_round_icon";
    public static final String ARCHIVED_CLASSES_DEX_PATH = "dex/classes.dex";
    public static final String CLOUD_SYMBOL_PATH = "drawable/cloud_symbol_xml.pb";
    public static final String OPACITY_LAYER_PATH = "drawable/opacity_layer_xml.pb";

    public static ImmutableMap<String, Integer> injectExtraResources(ResourceInjector resourceInjector, Optional<String> customAppStorePackageName, Optional<XmlProtoAttribute> iconAttribute, Optional<XmlProtoAttribute> roundIconAttribute) {
        ImmutableMap.Builder resourceNameToIdMapBuilder = ImmutableMap.builder().put((Object)APP_STORE_PACKAGE_NAME_RESOURCE_NAME, (Object)resourceInjector.addStringResource(APP_STORE_PACKAGE_NAME_RESOURCE_NAME, ArchivedResourcesUtils.getAppStorePackageName(customAppStorePackageName)).getFullResourceId()).put((Object)OPACITY_LAYER_DRAWABLE_NAME, (Object)resourceInjector.addXmlDrawableResource(OPACITY_LAYER_DRAWABLE_NAME, BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", OPACITY_LAYER_DRAWABLE_NAME)).toString()).getFullResourceId()).put((Object)CLOUD_SYMBOL_DRAWABLE_NAME, (Object)resourceInjector.addXmlDrawableResource(CLOUD_SYMBOL_DRAWABLE_NAME, BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", CLOUD_SYMBOL_DRAWABLE_NAME)).toString()).getFullResourceId());
        iconAttribute.ifPresent(attribute -> resourceNameToIdMapBuilder.put((Object)ARCHIVED_ICON_DRAWABLE_NAME, (Object)resourceInjector.addXmlDrawableResource(ARCHIVED_ICON_DRAWABLE_NAME, BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", ARCHIVED_ICON_DRAWABLE_NAME)).toString()).getFullResourceId()));
        roundIconAttribute.ifPresent(attribute -> resourceNameToIdMapBuilder.put((Object)ARCHIVED_ROUND_ICON_DRAWABLE_NAME, (Object)resourceInjector.addXmlDrawableResource(ARCHIVED_ROUND_ICON_DRAWABLE_NAME, BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", ARCHIVED_ROUND_ICON_DRAWABLE_NAME)).toString()).getFullResourceId()));
        return resourceNameToIdMapBuilder.build();
    }

    public static ImmutableMap<ZipPath, ByteSource> buildAdditionalResourcesByByteSourceMap(int cloudResourceId, int opacityLayerResourceId, Optional<XmlProtoAttribute> iconAttribute, Optional<XmlProtoAttribute> roundIconAttribute) throws IOException {
        ImmutableMap.Builder additionalResourcesByDestinationPathBuilder = new ImmutableMap.Builder().put((Object)BundleModule.DEX_DIRECTORY.resolve("classes.dex"), (Object)ArchivedResourcesUtils.getResourceByteSource(ARCHIVED_CLASSES_DEX_PATH)).put((Object)BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", OPACITY_LAYER_DRAWABLE_NAME)), (Object)ArchivedResourcesUtils.getResourceByteSource(OPACITY_LAYER_PATH)).put((Object)BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", CLOUD_SYMBOL_DRAWABLE_NAME)), (Object)ArchivedResourcesUtils.getResourceByteSource(CLOUD_SYMBOL_PATH));
        if (iconAttribute.isPresent()) {
            additionalResourcesByDestinationPathBuilder.put((Object)BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", ARCHIVED_ICON_DRAWABLE_NAME)), (Object)ByteSource.wrap((byte[])ArchivedResourcesUtils.buildArchiveIconXmlNode(cloudResourceId, opacityLayerResourceId, iconAttribute.get().getValueAsRefId()).getProto().toByteArray()));
        }
        if (roundIconAttribute.isPresent()) {
            additionalResourcesByDestinationPathBuilder.put((Object)BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", ARCHIVED_ROUND_ICON_DRAWABLE_NAME)), (Object)ByteSource.wrap((byte[])ArchivedResourcesUtils.buildArchiveIconXmlNode(cloudResourceId, opacityLayerResourceId, roundIconAttribute.get().getValueAsRefId()).getProto().toByteArray()));
        }
        return additionalResourcesByDestinationPathBuilder.build();
    }

    private static XmlProtoNode buildArchiveIconXmlNode(int cloudResourceId, int opacityLayerResourceId, int iconReferenceId) {
        return XmlProtoNode.createElementNode(XmlProtoElementBuilder.create("layer-list").addNamespaceDeclaration("android", "http://schemas.android.com/apk/res/android").addChildElement(XmlProtoElementBuilder.create("item").addAttribute(ArchivedResourcesUtils.createDrawableAttribute(iconReferenceId))).addChildElement(XmlProtoElementBuilder.create("item").addAttribute(ArchivedResourcesUtils.createDrawableAttribute(opacityLayerResourceId))).addChildElement(XmlProtoElementBuilder.create("item").addAttribute(ArchivedResourcesUtils.createDrawableAttribute(cloudResourceId))).build());
    }

    private static XmlProtoAttributeBuilder createDrawableAttribute(int referenceId) {
        return XmlProtoAttributeBuilder.create("drawable").setResourceId(0x1010199).setValueAsRefId(referenceId);
    }

    static ByteSource getResourceByteSource(String resourcePath) throws IOException {
        try (InputStream fileContentStream = ArchivedApksGenerator.class.getResourceAsStream(resourcePath);){
            ByteSource byteSource = ByteSource.wrap((byte[])ByteStreams.toByteArray((InputStream)fileContentStream));
            return byteSource;
        }
    }

    static String getAppStorePackageName(Optional<String> customAppStorePackageName) {
        return customAppStorePackageName.orElse(PLAY_STORE_PACKAGE_NAME);
    }

    private ArchivedResourcesUtils() {
    }
}

