/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.tools.build.bundletool.commands.AddTransparencyCommand;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.tools.build.bundletool.commands.BuildSdkApksCommand;
import com.android.tools.build.bundletool.commands.BuildSdkApksForAppCommand;
import com.android.tools.build.bundletool.commands.BuildSdkAsarCommand;
import com.android.tools.build.bundletool.commands.BuildSdkBundleCommand;
import com.android.tools.build.bundletool.commands.CheckTransparencyCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.DumpCommand;
import com.android.tools.build.bundletool.commands.EvaluateDeviceTargetingConfigCommand;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.tools.build.bundletool.commands.GetDeviceSpecCommand;
import com.android.tools.build.bundletool.commands.GetSizeCommand;
import com.android.tools.build.bundletool.commands.InstallApksCommand;
import com.android.tools.build.bundletool.commands.InstallMultiApksCommand;
import com.android.tools.build.bundletool.commands.PrintDeviceTargetingConfigCommand;
import com.android.tools.build.bundletool.commands.ValidateBundleCommand;
import com.android.tools.build.bundletool.commands.VersionCommand;
import com.android.tools.build.bundletool.device.DdmlibAdbServer;
import com.android.tools.build.bundletool.flags.FlagParser;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.google.common.collect.ImmutableList;
import java.util.Optional;

public class BundleToolMain {
    public static final String HELP_CMD = "help";

    public static void main(String[] args) {
        BundleToolMain.main(args, Runtime.getRuntime());
    }

    static void main(String[] args, Runtime runtime) {
        ParsedFlags flags;
        try {
            flags = new FlagParser().parse(args);
        }
        catch (FlagParser.FlagParseException e11) {
            System.err.println("Error while parsing the flags: " + e11.getMessage());
            runtime.exit(1);
            return;
        }
        Optional<String> command = flags.getMainCommand();
        if (!command.isPresent()) {
            System.err.println("Error: You have to specify a command.");
            BundleToolMain.help();
            runtime.exit(1);
            return;
        }
        try {
            switch (command.get()) {
                case "build-bundle": {
                    BuildBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-apks": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        BuildApksCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "build-sdk-bundle": {
                    BuildSdkBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-sdk-apks": {
                    BuildSdkApksCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-sdk-apks-for-app": {
                    BuildSdkApksForAppCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-sdk-asar": {
                    BuildSdkAsarCommand.fromFlags(flags).execute();
                    break;
                }
                case "print-device-targeting-config": {
                    PrintDeviceTargetingConfigCommand.fromFlags(flags).execute();
                    break;
                }
                case "evaluate-device-targeting-config": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        EvaluateDeviceTargetingConfigCommand.fromFlags(flags, adbServer).execute(System.out);
                        break;
                    }
                }
                case "extract-apks": {
                    ExtractApksCommand.fromFlags(flags).execute();
                    break;
                }
                case "get-device-spec": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        GetDeviceSpecCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "install-apks": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        InstallApksCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "install-multi-apks": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        InstallMultiApksCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "validate": {
                    ValidateBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "dump": {
                    DumpCommand.fromFlags(flags).execute();
                    break;
                }
                case "get-size": {
                    GetSizeCommand.fromFlags(flags).execute();
                    break;
                }
                case "version": {
                    VersionCommand.fromFlags(flags, System.out).execute();
                    break;
                }
                case "add-transparency": {
                    AddTransparencyCommand.fromFlags(flags).execute();
                    break;
                }
                case "check-transparency": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        CheckTransparencyCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "help": {
                    if (flags.getSubCommand().isPresent()) {
                        BundleToolMain.help(flags.getSubCommand().get(), runtime);
                        break;
                    }
                    BundleToolMain.help();
                    break;
                }
                default: {
                    System.err.printf("Error: Unrecognized command '%s'.%n%n%n", command.get());
                    BundleToolMain.help();
                    runtime.exit(1);
                    return;
                }
            }
        }
        catch (Exception e12) {
            System.err.println("[BT:" + BundleToolVersion.getCurrentVersion() + "] Error: " + e12.getMessage());
            e12.printStackTrace();
            runtime.exit(1);
            return;
        }
        runtime.exit(0);
    }

    public static void help() {
        ImmutableList commandHelps = ImmutableList.of((Object)BuildBundleCommand.help(), (Object)BuildApksCommand.help(), (Object)BuildSdkBundleCommand.help(), (Object)BuildSdkApksCommand.help(), (Object)BuildSdkApksForAppCommand.help(), (Object)BuildSdkAsarCommand.help(), (Object)PrintDeviceTargetingConfigCommand.help(), (Object)EvaluateDeviceTargetingConfigCommand.help(), (Object)ExtractApksCommand.help(), (Object)GetDeviceSpecCommand.help(), (Object)InstallApksCommand.help(), (Object)InstallMultiApksCommand.help(), (Object[])new CommandHelp[]{ValidateBundleCommand.help(), DumpCommand.help(), GetSizeCommand.help(), VersionCommand.help()});
        System.out.println("Synopsis: bundletool <command> ...");
        System.out.println();
        System.out.println("Use 'bundletool help <command>' to learn more about the given command.");
        System.out.println();
        commandHelps.forEach(commandHelp -> commandHelp.printSummary(System.out));
    }

    public static void help(String commandName, Runtime runtime) {
        CommandHelp commandHelp;
        switch (commandName) {
            case "build-bundle": {
                commandHelp = BuildBundleCommand.help();
                break;
            }
            case "build-apks": {
                commandHelp = BuildApksCommand.help();
                break;
            }
            case "build-sdk-bundle": {
                commandHelp = BuildSdkBundleCommand.help();
                break;
            }
            case "build-sdk-apks": {
                commandHelp = BuildSdkApksCommand.help();
                break;
            }
            case "build-sdk-apks-for-app": {
                commandHelp = BuildSdkApksForAppCommand.help();
                break;
            }
            case "build-sdk-asar": {
                commandHelp = BuildSdkAsarCommand.help();
                break;
            }
            case "print-device-targeting-config": {
                commandHelp = PrintDeviceTargetingConfigCommand.help();
                break;
            }
            case "evaluate-device-targeting-config": {
                commandHelp = EvaluateDeviceTargetingConfigCommand.help();
                break;
            }
            case "extract-apks": {
                commandHelp = ExtractApksCommand.help();
                break;
            }
            case "get-device-spec": {
                commandHelp = GetDeviceSpecCommand.help();
                break;
            }
            case "install-apks": {
                commandHelp = InstallApksCommand.help();
                break;
            }
            case "install-multi-apks": {
                commandHelp = InstallMultiApksCommand.help();
                break;
            }
            case "validate": {
                commandHelp = ValidateBundleCommand.help();
                break;
            }
            case "dump": {
                commandHelp = DumpCommand.help();
                break;
            }
            case "get-size": {
                commandHelp = GetSizeCommand.help();
                break;
            }
            case "add-transparency": {
                commandHelp = AddTransparencyCommand.help();
                break;
            }
            case "check-transparency": {
                commandHelp = CheckTransparencyCommand.help();
                break;
            }
            default: {
                System.err.printf("Error: Unrecognized command '%s'.%n%n%n", commandName);
                BundleToolMain.help();
                runtime.exit(1);
                return;
            }
        }
        commandHelp.printDetails(System.out);
    }
}

