/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class ModuleEntriesMutator {
    @CheckReturnValue
    public BundleModule applyMutation(BundleModule module) {
        if (!this.shouldApplyMutation(module)) {
            return module;
        }
        Map partitionedEntries = module.getEntries().stream().collect(Collectors.partitioningBy(this.getFilter(), ImmutableList.toImmutableList()));
        ImmutableList matchedEntries = (ImmutableList)partitionedEntries.get(true);
        ImmutableList otherEntries = (ImmutableList)partitionedEntries.get(false);
        ImmutableList newEntries = ImmutableList.builder().addAll((Iterable)otherEntries).addAll((Iterable)this.getMutator().apply((ImmutableList<ModuleEntry>)matchedEntries)).build();
        return module.toBuilder().setEntryMap((ImmutableMap<ZipPath, ModuleEntry>)((ImmutableMap)newEntries.stream().collect(ImmutableMap.toImmutableMap(ModuleEntry::getPath, Function.identity())))).build();
    }

    public abstract Predicate<ModuleEntry> getFilter();

    public abstract Function<ImmutableList<ModuleEntry>, ImmutableList<ModuleEntry>> getMutator();

    public abstract boolean shouldApplyMutation(BundleModule var1);
}

