/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.RuntimeEnabledSdkVersionEncoder;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.sdkmodule.DexAndResourceRepackager;
import com.android.tools.build.bundletool.xml.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RuntimeEnabledSdkTableInjector {
    @VisibleForTesting
    public static final String RUNTIME_ENABLED_SDK_TABLE_FILE_PATH = "assets/RuntimeEnabledSdkTable.xml";
    private static final String RUNTIME_ENABLED_SDK_TABLE_ELEMENT_NAME = "runtime-enabled-sdk-table";
    private static final String RUNTIME_ENABELD_SDK_ELEMENT_NAME = "runtime-enabled-sdk";
    private static final String SDK_PACKAGE_NAME_ELEMENT_NAME = "package-name";
    private static final String SDK_VERSION_MAJOR_ELEMENT_NAME = "version-major";
    private static final String COMPAT_CONFIG_PATH_ELEMENT_NAME = "compat-config-path";
    private final AppBundle appBundle;

    public RuntimeEnabledSdkTableInjector(AppBundle appBundle) {
        this.appBundle = appBundle;
    }

    public ModuleSplit inject(ModuleSplit split) {
        if (this.appBundle.getRuntimeEnabledSdkDependencies().isEmpty() || !this.shouldAddRuntimeEnabledSdkTable(split)) {
            return split;
        }
        return split.toBuilder().addEntry(ModuleEntry.builder().setPath(ZipPath.create(RUNTIME_ENABLED_SDK_TABLE_FILE_PATH)).setContent(ByteSource.wrap((byte[])RuntimeEnabledSdkTableInjector.generateRuntimeEnabledSdkTableBytes((ImmutableCollection<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk>)this.appBundle.getRuntimeEnabledSdkDependencies().values()))).build()).build();
    }

    public static byte[] generateRuntimeEnabledSdkTableBytes(ImmutableCollection<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> runtimeEnabledSdks) {
        return XmlUtils.documentToString(RuntimeEnabledSdkTableInjector.getRuntimeEnabledSdkTable((ImmutableSet<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk>)ImmutableSet.copyOf(runtimeEnabledSdks))).getBytes(StandardCharsets.UTF_8);
    }

    private boolean shouldAddRuntimeEnabledSdkTable(ModuleSplit split) {
        return !split.getVariantTargeting().getSdkRuntimeTargeting().getRequiresSdkRuntime() && (split.getSplitType() == ModuleSplit.SplitType.STANDALONE || split.isMasterSplit() && split.isBaseModuleSplit());
    }

    private static Document getRuntimeEnabledSdkTable(ImmutableSet<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> runtimeEnabledSdks) {
        Document runtimeEnabledSdkTable;
        try {
            runtimeEnabledSdkTable = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e11) {
            throw new IllegalStateException(e11);
        }
        runtimeEnabledSdkTable.appendChild(RuntimeEnabledSdkTableInjector.createRuntimeEnabledSdkTableNode(runtimeEnabledSdkTable, runtimeEnabledSdks));
        return runtimeEnabledSdkTable;
    }

    private static Node createRuntimeEnabledSdkTableNode(Document xmlFactory, ImmutableSet<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> runtimeEnabledSdks) {
        Element runtimeEnabledSdkTableNode = xmlFactory.createElement(RUNTIME_ENABLED_SDK_TABLE_ELEMENT_NAME);
        runtimeEnabledSdks.forEach(runtimeEnabledSdk -> runtimeEnabledSdkTableNode.appendChild(RuntimeEnabledSdkTableInjector.createRuntimeEnabledSdkNode(xmlFactory, runtimeEnabledSdk)));
        return runtimeEnabledSdkTableNode;
    }

    private static Node createRuntimeEnabledSdkNode(Document xmlFactory, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk runtimeEnabledSdk) {
        Element runtimeEnabledSdkNode = xmlFactory.createElement(RUNTIME_ENABELD_SDK_ELEMENT_NAME);
        Element sdkPackageNameNode = xmlFactory.createElement(SDK_PACKAGE_NAME_ELEMENT_NAME);
        sdkPackageNameNode.setTextContent(runtimeEnabledSdk.getPackageName());
        Element sdkVersionMajorNode = xmlFactory.createElement(SDK_VERSION_MAJOR_ELEMENT_NAME);
        sdkVersionMajorNode.setTextContent(String.valueOf(RuntimeEnabledSdkVersionEncoder.encodeSdkMajorAndMinorVersion(runtimeEnabledSdk.getVersionMajor(), runtimeEnabledSdk.getVersionMinor())));
        Element compatConfigPathNode = xmlFactory.createElement(COMPAT_CONFIG_PATH_ELEMENT_NAME);
        compatConfigPathNode.setTextContent(DexAndResourceRepackager.getCompatSdkConfigPathInAssets(runtimeEnabledSdk.getPackageName()));
        runtimeEnabledSdkNode.appendChild(sdkPackageNameNode);
        runtimeEnabledSdkNode.appendChild(sdkVersionMajorNode);
        runtimeEnabledSdkNode.appendChild(compatConfigPathNode);
        return runtimeEnabledSdkNode;
    }
}

