/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import shadow.bundletool.com.android.zipflinger.Ints;
import shadow.bundletool.com.android.zipflinger.Source;
import shadow.bundletool.com.android.zipflinger.ZipWriter;

class LocalFileHeader {
    private static final int SIGNATURE = 67324752;
    public static final int LOCAL_FILE_HEADER_SIZE = 30;
    public static final long VIRTUAL_HEADER_SIZE = 30L;
    public static final short COMPRESSION_NONE = 0;
    public static final short COMPRESSION_DEFLATE = 8;
    static final long VIRTUAL_ENTRY_MAX_SIZE = 65565L;
    static final long OFFSET_TO_NAME = 26L;
    private static final int ZIP64_PAYLOAD_SIZE = 16;
    private static final int ZIP64_EXTRA_SIZE = 20;
    private final byte[] nameBytes;
    private final short compressionFlag;
    private final int crc;
    private final long compressedSize;
    private final long uncompressedSize;
    private final boolean isZip64;
    private int padding;

    LocalFileHeader(Source source) {
        this.nameBytes = source.getNameBytes();
        this.compressionFlag = source.getCompressionFlag();
        this.crc = source.getCrc();
        this.compressedSize = source.getCompressedSize();
        this.uncompressedSize = source.getUncompressedSize();
        this.isZip64 = this.compressedSize > 0xFFFFFFFFL || this.uncompressedSize > 0xFFFFFFFFL;
        this.padding = 0;
    }

    public static void fillVirtualEntry(ByteBuffer virtualEntry) {
        int sizeToFill = virtualEntry.capacity();
        if ((long)sizeToFill < 30L) {
            String message2 = String.format("Not enough space for virtual entry (%d)", sizeToFill);
            throw new IllegalStateException(message2);
        }
        virtualEntry.order(ByteOrder.LITTLE_ENDIAN);
        virtualEntry.putInt(67324752);
        virtualEntry.putShort((short)0);
        virtualEntry.putShort((short)0);
        virtualEntry.putShort((short)0);
        virtualEntry.putShort((short)2081);
        virtualEntry.putShort((short)545);
        virtualEntry.putInt(0);
        virtualEntry.putInt(0);
        virtualEntry.putInt(0);
        virtualEntry.putShort((short)0);
        virtualEntry.putShort(Ints.intToUshort(virtualEntry.remaining() - 2));
        virtualEntry.rewind();
    }

    public void setPadding(int padding) {
        if ((long)padding > 65535L) {
            String err = String.format("Padding cannot be more than %s bytes", 65535L);
            throw new IllegalStateException(err);
        }
        this.padding = padding;
    }

    public void write(ZipWriter writer) throws IOException {
        ByteBuffer extraField = this.buildExtraField();
        int bytesNeeded = 30 + this.nameBytes.length + extraField.capacity();
        short versionNeeded = this.isZip64 ? (short)45 : 0;
        int size = this.isZip64 ? -1 : Ints.longToUint(this.uncompressedSize);
        int csize = this.isZip64 ? -1 : Ints.longToUint(this.compressedSize);
        ByteBuffer buffer = ByteBuffer.allocate(bytesNeeded).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(67324752);
        buffer.putShort(versionNeeded);
        buffer.putShort((short)0);
        buffer.putShort(this.compressionFlag);
        buffer.putShort((short)2081);
        buffer.putShort((short)545);
        buffer.putInt(this.crc);
        buffer.putInt(csize);
        buffer.putInt(size);
        buffer.putShort(Ints.intToUshort(this.nameBytes.length));
        buffer.putShort(Ints.intToUshort(extraField.capacity()));
        buffer.put(this.nameBytes);
        buffer.put(extraField);
        buffer.rewind();
        writer.write(buffer);
    }

    public long getSize() {
        long extraSize = this.isZip64 ? 20L : 0L;
        return (long)(30 + this.nameBytes.length) + extraSize;
    }

    private ByteBuffer buildExtraField() {
        if (!this.isZip64) {
            return ByteBuffer.allocate(this.padding);
        }
        ByteBuffer zip64extra = ByteBuffer.allocate(20 + this.padding);
        zip64extra.order(ByteOrder.LITTLE_ENDIAN);
        zip64extra.putShort((short)1);
        zip64extra.putShort(Ints.intToUshort(16));
        zip64extra.putLong(this.uncompressedSize);
        zip64extra.putLong(this.compressedSize);
        zip64extra.rewind();
        return zip64extra;
    }
}

