/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceId;
import com.android.bundle.DeviceProperties;
import com.android.bundle.DeviceRam;
import com.android.bundle.DeviceSelector;
import com.android.bundle.DeviceTier;
import com.android.bundle.DeviceTierConfig;
import com.android.bundle.UserCountrySet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class DeviceTargetingConfigEvaluator {
    private DeviceTargetingConfigEvaluator() {
    }

    public static Optional<DeviceTier> getSelectedDeviceTier(DeviceTierConfig config, DeviceProperties deviceProperties) {
        ImmutableList<DeviceTier> sortedDeviceTiers = DeviceTargetingConfigEvaluator.getSortedDeviceTiers(config);
        ImmutableMap<String, DeviceGroup> deviceGroupNameToDeviceGroup = DeviceTargetingConfigEvaluator.getDeviceGroupNameToDeviceGroupMap(config);
        return sortedDeviceTiers.stream().filter(tier -> DeviceTargetingConfigEvaluator.devicePropertiesMatchDeviceTier(deviceProperties, tier, deviceGroupNameToDeviceGroup)).findFirst();
    }

    public static ImmutableList<DeviceTier> getSortedDeviceTiers(DeviceTierConfig config) {
        return ImmutableList.sortedCopyOf(Comparator.comparingInt(DeviceTier::getLevel).reversed(), config.getDeviceTierSet().getDeviceTiersList());
    }

    public static ImmutableMap<String, DeviceGroup> getDeviceGroupNameToDeviceGroupMap(DeviceTierConfig config) {
        return (ImmutableMap)config.getDeviceGroupsList().stream().collect(ImmutableMap.toImmutableMap(DeviceGroup::getName, Function.identity()));
    }

    public static ImmutableSet<DeviceGroup> getMatchingDeviceGroups(DeviceTierConfig config, DeviceProperties deviceProperties) {
        return (ImmutableSet)config.getDeviceGroupsList().stream().filter(group -> DeviceTargetingConfigEvaluator.devicePropertiesMatchDeviceGroup(deviceProperties, group)).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<DeviceSelector> getDeviceSelectorsInTier(DeviceTier deviceTier, ImmutableMap<String, DeviceGroup> deviceGroupNameToDeviceGroup) {
        return (ImmutableSet)deviceTier.getDeviceGroupNamesList().stream().map(name -> ((DeviceGroup)deviceGroupNameToDeviceGroup.get(name)).getDeviceSelectorsList()).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
    }

    public static String getMatchingCountrySet(DeviceTierConfig config, String countryCode) {
        return config.getUserCountrySetsList().stream().filter(countrySet -> countrySet.getCountryCodesList().contains((Object)countryCode)).map(UserCountrySet::getName).findAny().orElse("");
    }

    private static boolean devicePropertiesMatchDeviceGroup(DeviceProperties deviceProperties, DeviceGroup deviceGroup) {
        return deviceGroup.getDeviceSelectorsList().stream().anyMatch(selector -> DeviceTargetingConfigEvaluator.devicePropertiesMatchDeviceSelector(deviceProperties, selector));
    }

    private static boolean devicePropertiesMatchDeviceTier(DeviceProperties deviceProperties, DeviceTier deviceTier, ImmutableMap<String, DeviceGroup> deviceGroupNameToDeviceGroup) {
        return DeviceTargetingConfigEvaluator.getDeviceSelectorsInTier(deviceTier, deviceGroupNameToDeviceGroup).stream().anyMatch(selector -> DeviceTargetingConfigEvaluator.devicePropertiesMatchDeviceSelector(deviceProperties, selector));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean devicePropertiesMatchDeviceSelector(DeviceProperties deviceProperties, DeviceSelector deviceSelector) {
        if (!DeviceTargetingConfigEvaluator.devicePropertiesMatchRamRule(deviceProperties, deviceSelector.getDeviceRam())) return false;
        if (!DeviceTargetingConfigEvaluator.deviceIdIncluded(deviceProperties.getDeviceId(), deviceSelector.getIncludedDeviceIdsList())) return false;
        if (DeviceTargetingConfigEvaluator.deviceIdExcluded(deviceProperties.getDeviceId(), deviceSelector.getExcludedDeviceIdsList())) return false;
        if (!deviceProperties.getSystemFeaturesList().containsAll(deviceSelector.getRequiredSystemFeaturesList())) return false;
        if (!deviceSelector.getForbiddenSystemFeaturesList().stream().noneMatch(deviceProperties.getSystemFeaturesList()::contains)) return false;
        return true;
    }

    private static boolean devicePropertiesMatchRamRule(DeviceProperties deviceProperties, DeviceRam deviceRam) {
        long minBytes = deviceRam.getMinBytes();
        long maxBytes = deviceRam.getMaxBytes() == 0L ? Long.MAX_VALUE : deviceRam.getMaxBytes();
        return minBytes <= deviceProperties.getRam() && deviceProperties.getRam() < maxBytes;
    }

    private static boolean deviceIdExcluded(DeviceId deviceId, List<DeviceId> deviceIdList) {
        DeviceId deviceOnlyBrand = DeviceId.newBuilder().setBuildBrand(deviceId.getBuildBrand()).build();
        return deviceIdList.contains(deviceId) || deviceIdList.contains(deviceOnlyBrand);
    }

    private static boolean deviceIdIncluded(DeviceId deviceId, List<DeviceId> deviceIdList) {
        if (deviceIdList.isEmpty()) {
            return true;
        }
        DeviceId deviceOnlyBrand = DeviceId.newBuilder().setBuildBrand(deviceId.getBuildBrand()).build();
        return deviceIdList.contains(deviceId) || deviceIdList.contains(deviceOnlyBrand);
    }
}

