/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;

public class CountrySetApkMatcher
extends TargetingDimensionMatcher<Targeting.CountrySetTargeting> {
    public CountrySetApkMatcher(Devices.DeviceSpec deviceSpec) {
        super(deviceSpec);
    }

    @Override
    protected Targeting.CountrySetTargeting getTargetingValue(Targeting.ApkTargeting apkTargeting) {
        return apkTargeting.getCountrySetTargeting();
    }

    @Override
    protected Targeting.CountrySetTargeting getTargetingValue(Targeting.VariantTargeting variantTargeting) {
        return Targeting.CountrySetTargeting.getDefaultInstance();
    }

    @Override
    public boolean matchesTargeting(Targeting.CountrySetTargeting targeting) {
        if (targeting.equals(Targeting.CountrySetTargeting.getDefaultInstance())) {
            return true;
        }
        ImmutableSet values2 = ImmutableSet.copyOf((Collection)targeting.getValueList());
        ImmutableSet alternatives = ImmutableSet.copyOf((Collection)targeting.getAlternativesList());
        Sets.SetView intersection = Sets.intersection((Set)values2, (Set)alternatives);
        Preconditions.checkArgument((boolean)intersection.isEmpty(), (String)"Expected targeting values and alternatives to be mutually exclusive, but both contain: %s", (Object)intersection);
        if (!this.getDeviceSpec().hasCountrySet() || this.getDeviceSpec().getCountrySet().getValue().isEmpty()) {
            return values2.isEmpty() && !alternatives.isEmpty();
        }
        return values2.contains((Object)this.getDeviceSpec().getCountrySet().getValue());
    }

    @Override
    protected boolean isDeviceDimensionPresent() {
        return this.getDeviceSpec().hasCountrySet();
    }

    @Override
    protected void checkDeviceCompatibleInternal(Targeting.CountrySetTargeting targeting) {
        if (targeting.equals(Targeting.CountrySetTargeting.getDefaultInstance())) {
            return;
        }
        if (!this.getDeviceSpec().hasCountrySet() || this.getDeviceSpec().getCountrySet().getValue().isEmpty()) {
            return;
        }
        ImmutableSet valuesAndAlternatives = (ImmutableSet)Streams.concat((Stream[])new Stream[]{targeting.getValueList().stream(), targeting.getAlternativesList().stream()}).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((boolean)valuesAndAlternatives.contains((Object)this.getDeviceSpec().getCountrySet().getValue()), (String)"The specified country set '%s' does not match any of the available values: %s.", (Object)this.getDeviceSpec().getCountrySet().getValue(), (Object)String.join((CharSequence)", ", (Iterable<? extends CharSequence>)valuesAndAlternatives));
    }
}

