/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AutoValue_RequiredSplitTypesInjector_RequiredSplitTypeName;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;

public class RequiredSplitTypesInjector {
    @CheckReturnValue
    public static ImmutableList<ModuleSplit> injectSplitTypeValidation(ImmutableList<ModuleSplit> splits, ImmutableList<BundleModuleName> requiredModules) {
        return (ImmutableList)splits.stream().map(split -> {
            ManifestEditor apkManifest = split.getAndroidManifest().toEditor();
            apkManifest.setSplitTypes((ImmutableList<String>)((ImmutableList)RequiredSplitTypesInjector.getProvidedSplitTypes(split).stream().map(RequiredSplitTypeName::toAttributeValue).collect(ImmutableList.toImmutableList())));
            if (split.isMasterSplit()) {
                apkManifest.setRequiredSplitTypes((ImmutableList<String>)((ImmutableList)RequiredSplitTypesInjector.getRequiredSplitTypes(splits, requiredModules, split).stream().map(RequiredSplitTypeName::toAttributeValue).collect(ImmutableList.toImmutableList())));
            }
            return split.toBuilder().setAndroidManifest(apkManifest.save()).build();
        }).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableSet<RequiredSplitTypeName> getProvidedSplitTypes(ModuleSplit moduleSplit) {
        Targeting.ApkTargeting apkTargeting = moduleSplit.getApkTargeting();
        BundleModuleName moduleName = moduleSplit.getModuleName();
        ImmutableSet.Builder splitTypes = ImmutableSet.builder();
        if (apkTargeting.hasAbiTargeting()) {
            splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.ABI));
        }
        if (apkTargeting.hasScreenDensityTargeting()) {
            splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.DENSITY));
        }
        if (apkTargeting.hasTextureCompressionFormatTargeting()) {
            splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.TEXTURE_FORMAT));
        }
        if (apkTargeting.hasDeviceTierTargeting()) {
            splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.DEVICE_TIER));
        }
        if (apkTargeting.hasDeviceGroupTargeting()) {
            splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.DEVICE_GROUP));
        }
        if (apkTargeting.hasCountrySetTargeting()) {
            splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.COUNTRY_SET));
        }
        if (moduleSplit.isMasterSplit() && !moduleSplit.isBaseModuleSplit()) {
            splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.MODULE));
        }
        return splitTypes.build();
    }

    private static ImmutableSet<RequiredSplitTypeName> getRequiredSplitTypes(ImmutableList<ModuleSplit> allSplits, ImmutableList<BundleModuleName> requiredModules, ModuleSplit moduleSplit) {
        BundleModuleName moduleName = moduleSplit.getModuleName();
        ImmutableSet.Builder splitTypes = ImmutableSet.builder();
        for (ModuleSplit split : allSplits) {
            if (!split.getModuleName().equals(moduleName)) continue;
            Targeting.ApkTargeting apkTargeting = split.getApkTargeting();
            if (apkTargeting.hasAbiTargeting()) {
                splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.ABI));
            }
            if (apkTargeting.hasScreenDensityTargeting()) {
                splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.DENSITY));
            }
            if (apkTargeting.hasTextureCompressionFormatTargeting()) {
                splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.TEXTURE_FORMAT));
            }
            if (apkTargeting.hasDeviceTierTargeting()) {
                splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.DEVICE_TIER));
            }
            if (apkTargeting.hasDeviceGroupTargeting()) {
                splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.DEVICE_GROUP));
            }
            if (!apkTargeting.hasCountrySetTargeting()) continue;
            splitTypes.add((Object)RequiredSplitTypeName.create(moduleName, RequiredSplitType.COUNTRY_SET));
        }
        if (moduleSplit.isBaseModuleSplit()) {
            requiredModules.stream().filter(requiredModuleName -> !requiredModuleName.equals(moduleName)).forEach(requiredModuleName -> splitTypes.add((Object)RequiredSplitTypeName.create(requiredModuleName, RequiredSplitType.MODULE)));
        }
        return splitTypes.build();
    }

    private RequiredSplitTypesInjector() {
    }

    static enum RequiredSplitType {
        ABI("abi"),
        DENSITY("density"),
        TEXTURE_FORMAT("textures"),
        DEVICE_TIER("tier"),
        DEVICE_GROUP("group"),
        COUNTRY_SET("countries"),
        MODULE("module");

        private final String label;

        private RequiredSplitType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    @AutoValue
    static abstract class RequiredSplitTypeName {
        RequiredSplitTypeName() {
        }

        abstract BundleModuleName getModuleName();

        abstract RequiredSplitType getSplitType();

        public static RequiredSplitTypeName create(BundleModuleName moduleName, RequiredSplitType splitType) {
            return new AutoValue_RequiredSplitTypesInjector_RequiredSplitTypeName(moduleName, splitType);
        }

        public String toAttributeValue() {
            return String.format("%s__%s", this.getModuleName().getName(), this.getSplitType().getLabel());
        }
    }
}

