/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.attributes.VariantAttr;
import com.android.build.gradle.internal.ide.dependencies.AdditionalArtifacts;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.LibraryService;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.dependencies.VariantKey;
import com.android.build.gradle.internal.testFixtures.TestFixturesUtil;
import com.android.builder.model.v2.ide.Library;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001ap\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\f2\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\t0\f\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"getLibrary", "Lcom/android/builder/model/v2/ide/Library;", "projectPath", "", "libraryService", "Lcom/android/build/gradle/internal/ide/dependencies/LibraryService;", "variant", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "variantDependencies", "", "Lorg/gradle/api/artifacts/result/DependencyResult;", "artifactMap", "", "Lcom/android/build/gradle/internal/ide/dependencies/VariantKey;", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "javadocArtifacts", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Ljava/io/File;", "sourceArtifacts", "getCategoryAttribute", "attributes", "Lorg/gradle/api/attributes/AttributeContainer;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nFullDependencyGraphBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullDependencyGraphBuilder.kt\ncom/android/build/gradle/internal/ide/dependencies/FullDependencyGraphBuilderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,387:1\n295#2,2:388\n1755#2,3:390\n*S KotlinDebug\n*F\n+ 1 FullDependencyGraphBuilder.kt\ncom/android/build/gradle/internal/ide/dependencies/FullDependencyGraphBuilderKt\n*L\n377#1:388,2\n297#1:390,3\n*E\n"})
public final class FullDependencyGraphBuilderKt {
    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final Library getLibrary(@NotNull String projectPath, @NotNull LibraryService libraryService, @NotNull ResolvedVariantResult variant, @NotNull List<? extends DependencyResult> variantDependencies2, @NotNull Map<VariantKey, ResolvedArtifact> artifactMap, @NotNull Map<ComponentIdentifier, ? extends File> javadocArtifacts, @NotNull Map<ComponentIdentifier, ? extends List<? extends File>> sourceArtifacts) {
        Library library;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)libraryService, (String)"libraryService");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(variantDependencies2, (String)"variantDependencies");
        Intrinsics.checkNotNullParameter(artifactMap, (String)"artifactMap");
        Intrinsics.checkNotNullParameter(javadocArtifacts, (String)"javadocArtifacts");
        Intrinsics.checkNotNullParameter(sourceArtifacts, (String)"sourceArtifacts");
        VariantKey variantKey = ArtifactUtils.toKey(variant);
        ResolvedArtifact artifact = artifactMap.get(variantKey);
        File javadoc = javadocArtifacts.get(variant.getOwner());
        List list = sourceArtifacts.get(variant.getOwner());
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List sources2 = list;
        AdditionalArtifacts additionalArtifacts = new AdditionalArtifacts(javadoc, sources2);
        if (artifact != null) {
            library = libraryService.getLibrary(artifact, additionalArtifacts);
            return library;
        }
        ComponentIdentifier owner = variant.getOwner();
        if (variant.getExternalVariant().isPresent()) {
            library = FullDependencyGraphBuilderKt.getLibrary$relocatedArtifactLibrary(libraryService, variant, additionalArtifacts);
            return library;
        }
        if (owner instanceof ProjectComponentIdentifier && Intrinsics.areEqual((Object)projectPath, (Object)((ProjectComponentIdentifier)owner).getProjectPath())) {
            library = FullDependencyGraphBuilderKt.getLibrary$androidProjectDependency(libraryService, variant, additionalArtifacts, (ProjectComponentIdentifier)owner);
            return library;
        }
        if (!(owner instanceof ProjectComponentIdentifier) && !((Collection)variantDependencies2).isEmpty()) {
            library = FullDependencyGraphBuilderKt.getLibrary$dependencyWithoutArtifactButTransitiveDependencies(libraryService, variant, additionalArtifacts);
            return library;
        }
        if (owner instanceof ProjectComponentIdentifier && !((Collection)variantDependencies2).isEmpty()) {
            AttributeContainer attributeContainer = variant.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)attributeContainer, (String)"getAttributes(...)");
            if (Intrinsics.areEqual((Object)FullDependencyGraphBuilderKt.getCategoryAttribute(attributeContainer), (Object)"platform")) {
                library = FullDependencyGraphBuilderKt.getLibrary$dependencyWithoutArtifactButTransitiveDependencies(libraryService, variant, additionalArtifacts);
                return library;
            }
        }
        if (!(owner instanceof ProjectComponentIdentifier)) return null;
        if (!ArtifactUtils.isAndroidProjectDependency(variant)) return null;
        library = FullDependencyGraphBuilderKt.getLibrary$androidProjectDependency(libraryService, variant, additionalArtifacts, (ProjectComponentIdentifier)owner);
        return library;
    }

    private static final String getCategoryAttribute(AttributeContainer attributes2) {
        Object v2;
        block3: {
            if (attributes2.keySet().contains(Category.CATEGORY_ATTRIBUTE)) {
                Object object = attributes2.getAttribute(Category.CATEGORY_ATTRIBUTE);
                Intrinsics.checkNotNull((Object)object);
                return ((Category)object).getName();
            }
            Set set = attributes2.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Attribute it = (Attribute)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)Category.CATEGORY_ATTRIBUTE.getName())) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        Attribute attribute = v2;
        if (attribute == null) {
            return null;
        }
        Attribute categoryAttr = attribute;
        return Intrinsics.areEqual((Object)categoryAttr.getType(), String.class) ? (String)attributes2.getAttribute(categoryAttr) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Library getLibrary$androidProjectDependency(LibraryService $libraryService, ResolvedVariantResult $variant, AdditionalArtifacts additionalArtifacts, ProjectComponentIdentifier owner) {
        boolean bl;
        LibraryService libraryService;
        ComponentIdentifier componentIdentifier;
        ResolvedVariantResult resolvedVariantResult;
        String string;
        File file;
        block3: {
            void $this$any$iv;
            String string2;
            ComponentIdentifier componentIdentifier2 = (ComponentIdentifier)owner;
            Object object = (VariantAttr)$variant.getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
            String string3 = object != null && (string2 = object.toString()) != null ? string2 : "unknown";
            List list = $variant.getCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCapabilities(...)");
            object = list;
            file = null;
            string = string3;
            resolvedVariantResult = $variant;
            componentIdentifier = componentIdentifier2;
            libraryService = $libraryService;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Capability it = (Capability)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    String string4 = owner.getProjectName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProjectName(...)");
                    if (!TestFixturesUtil.isProjectTestFixturesCapability(it, string4)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        boolean bl4 = false;
        ResolvedArtifact.DependencyType dependencyType = ResolvedArtifact.DependencyType.ANDROID;
        File file2 = null;
        File file3 = null;
        boolean bl5 = bl3;
        File file4 = file;
        String string5 = string;
        ResolvedVariantResult resolvedVariantResult2 = resolvedVariantResult;
        ComponentIdentifier componentIdentifier3 = componentIdentifier;
        return libraryService.getLibrary(new ResolvedArtifact(componentIdentifier3, resolvedVariantResult2, string5, file4, bl5, file3, file2, dependencyType, bl4), additionalArtifacts);
    }

    private static final Library getLibrary$dependencyWithoutArtifactButTransitiveDependencies(LibraryService $libraryService, ResolvedVariantResult $variant, AdditionalArtifacts additionalArtifacts) {
        ComponentIdentifier componentIdentifier = $variant.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"getOwner(...)");
        return $libraryService.getLibrary(new ResolvedArtifact(componentIdentifier, $variant, "unknown", null, false, null, null, ResolvedArtifact.DependencyType.NO_ARTIFACT_FILE, false), additionalArtifacts);
    }

    private static final Library getLibrary$relocatedArtifactLibrary(LibraryService $libraryService, ResolvedVariantResult $variant, AdditionalArtifacts additionalArtifacts) {
        ComponentIdentifier componentIdentifier = $variant.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"getOwner(...)");
        return $libraryService.getLibrary(new ResolvedArtifact(componentIdentifier, $variant, "unknown", null, false, null, null, ResolvedArtifact.DependencyType.RELOCATED_ARTIFACT, false), additionalArtifacts);
    }
}

