/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ClasspathComparisonTask;
import com.android.build.gradle.internal.tasks.ClasspathComparisonTaskKt;
import com.android.build.gradle.internal.tasks.Info;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.ide.common.repository.GradleVersion;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.VERIFICATION)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/AppClasspathCheckTask;", "Lcom/android/build/gradle/internal/tasks/ClasspathComparisonTask;", "<init>", "()V", "projectBuildFile", "Lorg/gradle/api/file/RegularFileProperty;", "getProjectBuildFile", "()Lorg/gradle/api/file/RegularFileProperty;", "onDifferentVersionsFound", "", "group", "", "module", "runtimeVersion", "compileVersion", "CreationAction", "gradle-core"})
public abstract class AppClasspathCheckTask
extends ClasspathComparisonTask {
    @Internal(value="only for task execution")
    @NotNull
    public abstract RegularFileProperty getProjectBuildFile();

    @Override
    protected void onDifferentVersionsFound(@NotNull String group, @NotNull String module, @NotNull String runtimeVersion, @NotNull String compileVersion) {
        Object runtime;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)runtimeVersion, (String)"runtimeVersion");
        Intrinsics.checkNotNullParameter((Object)compileVersion, (String)"compileVersion");
        try {
            runtime = GradleVersion.parse((String)runtimeVersion);
            GradleVersion compile = GradleVersion.parse((String)compileVersion);
            runtime = runtime.compareTo(compile) > 0 ? runtimeVersion : compileVersion;
        }
        catch (Throwable e) {
            runtime = runtimeVersion;
        }
        Object suggestedVersion = runtime;
        String message2 = "Conflict with dependency '" + group + ":" + module + "' in project '" + this.getProjectPath().get() + "'.\nResolved versions for runtime classpath (" + runtimeVersion + ") and compile classpath (" + compileVersion + ") differ.\nThis can lead to runtime crashes.\nTo resolve this issue follow advice at https://developer.android.com/studio/build/gradle-tips#configure-project-wide-properties.\nAlternatively, you can try to fix the problem by adding this snippet to " + ((RegularFile)this.getProjectBuildFile().get()).getAsFile() + ":\n\ndependencies {\n    implementation(\"" + group + ":" + module + ":" + (String)suggestedVersion + "\")\n}\n";
        throw new RuntimeException(message2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/AppClasspathCheckTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppClasspathCheckTask;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "<init>", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends TaskCreationAction<AppClasspathCheckTask> {
        @NotNull
        private final ComponentCreationConfig creationConfig;

        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this.creationConfig = creationConfig;
        }

        @Override
        @NotNull
        public String getName() {
            return this.creationConfig.computeTaskNameInternal("check", "Classpath");
        }

        @Override
        @NotNull
        public Class<AppClasspathCheckTask> getType() {
            return AppClasspathCheckTask.class;
        }

        @Override
        public void configure(@NotNull AppClasspathCheckTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            task.setVariantName(this.creationConfig.getName());
            Configuration runtimeClasspath = this.creationConfig.getVariantDependencies().getRuntimeClasspath();
            Configuration compileClasspath2 = this.creationConfig.getVariantDependencies().getCompileClasspath();
            task.getRuntimeVersionMap().set(task.getProject().getProviders().provider(new Callable(runtimeClasspath){
                final /* synthetic */ Configuration $runtimeClasspath;
                {
                    this.$runtimeClasspath = $runtimeClasspath;
                }

                public final Map<Info, String> call() {
                    return ClasspathComparisonTaskKt.toVersionMap(this.$runtimeClasspath);
                }
            }));
            task.getCompileVersionMap().set(task.getProject().getProviders().provider(new Callable(compileClasspath2){
                final /* synthetic */ Configuration $compileClasspath;
                {
                    this.$compileClasspath = $compileClasspath;
                }

                public final Map<Info, String> call() {
                    return ClasspathComparisonTaskKt.toVersionMap(this.$compileClasspath);
                }
            }));
            task.setFakeOutputDirectory((Provider<Directory>)this.creationConfig.getServices().getProjectInfo().getIntermediatesDirectory().map(new Transformer(this){
                final /* synthetic */ CreationAction this$0;
                {
                    this.this$0 = $receiver;
                }

                public final Directory transform(Directory it) {
                    return it.dir(this.this$0.getName()).dir(CreationAction.access$getCreationConfig$p(this.this$0).getDirName());
                }
            }));
            task.getProjectBuildFile().set(task.getProject().getBuildFile());
            task.getProjectBuildFile().disallowChanges();
        }

        public static final /* synthetic */ ComponentCreationConfig access$getCreationConfig$p(CreationAction $this) {
            return $this.creationConfig;
        }
    }
}

