/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.DensitySplit;
import com.android.build.gradle.internal.dsl.SplitOptions;
import com.android.build.gradle.internal.dsl.decorator.annotation.WithLazyInitialization;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.services.DslServices;
import com.android.resources.Density;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0005J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0014J\u0014\u0010\u0019\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bJ!\u0010\u001c\u001a\u00020\n2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u001d\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\fH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\u000b\u001a\u00020\fX\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/dsl/DensitySplitOptions;", "Lcom/android/build/gradle/internal/dsl/SplitOptions;", "Lcom/android/build/api/dsl/DensitySplit;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "<init>", "(Lcom/android/build/gradle/internal/services/DslServices;)V", "getDslServices", "()Lcom/android/build/gradle/internal/services/DslServices;", "lazyInit", "", "_isEnable", "", "get_isEnable", "()Z", "set_isEnable", "(Z)V", "value", "isEnable", "setEnable", "getDefaultValues", "", "", "getAllowedValues", "Lcom/google/common/collect/ImmutableSet;", "setCompatibleScreens", "sizes", "", "compatibleScreens", "", "([Ljava/lang/String;)V", "setAuto", "auto", "gradle-core"})
public abstract class DensitySplitOptions
extends SplitOptions
implements DensitySplit {
    @NotNull
    private final DslServices dslServices;

    @Inject
    public DensitySplitOptions(@NotNull DslServices dslServices2) {
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        this.dslServices = dslServices2;
    }

    @NotNull
    public final DslServices getDslServices() {
        return this.dslServices;
    }

    @WithLazyInitialization
    protected final void lazyInit() {
        this.setStrict(true);
        this.init();
    }

    protected abstract boolean get_isEnable();

    protected abstract void set_isEnable(boolean var1);

    public boolean isEnable() {
        return this.get_isEnable();
    }

    public void setEnable(boolean value) {
        this.dslServices.getDeprecationReporter().reportDeprecatedApi(null, "splits.density", "https://developer.android.com/studio/build/configure-apk-splits#configure-density-split", DeprecationReporter.DeprecationTarget.DENSITY_SPLIT_API);
        this.set_isEnable(value);
    }

    @Override
    @NotNull
    protected Set<String> getDefaultValues() {
        Set values = Density.getRecommendedValuesForDevice();
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)values.size());
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSetWithExpectedSize(...)");
        Set fullList = hashSet;
        for (Density value : values) {
            String string = value.getResourceValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResourceValue(...)");
            fullList.add(string);
        }
        return fullList;
    }

    @Override
    @NotNull
    protected ImmutableSet<String> getAllowedValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])Density.values());
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Density value = (Density)e;
            if (Intrinsics.areEqual((Object)value, (Object)Density.NODPI) || Intrinsics.areEqual((Object)value, (Object)Density.ANYDPI)) continue;
            builder.add((Object)value.getResourceValue());
        }
        ImmutableSet immutableSet = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"build(...)");
        return immutableSet;
    }

    public final void setCompatibleScreens(@NotNull List<String> sizes) {
        Intrinsics.checkNotNullParameter(sizes, (String)"sizes");
        List copiedValues = CollectionsKt.toList((Iterable)sizes);
        this.getCompatibleScreens().clear();
        this.getCompatibleScreens().addAll(copiedValues);
    }

    public void compatibleScreens(String ... sizes) {
        Intrinsics.checkNotNullParameter((Object)sizes, (String)"sizes");
        this.getCompatibleScreens().addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(sizes, sizes.length)));
    }

    @Deprecated(message="DensitySplitOptions.auto is not supported anymore.")
    public final void setAuto(boolean auto) {
        throw new RuntimeException("DensitySplitOptions.auto is not supported anymore.");
    }
}

