/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.dependencies.ArtifactHandler;
import com.android.build.gradle.internal.ide.dependencies.DependencyModelBuilder;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.tools.lint.model.DefaultLintModelDependencies;
import com.android.tools.lint.model.DefaultLintModelDependency;
import com.android.tools.lint.model.DefaultLintModelDependencyGraph;
import com.android.tools.lint.model.DefaultLintModelLibraryResolver;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelDependencyGraph;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelLibraryResolver;
import com.android.tools.lint.model.LintModelModuleLibrary;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0002H\u0016J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0018\u00010 2\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010%\u001a\u00020\u001b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/lint/LintDependencyModelBuilder;", "Lcom/android/build/gradle/internal/ide/dependencies/DependencyModelBuilder;", "Lcom/android/tools/lint/model/LintModelDependencies;", "artifactHandler", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactHandler;", "Lcom/android/tools/lint/model/LintModelLibrary;", "libraryMap", "", "", "mavenCoordinatesCache", "Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;", "<init>", "(Lcom/android/build/gradle/internal/ide/dependencies/ArtifactHandler;Ljava/util/Map;Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;)V", "libraryResolver", "Lcom/android/tools/lint/model/DefaultLintModelLibraryResolver;", "compileRoots", "", "Lcom/android/tools/lint/model/LintModelDependency;", "runtimeRoots", "createModel", "needFullRuntimeClasspath", "", "getNeedFullRuntimeClasspath", "()Z", "needRuntimeOnlyClasspath", "getNeedRuntimeOnlyClasspath", "addArtifact", "", "artifact", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "isProvided", "lintJarMap", "", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Ljava/io/File;", "type", "Lcom/android/build/gradle/internal/ide/dependencies/DependencyModelBuilder$ClasspathType;", "setRuntimeOnlyClasspath", "files", "Lcom/google/common/collect/ImmutableList;", "gradle-core"})
public final class LintDependencyModelBuilder
implements DependencyModelBuilder<LintModelDependencies> {
    @NotNull
    private final ArtifactHandler<LintModelLibrary> artifactHandler;
    @NotNull
    private final Map<String, LintModelLibrary> libraryMap;
    @NotNull
    private final MavenCoordinatesCacheBuildService mavenCoordinatesCache;
    @NotNull
    private final DefaultLintModelLibraryResolver libraryResolver;
    @NotNull
    private final List<LintModelDependency> compileRoots;
    @NotNull
    private final List<LintModelDependency> runtimeRoots;

    public LintDependencyModelBuilder(@NotNull ArtifactHandler<LintModelLibrary> artifactHandler, @NotNull Map<String, LintModelLibrary> libraryMap, @NotNull MavenCoordinatesCacheBuildService mavenCoordinatesCache) {
        Intrinsics.checkNotNullParameter(artifactHandler, (String)"artifactHandler");
        Intrinsics.checkNotNullParameter(libraryMap, (String)"libraryMap");
        Intrinsics.checkNotNullParameter((Object)mavenCoordinatesCache, (String)"mavenCoordinatesCache");
        this.artifactHandler = artifactHandler;
        this.libraryMap = libraryMap;
        this.mavenCoordinatesCache = mavenCoordinatesCache;
        this.libraryResolver = new DefaultLintModelLibraryResolver(this.libraryMap);
        this.compileRoots = new ArrayList();
        this.runtimeRoots = new ArrayList();
    }

    public /* synthetic */ LintDependencyModelBuilder(ArtifactHandler artifactHandler, Map map, MavenCoordinatesCacheBuildService mavenCoordinatesCacheBuildService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        this(artifactHandler, map, mavenCoordinatesCacheBuildService);
    }

    @Override
    @NotNull
    public LintModelDependencies createModel() {
        return (LintModelDependencies)new DefaultLintModelDependencies((LintModelDependencyGraph)new DefaultLintModelDependencyGraph(this.compileRoots, (LintModelLibraryResolver)this.libraryResolver), (LintModelDependencyGraph)new DefaultLintModelDependencyGraph(this.runtimeRoots, (LintModelLibraryResolver)this.libraryResolver), (LintModelLibraryResolver)this.libraryResolver);
    }

    @Override
    public boolean getNeedFullRuntimeClasspath() {
        return true;
    }

    @Override
    public boolean getNeedRuntimeOnlyClasspath() {
        return false;
    }

    @Override
    public void addArtifact(@NotNull ResolvedArtifact artifact, boolean isProvided, @Nullable Map<ComponentIdentifier, ? extends File> lintJarMap, @NotNull DependencyModelBuilder.ClasspathType type) {
        String string;
        LintModelLibrary lintModelLibrary2;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if ((!(artifact.getComponentIdentifier() instanceof ProjectComponentIdentifier) || artifact.isWrappedModule()) && artifact.getDependencyType() == ResolvedArtifact.DependencyType.ANDROID && artifact.getExtractedFolder() == null) {
            return;
        }
        LintModelLibrary lintModelLibrary3 = this.libraryMap.computeIfAbsent(artifact.computeModelAddress(this.mavenCoordinatesCache), new Function(this, artifact, isProvided, lintJarMap){
            final /* synthetic */ LintDependencyModelBuilder this$0;
            final /* synthetic */ ResolvedArtifact $artifact;
            final /* synthetic */ boolean $isProvided;
            final /* synthetic */ Map<ComponentIdentifier, File> $lintJarMap;
            {
                this.this$0 = $receiver;
                this.$artifact = $artifact;
                this.$isProvided = $isProvided;
                this.$lintJarMap = $lintJarMap;
            }

            public final LintModelLibrary apply(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (LintModelLibrary)LintDependencyModelBuilder.access$getArtifactHandler$p(this.this$0).handleArtifact(this.$artifact, this.$isProvided, this.$lintJarMap);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)lintModelLibrary3, (String)"computeIfAbsent(...)");
        LintModelLibrary lintModelLibrary4 = lintModelLibrary2 = lintModelLibrary3;
        if (lintModelLibrary4 instanceof LintModelExternalLibrary) {
            string = ((LintModelExternalLibrary)lintModelLibrary2).getResolvedCoordinates().getGroupId() + ":" + ((LintModelExternalLibrary)lintModelLibrary2).getResolvedCoordinates().getArtifactId();
        } else if (lintModelLibrary4 instanceof LintModelModuleLibrary) {
            string = "artifacts:" + ((LintModelModuleLibrary)lintModelLibrary2).getProjectPath();
        } else {
            throw new RuntimeException("Not supported library type");
        }
        String artifactName = string;
        DefaultLintModelDependency dependency = new DefaultLintModelDependency(lintModelLibrary2.getIdentifier(), artifactName, null, CollectionsKt.emptyList(), (LintModelLibraryResolver)this.libraryResolver);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                boolean bl = this.compileRoots.add((LintModelDependency)dependency);
                break;
            }
            case 2: {
                boolean bl = this.runtimeRoots.add((LintModelDependency)dependency);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void setRuntimeOnlyClasspath(@NotNull ImmutableList<File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        throw new RuntimeException("LintModel does not support runtimeOnlyClasspath");
    }

    public static final /* synthetic */ ArtifactHandler access$getArtifactHandler$p(LintDependencyModelBuilder $this) {
        return $this.artifactHandler;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DependencyModelBuilder.ClasspathType.values().length];
            try {
                nArray[DependencyModelBuilder.ClasspathType.COMPILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DependencyModelBuilder.ClasspathType.RUNTIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

