/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.Version;
import com.android.build.gradle.internal.EmulatorComponents;
import com.android.build.gradle.internal.PlatformComponents;
import com.android.build.gradle.internal.PlatformToolsComponents;
import com.android.build.gradle.internal.SdkLocation;
import com.android.build.gradle.internal.SdkLocationSourceSet;
import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.SdkParsingUtilsKt;
import com.android.build.gradle.internal.SdkType;
import com.android.build.gradle.internal.SupportToolsComponents;
import com.android.build.gradle.internal.SystemImageComponents;
import com.android.build.gradle.internal.utils.ConsoleProgressIndicatorFactory;
import com.android.builder.core.ToolsRevisionUtils;
import com.android.builder.errors.IssueReporter;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.OptionalLibrary;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0002<=BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\b\u0010 \u001a\u0004\u0018\u00010\u001fJ\b\u0010!\u001a\u0004\u0018\u00010\u001fJ\b\u0010\"\u001a\u0004\u0018\u00010\u001fJ\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$J\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$J\b\u0010'\u001a\u0004\u0018\u00010\u001fJ\b\u0010(\u001a\u0004\u0018\u00010)J\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010$J\b\u0010+\u001a\u0004\u0018\u00010,J\b\u0010-\u001a\u0004\u0018\u00010\u0007J\u0012\u0010.\u001a\u0004\u0018\u00010\u001f2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u0004\u0018\u00010\u001fJ\b\u00102\u001a\u0004\u0018\u00010\u001fJ\b\u00103\u001a\u0004\u0018\u00010\u001fJ\b\u00104\u001a\u0004\u0018\u00010\u001fJ\b\u00105\u001a\u0004\u0018\u00010\u001fJ\u0010\u00106\u001a\u0004\u0018\u00010\u001f2\u0006\u00107\u001a\u00020\u0005J\b\u00108\u001a\u0004\u0018\u00010\u001fJ\b\u00109\u001a\u0004\u0018\u00010\u001fJ\u0006\u0010:\u001a\u00020;R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006>"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy;", "", "sdkLocationSourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "platformTargetHashSupplier", "", "buildToolRevisionSupplier", "Lcom/android/repository/Revision;", "useAndroidX", "", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "suppressWarningIfTooNewForVersions", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "<init>", "(Lcom/android/build/gradle/internal/SdkLocationSourceSet;Ljava/lang/String;Lcom/android/repository/Revision;ZLcom/android/builder/errors/IssueReporter;Ljava/lang/String;Lorg/gradle/api/provider/ProviderFactory;)V", "components", "Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "getComponents", "()Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "components$delegate", "Lkotlin/Lazy;", "init", "loadSdkComponents", "targetHash", "buildToolRevision", "checkBuildToolsRevision", "revision", "loadedSuccessfully", "getAdbExecutable", "Ljava/io/File;", "getAnnotationsJar", "getAidlFramework", "getAndroidJar", "getAdditionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "getOptionalLibraries", "getApiVersionsFile", "getTargetPlatformVersion", "Lcom/android/sdklib/AndroidVersion;", "getTargetBootClasspath", "getBuildToolsInfo", "Lcom/android/sdklib/BuildToolInfo;", "getBuildToolsRevision", "getFileFromBuildTool", "component", "Lcom/android/sdklib/BuildToolInfo$PathId;", "getAidlExecutable", "getCoreLambaStubs", "getRenderScriptSupportJar", "getSupportNativeLibFolder", "getSupportBlasLibFolder", "getSystemImageLibFolder", "imageHash", "getEmulatorLibFolder", "getCoreForSystemModulesJar", "reset", "", "Companion", "DirectLoadComponents", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSdkDirectLoadingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkDirectLoadingStrategy.kt\ncom/android/build/gradle/internal/SdkDirectLoadingStrategy\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,425:1\n72#2,2:426\n72#2,2:429\n72#2,2:433\n1#3:428\n1#3:431\n1#3:432\n1#3:435\n*S KotlinDebug\n*F\n+ 1 SdkDirectLoadingStrategy.kt\ncom/android/build/gradle/internal/SdkDirectLoadingStrategy\n*L\n128#1:426,2\n136#1:429,2\n232#1:433,2\n128#1:428\n136#1:431\n232#1:435\n*E\n"})
public final class SdkDirectLoadingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkLocationSourceSet sdkLocationSourceSet;
    @Nullable
    private final String platformTargetHashSupplier;
    @Nullable
    private final Revision buildToolRevisionSupplier;
    private final boolean useAndroidX;
    @NotNull
    private final IssueReporter issueReporter;
    @Nullable
    private final String suppressWarningIfTooNewForVersions;
    @NotNull
    private final ProviderFactory providerFactory;
    @NotNull
    private final Lazy components$delegate;
    @NotNull
    private static final ConcurrentHashMap<Revision, Optional<BuildToolInfo>> buildToolsCache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, Optional<PlatformComponents>> platformCache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, Optional<SystemImageComponents>> systemImageCache = new ConcurrentHashMap();

    public SdkDirectLoadingStrategy(@NotNull SdkLocationSourceSet sdkLocationSourceSet, @Nullable String platformTargetHashSupplier, @Nullable Revision buildToolRevisionSupplier, boolean useAndroidX, @NotNull IssueReporter issueReporter2, @Nullable String suppressWarningIfTooNewForVersions, @NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)sdkLocationSourceSet, (String)"sdkLocationSourceSet");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        this.sdkLocationSourceSet = sdkLocationSourceSet;
        this.platformTargetHashSupplier = platformTargetHashSupplier;
        this.buildToolRevisionSupplier = buildToolRevisionSupplier;
        this.useAndroidX = useAndroidX;
        this.issueReporter = issueReporter2;
        this.suppressWarningIfTooNewForVersions = suppressWarningIfTooNewForVersions;
        this.providerFactory = providerFactory;
        this.components$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DirectLoadComponents>(this){
            final /* synthetic */ SdkDirectLoadingStrategy this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DirectLoadComponents invoke() {
                return SdkDirectLoadingStrategy.access$init(this.this$0, SdkDirectLoadingStrategy.access$getProviderFactory$p(this.this$0));
            }
        }));
    }

    private final DirectLoadComponents getComponents() {
        Lazy lazy = this.components$delegate;
        return (DirectLoadComponents)lazy.getValue();
    }

    private final synchronized DirectLoadComponents init(ProviderFactory providerFactory) {
        String string = this.platformTargetHashSupplier;
        if (string == null) {
            boolean bl = false;
            String string2 = "Extension not initialized yet, couldn't access compileSdkVersion.";
            throw new IllegalStateException(string2.toString());
        }
        String targetHash = string;
        SdkDirectLoadingStrategy sdkDirectLoadingStrategy = this;
        Revision revision = this.buildToolRevisionSupplier;
        if (revision == null) {
            SdkDirectLoadingStrategy sdkDirectLoadingStrategy2 = sdkDirectLoadingStrategy;
            boolean bl = false;
            SdkDirectLoadingStrategy sdkDirectLoadingStrategy3 = sdkDirectLoadingStrategy2;
            String string3 = "Extension not initialized yet, couldn't access buildToolsVersion.";
            throw new IllegalStateException(string3.toString());
        }
        Revision buildToolRevision = sdkDirectLoadingStrategy.checkBuildToolsRevision(revision);
        return this.loadSdkComponents(targetHash, buildToolRevision, providerFactory);
    }

    /*
     * WARNING - void declaration
     */
    private final DirectLoadComponents loadSdkComponents(String targetHash, Revision buildToolRevision, ProviderFactory providerFactory) {
        void $this$getOrPut$iv;
        void $this$getOrPut$iv2;
        SdkLocation sdkLocation = SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.issueReporter);
        if (sdkLocation.getType() == SdkType.MISSING) {
            return null;
        }
        File file = sdkLocation.getDirectory();
        Intrinsics.checkNotNull((Object)file);
        File sdkDirectory2 = file;
        PlatformToolsComponents platformTools = PlatformToolsComponents.Companion.build$gradle_core(sdkDirectory2, providerFactory);
        SupportToolsComponents supportTools = SupportToolsComponents.Companion.build$gradle_core(sdkDirectory2, targetHash, providerFactory);
        ConcurrentMap concurrentMap = buildToolsCache;
        Object key$iv = buildToolRevision;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv2.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Optional<BuildToolInfo> default$iv = Optional.ofNullable(SdkParsingUtilsKt.buildBuildTools(sdkDirectory2, buildToolRevision));
            boolean bl2 = false;
            object = $this$getOrPut$iv2.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        BuildToolInfo buildTools = ((Optional)object).orElse(null);
        key$iv = platformCache;
        String key$iv2 = targetHash;
        boolean $i$f$getOrPut2 = false;
        Object object2 = $this$getOrPut$iv.get(key$iv2);
        if (object2 == null) {
            boolean bl = false;
            Optional<PlatformComponents> default$iv = Optional.ofNullable(PlatformComponents.Companion.build$gradle_core(sdkDirectory2, targetHash, new ConsoleProgressIndicatorFactory(providerFactory)));
            boolean bl3 = false;
            object2 = $this$getOrPut$iv.putIfAbsent(key$iv2, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        PlatformComponents platform = ((Optional)object2).orElse(null);
        EmulatorComponents emulator = EmulatorComponents.Companion.build$gradle_core(sdkDirectory2, providerFactory);
        if (platformTools == null || supportTools == null || buildTools == null || platform == null) {
            return null;
        }
        SdkParsingUtilsKt.warnIfCompileSdkTooNew(platform.getTargetPlatformVersion$gradle_core(), this.issueReporter, this.suppressWarningIfTooNewForVersions);
        return new DirectLoadComponents(sdkDirectory2, platformTools, supportTools, buildTools, platform, emulator);
    }

    private final Revision checkBuildToolsRevision(Revision revision) {
        if (revision.compareTo(ToolsRevisionUtils.MIN_BUILD_TOOLS_REV) < 0) {
            String string = "The specified Android SDK Build Tools version (%1$s) is ignored, as it is below the minimum supported version (%2$s) for Android Gradle Plugin %3$s.\nAndroid SDK Build Tools %4$s will be used.\nTo suppress this warning, remove \"buildToolsVersion '%1$s'\" from your build.gradle file, as each version of the Android Gradle Plugin now has a default version of the build tools.";
            Object[] objectArray = new Object[]{revision, ToolsRevisionUtils.MIN_BUILD_TOOLS_REV, Version.ANDROID_GRADLE_PLUGIN_VERSION, ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.BUILD_TOOLS_TOO_LOW, (String)string2, (String)ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION.toString(), null, (int)8, null);
            Revision revision2 = ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION;
            Intrinsics.checkNotNullExpressionValue((Object)revision2, (String)"DEFAULT_BUILD_TOOLS_REVISION");
            return revision2;
        }
        return revision;
    }

    public final boolean loadedSuccessfully() {
        return this.getComponents() != null;
    }

    @Nullable
    public final File getAdbExecutable() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatformTools$gradle_core()) != null ? ((PlatformToolsComponents)object).getAdbExecutable$gradle_core() : null;
    }

    @Nullable
    public final File getAnnotationsJar() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getSupportTools$gradle_core()) != null ? ((SupportToolsComponents)object).getAnnotationsJar$gradle_core() : null;
    }

    @Nullable
    public final File getAidlFramework() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getAidlFramework$gradle_core() : null;
    }

    @Nullable
    public final File getAndroidJar() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getAndroidJar$gradle_core() : null;
    }

    @Nullable
    public final List<OptionalLibrary> getAdditionalLibraries() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getAdditionalLibraries$gradle_core() : null;
    }

    @Nullable
    public final List<OptionalLibrary> getOptionalLibraries() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getOptionalLibraries$gradle_core() : null;
    }

    @Nullable
    public final File getApiVersionsFile() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getApiVersionsFile() : null;
    }

    @Nullable
    public final AndroidVersion getTargetPlatformVersion() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getTargetPlatformVersion$gradle_core() : null;
    }

    @Nullable
    public final List<File> getTargetBootClasspath() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getTargetBootClasspath$gradle_core() : null;
    }

    @Nullable
    public final BuildToolInfo getBuildToolsInfo() {
        DirectLoadComponents directLoadComponents = this.getComponents();
        return directLoadComponents != null ? directLoadComponents.getBuildToolInfo$gradle_core() : null;
    }

    @Nullable
    public final Revision getBuildToolsRevision() {
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        return buildToolInfo != null ? buildToolInfo.getRevision() : null;
    }

    private final File getFileFromBuildTool(BuildToolInfo.PathId component2) {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo it = buildToolInfo;
            boolean bl = false;
            file = new File(it.getPath(component2));
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAidlExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.AIDL);
    }

    @Nullable
    public final File getCoreLambaStubs() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.CORE_LAMBDA_STUBS);
    }

    @Nullable
    public final File getRenderScriptSupportJar() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo it = buildToolInfo;
            boolean bl = false;
            File file2 = it.getLocation().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            file = RenderScriptProcessor.Companion.getSupportJar(file2, this.useAndroidX);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportNativeLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo it = buildToolInfo;
            boolean bl = false;
            File file2 = it.getLocation().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            file = RenderScriptProcessor.Companion.getSupportNativeLibFolder(file2);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportBlasLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo it = buildToolInfo;
            boolean bl = false;
            File file2 = it.getLocation().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            file = RenderScriptProcessor.Companion.getSupportBlasLibFolder(file2);
        } else {
            file = null;
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final File getSystemImageLibFolder(@NotNull String imageHash) {
        SystemImageComponents systemImageComponents;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
        ConcurrentMap concurrentMap = systemImageCache;
        String key$iv = imageHash;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            DirectLoadComponents directLoadComponents = this.getComponents();
            Optional<SystemImageComponents> default$iv = Optional.ofNullable(SystemImageComponents.Companion.build$gradle_core(directLoadComponents != null ? directLoadComponents.getSdkDirectory$gradle_core() : null, imageHash));
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (systemImageComponents = (SystemImageComponents)((Optional)object).orElse(null)) != null ? systemImageComponents.getSystemImageDir$gradle_core() : null;
    }

    @Nullable
    public final File getEmulatorLibFolder() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getEmulator$gradle_core()) != null ? ((EmulatorComponents)object).getEmulatorDir$gradle_core() : null;
    }

    @Nullable
    public final File getCoreForSystemModulesJar() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getCoreForSystemModulesJar$gradle_core() : null;
    }

    public final void reset() {
        Companion.clearCaches();
    }

    public static final /* synthetic */ DirectLoadComponents access$init(SdkDirectLoadingStrategy $this, ProviderFactory providerFactory) {
        return $this.init(providerFactory);
    }

    public static final /* synthetic */ ProviderFactory access$getProviderFactory$p(SdkDirectLoadingStrategy $this) {
        return $this.providerFactory;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0007R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$Companion;", "", "<init>", "()V", "buildToolsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/repository/Revision;", "Ljava/util/Optional;", "Lcom/android/sdklib/BuildToolInfo;", "platformCache", "", "Lcom/android/build/gradle/internal/PlatformComponents;", "systemImageCache", "Lcom/android/build/gradle/internal/SystemImageComponents;", "clearCaches", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final synchronized void clearCaches() {
            buildToolsCache.clear();
            platformCache.clear();
            systemImageCache.clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "", "sdkDirectory", "Ljava/io/File;", "platformTools", "Lcom/android/build/gradle/internal/PlatformToolsComponents;", "supportTools", "Lcom/android/build/gradle/internal/SupportToolsComponents;", "buildToolInfo", "Lcom/android/sdklib/BuildToolInfo;", "platform", "Lcom/android/build/gradle/internal/PlatformComponents;", "emulator", "Lcom/android/build/gradle/internal/EmulatorComponents;", "<init>", "(Ljava/io/File;Lcom/android/build/gradle/internal/PlatformToolsComponents;Lcom/android/build/gradle/internal/SupportToolsComponents;Lcom/android/sdklib/BuildToolInfo;Lcom/android/build/gradle/internal/PlatformComponents;Lcom/android/build/gradle/internal/EmulatorComponents;)V", "getSdkDirectory$gradle_core", "()Ljava/io/File;", "getPlatformTools$gradle_core", "()Lcom/android/build/gradle/internal/PlatformToolsComponents;", "getSupportTools$gradle_core", "()Lcom/android/build/gradle/internal/SupportToolsComponents;", "getBuildToolInfo$gradle_core", "()Lcom/android/sdklib/BuildToolInfo;", "getPlatform$gradle_core", "()Lcom/android/build/gradle/internal/PlatformComponents;", "getEmulator$gradle_core", "()Lcom/android/build/gradle/internal/EmulatorComponents;", "gradle-core"})
    private static final class DirectLoadComponents {
        @NotNull
        private final File sdkDirectory;
        @NotNull
        private final PlatformToolsComponents platformTools;
        @NotNull
        private final SupportToolsComponents supportTools;
        @NotNull
        private final BuildToolInfo buildToolInfo;
        @NotNull
        private final PlatformComponents platform;
        @Nullable
        private final EmulatorComponents emulator;

        public DirectLoadComponents(@NotNull File sdkDirectory2, @NotNull PlatformToolsComponents platformTools, @NotNull SupportToolsComponents supportTools, @NotNull BuildToolInfo buildToolInfo, @NotNull PlatformComponents platform, @Nullable EmulatorComponents emulator) {
            Intrinsics.checkNotNullParameter((Object)sdkDirectory2, (String)"sdkDirectory");
            Intrinsics.checkNotNullParameter((Object)platformTools, (String)"platformTools");
            Intrinsics.checkNotNullParameter((Object)supportTools, (String)"supportTools");
            Intrinsics.checkNotNullParameter((Object)buildToolInfo, (String)"buildToolInfo");
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            this.sdkDirectory = sdkDirectory2;
            this.platformTools = platformTools;
            this.supportTools = supportTools;
            this.buildToolInfo = buildToolInfo;
            this.platform = platform;
            this.emulator = emulator;
        }

        @NotNull
        public final File getSdkDirectory$gradle_core() {
            return this.sdkDirectory;
        }

        @NotNull
        public final PlatformToolsComponents getPlatformTools$gradle_core() {
            return this.platformTools;
        }

        @NotNull
        public final SupportToolsComponents getSupportTools$gradle_core() {
            return this.supportTools;
        }

        @NotNull
        public final BuildToolInfo getBuildToolInfo$gradle_core() {
            return this.buildToolInfo;
        }

        @NotNull
        public final PlatformComponents getPlatform$gradle_core() {
            return this.platform;
        }

        @Nullable
        public final EmulatorComponents getEmulator$gradle_core() {
            return this.emulator;
        }
    }
}

