/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.TestVariantBuilder;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.component.TestVariantCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.SigningConfigVersionsWriterTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskManagerConfig;
import com.android.build.gradle.internal.test.SeparateTestModuleTestData;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.tasks.CheckTestedAppObfuscation;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public class TestApplicationTaskManager
extends AbstractAppTaskManager<TestVariantBuilder, TestVariantCreationConfig> {
    public TestApplicationTaskManager(Project project, Collection<? extends ComponentInfo<TestVariantBuilder, TestVariantCreationConfig>> variants, Collection<? extends TestComponentCreationConfig> testComponents, Collection<? extends TestFixturesCreationConfig> testFixturesComponents, GlobalTaskCreationConfig globalConfig2, TaskManagerConfig localConfig) {
        super(project, variants, testComponents, testFixturesComponents, globalConfig2, localConfig);
    }

    private SeparateTestModuleTestData getTestData(TestVariantCreationConfig testVariantProperties) {
        Provider testingApk = testVariantProperties.getArtifacts().get(SingleArtifact.APK.INSTANCE);
        FileCollection privacySandboxSdkApks = testVariantProperties.getPrivacySandboxEnabled() ? testVariantProperties.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.PROVIDED_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_EXTRACTED_SDK_APKS) : null;
        Provider<Directory> privacySandboxCompatSdkApks = testVariantProperties.getPrivacySandboxEnabled() ? testVariantProperties.getPrivacySandboxCompatApks() : null;
        Provider<Directory> additionalSdkSupportedApkSplits = testVariantProperties.getPrivacySandboxEnabled() ? testVariantProperties.getUsesSdkLibrarySplitForLocalDeployment() : null;
        return new SeparateTestModuleTestData(testVariantProperties.getNamespace(), testVariantProperties, testingApk, testVariantProperties.getTestedApks(), privacySandboxSdkApks, privacySandboxCompatSdkApks, additionalSdkSupportedApkSplits, testVariantProperties.getServices().getProjectOptions().getExtraInstrumentationTestRunnerArgs());
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<TestVariantBuilder, TestVariantCreationConfig> variantInfo2) {
        this.createCommonTasks(variantInfo2);
        TestVariantCreationConfig testVariantProperties = variantInfo2.getVariant();
        SeparateTestModuleTestData testData = this.getTestData(testVariantProperties);
        this.configureTestData(testVariantProperties, testData);
        this.createValidateSigningTask(testVariantProperties);
        this.taskFactory.register(new SigningConfigVersionsWriterTask.CreationAction(testVariantProperties));
        TaskProvider<DeviceProviderInstrumentTestTask> instrumentTestTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(testVariantProperties, testData){

            @Override
            public String getName() {
                return super.getName() + "AndroidTest";
            }
        });
        this.taskFactory.configure("connectedAndroidTest", (Action<? super Task>)((Action)task -> task.dependsOn(new Object[]{instrumentTestTask})));
        this.createTestDevicesForVariant(testVariantProperties, testData, testVariantProperties.getName(), "AndroidTest");
    }

    @Override
    protected void maybeCreateJavaCodeShrinkerTask(ConsumableCreationConfig creationConfig) {
        if (creationConfig.getOptimizationCreationConfig().getMinifiedEnabled()) {
            this.doCreateJavaCodeShrinkerTask(creationConfig, true);
        } else {
            TaskProvider<CheckTestedAppObfuscation> checkObfuscation = this.taskFactory.register(new CheckTestedAppObfuscation.CreationAction((TestVariantCreationConfig)creationConfig));
            Preconditions.checkNotNull(creationConfig.getTaskContainer().getJavacTask());
            TaskFactoryUtils.dependsOn(creationConfig.getTaskContainer().getJavacTask(), checkObfuscation);
        }
    }

    @Override
    protected TaskProvider<? extends ManifestProcessorTask> createMergeManifestTasks(ApkCreationConfig creationConfig) {
        return this.taskFactory.register(new ProcessTestManifest.CreationAction((TestCreationConfig)((Object)creationConfig)));
    }
}

