/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.attribution;

import com.android.Version;
import com.android.build.gradle.internal.attribution.BuildAnalyzerConfiguratorService;
import com.android.build.gradle.internal.attribution.BuildAnalyzerService;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import com.android.tools.analytics.HostData;
import com.android.utils.HelpfulEnumConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ.\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017JL\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001e0\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020 0\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "<init>", "()V", "state", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService$State;", "taskCategoryIssues", "", "Lcom/android/buildanalyzer/common/TaskCategoryIssue;", "kotlin.jvm.PlatformType", "", "reportBuildAnalyzerIssue", "", "issue", "initBuildAnalyzerService", "project", "Lorg/gradle/api/Project;", "attributionFileLocation", "", "parameters", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerService$Parameters;", "isConfigurationCacheActive", "", "isProjectIsolationActive", "collectAllTaskInfo", "taskGraph", "Lorg/gradle/api/execution/TaskExecutionGraph;", "outputFileToTasksMap", "", "", "taskNameToTaskInfoMap", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData$TaskInfo;", "taskCategoryConverter", "Lcom/android/utils/HelpfulEnumConverter;", "Lcom/android/buildanalyzer/common/TaskCategory;", "getTaskClassName", "className", "State", "RegistrationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nBuildAnalyzerConfiguratorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAnalyzerConfiguratorService.kt\ncom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,178:1\n1863#2:179\n1863#2,2:180\n1864#2:186\n11165#3:182\n11500#3,3:183\n*S KotlinDebug\n*F\n+ 1 BuildAnalyzerConfiguratorService.kt\ncom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService\n*L\n127#1:179\n128#1:180,2\n127#1:186\n141#1:182\n141#1:183,3\n*E\n"})
public abstract class BuildAnalyzerConfiguratorService
implements BuildService<BuildServiceParameters.None> {
    @NotNull
    private State state = State.NOT_INITIALIZED;
    private final Set<TaskCategoryIssue> taskCategoryIssues = Collections.synchronizedSet(new LinkedHashSet());

    public final void reportBuildAnalyzerIssue(@NotNull TaskCategoryIssue issue) {
        Intrinsics.checkNotNullParameter((Object)((Object)issue), (String)"issue");
        if (this.state == State.MAIN_SERVICE_CONFIGURED) {
            throw new RuntimeException("The configurator service has already configured the build analyzer service. To add execution time warnings, add them directly to the BuildAnalyzerService.");
        }
        this.taskCategoryIssues.add(issue);
    }

    public final void initBuildAnalyzerService(@NotNull Project project, @NotNull String attributionFileLocation, @NotNull BuildAnalyzerService.Parameters parameters, boolean isConfigurationCacheActive, boolean isProjectIsolationActive) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)attributionFileLocation, (String)"attributionFileLocation");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (this.state != State.NOT_INITIALIZED) {
            return;
        }
        this.state = State.INITIALIZED;
        HelpfulEnumConverter taskCategoryConverter = new HelpfulEnumConverter(TaskCategory.class);
        project.getGradle().getTaskGraph().whenReady(new Action(isProjectIsolationActive, this, (HelpfulEnumConverter<TaskCategory>)taskCategoryConverter, project, parameters, attributionFileLocation, isConfigurationCacheActive){
            final /* synthetic */ boolean $isProjectIsolationActive;
            final /* synthetic */ BuildAnalyzerConfiguratorService this$0;
            final /* synthetic */ HelpfulEnumConverter<TaskCategory> $taskCategoryConverter;
            final /* synthetic */ Project $project;
            final /* synthetic */ BuildAnalyzerService.Parameters $parameters;
            final /* synthetic */ String $attributionFileLocation;
            final /* synthetic */ boolean $isConfigurationCacheActive;
            {
                this.$isProjectIsolationActive = $isProjectIsolationActive;
                this.this$0 = $receiver;
                this.$taskCategoryConverter = $taskCategoryConverter;
                this.$project = $project;
                this.$parameters = $parameters;
                this.$attributionFileLocation = $attributionFileLocation;
                this.$isConfigurationCacheActive = $isConfigurationCacheActive;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(TaskExecutionGraph taskGraph) {
                Object object;
                String string;
                String string2;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                List list;
                Map.Entry it;
                Object object2;
                void $this$mapTo$iv$iv;
                Object destination$iv$iv;
                Map $this$map$iv;
                Map outputFileToTasksMap = new LinkedHashMap<K, V>();
                Map taskNameToTaskInfoMap = new LinkedHashMap<K, V>();
                if (!this.$isProjectIsolationActive) {
                    Intrinsics.checkNotNull((Object)taskGraph);
                    BuildAnalyzerConfiguratorService.access$collectAllTaskInfo(this.this$0, taskGraph, outputFileToTasksMap, taskNameToTaskInfoMap, this.$taskCategoryConverter);
                }
                if (!this.$isProjectIsolationActive) {
                    Project project = this.$project.getRootProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getRootProject(...)");
                    Iterable iterable = GradlePluginUtils.getBuildscriptDependencies(project);
                    boolean $i$f$map = false;
                    void var7_6 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)item$iv$iv;
                        object2 = destination$iv$iv;
                        boolean bl = false;
                        object2.add(it.getGroup() + ":" + it.getModule() + ":" + it.getVersion());
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List buildscriptDependenciesInfo = list;
                this.$parameters.getAttributionFileLocation().set((Object)this.$attributionFileLocation);
                $this$map$iv = outputFileToTasksMap;
                object2 = this.$parameters.getTasksSharingOutputs();
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                Iterator<Object> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv;
                    it = element$iv$iv = (Map.Entry)iterator2.next();
                    boolean bl = false;
                    if (!(((List)it.getValue()).size() > 1)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                object2.set((Map)destination$iv$iv);
                Property<AndroidGradlePluginAttributionData.JavaInfo> property = this.$parameters.getJavaInfo();
                String string3 = System.getProperty("java.version");
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = System.getProperty("java.vendor")) == null) {
                    string2 = "";
                }
                if ((string = System.getProperty("java.home")) == null) {
                    string = "";
                }
                if ((object = HostData.getRuntimeBean()) == null || (object = object.getInputArguments()) == null) {
                    object = CollectionsKt.emptyList();
                }
                property.set((Object)new AndroidGradlePluginAttributionData.JavaInfo(string3, string2, string, (List<String>)object));
                this.$parameters.getBuildscriptDependenciesInfo().set((Iterable)buildscriptDependenciesInfo);
                this.$parameters.getBuildInfo().set((Object)new AndroidGradlePluginAttributionData.BuildInfo(Version.ANDROID_GRADLE_PLUGIN_VERSION, this.$project.getGradle().getGradleVersion(), this.$isConfigurationCacheActive));
                this.$parameters.getTaskNameToTaskInfoMap().set(taskNameToTaskInfoMap);
                this.$parameters.getTaskCategoryIssues().set((Iterable)BuildAnalyzerConfiguratorService.access$getTaskCategoryIssues$p(this.this$0));
                BuildAnalyzerConfiguratorService.access$setState$p(this.this$0, State.MAIN_SERVICE_CONFIGURED);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void collectAllTaskInfo(TaskExecutionGraph taskGraph, Map<String, List<String>> outputFileToTasksMap, Map<String, AndroidGradlePluginAttributionData.TaskInfo> taskNameToTaskInfoMap, HelpfulEnumConverter<TaskCategory> taskCategoryConverter) {
        List list = taskGraph.getAllTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllTasks(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidGradlePluginAttributionData.TaskCategoryInfo taskCategoryInfo;
            Task task = (Task)element$iv;
            boolean bl = false;
            FileCollection fileCollection2 = task.getOutputs().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getFiles(...)");
            Iterable $this$forEach$iv2 = (Iterable)fileCollection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File outputFile = (File)element$iv2;
                boolean bl2 = false;
                String string = task.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                outputFileToTasksMap.computeIfAbsent(outputFile.getAbsolutePath(), collectAllTaskInfo.1.1.1.INSTANCE).add(string);
            }
            if (task.getClass().isAnnotationPresent(BuildAnalyzer.class)) {
                void $this$mapTo$iv$iv;
                BuildAnalyzer annotation = task.getClass().getAnnotation(BuildAnalyzer.class);
                Object object = taskCategoryConverter.convert((Object)annotation.primaryTaskCategory().toString());
                Intrinsics.checkNotNull((Object)object);
                TaskCategory primaryTaskCategory = (TaskCategory)((Object)object);
                TaskCategory[] $this$map$iv = annotation.secondaryTaskCategories();
                boolean $i$f$map = false;
                TaskCategory[] taskCategoryArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var23_25 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Object object2 = taskCategoryConverter.convert((Object)it.toString());
                    Intrinsics.checkNotNull((Object)object2);
                    collection.add((TaskCategory)((Object)object2));
                }
                List secondaryTaskCategories = (List)destination$iv$iv;
                taskCategoryInfo = new AndroidGradlePluginAttributionData.TaskCategoryInfo(primaryTaskCategory, secondaryTaskCategories);
            } else {
                taskCategoryInfo = new AndroidGradlePluginAttributionData.TaskCategoryInfo(TaskCategory.UNCATEGORIZED, null, 2, null);
            }
            AndroidGradlePluginAttributionData.TaskCategoryInfo taskCategoryInfo2 = taskCategoryInfo;
            Map<String, AndroidGradlePluginAttributionData.TaskInfo> map = taskNameToTaskInfoMap;
            String string = task.getName();
            String string2 = task.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            AndroidGradlePluginAttributionData.TaskInfo taskInfo = new AndroidGradlePluginAttributionData.TaskInfo(this.getTaskClassName(string2), taskCategoryInfo2);
            map.put(string, taskInfo);
        }
    }

    private final String getTaskClassName(String className) {
        if (StringsKt.endsWith$default((String)className, (String)"_Decorated", (boolean)false, (int)2, null)) {
            String string = className.substring(0, className.length() - 10);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return className;
    }

    public static final /* synthetic */ void access$collectAllTaskInfo(BuildAnalyzerConfiguratorService $this, TaskExecutionGraph taskGraph, Map outputFileToTasksMap, Map taskNameToTaskInfoMap, HelpfulEnumConverter taskCategoryConverter) {
        $this.collectAllTaskInfo(taskGraph, outputFileToTasksMap, taskNameToTaskInfoMap, (HelpfulEnumConverter<TaskCategory>)taskCategoryConverter);
    }

    public static final /* synthetic */ Set access$getTaskCategoryIssues$p(BuildAnalyzerConfiguratorService $this) {
        return $this.taskCategoryIssues;
    }

    public static final /* synthetic */ void access$setState$p(BuildAnalyzerConfiguratorService $this, State state) {
        $this.state = state;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<BuildAnalyzerConfiguratorService, BuildServiceParameters.None> {
        public RegistrationAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, BuildAnalyzerConfiguratorService.class, null, null, 12, null);
        }

        @Override
        public void configure(@NotNull BuildServiceParameters.None parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerConfiguratorService$State;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_INITIALIZED", "INITIALIZED", "MAIN_SERVICE_CONFIGURED", "gradle-core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_INITIALIZED = new State();
        public static final /* enum */ State INITIALIZED = new State();
        public static final /* enum */ State MAIN_SERVICE_CONFIGURED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.NOT_INITIALIZED, State.INITIALIZED, State.MAIN_SERVICE_CONFIGURED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

