/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.Version;
import com.android.build.gradle.internal.cxx.logging.CxxStructuredLogEncoder;
import com.android.build.gradle.internal.cxx.logging.EncodedLoggingMessage;
import com.android.build.gradle.internal.cxx.logging.IssueReporterLoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.LoggingMessage;
import com.android.build.gradle.internal.cxx.logging.LoggingMessageKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughRecordingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.builder.errors.IssueReporter;
import com.google.protobuf.GeneratedMessageV3;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\rB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u0012J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001c\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/IssueReporterLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/PassThroughRecordingLoggingEnvironment;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "rootBuildGradleFolder", "Ljava/io/File;", "cxxFolder", "allowStructuredLogging", "", "metrics", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "<init>", "(Lcom/android/builder/errors/IssueReporter;Ljava/io/File;Ljava/io/File;ZLcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "(Lcom/android/builder/errors/IssueReporter;Ljava/io/File;Ljava/io/File;Z)V", "analyticsService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "(Lcom/android/builder/errors/IssueReporter;Lcom/android/build/gradle/internal/profile/AnalyticsService;Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Z)V", "structuredLogEncoder", "Lcom/android/build/gradle/internal/cxx/logging/CxxStructuredLogEncoder;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "log", "", "message", "Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage;", "logStructured", "Lkotlin/Function1;", "Lcom/android/build/gradle/internal/cxx/string/StringEncoder;", "Lcom/google/protobuf/GeneratedMessageV3;", "close", "gradle-core"})
public final class IssueReporterLoggingEnvironment
extends PassThroughRecordingLoggingEnvironment {
    @NotNull
    private final IssueReporter issueReporter;
    @Nullable
    private final File cxxFolder;
    @Nullable
    private final GradleBuildVariant.Builder metrics;
    @Nullable
    private final CxxStructuredLogEncoder structuredLogEncoder;
    private final Logger logger;

    private IssueReporterLoggingEnvironment(IssueReporter issueReporter2, File rootBuildGradleFolder, File cxxFolder, boolean allowStructuredLogging, GradleBuildVariant.Builder metrics) {
        CxxStructuredLogEncoder cxxStructuredLogEncoder;
        this.issueReporter = issueReporter2;
        this.cxxFolder = cxxFolder;
        this.metrics = metrics;
        File structuredLogFolder = IssueReporterLoggingEnvironmentKt.getCxxStructuredLogFolder(rootBuildGradleFolder);
        if (allowStructuredLogging && structuredLogFolder.isDirectory()) {
            File log2 = FilesKt.resolve((File)structuredLogFolder, (String)("log_" + System.currentTimeMillis() + "_" + Thread.currentThread().getId() + ".bin"));
            cxxStructuredLogEncoder = new CxxStructuredLogEncoder(log2);
        } else {
            cxxStructuredLogEncoder = null;
        }
        this.structuredLogEncoder = cxxStructuredLogEncoder;
        this.logger = Logging.getLogger(IssueReporterLoggingEnvironment.class);
    }

    public IssueReporterLoggingEnvironment(@NotNull IssueReporter issueReporter2, @NotNull File rootBuildGradleFolder, @Nullable File cxxFolder, boolean allowStructuredLogging) {
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)rootBuildGradleFolder, (String)"rootBuildGradleFolder");
        this(issueReporter2, rootBuildGradleFolder, cxxFolder, allowStructuredLogging, null);
    }

    public IssueReporterLoggingEnvironment(@NotNull IssueReporter issueReporter2, @NotNull AnalyticsService analyticsService, @NotNull CxxVariantModel variant, boolean allowStructuredLogging) {
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this(issueReporter2, variant.getModule().getProject().getRootBuildGradleFolder(), variant.getModule().getCxxFolder(), allowStructuredLogging, analyticsService.getVariantBuilder(variant.getModule().getGradleModulePathName(), variant.getVariantName()));
    }

    public /* synthetic */ IssueReporterLoggingEnvironment(IssueReporter issueReporter2, AnalyticsService analyticsService, CxxVariantModel cxxVariantModel, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(issueReporter2, analyticsService, cxxVariantModel, bl);
    }

    @Override
    public void log(@NotNull LoggingMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.logStructured((Function1<? super StringEncoder, ? extends GeneratedMessageV3>)((Function1)new Function1<StringEncoder, GeneratedMessageV3>(message2){
            final /* synthetic */ LoggingMessage $message;
            {
                this.$message = $message;
                super(1);
            }

            public final GeneratedMessageV3 invoke(StringEncoder strings) {
                Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
                EncodedLoggingMessage.Builder builder = EncodedLoggingMessage.newBuilder().setLevel(this.$message.getLevel());
                String string = this.$message.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
                EncodedLoggingMessage.Builder encoded = builder.setMessageId(strings.encode(string)).setDiagnosticCode(this.$message.getDiagnosticCode());
                if (this.$message.getFile() != null) {
                    String string2 = this.$message.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFile(...)");
                    encoded.setFileId(strings.encode(string2));
                }
                if (this.$message.getTag() != null) {
                    String string3 = this.$message.getTag();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTag(...)");
                    encoded.setTagId(strings.encode(string3));
                }
                EncodedLoggingMessage encodedLoggingMessage = encoded.build();
                Intrinsics.checkNotNullExpressionValue((Object)encodedLoggingMessage, (String)"build(...)");
                return encodedLoggingMessage;
            }
        }));
        LoggingMessage.LoggingLevel loggingLevel = message2.getLevel();
        switch (loggingLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[loggingLevel.ordinal()]) {
            case 1: {
                this.logger.info(LoggingMessageKt.text(message2));
                break;
            }
            case 2: {
                this.logger.lifecycle(LoggingMessageKt.text(message2));
                break;
            }
            case 3: {
                GradleBuildVariant.Builder builder = this.metrics;
                if (builder != null) {
                    builder.addCxxDiagnosticCodes(message2.getDiagnosticCode());
                }
                IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, (String)LoggingMessageKt.text(message2), null, null, (int)12, null);
                this.logger.warn(LoggingMessageKt.text(message2));
                break;
            }
            case 4: {
                GradleBuildVariant.Builder builder = this.metrics;
                if (builder != null) {
                    builder.addCxxDiagnosticCodes(message2.getDiagnosticCode());
                }
                IssueReporter.reportError$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, (String)LoggingMessageKt.text(message2), null, null, (int)12, null);
                this.logger.error(LoggingMessageKt.text(message2));
                break;
            }
            case 5: {
                GradleBuildVariant.Builder builder = this.metrics;
                if (builder != null) {
                    builder.addCxxDiagnosticCodes(message2.getDiagnosticCode());
                }
                StringBuilder sb = new StringBuilder(LoggingMessageKt.text(message2) + " ");
                sb.append("Please refer to bug https://issuetracker.google.com/" + message2.getDiagnosticCode() + " for more information. \n");
                if (this.cxxFolder != null) {
                    sb.append("If possible, please also attach a zipped copy of " + this.cxxFolder + " to the bug to assist in diagnosing the issue. \n");
                }
                sb.append("The current Android Gradle Plugin Version is " + Version.ANDROID_GRADLE_PLUGIN_VERSION + ".\n");
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                IssueReporter.reportError$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, (String)string, null, null, (int)12, null);
                this.logger.error(sb.toString());
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void logStructured(@NotNull Function1<? super StringEncoder, ? extends GeneratedMessageV3> message2) {
        block0: {
            Intrinsics.checkNotNullParameter(message2, (String)"message");
            CxxStructuredLogEncoder cxxStructuredLogEncoder = this.structuredLogEncoder;
            if (cxxStructuredLogEncoder == null) break block0;
            cxxStructuredLogEncoder.write((GeneratedMessageV3)message2.invoke((Object)this.structuredLogEncoder));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.structuredLogEncoder != null) {
                LoggingEnvironmentKt.infoln("Closing '" + this.structuredLogEncoder.getFile() + "'", new Object[0]);
                this.structuredLogEncoder.close();
            }
        }
        finally {
            super.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoggingMessage.LoggingLevel.values().length];
            try {
                nArray[LoggingMessage.LoggingLevel.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingMessage.LoggingLevel.LIFECYCLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingMessage.LoggingLevel.WARN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingMessage.LoggingLevel.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingMessage.LoggingLevel.BUG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoggingMessage.LoggingLevel.UNRECOGNIZED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

