/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.CompileSdkReleaseSpec;
import com.android.build.api.dsl.CompileSdkSpec;
import com.android.build.api.dsl.CompileSdkVersion;
import com.android.build.gradle.internal.dsl.CompileSdkProperties;
import com.android.build.gradle.internal.dsl.CompileSdkSpecImpl;
import com.android.build.gradle.internal.dsl.CompileSdkVersionImpl;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.utils.SdkUtilsKt;
import com.android.builder.errors.IssueReporter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0010\u001a\u00020\u00072\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b$H\u0016J\u0016\u0010\u0010\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0%H\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0013H\u0016J \u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u000fH\u0016J\b\u0010+\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0013H\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0002\u0010\u0011\"\u0004\b\u0005\u0010\u0012R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0012R(\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0011\"\u0004\b\u001e\u0010\u0012R(\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/dsl/CompileSdkDelegate;", "Lcom/android/build/gradle/internal/dsl/CompileSdkProperties;", "getCompileSdk", "Lkotlin/Function0;", "Lcom/android/build/api/dsl/CompileSdkVersion;", "setCompileSdk", "Lkotlin/Function1;", "", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lcom/android/builder/errors/IssueReporter;Lcom/android/build/gradle/internal/services/DslServices;)V", "value", "", "compileSdk", "()Ljava/lang/Integer;", "(Ljava/lang/Integer;)V", "", "compileSdkPreview", "getCompileSdkPreview", "()Ljava/lang/String;", "setCompileSdkPreview", "(Ljava/lang/String;)V", "compileSdkExtension", "getCompileSdkExtension", "setCompileSdkExtension", "compileSdkMinor", "getCompileSdkMinor", "setCompileSdkMinor", "compileSdkVersion", "getCompileSdkVersion", "setCompileSdkVersion", "action", "Lcom/android/build/api/dsl/CompileSdkSpec;", "Lkotlin/ExtensionFunctionType;", "Lorg/gradle/api/Action;", "apiLevel", "version", "compileSdkAddon", "vendor", "name", "createCompileSdkSpec", "Lcom/android/build/gradle/internal/dsl/CompileSdkSpecImpl;", "parseAndSetCompileSdkVersion", "gradle-core"})
public final class CompileSdkDelegate
implements CompileSdkProperties {
    @NotNull
    private final Function0<CompileSdkVersion> getCompileSdk;
    @NotNull
    private final Function1<CompileSdkVersion, Unit> setCompileSdk;
    @NotNull
    private final IssueReporter issueReporter;
    @NotNull
    private final DslServices dslServices;

    public CompileSdkDelegate(@NotNull Function0<? extends CompileSdkVersion> getCompileSdk, @NotNull Function1<? super CompileSdkVersion, Unit> setCompileSdk, @NotNull IssueReporter issueReporter2, @NotNull DslServices dslServices2) {
        Intrinsics.checkNotNullParameter(getCompileSdk, (String)"getCompileSdk");
        Intrinsics.checkNotNullParameter(setCompileSdk, (String)"setCompileSdk");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        this.getCompileSdk = getCompileSdk;
        this.setCompileSdk = setCompileSdk;
        this.issueReporter = issueReporter2;
        this.dslServices = dslServices2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Integer getCompileSdk() {
        CompileSdkVersion currentSdk;
        CompileSdkVersion compileSdkVersion2 = currentSdk = (CompileSdkVersion)this.getCompileSdk.invoke();
        if ((compileSdkVersion2 != null ? compileSdkVersion2.getVendorName() : null) != null) return null;
        CompileSdkVersion compileSdkVersion3 = currentSdk;
        if ((compileSdkVersion3 != null ? compileSdkVersion3.getCodeName() : null) != null) {
            return null;
        }
        boolean bl = false;
        boolean isAddonOrPreview = bl;
        if (isAddonOrPreview) return null;
        CompileSdkVersion compileSdkVersion4 = currentSdk;
        if (compileSdkVersion4 == null) return null;
        Integer n = compileSdkVersion4.getApiLevel();
        return n;
    }

    @Override
    public void setCompileSdk(@Nullable Integer value) {
        this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(value){
            final /* synthetic */ Integer $value;
            {
                this.$value = $value;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(CompileSdkSpec $this$compileSdk) {
                CompileSdkVersion compileSdkVersion2;
                Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                CompileSdkSpec compileSdkSpec = $this$compileSdk;
                Integer n = this.$value;
                if (n != null) {
                    void it;
                    int n2 = ((Number)n).intValue();
                    CompileSdkSpec compileSdkSpec2 = compileSdkSpec;
                    boolean bl = false;
                    compileSdkVersion2 = $this$compileSdk.release((int)it);
                    compileSdkSpec = compileSdkSpec2;
                } else {
                    compileSdkVersion2 = null;
                }
                compileSdkSpec.setVersion(compileSdkVersion2);
            }
        }));
    }

    @Override
    @Nullable
    public String getCompileSdkPreview() {
        CompileSdkVersion compileSdkVersion2 = (CompileSdkVersion)this.getCompileSdk.invoke();
        return compileSdkVersion2 != null ? compileSdkVersion2.getCodeName() : null;
    }

    @Override
    public void setCompileSdkPreview(@Nullable String value) {
        if (value == null) {
            CompileSdkVersion compileSdkVersion2 = (CompileSdkVersion)this.getCompileSdk.invoke();
            if ((compileSdkVersion2 != null ? compileSdkVersion2.getCodeName() : null) != null) {
                this.setCompileSdk.invoke(null);
            }
            return;
        }
        this.setCompileSdk.invoke(null);
        String previewValue = SdkUtilsKt.validatePreviewTargetValue(value);
        if (previewValue != null) {
            this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(previewValue){
                final /* synthetic */ String $previewValue;
                {
                    this.$previewValue = $previewValue;
                    super(1);
                }

                public final void invoke(CompileSdkSpec $this$compileSdk) {
                    Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                    $this$compileSdk.setVersion($this$compileSdk.preview(this.$previewValue));
                }
            }));
        } else if (StringsKt.toIntOrNull((String)value) != null) {
            this.issueReporter.reportError(IssueReporter.Type.GENERIC, (Exception)new RuntimeException("Invalid integer value for compileSdkPreview (" + value + "). Use compileSdk instead"));
        } else {
            String string;
            if (StringsKt.startsWith$default((String)value, (String)"android-", (boolean)false, (int)2, null)) {
                String string2 = value.substring(8);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = "S";
            }
            String expected = string;
            this.issueReporter.reportError(IssueReporter.Type.GENERIC, (Exception)new RuntimeException("Invalid value for compileSdkPreview (\"" + value + "\"). Value must be a platform preview name (e.g. \"" + expected + "\")"));
        }
    }

    @Override
    @Nullable
    public Integer getCompileSdkExtension() {
        CompileSdkVersion compileSdkVersion2 = (CompileSdkVersion)this.getCompileSdk.invoke();
        return compileSdkVersion2 != null ? compileSdkVersion2.getSdkExtension() : null;
    }

    @Override
    public void setCompileSdkExtension(@Nullable Integer value) {
        this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(this, value){
            final /* synthetic */ CompileSdkDelegate this$0;
            final /* synthetic */ Integer $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(CompileSdkSpec $this$compileSdk) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                    Object object = (CompileSdkVersion)CompileSdkDelegate.access$getGetCompileSdk$p(this.this$0).invoke();
                    if (object == null || (object = object.getApiLevel()) == null) break block0;
                    Object object2 = object;
                    Integer n = this.$value;
                    CompileSdkDelegate compileSdkDelegate2 = this.this$0;
                    int apiLevel = ((Number)object2).intValue();
                    boolean bl = false;
                    $this$compileSdk.setVersion($this$compileSdk.release(apiLevel, (Function1)new Function1<CompileSdkReleaseSpec, Unit>(n, compileSdkDelegate2){
                        final /* synthetic */ Integer $value;
                        final /* synthetic */ CompileSdkDelegate this$0;
                        {
                            this.$value = $value;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(CompileSdkReleaseSpec $this$release) {
                            Intrinsics.checkNotNullParameter((Object)$this$release, (String)"$this$release");
                            $this$release.setSdkExtension(this.$value);
                            CompileSdkVersion compileSdkVersion2 = (CompileSdkVersion)CompileSdkDelegate.access$getGetCompileSdk$p(this.this$0).invoke();
                            $this$release.setMinorApiLevel(compileSdkVersion2 != null ? compileSdkVersion2.getMinorApiLevel() : null);
                        }
                    }));
                }
            }
        }));
    }

    @Override
    @Nullable
    public Integer getCompileSdkMinor() {
        CompileSdkVersion compileSdkVersion2 = (CompileSdkVersion)this.getCompileSdk.invoke();
        return compileSdkVersion2 != null ? compileSdkVersion2.getMinorApiLevel() : null;
    }

    @Override
    public void setCompileSdkMinor(@Nullable Integer value) {
        block2: {
            Object object = (CompileSdkVersion)this.getCompileSdk.invoke();
            if (object == null || (object = object.getApiLevel()) == null) break block2;
            int apiLevel = ((Number)object).intValue();
            boolean bl = false;
            this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(apiLevel, value){
                final /* synthetic */ int $apiLevel;
                final /* synthetic */ Integer $value;
                {
                    this.$apiLevel = $apiLevel;
                    this.$value = $value;
                    super(1);
                }

                public final void invoke(CompileSdkSpec $this$compileSdk) {
                    Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                    $this$compileSdk.setVersion($this$compileSdk.release(this.$apiLevel, (Function1)new Function1<CompileSdkReleaseSpec, Unit>(this.$value, $this$compileSdk){
                        final /* synthetic */ Integer $value;
                        final /* synthetic */ CompileSdkSpec $this_compileSdk;
                        {
                            this.$value = $value;
                            this.$this_compileSdk = $this_compileSdk;
                            super(1);
                        }

                        public final void invoke(CompileSdkReleaseSpec $this$release) {
                            Intrinsics.checkNotNullParameter((Object)$this$release, (String)"$this$release");
                            $this$release.setMinorApiLevel(this.$value);
                            CompileSdkVersion compileSdkVersion2 = this.$this_compileSdk.getVersion();
                            $this$release.setSdkExtension(compileSdkVersion2 != null ? compileSdkVersion2.getSdkExtension() : null);
                        }
                    }));
                }
            }));
            if (apiLevel < 36) {
                CompileSdkVersion compileSdkVersion2 = (CompileSdkVersion)this.getCompileSdk.invoke();
                if ((compileSdkVersion2 != null ? compileSdkVersion2.getMinorApiLevel() : null) != null) {
                    this.dslServices.getIssueReporter().reportError(IssueReporter.Type.GENERIC, (Exception)new RuntimeException("Minor versions are only supported for API 36 and above."));
                    this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(apiLevel){
                        final /* synthetic */ int $apiLevel;
                        {
                            this.$apiLevel = $apiLevel;
                            super(1);
                        }

                        public final void invoke(CompileSdkSpec $this$compileSdk) {
                            Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                            $this$compileSdk.setVersion($this$compileSdk.release(this.$apiLevel, (Function1)new Function1<CompileSdkReleaseSpec, Unit>($this$compileSdk){
                                final /* synthetic */ CompileSdkSpec $this_compileSdk;
                                {
                                    this.$this_compileSdk = $this_compileSdk;
                                    super(1);
                                }

                                public final void invoke(CompileSdkReleaseSpec $this$release) {
                                    Intrinsics.checkNotNullParameter((Object)$this$release, (String)"$this$release");
                                    $this$release.setMinorApiLevel(null);
                                    CompileSdkVersion compileSdkVersion2 = this.$this_compileSdk.getVersion();
                                    $this$release.setSdkExtension(compileSdkVersion2 != null ? compileSdkVersion2.getSdkExtension() : null);
                                }
                            }));
                        }
                    }));
                }
            }
        }
    }

    @Override
    @Nullable
    public String getCompileSdkVersion() {
        CompileSdkVersion version;
        CompileSdkVersion compileSdkVersion2 = version = (CompileSdkVersion)this.getCompileSdk.invoke();
        CompileSdkVersion compileSdkVersion3 = version;
        CompileSdkVersion compileSdkVersion4 = version;
        CompileSdkVersion compileSdkVersion5 = version;
        CompileSdkVersion compileSdkVersion6 = version;
        CompileSdkVersion compileSdkVersion7 = version;
        return new CompileSdkVersionImpl(compileSdkVersion2 != null ? compileSdkVersion2.getApiLevel() : null, compileSdkVersion3 != null ? compileSdkVersion3.getMinorApiLevel() : null, compileSdkVersion4 != null ? compileSdkVersion4.getSdkExtension() : null, compileSdkVersion5 != null ? compileSdkVersion5.getCodeName() : null, compileSdkVersion6 != null ? compileSdkVersion6.getAddonName() : null, compileSdkVersion7 != null ? compileSdkVersion7.getVendorName() : null).toHash();
    }

    @Override
    public void setCompileSdkVersion(@Nullable String value) {
        this.parseAndSetCompileSdkVersion(value);
    }

    @Override
    public void compileSdk(@NotNull Function1<? super CompileSdkSpec, Unit> action) {
        CompileSdkSpecImpl compileSdkSpecImpl;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        CompileSdkSpecImpl it = compileSdkSpecImpl = this.createCompileSdkSpec();
        boolean bl = false;
        action.invoke((Object)it);
        SdkUtilsKt.updateIfChanged(this.getCompileSdk.invoke(), it.getVersion(), (Function1)new Function1<CompileSdkVersion, Unit>(this){
            final /* synthetic */ CompileSdkDelegate this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(CompileSdkVersion it) {
                CompileSdkDelegate.access$getSetCompileSdk$p(this.this$0).invoke((Object)it);
            }
        });
    }

    @Override
    public void compileSdk(@NotNull Action<CompileSdkSpec> action) {
        CompileSdkSpecImpl compileSdkSpecImpl;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        CompileSdkSpecImpl it = compileSdkSpecImpl = this.createCompileSdkSpec();
        boolean bl = false;
        action.execute((Object)it);
        SdkUtilsKt.updateIfChanged(this.getCompileSdk.invoke(), it.getVersion(), (Function1)new Function1<CompileSdkVersion, Unit>(this){
            final /* synthetic */ CompileSdkDelegate this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(CompileSdkVersion it) {
                CompileSdkDelegate.access$getSetCompileSdk$p(this.this$0).invoke((Object)it);
            }
        });
    }

    @Override
    public void compileSdkVersion(int apiLevel) {
        this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(apiLevel){
            final /* synthetic */ int $apiLevel;
            {
                this.$apiLevel = $apiLevel;
                super(1);
            }

            public final void invoke(CompileSdkSpec $this$compileSdk) {
                Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                $this$compileSdk.setVersion($this$compileSdk.release(this.$apiLevel));
            }
        }));
    }

    @Override
    public void compileSdkVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.parseAndSetCompileSdkVersion(version);
    }

    @Override
    public void compileSdkAddon(@NotNull String vendor, @NotNull String name, int version) {
        Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(vendor, name, version){
            final /* synthetic */ String $vendor;
            final /* synthetic */ String $name;
            final /* synthetic */ int $version;
            {
                this.$vendor = $vendor;
                this.$name = $name;
                this.$version = $version;
                super(1);
            }

            public final void invoke(CompileSdkSpec $this$compileSdk) {
                Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                $this$compileSdk.setVersion($this$compileSdk.addon(this.$vendor, this.$name, this.$version));
            }
        }));
    }

    private final CompileSdkSpecImpl createCompileSdkSpec() {
        Object object = new Object[]{this.dslServices};
        object = this.dslServices.newDecoratedInstance(CompileSdkSpecImpl.class, object);
        CompileSdkSpecImpl it = (CompileSdkSpecImpl)object;
        boolean bl = false;
        it.setVersion((CompileSdkVersion)this.getCompileSdk.invoke());
        return (CompileSdkSpecImpl)object;
    }

    private final void parseAndSetCompileSdkVersion(String value) {
        block2: {
            CompileSdkVersionImpl compileData;
            block3: {
                block1: {
                    this.setCompileSdk.invoke(null);
                    if (value == null) {
                        return;
                    }
                    compileData = SdkUtilsKt.parseTargetHash(value);
                    if (!compileData.isAddon()) break block1;
                    this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(compileData){
                        final /* synthetic */ CompileSdkVersionImpl $compileData;
                        {
                            this.$compileData = $compileData;
                            super(1);
                        }

                        public final void invoke(CompileSdkSpec $this$compileSdk) {
                            Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                            String string = this.$compileData.getVendorName();
                            Intrinsics.checkNotNull((Object)string);
                            String string2 = this.$compileData.getAddonName();
                            Intrinsics.checkNotNull((Object)string2);
                            Integer n = this.$compileData.getApiLevel();
                            Intrinsics.checkNotNull((Object)n);
                            $this$compileSdk.setVersion($this$compileSdk.addon(string, string2, n.intValue()));
                        }
                    }));
                    break block2;
                }
                if (compileData.getCodeName() == null) break block3;
                this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(compileData){
                    final /* synthetic */ CompileSdkVersionImpl $compileData;
                    {
                        this.$compileData = $compileData;
                        super(1);
                    }

                    public final void invoke(CompileSdkSpec $this$compileSdk) {
                        Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                        $this$compileSdk.setVersion($this$compileSdk.preview(this.$compileData.getCodeName()));
                    }
                }));
                break block2;
            }
            Integer n = compileData.getApiLevel();
            if (n == null) break block2;
            int apiLevel = ((Number)n).intValue();
            boolean bl = false;
            this.compileSdk((Function1<? super CompileSdkSpec, Unit>)((Function1)new Function1<CompileSdkSpec, Unit>(apiLevel, compileData){
                final /* synthetic */ int $apiLevel;
                final /* synthetic */ CompileSdkVersionImpl $compileData;
                {
                    this.$apiLevel = $apiLevel;
                    this.$compileData = $compileData;
                    super(1);
                }

                public final void invoke(CompileSdkSpec $this$compileSdk) {
                    Intrinsics.checkNotNullParameter((Object)$this$compileSdk, (String)"$this$compileSdk");
                    $this$compileSdk.setVersion($this$compileSdk.release(this.$apiLevel, (Function1)new Function1<CompileSdkReleaseSpec, Unit>(this.$compileData){
                        final /* synthetic */ CompileSdkVersionImpl $compileData;
                        {
                            this.$compileData = $compileData;
                            super(1);
                        }

                        public final void invoke(CompileSdkReleaseSpec $this$release) {
                            Intrinsics.checkNotNullParameter((Object)$this$release, (String)"$this$release");
                            $this$release.setMinorApiLevel(this.$compileData.getMinorApiLevel());
                            $this$release.setSdkExtension(this.$compileData.getSdkExtension());
                        }
                    }));
                }
            }));
        }
    }

    public static final /* synthetic */ Function0 access$getGetCompileSdk$p(CompileSdkDelegate $this) {
        return $this.getCompileSdk;
    }

    public static final /* synthetic */ Function1 access$getSetCompileSdk$p(CompileSdkDelegate $this) {
        return $this.setCompileSdk;
    }
}

