/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.AndroidProblemsReporter;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.IssueReporter;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GeneralDataSpec;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/errors/AndroidProblemsReporterImpl;", "Lcom/android/build/gradle/internal/errors/AndroidProblemsReporter;", "problemReporter", "Lorg/gradle/api/problems/internal/InternalProblemReporter;", "<init>", "(Lorg/gradle/api/problems/internal/InternalProblemReporter;)V", "getProblemReporter", "()Lorg/gradle/api/problems/internal/InternalProblemReporter;", "reportSyncIssue", "", "type", "Lcom/android/builder/errors/IssueReporter$Type;", "severity", "Lcom/android/builder/errors/IssueReporter$Severity;", "exception", "Lcom/android/builder/errors/EvalIssueException;", "AndroidSyncIssueProblemBuilder", "gradle-core"})
public final class AndroidProblemsReporterImpl
implements AndroidProblemsReporter {
    @NotNull
    private final InternalProblemReporter problemReporter;

    public AndroidProblemsReporterImpl(@NotNull InternalProblemReporter problemReporter) {
        Intrinsics.checkNotNullParameter((Object)problemReporter, (String)"problemReporter");
        this.problemReporter = problemReporter;
    }

    @NotNull
    public final InternalProblemReporter getProblemReporter() {
        return this.problemReporter;
    }

    @Override
    public void reportSyncIssue(@NotNull IssueReporter.Type type, @NotNull IssueReporter.Severity severity, @NotNull EvalIssueException exception) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        InternalProblem problem = this.problemReporter.internalCreate((Action)new AndroidSyncIssueProblemBuilder(type, severity, exception));
        this.problemReporter.report((Problem)problem);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/errors/AndroidProblemsReporterImpl$AndroidSyncIssueProblemBuilder;", "Lorg/gradle/api/Action;", "Lorg/gradle/api/problems/internal/InternalProblemSpec;", "type", "Lcom/android/builder/errors/IssueReporter$Type;", "severity", "Lcom/android/builder/errors/IssueReporter$Severity;", "exception", "Lcom/android/builder/errors/EvalIssueException;", "<init>", "(Lcom/android/builder/errors/IssueReporter$Type;Lcom/android/builder/errors/IssueReporter$Severity;Lcom/android/builder/errors/EvalIssueException;)V", "getType", "()Lcom/android/builder/errors/IssueReporter$Type;", "getSeverity", "()Lcom/android/builder/errors/IssueReporter$Severity;", "getException", "()Lcom/android/builder/errors/EvalIssueException;", "syncIssueProblemGroup", "Lorg/gradle/api/problems/ProblemGroup;", "kotlin.jvm.PlatformType", "execute", "", "problem", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nAndroidProblemsReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidProblemsReporter.kt\ncom/android/build/gradle/internal/errors/AndroidProblemsReporterImpl$AndroidSyncIssueProblemBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
    public static final class AndroidSyncIssueProblemBuilder
    implements Action<InternalProblemSpec> {
        @NotNull
        private final IssueReporter.Type type;
        @NotNull
        private final IssueReporter.Severity severity;
        @NotNull
        private final EvalIssueException exception;
        private final ProblemGroup syncIssueProblemGroup;

        public AndroidSyncIssueProblemBuilder(@NotNull IssueReporter.Type type, @NotNull IssueReporter.Severity severity, @NotNull EvalIssueException exception) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            this.type = type;
            this.severity = severity;
            this.exception = exception;
            this.syncIssueProblemGroup = ProblemGroup.create((String)"agp-sync-issues", (String)"Sync Issues");
        }

        @NotNull
        public final IssueReporter.Type getType() {
            return this.type;
        }

        @NotNull
        public final IssueReporter.Severity getSeverity() {
            return this.severity;
        }

        @NotNull
        public final EvalIssueException getException() {
            return this.exception;
        }

        public void execute(@NotNull InternalProblemSpec problem) {
            Object it;
            Severity severity;
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            switch (WhenMappings.$EnumSwitchMapping$0[this.severity.ordinal()]) {
                case 1: {
                    severity = Severity.WARNING;
                    break;
                }
                case 2: {
                    severity = Severity.ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Severity problemSeverity = severity;
            problem.id(ProblemId.create((String)String.valueOf(this.type.getType()), (String)this.type.name(), (ProblemGroup)this.syncIssueProblemGroup));
            problem.severity(problemSeverity);
            problem.contextualLabel(this.exception.getMessage());
            List list = this.exception.getMultilineMessage();
            if (list != null) {
                it = list;
                boolean bl = false;
                problem.details(CollectionsKt.joinToString$default((Iterable)((Iterable)it), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            String string = this.exception.getData();
            if (string != null) {
                it = string;
                boolean bl = false;
                problem.additionalDataInternal(GeneralDataSpec.class, new Action((String)it){
                    final /* synthetic */ String $it;
                    {
                        this.$it = $it;
                    }

                    public final void execute(GeneralDataSpec data) {
                        data.put("EvalIssueException.data", this.$it);
                    }
                });
            }
            problem.withException((Throwable)this.exception);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IssueReporter.Severity.values().length];
                try {
                    nArray[IssueReporter.Severity.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IssueReporter.Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

