/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\u001aH\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2 \u0010\r\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f\u0012\u0004\u0012\u00020\u00070\u000eH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\fH\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "pattern2", "LINE_SPLITTER", "Lcom/google/common/base/Splitter;", "processDependencyThrowable", "", "throwable", "", "dataExtractor", "Lkotlin/Function1;", "", "resultConsumer", "Lkotlin/Function2;", "", "checkForData", "message", "gradle-core"})
public final class DependencyFailureHandlerKt {
    private static final Pattern pattern = Pattern.compile(".*any matches for (\\S*) .*", 32);
    private static final Pattern pattern2 = Pattern.compile(".*Could not find (\\S*)\\..*", 32);
    private static final Splitter LINE_SPLITTER = Splitter.on((String)System.lineSeparator());

    private static final void processDependencyThrowable(Throwable throwable, Function1<? super String, String> dataExtractor, Function2<? super String, ? super List<String>, Unit> resultConsumer) {
        List messages = new ArrayList();
        Object firstIndent = " > ";
        Object allIndent = "";
        String data = null;
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            String message2 = cause.getMessage();
            if (message2 == null) continue;
            ImmutableList lines = ImmutableList.copyOf((Iterable)LINE_SPLITTER.split((CharSequence)message2));
            Object object = lines.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            data = (String)dataExtractor.invoke(object);
            if (data != null) break;
            int count = lines.size();
            for (int i = 0; i < count; ++i) {
                boolean bl;
                String line = (String)lines.get(i);
                if (((CharSequence)allIndent).length() == 0) {
                    Intrinsics.checkNotNull((Object)line);
                    bl = messages.add(line);
                    continue;
                }
                bl = i == 0 ? messages.add((String)firstIndent + line) : messages.add((String)allIndent + line);
            }
            firstIndent = (String)allIndent + (String)firstIndent;
            allIndent = (String)allIndent + "   ";
        }
        resultConsumer.invoke(data, (Object)messages);
    }

    @Nullable
    public static final String checkForData(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Matcher m = pattern.matcher(message2);
        if (m.matches()) {
            return m.group(1);
        }
        m = pattern2.matcher(message2);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static final /* synthetic */ void access$processDependencyThrowable(Throwable throwable, Function1 dataExtractor, Function2 resultConsumer) {
        DependencyFailureHandlerKt.processDependencyThrowable(throwable, (Function1<? super String, String>)dataExtractor, (Function2<? super String, ? super List<String>, Unit>)resultConsumer);
    }
}

