/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceGroupConfig;
import com.android.bundle.DeviceId;
import com.android.bundle.DeviceRam;
import com.android.bundle.DeviceSelector;
import com.android.bundle.SystemFeature;
import com.android.bundle.SystemOnChip;
import java.util.ArrayList;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\b\tB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/DeviceTargetingConfigParser;", "", "config", "Lorg/w3c/dom/Document;", "<init>", "(Lorg/w3c/dom/Document;)V", "parseConfig", "Lcom/android/bundle/DeviceGroupConfig;", "InvalidDeviceTargetingConfigException", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nDeviceTargetingConfigParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceTargetingConfigParser.kt\ncom/android/build/gradle/internal/tasks/DeviceTargetingConfigParser\n+ 2 NodeCollectionHelper.kt\ncom/android/utils/NodeCollectionHelperKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n26#2,3:141\n29#2:146\n1869#3,2:144\n*S KotlinDebug\n*F\n+ 1 DeviceTargetingConfigParser.kt\ncom/android/build/gradle/internal/tasks/DeviceTargetingConfigParser\n*L\n45#1:141,3\n45#1:146\n45#1:144,2\n*E\n"})
public final class DeviceTargetingConfigParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document config;
    @NotNull
    private static final String CONFIG_NS = "http://schemas.android.com/apk/config";

    public DeviceTargetingConfigParser(@NotNull Document config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.config = config2;
    }

    @NotNull
    public final DeviceGroupConfig parseConfig() {
        try {
            DeviceTargetingConfigParser.Companion.validate(this.config);
        }
        catch (SAXParseException e) {
            throw new InvalidDeviceTargetingConfigException("The DeviceTargetingConfig xml provided is invalid.", e);
        }
        DeviceGroupConfig.Builder builder = DeviceGroupConfig.newBuilder();
        NodeList nodeList = this.config.getDocumentElement().getElementsByTagNameNS(CONFIG_NS, "device-group");
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagNameNS(...)");
        NodeList $this$forEach$iv = nodeList;
        boolean $i$f$forEach = false;
        ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
        int n = $this$forEach$iv.getLength();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            copy$iv.add($this$forEach$iv.item(i$iv));
        }
        Iterable $this$forEach$iv$iv = copy$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            Node it$iv = (Node)element$iv$iv;
            boolean bl = false;
            Node it = it$iv;
            boolean bl2 = false;
            if (!(it instanceof Element)) continue;
            builder.addDeviceGroups(DeviceTargetingConfigParser.Companion.parseDeviceGroup((Element)it));
        }
        DeviceGroupConfig deviceGroupConfig = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)deviceGroupConfig, (String)"build(...)");
        return deviceGroupConfig;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/DeviceTargetingConfigParser$Companion;", "", "<init>", "()V", "CONFIG_NS", "", "parseDeviceGroup", "Lcom/android/bundle/DeviceGroup$Builder;", "group", "Lorg/w3c/dom/Element;", "parseDeviceSelector", "Lcom/android/bundle/DeviceSelector$Builder;", "selector", "parseDeviceRam", "Lcom/android/bundle/DeviceRam$Builder;", "element", "parseDeviceId", "Lcom/android/bundle/DeviceId$Builder;", "parseSystemFeature", "Lcom/android/bundle/SystemFeature$Builder;", "parseSystemOnChip", "Lcom/android/bundle/SystemOnChip$Builder;", "validate", "", "document", "Lorg/w3c/dom/Document;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nDeviceTargetingConfigParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceTargetingConfigParser.kt\ncom/android/build/gradle/internal/tasks/DeviceTargetingConfigParser$Companion\n+ 2 NodeCollectionHelper.kt\ncom/android/utils/NodeCollectionHelperKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n26#2,3:141\n29#2:146\n26#2,3:147\n29#2:152\n26#2,3:153\n29#2:158\n26#2,3:159\n29#2:164\n26#2,3:165\n29#2:170\n26#2,3:171\n29#2:176\n1869#3,2:144\n1869#3,2:150\n1869#3,2:156\n1869#3,2:162\n1869#3,2:168\n1869#3,2:174\n*S KotlinDebug\n*F\n+ 1 DeviceTargetingConfigParser.kt\ncom/android/build/gradle/internal/tasks/DeviceTargetingConfigParser$Companion\n*L\n59#1:141,3\n59#1:146\n73#1:147,3\n73#1:152\n78#1:153,3\n78#1:158\n83#1:159,3\n83#1:164\n88#1:165,3\n88#1:170\n93#1:171,3\n93#1:176\n59#1:144,2\n73#1:150,2\n78#1:156,2\n83#1:162,2\n88#1:168,2\n93#1:174,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final DeviceGroup.Builder parseDeviceGroup(Element group) {
            DeviceGroup.Builder builder = DeviceGroup.newBuilder().setName(group.getAttribute("name"));
            NodeList nodeList = group.getElementsByTagNameNS(CONFIG_NS, "device-selector");
            Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagNameNS(...)");
            NodeList $this$forEach$iv = nodeList;
            boolean $i$f$forEach = false;
            ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int n = $this$forEach$iv.getLength();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                copy$iv.add($this$forEach$iv.item(i$iv));
            }
            Iterable $this$forEach$iv$iv = copy$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Node it$iv = (Node)element$iv$iv;
                boolean bl = false;
                Node it = it$iv;
                boolean bl2 = false;
                if (!(it instanceof Element)) continue;
                builder.addDeviceSelectors(Companion.parseDeviceSelector((Element)it));
            }
            Intrinsics.checkNotNull((Object)builder);
            return builder;
        }

        private final DeviceSelector.Builder parseDeviceSelector(Element selector) {
            Node it;
            boolean bl;
            Node it$iv;
            DeviceSelector.Builder builder = DeviceSelector.newBuilder();
            DeviceRam.Builder builder2 = this.parseDeviceRam(selector);
            if (builder2 != null) {
                DeviceRam.Builder it2 = builder2;
                boolean bl2 = false;
                builder.setDeviceRam(it2);
            }
            NodeList nodeList = selector.getElementsByTagNameNS(CONFIG_NS, "included-device-id");
            Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"getElementsByTagNameNS(...)");
            NodeList $this$forEach$iv = nodeList;
            boolean $i$f$forEach = false;
            ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
            int n = $this$forEach$iv.getLength();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                copy$iv.add($this$forEach$iv.item(i$iv));
            }
            Iterable $this$forEach$iv$iv = copy$iv;
            int $i$f$forEach2 = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (Node)element$iv$iv;
                bl = false;
                it = it$iv;
                boolean bl3 = false;
                if (!(it instanceof Element)) continue;
                builder.addIncludedDeviceIds(Companion.parseDeviceId((Element)it));
            }
            NodeList nodeList2 = selector.getElementsByTagNameNS(CONFIG_NS, "excluded-device-id");
            Intrinsics.checkNotNullExpressionValue((Object)nodeList2, (String)"getElementsByTagNameNS(...)");
            $this$forEach$iv = nodeList2;
            $i$f$forEach = false;
            copy$iv = new ArrayList($this$forEach$iv.getLength());
            $i$f$forEach2 = $this$forEach$iv.getLength();
            for (int i$iv = 0; i$iv < $i$f$forEach2; ++i$iv) {
                copy$iv.add($this$forEach$iv.item(i$iv));
            }
            $this$forEach$iv$iv = copy$iv;
            $i$f$forEach2 = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (Node)element$iv$iv;
                bl = false;
                it = it$iv;
                boolean bl4 = false;
                if (!(it instanceof Element)) continue;
                builder.addExcludedDeviceIds(Companion.parseDeviceId((Element)it));
            }
            NodeList nodeList3 = selector.getElementsByTagNameNS(CONFIG_NS, "required-system-feature");
            Intrinsics.checkNotNullExpressionValue((Object)nodeList3, (String)"getElementsByTagNameNS(...)");
            $this$forEach$iv = nodeList3;
            $i$f$forEach = false;
            copy$iv = new ArrayList($this$forEach$iv.getLength());
            $i$f$forEach2 = $this$forEach$iv.getLength();
            for (int i$iv = 0; i$iv < $i$f$forEach2; ++i$iv) {
                copy$iv.add($this$forEach$iv.item(i$iv));
            }
            $this$forEach$iv$iv = copy$iv;
            $i$f$forEach2 = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (Node)element$iv$iv;
                bl = false;
                it = it$iv;
                boolean bl5 = false;
                if (!(it instanceof Element)) continue;
                builder.addRequiredSystemFeatures(Companion.parseSystemFeature((Element)it));
            }
            NodeList nodeList4 = selector.getElementsByTagNameNS(CONFIG_NS, "forbidden-system-feature");
            Intrinsics.checkNotNullExpressionValue((Object)nodeList4, (String)"getElementsByTagNameNS(...)");
            $this$forEach$iv = nodeList4;
            $i$f$forEach = false;
            copy$iv = new ArrayList($this$forEach$iv.getLength());
            $i$f$forEach2 = $this$forEach$iv.getLength();
            for (int i$iv = 0; i$iv < $i$f$forEach2; ++i$iv) {
                copy$iv.add($this$forEach$iv.item(i$iv));
            }
            $this$forEach$iv$iv = copy$iv;
            $i$f$forEach2 = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (Node)element$iv$iv;
                bl = false;
                it = it$iv;
                boolean bl6 = false;
                if (!(it instanceof Element)) continue;
                builder.addForbiddenSystemFeatures(Companion.parseSystemFeature((Element)it));
            }
            NodeList nodeList5 = selector.getElementsByTagNameNS(CONFIG_NS, "system-on-chip");
            Intrinsics.checkNotNullExpressionValue((Object)nodeList5, (String)"getElementsByTagNameNS(...)");
            $this$forEach$iv = nodeList5;
            $i$f$forEach = false;
            copy$iv = new ArrayList($this$forEach$iv.getLength());
            $i$f$forEach2 = $this$forEach$iv.getLength();
            for (int i$iv = 0; i$iv < $i$f$forEach2; ++i$iv) {
                copy$iv.add($this$forEach$iv.item(i$iv));
            }
            $this$forEach$iv$iv = copy$iv;
            $i$f$forEach2 = 0;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                it$iv = (Node)element$iv$iv;
                bl = false;
                it = it$iv;
                boolean bl7 = false;
                if (!(it instanceof Element)) continue;
                builder.addSystemOnChips(Companion.parseSystemOnChip((Element)it));
            }
            Intrinsics.checkNotNull((Object)builder);
            return builder;
        }

        private final DeviceRam.Builder parseDeviceRam(Element element) {
            Object object;
            String ramMinBytes = element.getAttribute("ram-min-bytes");
            String ramMaxBytes = element.getAttribute("ram-max-bytes");
            if (ramMinBytes == null && ramMaxBytes == null) {
                return null;
            }
            DeviceRam.Builder builder = DeviceRam.newBuilder().setMinBytes((object = ramMinBytes) != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L);
            if (ramMaxBytes != null) {
                Long l = StringsKt.toLongOrNull((String)ramMaxBytes);
                builder.setMaxBytes(l != null ? l : 0L);
            }
            return builder;
        }

        private final DeviceId.Builder parseDeviceId(Element element) {
            DeviceId.Builder builder = DeviceId.newBuilder().setBuildBrand(element.getAttribute("brand"));
            if (element.hasAttribute("device")) {
                builder.setBuildDevice(element.getAttribute("device"));
            }
            Intrinsics.checkNotNull((Object)builder);
            return builder;
        }

        private final SystemFeature.Builder parseSystemFeature(Element element) {
            SystemFeature.Builder builder = SystemFeature.newBuilder().setName(element.getAttribute("name"));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setName(...)");
            return builder;
        }

        private final SystemOnChip.Builder parseSystemOnChip(Element element) {
            SystemOnChip.Builder builder = SystemOnChip.newBuilder().setManufacturer(element.getAttribute("manufacturer")).setModel(element.getAttribute("model"));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setModel(...)");
            return builder;
        }

        private final void validate(Document document) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(DeviceTargetingConfigParser.class.getResource("device_targeting_config_schema.xsd"));
            schema.newValidator().validate(new DOMSource(document));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/DeviceTargetingConfigParser$InvalidDeviceTargetingConfigException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "t", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "gradle-core"})
    public static final class InvalidDeviceTargetingConfigException
    extends Exception {
        public InvalidDeviceTargetingConfigException(@NotNull String message2, @NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super(message2, t);
        }
    }
}

