/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.variant.impl.SigningConfigImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.signing.SigningConfigVersions;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.SigningConfigUtils;
import com.android.build.gradle.internal.tasks.SigningConfigVersionsWriterTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.APK_PACKAGING)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigVersionsWriterTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "enableV1Signing", "Lorg/gradle/api/provider/Property;", "", "getEnableV1Signing", "()Lorg/gradle/api/provider/Property;", "enableV2Signing", "getEnableV2Signing", "enableV3Signing", "getEnableV3Signing", "enableV4Signing", "getEnableV4Signing", "overrideEnableV1Signing", "getOverrideEnableV1Signing", "overrideEnableV2Signing", "getOverrideEnableV2Signing", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class SigningConfigVersionsWriterTask
extends NonIncrementalTask {
    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableV1Signing();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableV2Signing();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableV3Signing();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableV4Signing();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getOverrideEnableV1Signing();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getOverrideEnableV2Signing();

    @Override
    public void doTaskAction() {
        File file = ((RegularFile)this.getOutputFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        Boolean bl = (Boolean)this.getOverrideEnableV1Signing().getOrNull();
        if (bl == null) {
            bl = (Boolean)this.getEnableV1Signing().get();
        }
        Boolean bl2 = bl;
        Intrinsics.checkNotNull((Object)bl2);
        boolean bl3 = bl2;
        Boolean bl4 = (Boolean)this.getOverrideEnableV2Signing().getOrNull();
        if (bl4 == null) {
            bl4 = (Boolean)this.getEnableV2Signing().get();
        }
        bl2 = bl4;
        Intrinsics.checkNotNull((Object)bl2);
        boolean bl5 = bl2;
        Object object = this.getEnableV3Signing().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        boolean bl6 = (Boolean)object;
        Object object2 = this.getEnableV4Signing().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        SigningConfigUtils.Companion.saveSigningConfigVersions(file, new SigningConfigVersions(bl3, bl5, bl6, (Boolean)object2));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigVersionsWriterTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/SigningConfigVersionsWriterTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<SigningConfigVersionsWriterTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("write", "signingConfigVersions");
        }

        @Override
        @NotNull
        public Class<SigningConfigVersionsWriterTask> getType() {
            return SigningConfigVersionsWriterTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<SigningConfigVersionsWriterTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("signing-config-versions.json").on(InternalArtifactType.SIGNING_CONFIG_VERSIONS.INSTANCE);
        }

        @Override
        public void configure(@NotNull SigningConfigVersionsWriterTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            SigningConfigImpl signingConfig2 = ((ApkCreationConfig)this.creationConfig).getSigningConfig();
            if (signingConfig2 == null) {
                HasConfigurableValuesKt.setDisallowChanges(task.getEnableV1Signing(), false);
                HasConfigurableValuesKt.setDisallowChanges(task.getEnableV2Signing(), false);
                HasConfigurableValuesKt.setDisallowChanges(task.getEnableV3Signing(), false);
                HasConfigurableValuesKt.setDisallowChanges(task.getEnableV4Signing(), false);
            } else {
                HasConfigurableValuesKt.setDisallowChanges(task.getEnableV1Signing(), (Provider)signingConfig2.getEnableV1Signing());
                HasConfigurableValuesKt.setDisallowChanges(task.getEnableV2Signing(), (Provider)signingConfig2.getEnableV2Signing());
                HasConfigurableValuesKt.setDisallowChanges(task.getEnableV3Signing(), (Provider)signingConfig2.getEnableV3Signing());
                HasConfigurableValuesKt.setDisallowChanges(task.getEnableV4Signing(), (Provider)signingConfig2.getEnableV4Signing());
            }
            HasConfigurableValuesKt.setDisallowChanges(task.getOverrideEnableV1Signing(), ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(OptionalBooleanOption.SIGNING_V1_ENABLED));
            HasConfigurableValuesKt.setDisallowChanges(task.getOverrideEnableV2Signing(), ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(OptionalBooleanOption.SIGNING_V2_ENABLED));
        }
    }
}

