/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/utils/DesugarLibLintExtractor;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/utils/DesugarLibLintExtractor$Parameters;", "<init>", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "gradle-core"})
public abstract class DesugarLibLintExtractor
implements TransformAction<Parameters> {
    @InputArtifact
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs2) {
        Intrinsics.checkNotNullParameter((Object)outputs2, (String)"outputs");
        File inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        Integer minSdkVersion2 = (Integer)((Parameters)this.getParameters()).getMinSdkVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Parameters)this.getParameters()).getCompileSdkVersion().get(), (String)"get(...)");
        for (int compileSdkVersion2 = ((Number)(v403307)).intValue(); 25 < compileSdkVersion2; --compileSdkVersion2) {
            String pattern = minSdkVersion2 >= 21 ? compileSdkVersion2 + "_21.txt" : compileSdkVersion2 + "_1.txt";
            Intrinsics.checkNotNull((Object)inputFile);
            Closeable closeable = new FileInputStream(inputFile);
            int n = 8192;
            closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            Throwable throwable = null;
            try {
                ZipInputStream zipInputStream = (ZipInputStream)closeable;
                boolean bl = false;
                while (zipInputStream.getNextEntry() != null) {
                    ZipEntry entry2;
                    String string = entry2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)pattern, (boolean)false, (int)2, null)) continue;
                    File outputFile = outputs2.file((Object)(FilesKt.getNameWithoutExtension((File)inputFile) + "-desugar-lint.txt"));
                    OutputStream outputStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                    Closeable closeable2 = outputStream;
                    int n2 = 8192;
                    closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n2);
                    Throwable throwable2 = null;
                    try {
                        BufferedOutputStream output2 = (BufferedOutputStream)closeable2;
                        boolean bl2 = false;
                        long l = ByteStreams.copy((InputStream)zipInputStream, (OutputStream)output2);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    return;
                }
                Unit unit = Unit.INSTANCE;
                continue;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/utils/DesugarLibLintExtractor$Parameters;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "minSdkVersion", "Lorg/gradle/api/provider/Property;", "", "getMinSdkVersion", "()Lorg/gradle/api/provider/Property;", "compileSdkVersion", "getCompileSdkVersion", "gradle-core"})
    public static interface Parameters
    extends GenericTransformParameters {
        @Input
        @NotNull
        public Property<Integer> getMinSdkVersion();

        @Input
        @NotNull
        public Property<Integer> getCompileSdkVersion();
    }
}

