/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.component.impl.AnnotationProcessorImpl;
import com.android.build.api.variant.AnnotationProcessor;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.KmpComponentCreationConfig;
import com.android.build.gradle.internal.dependency.JdkImageTransformKt;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.decorator.LockableList;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.CommandLineArgumentProviderAdapter;
import com.android.build.gradle.tasks.JavaCompileUtils;
import com.android.build.gradle.tasks.JdkImageInput;
import com.android.build.gradle.tasks.ProcessorInfo;
import com.android.build.gradle.tasks.SerializableArtifact;
import com.android.builder.errors.DefaultIssueReporter;
import com.android.builder.errors.IssueReporter;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.wireless.android.sdk.stats.AnnotationProcessorInfo;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\f\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a<\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u001a\"\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u001a\"\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u001aN\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001b2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001bH\u0002\u001a\"\u0010\u001f\u001a\u00020\u00072\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010!\u001a\u00020\u001c\u001a\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010!\u001a\u00020\u001c\u001a2\u0010#\u001a\u00020\u00072\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'\u001a0\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\b\u00100\u001a\u0004\u0018\u00010.\u001a\u0018\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u000204H\u0002\u001a\u0014\u00105\u001a\u00020\u0007*\u00020\b2\u0006\u00103\u001a\u000204H\u0002\u001a$\u00106\u001a\u00020\u0007*\u00020\b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00107\u001a\u00020\u0005H\u0002\u001a0\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020.2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00107\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0002\u001a\"\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00109\u001a\u00020.2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002\u001a\n\u0010<\u001a\u00020\u000f*\u00020=\u001a\n\u0010>\u001a\u00020.*\u00020?\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"ANNOTATION_PROCESSORS_INDICATOR_FILE", "", "INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE", "KSP_PROCESSORS_INDICATOR_FILE", "DEFAULT_INCREMENTAL_COMPILATION", "", "configureProperties", "", "Lorg/gradle/api/tasks/compile/JavaCompile;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "configurePropertiesForAnnotationProcessing", "configureAnnotationProcessorPath", "detectAnnotationAndKspProcessors", "", "Lcom/android/build/gradle/tasks/ProcessorInfo;", "apOptionClassNames", "", "annotationProcessorClasspath", "", "Lcom/android/build/gradle/tasks/SerializableArtifact;", "kspClasspath", "findAllAnnotationProcessors", "artifacts", "findAllKspProcessors", "detectProcessors", "dirFilter", "Lkotlin/Function1;", "Ljava/io/File;", "jarFilter", "Ljava/util/jar/JarFile;", "writeAnnotationProcessorsToJsonFile", "processors", "processorListFile", "readAnnotationProcessorsFromJsonFile", "recordAnnotationProcessorsForAnalytics", "projectPath", "variantName", "analyticService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "recordCompileOptionsForAnalytics", "project", "Lorg/gradle/api/Project;", "buildServiceRegistry", "Lorg/gradle/api/services/BuildServiceRegistry;", "sourceCompatibility", "Lorg/gradle/api/JavaVersion;", "targetCompatibility", "toolchainLanguageVersion", "checkSdkCompatibility", "compileSdkVersion", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "checkReleaseOption", "checkDeprecatedSourceAndTargetAtExecutionTime", "suppressWarning", "checkDeprecatedSourceAndTarget", "javacVersion", "determineJavacSupportForSourceAndTarget", "Lcom/android/builder/errors/IssueReporter$Severity;", "toProcessorInfo", "Lcom/google/wireless/android/sdk/stats/AnnotationProcessorInfo;", "asJavaVersion", "Lorg/gradle/jvm/toolchain/JavaLanguageVersion;", "gradle-core"})
@JvmName(name="JavaCompileUtils")
@SourceDebugExtension(value={"SMAP\nJavaCompileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCompileUtils.kt\ncom/android/build/gradle/tasks/JavaCompileUtils\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,530:1\n216#2,2:531\n216#2,2:533\n1#3:535\n*S KotlinDebug\n*F\n+ 1 JavaCompileUtils.kt\ncom/android/build/gradle/tasks/JavaCompileUtils\n*L\n216#1:531,2\n222#1:533,2\n*E\n"})
public final class JavaCompileUtils {
    @NotNull
    public static final String ANNOTATION_PROCESSORS_INDICATOR_FILE = "META-INF/services/javax.annotation.processing.Processor";
    @NotNull
    public static final String INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE = "META-INF/gradle/incremental.annotation.processors";
    @NotNull
    public static final String KSP_PROCESSORS_INDICATOR_FILE = "META-INF/services/com.google.devtools.ksp.processing.SymbolProcessorProvider";
    public static final boolean DEFAULT_INCREMENTAL_COMPILATION = true;

    public static final void configureProperties(@NotNull JavaCompile $this$configureProperties, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$configureProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        com.android.build.api.dsl.CompileOptions compileOptions = creationConfig.getGlobal().getCompileOptions();
        if (compileOptions.getSourceCompatibility().isJava9Compatible()) {
            JavaCompileUtils.checkSdkCompatibility(creationConfig.getGlobal().getCompileSdkHashString(), creationConfig.getServices().getIssueReporter());
            if (!$this$configureProperties.getProject().getConfigurations().getNames().contains("androidJdkImage")) {
                boolean bl = false;
                String string = "The androidJdkImage configuration must exist for Java 9+ sources.";
                throw new IllegalStateException(string.toString());
            }
            FileCollection jdkImage = JdkImageTransformKt.getJdkImageFromTransform(creationConfig.getServices(), (JavaCompiler)$this$configureProperties.getJavaCompiler().getOrNull());
            $this$configureProperties.getOptions().getCompilerArgumentProviders().add(new JdkImageInput(jdkImage));
            $this$configureProperties.getOptions().getCompilerArgs().add("-XDstringConcat=inline");
            Object[] objectArray = new Object[]{creationConfig.getGlobal().getBootClasspath(), creationConfig.getCompileClasspath(), creationConfig.getBuiltInKotlincOutput(), creationConfig.getBuiltInKaptArtifact(InternalArtifactType.BUILT_IN_KAPT_CLASSES_DIR.INSTANCE)};
            $this$configureProperties.setClasspath((FileCollection)$this$configureProperties.getProject().files(objectArray));
        } else {
            Object[] objectArray = new Object[]{creationConfig.getGlobal().getBootClasspath()};
            $this$configureProperties.getOptions().setBootstrapClasspath((FileCollection)$this$configureProperties.getProject().files(objectArray));
            objectArray = new Object[]{creationConfig.getCompileClasspath(), creationConfig.getBuiltInKotlincOutput(), creationConfig.getBuiltInKaptArtifact(InternalArtifactType.BUILT_IN_KAPT_CLASSES_DIR.INSTANCE)};
            $this$configureProperties.setClasspath((FileCollection)$this$configureProperties.getProject().files(objectArray));
        }
        $this$configureProperties.setSourceCompatibility(compileOptions.getSourceCompatibility().toString());
        $this$configureProperties.setTargetCompatibility(compileOptions.getTargetCompatibility().toString());
        $this$configureProperties.getOptions().setEncoding(compileOptions.getEncoding());
        JavaCompileUtils.checkReleaseOption($this$configureProperties, creationConfig.getServices().getIssueReporter());
        JavaCompileUtils.checkDeprecatedSourceAndTargetAtExecutionTime($this$configureProperties, compileOptions.getSourceCompatibility(), compileOptions.getTargetCompatibility(), creationConfig.getServices().getProjectOptions().get(BooleanOption.JAVA_COMPILE_SUPPRESS_SOURCE_TARGET_DEPRECATION_WARNING));
    }

    public static final void configurePropertiesForAnnotationProcessing(@NotNull JavaCompile $this$configurePropertiesForAnnotationProcessing, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$configurePropertiesForAnnotationProcessing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        AnnotationProcessor processorOptions = creationConfig.getJavaCompilation().getAnnotationProcessor();
        CompileOptions compileOptions = $this$configurePropertiesForAnnotationProcessing.getOptions();
        if (creationConfig.getUseBuiltInKaptSupport()) {
            compileOptions.getCompilerArgs().add("-proc:none");
        }
        JavaCompileUtils.configureAnnotationProcessorPath($this$configurePropertiesForAnnotationProcessing, creationConfig);
        List list = compileOptions.getCompilerArgumentProviders();
        Intrinsics.checkNotNull((Object)processorOptions, (String)"null cannot be cast to non-null type com.android.build.api.component.impl.AnnotationProcessorImpl");
        list.add(new CommandLineArgumentProviderAdapter(((AnnotationProcessorImpl)processorOptions).getFinalListOfClassNames(), (Provider<Map<String, String>>)((Provider)((AnnotationProcessorImpl)processorOptions).getArguments())));
        List it = ((AnnotationProcessorImpl)processorOptions).getArgumentProviders();
        boolean bl = false;
        ((LockableList)it).lock();
        compileOptions.getCompilerArgumentProviders().addAll(it);
    }

    public static final void configureAnnotationProcessorPath(@NotNull JavaCompile $this$configureAnnotationProcessorPath, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$configureAnnotationProcessorPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        if (creationConfig instanceof KmpComponentCreationConfig) {
            return;
        }
        FileCollection projectJars = VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.JAR, null, 8, null);
        FileCollection externalJars = VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.EXTERNAL, creationConfig.getGlobal().getAarOrJarTypeToConsume().getJar(), null, 8, null);
        $this$configureAnnotationProcessorPath.getOptions().setAnnotationProcessorPath(projectJars.plus(externalJars));
    }

    @NotNull
    public static final Map<String, ProcessorInfo> detectAnnotationAndKspProcessors(@NotNull List<String> apOptionClassNames, @NotNull Collection<SerializableArtifact> annotationProcessorClasspath, @NotNull Collection<SerializableArtifact> kspClasspath) {
        Map.Entry<SerializableArtifact, ProcessorInfo> it;
        Map.Entry<SerializableArtifact, ProcessorInfo> element$iv;
        Iterator<Map.Entry<SerializableArtifact, ProcessorInfo>> iterator2;
        Map<SerializableArtifact, ProcessorInfo> $this$forEach$iv;
        Intrinsics.checkNotNullParameter(apOptionClassNames, (String)"apOptionClassNames");
        Intrinsics.checkNotNullParameter(annotationProcessorClasspath, (String)"annotationProcessorClasspath");
        Intrinsics.checkNotNullParameter(kspClasspath, (String)"kspClasspath");
        Map processors = new LinkedHashMap();
        if (!apOptionClassNames.isEmpty()) {
            for (String processor2 : apOptionClassNames) {
                processors.put(processor2, ProcessorInfo.NON_INCREMENTAL_AP);
            }
        } else {
            $this$forEach$iv = JavaCompileUtils.findAllAnnotationProcessors(annotationProcessorClasspath);
            boolean $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl = false;
                processors.put(it.getKey().getDisplayName(), it.getValue());
            }
        }
        $this$forEach$iv = JavaCompileUtils.findAllKspProcessors(kspClasspath);
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            processors.put(it.getKey().getDisplayName(), it.getValue());
        }
        return processors;
    }

    private static final Map<SerializableArtifact, ProcessorInfo> findAllAnnotationProcessors(Collection<SerializableArtifact> artifacts2) {
        return JavaCompileUtils.detectProcessors(artifacts2, (Function1<? super File, ? extends ProcessorInfo>)((Function1)findAllAnnotationProcessors.1.INSTANCE), (Function1<? super JarFile, ? extends ProcessorInfo>)((Function1)findAllAnnotationProcessors.2.INSTANCE));
    }

    private static final Map<SerializableArtifact, ProcessorInfo> findAllKspProcessors(Collection<SerializableArtifact> artifacts2) {
        return JavaCompileUtils.detectProcessors(artifacts2, (Function1<? super File, ? extends ProcessorInfo>)((Function1)findAllKspProcessors.1.INSTANCE), (Function1<? super JarFile, ? extends ProcessorInfo>)((Function1)findAllKspProcessors.2.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<SerializableArtifact, ProcessorInfo> detectProcessors(Collection<SerializableArtifact> artifacts2, Function1<? super File, ? extends ProcessorInfo> dirFilter, Function1<? super JarFile, ? extends ProcessorInfo> jarFilter) {
        Map processors = new LinkedHashMap();
        for (SerializableArtifact artifact : artifacts2) {
            File artifactFile = artifact.getFile();
            if (artifactFile.isDirectory()) {
                if ((ProcessorInfo)((Object)dirFilter.invoke((Object)artifactFile)) != null) {
                    ProcessorInfo it;
                    boolean bl = false;
                    processors.put(artifact, it);
                }
                continue;
            }
            if (!artifactFile.isFile()) continue;
            try {
                Closeable closeable = new JarFile(artifactFile);
                Throwable throwable = null;
                try {
                    Unit unit;
                    JarFile jarFile = (JarFile)closeable;
                    boolean bl = false;
                    if ((ProcessorInfo)((Object)jarFilter.invoke((Object)jarFile)) != null) {
                        ProcessorInfo it;
                        boolean bl2 = false;
                        processors.put(artifact, it);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {}
        }
        return processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeAnnotationProcessorsToJsonFile(@NotNull Map<String, ? extends ProcessorInfo> processors, @NotNull File processorListFile) {
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        Intrinsics.checkNotNullParameter((Object)processorListFile, (String)"processorListFile");
        Gson gson2 = new GsonBuilder().create();
        try {
            FileUtils.deleteIfExists((File)processorListFile);
            Closeable closeable = new FileWriter(processorListFile);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                gson2.toJson(processors, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, ProcessorInfo> readAnnotationProcessorsFromJsonFile(@NotNull File processorListFile) {
        Intrinsics.checkNotNullParameter((Object)processorListFile, (String)"processorListFile");
        Gson gson2 = new GsonBuilder().create();
        try {
            Closeable closeable = new FileReader(processorListFile);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl = false;
                Object object = gson2.fromJson((Reader)reader, new TypeToken<Map<String, ? extends ProcessorInfo>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                Map map = (Map)object;
                return map;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final void recordAnnotationProcessorsForAnalytics(@NotNull Map<String, ? extends ProcessorInfo> processors, @NotNull String projectPath, @NotNull String variantName, @NotNull AnalyticsService analyticService) {
        block6: {
            Intrinsics.checkNotNullParameter(processors, (String)"processors");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)analyticService, (String)"analyticService");
            GradleBuildVariant.Builder variant = analyticService.getVariantBuilder(projectPath, variantName);
            for (Map.Entry<String, ? extends ProcessorInfo> processor2 : processors.entrySet()) {
                AnnotationProcessorInfo.Builder builder = AnnotationProcessorInfo.newBuilder();
                builder.setSpec(processor2.getKey());
                switch (WhenMappings.$EnumSwitchMapping$0[processor2.getValue().ordinal()]) {
                    case 1: {
                        builder.setIsIncremental(true);
                        break;
                    }
                    case 2: {
                        builder.setIsIncremental(false);
                        break;
                    }
                    case 3: {
                        builder.setIsIncremental(false);
                        builder.setInclusionType(AnnotationProcessorInfo.InclusionType.KSP);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                GradleBuildVariant.Builder builder2 = variant;
                if (builder2 == null) continue;
                builder2.addAnnotationProcessors(builder);
            }
            GradleBuildVariant.Builder builder = variant;
            if (builder == null) break block6;
            builder.setIsAnnotationProcessingIncremental(!processors.values().contains((Object)ProcessorInfo.NON_INCREMENTAL_AP));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void recordCompileOptionsForAnalytics(@NotNull Project project, @NotNull BuildServiceRegistry buildServiceRegistry, @NotNull JavaVersion sourceCompatibility, @NotNull JavaVersion targetCompatibility, @Nullable JavaVersion toolchainLanguageVersion) {
        block1: {
            void it;
            GradleBuildProject.CompileOptions.Builder builder;
            GradleBuildProject.Builder builder2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)buildServiceRegistry, (String)"buildServiceRegistry");
            Intrinsics.checkNotNullParameter((Object)sourceCompatibility, (String)"sourceCompatibility");
            Intrinsics.checkNotNullParameter((Object)targetCompatibility, (String)"targetCompatibility");
            AnalyticsConfiguratorService analyticsConfiguratorService = (AnalyticsConfiguratorService)BuildServicesKt.getBuildService(buildServiceRegistry, AnalyticsConfiguratorService.class).get();
            String string = project.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            GradleBuildProject.Builder builder3 = analyticsConfiguratorService.getProjectBuilder(string);
            if (builder3 == null) break block1;
            GradleBuildProject.Builder $this$recordCompileOptionsForAnalytics_u24lambda_u2411 = builder2 = builder3;
            boolean bl = false;
            GradleBuildProject.CompileOptions.Builder builder4 = builder = GradleBuildProject.CompileOptions.newBuilder();
            GradleBuildProject.Builder builder5 = $this$recordCompileOptionsForAnalytics_u24lambda_u2411;
            boolean bl2 = false;
            String string2 = sourceCompatibility.getMajorVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMajorVersion(...)");
            it.setSourceCompatibility(Integer.parseInt(string2));
            String string3 = targetCompatibility.getMajorVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMajorVersion(...)");
            it.setTargetCompatibility(Integer.parseInt(string3));
            JavaVersion javaVersion = toolchainLanguageVersion;
            if (javaVersion != null) {
                JavaVersion version = javaVersion;
                boolean bl3 = false;
                String string4 = version.getMajorVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMajorVersion(...)");
                it.setToolchainLanguageVersion(Integer.parseInt(string4));
            }
            builder5.setCompileOptions(builder.build());
        }
    }

    private static final void checkSdkCompatibility(String compileSdkVersion2, IssueReporter issueReporter2) {
        String it = compileSdkVersion2;
        boolean bl = false;
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)it);
        Intrinsics.checkNotNull((Object)androidVersion);
        if (androidVersion.getFeatureLevel() < 30) {
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to compile Java 9+ source, please set compileSdkVersion to 30 or above", null, null, (int)12, null);
        }
    }

    private static final void checkReleaseOption(JavaCompile $this$checkReleaseOption, IssueReporter issueReporter2) {
        if ($this$checkReleaseOption.getOptions().getRelease().isPresent()) {
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"Using '--release' option for JavaCompile is not supported because it prevents the Android Gradle plugin\nfrom setting up the bootclasspath for compiling Java source files against Android APIs\n(see https://issuetracker.google.com/278800528).\nPlease use Java toolchain or set 'sourceCompatibility' and 'targetCompatibility' options instead.\n(see https://developer.android.com/build/jdks#source-compat).", null, null, (int)12, null);
        }
    }

    private static final void checkDeprecatedSourceAndTargetAtExecutionTime(JavaCompile $this$checkDeprecatedSourceAndTargetAtExecutionTime, JavaVersion sourceCompatibility, JavaVersion targetCompatibility, boolean suppressWarning) {
        $this$checkDeprecatedSourceAndTargetAtExecutionTime.doFirst(new Action(sourceCompatibility, targetCompatibility, suppressWarning, $this$checkDeprecatedSourceAndTargetAtExecutionTime){
            final /* synthetic */ JavaVersion $sourceCompatibility;
            final /* synthetic */ JavaVersion $targetCompatibility;
            final /* synthetic */ boolean $suppressWarning;
            final /* synthetic */ JavaCompile $this_checkDeprecatedSourceAndTargetAtExecutionTime;
            {
                this.$sourceCompatibility = $sourceCompatibility;
                this.$targetCompatibility = $targetCompatibility;
                this.$suppressWarning = $suppressWarning;
                this.$this_checkDeprecatedSourceAndTargetAtExecutionTime = $receiver;
            }

            public final void execute(Task it) {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.gradle.api.tasks.compile.JavaCompile");
                JavaLanguageVersion javaLanguageVersion = ((JavaCompiler)((JavaCompile)it).getJavaCompiler().get()).getMetadata().getLanguageVersion();
                Intrinsics.checkNotNullExpressionValue((Object)javaLanguageVersion, (String)"getLanguageVersion(...)");
                JavaCompileUtils.access$checkDeprecatedSourceAndTarget(JavaCompileUtils.asJavaVersion(javaLanguageVersion), this.$sourceCompatibility, this.$targetCompatibility, this.$suppressWarning, (IssueReporter)new DefaultIssueReporter((ILogger)new LoggerWrapper(this.$this_checkDeprecatedSourceAndTargetAtExecutionTime.getLogger())));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkDeprecatedSourceAndTarget(JavaVersion javacVersion, JavaVersion sourceCompatibility, JavaVersion targetCompatibility, boolean suppressWarning, IssueReporter issueReporter2) {
        Object object;
        String string;
        IssueReporter.Severity severity;
        block13: {
            block12: {
                void it;
                String string2;
                severity = JavaCompileUtils.determineJavacSupportForSourceAndTarget(javacVersion, sourceCompatibility, targetCompatibility);
                if (severity == null || severity == IssueReporter.Severity.WARNING && suppressWarning) {
                    return;
                }
                IssueReporter.Severity severity2 = severity;
                switch (WhenMappings.$EnumSwitchMapping$1[severity2.ordinal()]) {
                    case 1: {
                        string2 = "removed";
                        break;
                    }
                    case 2: {
                        string2 = "deprecated";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String removedOrDeprecated = string2;
                String suppressWarningMessage = severity == IssueReporter.Severity.WARNING ? "To suppress this warning, set " + BooleanOption.JAVA_COMPILE_SUPPRESS_SOURCE_TARGET_DEPRECATION_WARNING.getPropertyName() + "=true in gradle.properties." : null;
                String string3 = sourceCompatibility.getMajorVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMajorVersion(...)");
                int n = Integer.parseInt(string3);
                String string4 = targetCompatibility.getMajorVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMajorVersion(...)");
                int n2 = Integer.parseInt(string4);
                string = StringsKt.trimIndent((String)("\n        Java compiler version " + javacVersion + " has " + removedOrDeprecated + " support for compiling with source/target version " + Math.min(n, n2) + ".\n        Try one of the following options:\n            1. [Recommended] Use Java toolchain with a lower language version\n            2. Set a higher source/target version\n            3. Use a lower version of the JDK running the build (if you're not using Java toolchain)\n        For more details on how to configure these settings, see https://developer.android.com/build/jdks.\n        "));
                object = suppressWarningMessage;
                if (object == null) break block12;
                String string5 = object;
                String string6 = string;
                boolean bl = false;
                String string7 = "\n" + (String)it;
                string = string6;
                object = string7;
                if (string7 != null) break block13;
            }
            object = "";
        }
        String message2 = string + (String)object;
        String data = "javacVersion=" + javacVersion + ",sourceCompatibility=" + sourceCompatibility + ",targetCompatibility=" + targetCompatibility;
        IssueReporter.Severity severity3 = severity;
        switch (WhenMappings.$EnumSwitchMapping$1[severity3.ordinal()]) {
            case 1: {
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, (String)data, null, (int)8, null);
                break;
            }
            case 2: {
                IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, (String)data, null, (int)8, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final IssueReporter.Severity determineJavacSupportForSourceAndTarget(JavaVersion javacVersion, JavaVersion sourceCompatibility, JavaVersion targetCompatibility) {
        return javacVersion.compareTo((Enum)JavaVersion.VERSION_20) >= 0 ? (sourceCompatibility.compareTo((Enum)JavaVersion.VERSION_1_7) <= 0 || targetCompatibility.compareTo((Enum)JavaVersion.VERSION_1_7) <= 0 ? IssueReporter.Severity.ERROR : (sourceCompatibility == JavaVersion.VERSION_1_8 || targetCompatibility == JavaVersion.VERSION_1_8 ? IssueReporter.Severity.WARNING : null)) : null;
    }

    @NotNull
    public static final ProcessorInfo toProcessorInfo(@NotNull AnnotationProcessorInfo $this$toProcessorInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$toProcessorInfo, (String)"<this>");
        return $this$toProcessorInfo.getInclusionType() == AnnotationProcessorInfo.InclusionType.KSP ? ProcessorInfo.KSP_PROCESSOR : ($this$toProcessorInfo.getIsIncremental() ? ProcessorInfo.INCREMENTAL_AP : ProcessorInfo.NON_INCREMENTAL_AP);
    }

    @NotNull
    public static final JavaVersion asJavaVersion(@NotNull JavaLanguageVersion $this$asJavaVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$asJavaVersion, (String)"<this>");
        JavaVersion javaVersion = JavaVersion.toVersion((Object)$this$asJavaVersion.asInt());
        Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"toVersion(...)");
        return javaVersion;
    }

    public static final /* synthetic */ void access$checkDeprecatedSourceAndTarget(JavaVersion javacVersion, JavaVersion sourceCompatibility, JavaVersion targetCompatibility, boolean suppressWarning, IssueReporter issueReporter2) {
        JavaCompileUtils.checkDeprecatedSourceAndTarget(javacVersion, sourceCompatibility, targetCompatibility, suppressWarning, issueReporter2);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProcessorInfo.values().length];
            try {
                nArray[ProcessorInfo.INCREMENTAL_AP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessorInfo.NON_INCREMENTAL_AP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessorInfo.KSP_PROCESSOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IssueReporter.Severity.values().length];
            try {
                nArray[IssueReporter.Severity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueReporter.Severity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

