/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.variant.impl.DirectoryEntry;
import com.android.build.api.variant.impl.FlatSourceDirectoriesImpl;
import com.android.build.api.variant.impl.LayeredSourceDirectoriesImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.KmpComponentCreationConfig;
import com.android.build.gradle.internal.component.NestedComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.builder.compiling.BuildConfigType;
import com.google.common.collect.Streams;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;

public class Utils {
    public static List<File> getGeneratedSourceFolders(ComponentCreationConfig component2) {
        return Streams.stream((Iterable)Utils.getGeneratedSourceFoldersFileCollection(component2)).collect(Collectors.toList());
    }

    public static List<File> getGeneratedSourceFoldersForUnitTests(ComponentCreationConfig component2) {
        return Streams.stream((Iterable)Utils.getGeneratedSourceFoldersFileCollectionForUnitTests(component2)).collect(Collectors.toList());
    }

    private static FileCollection getGeneratedSourceFoldersFileCollectionForUnitTests(ComponentCreationConfig component2) {
        ConfigurableFileCollection fileCollection2 = component2.getServices().fileCollection();
        component2.getSources().java((Function1<? super FlatSourceDirectoriesImpl, Unit>)((Function1)javaSources -> {
            fileCollection2.from(new Object[]{javaSources.variantSourcesFileCollectionForModel$gradle_core((Function1<? super DirectoryEntry, Boolean>)((Function1)directoryEntry -> directoryEntry.isGenerated() && directoryEntry.getShouldBeAddedToIdeModel()))});
            return Unit.INSTANCE;
        }));
        if (component2.getOldVariantApiLegacySupport() != null) {
            fileCollection2.from(new Object[]{component2.getOldVariantApiLegacySupport().getVariantData().getExtraGeneratedSourceFoldersOnlyInModel()});
        }
        if (!(component2 instanceof KmpComponentCreationConfig)) {
            fileCollection2.from(new Object[]{component2.getArtifacts().get(InternalArtifactType.AP_GENERATED_SOURCES.INSTANCE)});
        }
        fileCollection2.disallowChanges();
        return fileCollection2;
    }

    public static FileCollection getGeneratedSourceFoldersFileCollection(ComponentCreationConfig component2) {
        ConfigurableFileCollection fileCollection2 = component2.getServices().fileCollection();
        ArtifactsImpl artifacts2 = component2.getArtifacts();
        fileCollection2.from(new Object[]{Utils.getGeneratedSourceFoldersFileCollectionForUnitTests(component2)});
        if (component2.getBuildFeatures().getAidl()) {
            Callable<Directory> aidlCallable = () -> (Directory)artifacts2.get(InternalArtifactType.AIDL_SOURCE_OUTPUT_DIR.INSTANCE).getOrNull();
            fileCollection2.from(new Object[]{aidlCallable});
        }
        if (component2.getBuildConfigCreationConfig() != null && component2.getBuildConfigCreationConfig().getBuildConfigType() == BuildConfigType.JAVA_SOURCE) {
            Callable<Directory> buildConfigCallable = () -> (Directory)component2.getPaths().getBuildConfigSourceOutputDir().getOrNull();
            fileCollection2.from(new Object[]{buildConfigCallable});
        }
        boolean ndkMode = false;
        VariantCreationConfig mainVariant = component2 instanceof NestedComponentCreationConfig ? ((NestedComponentCreationConfig)component2).getMainVariant() : (VariantCreationConfig)component2;
        if (mainVariant.getRenderscriptCreationConfig() != null) {
            ndkMode = mainVariant.getRenderscriptCreationConfig().getDslRenderscriptNdkModeEnabled();
        }
        if (!ndkMode && component2.getBuildFeatures().getRenderScript()) {
            Callable<Directory> renderscriptCallable = () -> (Directory)artifacts2.get(InternalArtifactType.RENDERSCRIPT_SOURCE_OUTPUT_DIR.INSTANCE).getOrNull();
            fileCollection2.from(new Object[]{renderscriptCallable});
        }
        boolean isDataBindingEnabled = component2.getBuildFeatures().getDataBinding();
        boolean isViewBindingEnabled = component2.getBuildFeatures().getViewBinding();
        if (isDataBindingEnabled || isViewBindingEnabled) {
            Callable<Directory> dataBindingCallable = () -> (Directory)artifacts2.get(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT.INSTANCE).getOrNull();
            fileCollection2.from(new Object[]{dataBindingCallable});
        }
        fileCollection2.disallowChanges();
        return fileCollection2;
    }

    public static List<File> getGeneratedResourceFolders(ComponentCreationConfig component2) {
        return Streams.stream((Iterable)Utils.getGeneratedResourceFoldersFileCollection(component2)).collect(Collectors.toList());
    }

    public static FileCollection getGeneratedResourceFoldersFileCollection(ComponentCreationConfig component2) {
        ConfigurableFileCollection fileCollection2 = component2.getServices().fileCollection();
        component2.getSources().res((Function1<? super LayeredSourceDirectoriesImpl, Unit>)((Function1)resSources -> {
            resSources.forAllSources((Function1<? super DirectoryEntry, Unit>)((Function1)directoryEntry -> {
                if (directoryEntry.isUserAdded() && directoryEntry.isGenerated() && directoryEntry.getShouldBeAddedToIdeModel()) {
                    fileCollection2.from(new Object[]{directoryEntry.asFiles((Provider<Directory>)component2.getServices().getProjectInfo().getBuildDirectory())});
                }
                return Unit.INSTANCE;
            }));
            return Unit.INSTANCE;
        }));
        if (component2.getBuildFeatures().getRenderScript()) {
            fileCollection2.from(new Object[]{component2.getArtifacts().get(InternalArtifactType.RENDERSCRIPT_GENERATED_RES.INSTANCE)});
        }
        if (component2.getBuildFeatures().getAndroidResources() && component2.getArtifacts().get(InternalArtifactType.GENERATED_RES.INSTANCE).isPresent()) {
            fileCollection2.from(new Object[]{component2.getArtifacts().get(InternalArtifactType.GENERATED_RES.INSTANCE)});
        }
        fileCollection2.disallowChanges();
        return fileCollection2;
    }
}

