/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.KmpComponentCreationConfig;
import com.android.build.gradle.internal.component.features.AndroidResourcesCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.ide.Utils;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputs;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputsImpl;
import com.android.build.gradle.internal.lint.ArtifactInput;
import com.android.build.gradle.internal.lint.DependencyCaches;
import com.android.build.gradle.internal.lint.KotlinCompilationWrapper;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.ComponentType;
import com.android.builder.core.ComponentTypeImpl;
import com.android.tools.lint.model.DefaultLintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelArtifactType;
import com.android.tools.lint.model.LintModelDependencies;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonOptions;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u00162\b\b\u0002\u0010\u001c\u001a\u00020\u0016J6\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J6\u0010$\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J\u001d\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/lint/AndroidArtifactInput;", "Lcom/android/build/gradle/internal/lint/ArtifactInput;", "()V", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "desugaredMethodsFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getDesugaredMethodsFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "generatedResourceFolders", "getGeneratedResourceFolders", "generatedSourceFolders", "getGeneratedSourceFolders", "initialize", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "useModuleDependencyLintModels", "", "addBaseModuleLintModel", "warnIfProjectTreatedAsExternalDependency", "fatalOnly", "isPerComponentLintAnalysis", "includeClassesOutputDirectories", "includeGeneratedSourceFolders", "initializeForStandalone", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "initializeForStandaloneWithKotlinMultiplatform", "kotlinCompilationWrapper", "Lcom/android/build/gradle/internal/lint/KotlinCompilationWrapper;", "toLintModel", "Lcom/android/tools/lint/model/LintModelAndroidArtifact;", "dependencyCaches", "Lcom/android/build/gradle/internal/lint/DependencyCaches;", "type", "Lcom/android/tools/lint/model/LintModelArtifactType;", "toLintModel$gradle_core", "gradle-core"})
public abstract class AndroidArtifactInput
extends ArtifactInput {
    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getGeneratedSourceFolders();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getGeneratedResourceFolders();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getDesugaredMethodsFiles();

    @NotNull
    public final AndroidArtifactInput initialize(@NotNull ComponentCreationConfig creationConfig, @NotNull LintMode lintMode, boolean useModuleDependencyLintModels, boolean addBaseModuleLintModel, boolean warnIfProjectTreatedAsExternalDependency, boolean fatalOnly, boolean isPerComponentLintAnalysis, boolean includeClassesOutputDirectories, boolean includeGeneratedSourceFolders) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        HasConfigurableValuesKt.setDisallowChanges(this.getApplicationId(), creationConfig.getApplicationId());
        if (includeGeneratedSourceFolders) {
            objectArray = new Object[]{Utils.getGeneratedSourceFoldersFileCollection(creationConfig)};
            this.getGeneratedSourceFolders().from(objectArray);
        }
        this.getGeneratedSourceFolders().disallowChanges();
        ConfigurableFileCollection configurableFileCollection = this.getGeneratedResourceFolders();
        objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)Utils.getGeneratedResourceFoldersFileCollection(creationConfig), (String)"getGeneratedResourceFold\u2026ollection(creationConfig)");
        HasConfigurableValuesKt.fromDisallowChanges(configurableFileCollection, objectArray);
        if (includeClassesOutputDirectories) {
            Object object;
            if (creationConfig instanceof KmpComponentCreationConfig) {
                objectArray = new Object[]{creationConfig.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE)};
                this.getClassesOutputDirectories().from(objectArray);
            } else {
                objectArray = new Object[]{creationConfig.getArtifacts().get(InternalArtifactType.JAVAC.INSTANCE)};
                this.getClassesOutputDirectories().from(objectArray);
            }
            if ((object = creationConfig.getOldVariantApiLegacySupport()) != null && (object = object.getVariantData()) != null) {
                Object it = object;
                boolean bl = false;
                Object[] objectArray2 = new Object[]{((BaseVariantData)it).getAllPreJavacGeneratedBytecode()};
                this.getClassesOutputDirectories().from(objectArray2);
                objectArray2 = new Object[]{((BaseVariantData)it).getAllPostJavacGeneratedBytecode()};
                this.getClassesOutputDirectories().from(objectArray2);
            }
            AndroidResourcesCreationConfig androidResourcesCreationConfig2 = creationConfig.getAndroidResourcesCreationConfig();
            if (androidResourcesCreationConfig2 != null) {
                AndroidResourcesCreationConfig it = androidResourcesCreationConfig2;
                boolean bl = false;
                Object[] objectArray3 = new Object[]{it.getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH)};
                this.getClassesOutputDirectories().from(objectArray3);
            }
        }
        this.getClassesOutputDirectories().disallowChanges();
        HasConfigurableValuesKt.setDisallowChanges(this.getWarnIfProjectTreatedAsExternalDependency(), warnIfProjectTreatedAsExternalDependency);
        HasConfigurableValuesKt.setDisallowChanges(this.getIgnoreUnexpectedArtifactTypes(), false);
        this.initializeProjectDependencyLintArtifacts(useModuleDependencyLintModels, creationConfig.getVariantDependencies(), lintMode, !creationConfig.getComponentType().isNestedComponent(), fatalOnly, isPerComponentLintAnalysis);
        if (!useModuleDependencyLintModels) {
            if (addBaseModuleLintModel) {
                this.initializeBaseModuleLintModel(creationConfig.getVariantDependencies());
            }
            this.setProjectRuntimeExplodedAars(VariantDependencies.getArtifactCollectionForToolingModel$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LOCAL_EXPLODED_AAR_FOR_LINT, null, 8, null));
            this.setProjectCompileExplodedAars(VariantDependencies.getArtifactCollectionForToolingModel$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.LOCAL_EXPLODED_AAR_FOR_LINT, null, 8, null));
        }
        HasConfigurableValuesKt.setDisallowChanges(this.getArtifactCollectionsInputs(), new ArtifactCollectionsInputsImpl(creationConfig.getVariantDependencies(), creationConfig.getServices().getProjectInfo().getPath(), creationConfig.getName(), ArtifactCollectionsInputs.RuntimeType.FULL));
        ConsumableCreationConfig consumableCreationConfig = creationConfig instanceof ConsumableCreationConfig ? (ConsumableCreationConfig)creationConfig : null;
        boolean coreLibDesugaring = consumableCreationConfig != null ? consumableCreationConfig.isCoreLibraryDesugaringEnabledLintCheck() : false;
        Object[] objectArray4 = new Object[]{DesugarLibUtils.getDesugaredMethods(creationConfig.getServices(), coreLibDesugaring, creationConfig.getMinSdk(), creationConfig.getGlobal())};
        this.getDesugaredMethodsFiles().from(objectArray4).disallowChanges();
        return this;
    }

    public static /* synthetic */ AndroidArtifactInput initialize$default(AndroidArtifactInput androidArtifactInput, ComponentCreationConfig componentCreationConfig, LintMode lintMode, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialize");
        }
        if ((n & 0x80) != 0) {
            bl6 = true;
        }
        if ((n & 0x100) != 0) {
            bl7 = true;
        }
        return androidArtifactInput.initialize(componentCreationConfig, lintMode, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    @NotNull
    public final AndroidArtifactInput initializeForStandalone(@NotNull Project project, @NotNull ProjectOptions projectOptions, @NotNull SourceSet sourceSet2, @NotNull LintMode lintMode, boolean useModuleDependencyLintModels, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        HasConfigurableValuesKt.setDisallowChanges(this.getApplicationId(), "");
        this.getGeneratedSourceFolders().disallowChanges();
        this.getGeneratedResourceFolders().disallowChanges();
        this.getDesugaredMethodsFiles().disallowChanges();
        ConfigurableFileCollection configurableFileCollection = this.getClassesOutputDirectories();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)sourceSet2.getOutput().getClassesDirs(), (String)"sourceSet.output.classesDirs");
        HasConfigurableValuesKt.fromDisallowChanges(configurableFileCollection, objectArray);
        HasConfigurableValuesKt.setDisallowChanges(this.getWarnIfProjectTreatedAsExternalDependency(), false);
        HasConfigurableValuesKt.setDisallowChanges(this.getIgnoreUnexpectedArtifactTypes(), true);
        String string = sourceSet2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceSet.name");
        ComponentType componentType = (ComponentType)ComponentTypeImpl.JAVA_LIBRARY;
        Configuration configuration = project.getConfigurations().getByName(sourceSet2.getCompileClasspathConfigurationName());
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026asspathConfigurationName)");
        Configuration configuration2 = project.getConfigurations().getByName(sourceSet2.getRuntimeClasspathConfigurationName());
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"project.configurations.g\u2026asspathConfigurationName)");
        VariantDependencies variantDependencies2 = new VariantDependencies(string, componentType, configuration, configuration2, CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap(), project.getConfigurations().getByName(sourceSet2.getCompileOnlyConfigurationName()), project.getConfigurations().getByName(sourceSet2.getAnnotationProcessorConfigurationName()), null, null, null, project, projectOptions, false, false);
        Property<ArtifactCollectionsInputs> property = this.getArtifactCollectionsInputs();
        String string2 = project.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.path");
        String string3 = sourceSet2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sourceSet.name");
        HasConfigurableValuesKt.setDisallowChanges(property, new ArtifactCollectionsInputsImpl(variantDependencies2, string2, string3, ArtifactCollectionsInputs.RuntimeType.FULL));
        this.initializeProjectDependencyLintArtifacts(useModuleDependencyLintModels, variantDependencies2, lintMode, true, fatalOnly, projectOptions.get(BooleanOption.LINT_ANALYSIS_PER_COMPONENT));
        return this;
    }

    @NotNull
    public final AndroidArtifactInput initializeForStandaloneWithKotlinMultiplatform(@NotNull Project project, @NotNull ProjectOptions projectOptions, @NotNull KotlinCompilationWrapper kotlinCompilationWrapper, @NotNull LintMode lintMode, boolean useModuleDependencyLintModels, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)kotlinCompilationWrapper, (String)"kotlinCompilationWrapper");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        KotlinCompilation<KotlinCommonOptions> compilation = kotlinCompilationWrapper.getKotlinCompilation();
        HasConfigurableValuesKt.setDisallowChanges(this.getApplicationId(), "");
        this.getGeneratedSourceFolders().disallowChanges();
        this.getGeneratedResourceFolders().disallowChanges();
        this.getDesugaredMethodsFiles().disallowChanges();
        Object[] objectArray = new Object[]{compilation.getOutput().getClassesDirs()};
        HasConfigurableValuesKt.fromDisallowChanges(this.getClassesOutputDirectories(), objectArray);
        HasConfigurableValuesKt.setDisallowChanges(this.getWarnIfProjectTreatedAsExternalDependency(), false);
        HasConfigurableValuesKt.setDisallowChanges(this.getIgnoreUnexpectedArtifactTypes(), true);
        String string = compilation.getName();
        ComponentType componentType = (ComponentType)ComponentTypeImpl.JAVA_LIBRARY;
        Configuration configuration = project.getConfigurations().getByName(compilation.getCompileDependencyConfigurationName());
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026endencyConfigurationName)");
        ConfigurationContainer configurationContainer = project.getConfigurations();
        String string2 = compilation.getRuntimeDependencyConfigurationName();
        if (string2 == null) {
            string2 = compilation.getCompileDependencyConfigurationName();
        }
        Configuration configuration2 = configurationContainer.getByName(string2);
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"project.configurations.g\u2026endencyConfigurationName)");
        VariantDependencies variantDependencies2 = new VariantDependencies(string, componentType, configuration, configuration2, CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap(), project.getConfigurations().getByName(compilation.getCompileOnlyConfigurationName()), null, null, null, null, project, projectOptions, false, false);
        Property<ArtifactCollectionsInputs> property = this.getArtifactCollectionsInputs();
        String string3 = project.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.path");
        HasConfigurableValuesKt.setDisallowChanges(property, new ArtifactCollectionsInputsImpl(variantDependencies2, string3, compilation.getName(), ArtifactCollectionsInputs.RuntimeType.FULL));
        this.initializeProjectDependencyLintArtifacts(useModuleDependencyLintModels, variantDependencies2, lintMode, true, fatalOnly, projectOptions.get(BooleanOption.LINT_ANALYSIS_PER_COMPONENT));
        return this;
    }

    @NotNull
    public final LintModelAndroidArtifact toLintModel$gradle_core(@NotNull DependencyCaches dependencyCaches, @NotNull LintModelArtifactType type) {
        Intrinsics.checkNotNullParameter((Object)dependencyCaches, (String)"dependencyCaches");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object object = this.getApplicationId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"applicationId.get()");
        String string = (String)object;
        Collection collection = CollectionsKt.toList((Iterable)((Iterable)this.getGeneratedResourceFolders()));
        Collection collection2 = CollectionsKt.toList((Iterable)((Iterable)this.getGeneratedSourceFolders()));
        Collection collection3 = CollectionsKt.toList((Iterable)((Iterable)this.getDesugaredMethodsFiles()));
        LintModelDependencies lintModelDependencies = this.computeDependencies$gradle_core(dependencyCaches);
        Set set = this.getClassesOutputDirectories().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"classesOutputDirectories.files");
        return (LintModelAndroidArtifact)new DefaultLintModelAndroidArtifact(string, collection, collection2, collection3, lintModelDependencies, CollectionsKt.toList((Iterable)set), type);
    }
}

