/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.FeatureFlag;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.XmlNode;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OrphanXmlElement
extends XmlNode {
    @NotNull
    private final Element mXml;
    @NotNull
    private final ManifestModel.NodeTypes mType;

    public OrphanXmlElement(@NotNull Element xml, @NotNull DocumentModel<ManifestModel.NodeTypes> model) {
        this.mXml = (Element)Preconditions.checkNotNull((Object)xml);
        String elementName = this.mXml.getNodeName();
        this.mType = model.fromXmlSimpleName(elementName.substring(elementName.indexOf(58) + 1));
    }

    public boolean isA(ManifestModel.NodeTypes type) {
        return this.mType == type;
    }

    @Override
    @NotNull
    public Element getXml() {
        return this.mXml;
    }

    @NotNull
    public String getNamespaceURI() {
        return this.mXml.getNamespaceURI();
    }

    @NotNull
    public String getTagName() {
        return this.mXml.getTagName();
    }

    @Nullable
    public String getAttributeValue(String namespaceUri, String localName) {
        NamedNodeMap namedNodeMap = this.getXml().getAttributes();
        return Optional.ofNullable(namedNodeMap.getNamedItemNS(namespaceUri, localName)).map(Node::getNodeValue).orElse(null);
    }

    @Nullable
    public String getAttributeInfo(String namespaceUri, String attributeName) {
        Element element = this.getXml();
        Attr attr = element.getAttributeNodeNS(namespaceUri, attributeName);
        if (attr == null) {
            return null;
        }
        return element.getTagName() + ":" + attributeName + ":" + attr.getValue();
    }

    @NotNull
    public String lookupNamespacePrefix(@NotNull String nsUri, boolean create) {
        return XmlUtils.lookupNamespacePrefix((Node)this.getXml(), (String)nsUri, (boolean)create);
    }

    @NotNull
    public String lookupNamespacePrefix(@NotNull String nsUri, @NotNull String defaultPrefix, boolean create) {
        return XmlUtils.lookupNamespacePrefix((Node)this.getXml(), (String)nsUri, (String)defaultPrefix, (boolean)create);
    }

    @Nullable
    public Attr getAttributeNode(String name) {
        return this.mXml.getAttributeNode(name);
    }

    @Nullable
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.mXml.getAttributeNodeNS(namespaceURI, localName);
    }

    @Nullable
    public FeatureFlag featureFlag() {
        Attr featureFlagAttribute = this.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "featureFlag");
        if (featureFlagAttribute != null) {
            return FeatureFlag.Companion.from(featureFlagAttribute.getValue());
        }
        return null;
    }

    public boolean hasFeatureFlag() {
        return this.featureFlag() != null;
    }

    @Override
    @NotNull
    public XmlNode.NodeKey getId() {
        String featureFlagSuffix = Optional.ofNullable(this.featureFlag()).map(flag -> "#" + flag.getAttributeValue()).orElse("");
        String idPrefix = this.getKey() == null || this.getKey().isEmpty() ? this.getName().toString() : this.getName() + "#" + this.getKey();
        return new XmlNode.NodeKey(idPrefix + featureFlagSuffix);
    }

    @Override
    @NotNull
    public XmlNode.NodeName getName() {
        return XmlNode.unwrapName(this.mXml);
    }

    @NotNull
    public ManifestModel.NodeTypes getType() {
        return this.mType;
    }

    @Nullable
    public String getKey() {
        return this.mType.getNodeKeyResolver().getKey(this.mXml);
    }

    @Override
    @NotNull
    public SourcePosition getPosition() {
        return SourcePosition.UNKNOWN;
    }

    @Override
    @NotNull
    public SourceFile getSourceFile() {
        return SourceFile.UNKNOWN;
    }
}

