/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsReferenceableElement;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsElementCollectionImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryReferenceImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootRole;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsLibraryImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsLibraryImpl<P>>
implements JpsTypedLibrary<P> {
    private static final ConcurrentMap<JpsOrderRootType, JpsElementCollectionRole<JpsLibraryRoot>> ourRootRoles = ContainerUtil.newConcurrentMap();
    private final JpsLibraryType<P> myLibraryType;
    private static final Set<String> AR_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"jar", "zip", "swc", "ane"});

    public JpsLibraryImpl(@NotNull String name2, @NotNull JpsLibraryType<P> type2, @NotNull P properties2) {
        if (name2 == null) {
            JpsLibraryImpl.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            JpsLibraryImpl.$$$reportNull$$$0(1);
        }
        if (properties2 == null) {
            JpsLibraryImpl.$$$reportNull$$$0(2);
        }
        super(name2);
        this.myLibraryType = type2;
        this.myContainer.setChild(this.myLibraryType.getPropertiesRole(), properties2);
    }

    private JpsLibraryImpl(@NotNull JpsLibraryImpl<P> original) {
        if (original == null) {
            JpsLibraryImpl.$$$reportNull$$$0(3);
        }
        super(original);
        this.myLibraryType = original.myLibraryType;
    }

    @Override
    @NotNull
    public JpsLibraryType<P> getType() {
        JpsLibraryType<P> jpsLibraryType = this.myLibraryType;
        if (jpsLibraryType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(4);
        }
        return jpsLibraryType;
    }

    @Override
    @Nullable
    public <P extends JpsElement> JpsTypedLibrary<P> asTyped(@NotNull JpsLibraryType<P> type2) {
        if (type2 == null) {
            JpsLibraryImpl.$$$reportNull$$$0(5);
        }
        return this.myLibraryType.equals(type2) ? this : null;
    }

    @Override
    @NotNull
    public P getProperties() {
        Object p = this.myContainer.getChild(this.myLibraryType.getPropertiesRole());
        if (p == null) {
            JpsLibraryImpl.$$$reportNull$$$0(6);
        }
        return p;
    }

    @Override
    @NotNull
    public List<JpsLibraryRoot> getRoots(@NotNull JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection;
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(7);
        }
        List<Object> list2 = (rootsCollection = (JpsElementCollection)((Object)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType)))) != null ? rootsCollection.getElements() : Collections.emptyList();
        if (list2 == null) {
            JpsLibraryImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        if (url == null) {
            JpsLibraryImpl.$$$reportNull$$$0(9);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(10);
        }
        this.addRoot(url, rootType, JpsLibraryRoot.InclusionOptions.ROOT_ITSELF);
    }

    @Override
    public void addRoot(@NotNull File file2, @NotNull JpsOrderRootType rootType) {
        if (file2 == null) {
            JpsLibraryImpl.$$$reportNull$$$0(11);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(12);
        }
        this.addRoot(JpsPathUtil.getLibraryRootUrl((File)file2), rootType);
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType, @NotNull JpsLibraryRoot.InclusionOptions options) {
        if (url == null) {
            JpsLibraryImpl.$$$reportNull$$$0(13);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(14);
        }
        if (options == null) {
            JpsLibraryImpl.$$$reportNull$$$0(15);
        }
        ((JpsElementCollection)this.myContainer.getOrSetChild(JpsLibraryImpl.getRole(rootType))).addChild(new JpsLibraryRootImpl(url, rootType, options));
    }

    @Override
    public void removeUrl(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection;
        if (url == null) {
            JpsLibraryImpl.$$$reportNull$$$0(16);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(17);
        }
        if ((rootsCollection = (JpsElementCollection)((Object)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType)))) != null) {
            for (JpsLibraryRoot root2 : rootsCollection.getElements()) {
                if (!root2.getUrl().equals(url) || !root2.getRootType().equals(rootType)) continue;
                rootsCollection.removeChild(root2);
                break;
            }
        }
    }

    private static JpsElementCollectionRole<JpsLibraryRoot> getRole(JpsOrderRootType type2) {
        JpsElementCollectionRole role = (JpsElementCollectionRole)ourRootRoles.get(type2);
        if (role != null) {
            return role;
        }
        ourRootRoles.putIfAbsent(type2, JpsElementCollectionRole.create(new JpsLibraryRootRole(type2)));
        return (JpsElementCollectionRole)ourRootRoles.get(type2);
    }

    @Override
    public void delete() {
        ((JpsElementCollectionImpl)this.getParent()).removeChild(this);
    }

    @Override
    public JpsElementCollectionImpl<JpsLibrary> getParent() {
        return (JpsElementCollectionImpl)this.myParent;
    }

    @Override
    @NotNull
    public JpsLibraryImpl<P> createCopy() {
        return new JpsLibraryImpl<P>(this);
    }

    @Override
    @NotNull
    public JpsLibraryReference createReference() {
        return new JpsLibraryReferenceImpl(this.getName(), this.createParentReference());
    }

    private JpsElementReference<JpsCompositeElement> createParentReference() {
        return ((JpsReferenceableElement)((Object)this.getParent().getParent())).createReference();
    }

    @Override
    public List<File> getFiles(JpsOrderRootType rootType) {
        List<String> urls = this.getRootUrls(rootType);
        ArrayList<File> files2 = new ArrayList<File>(urls.size());
        for (String url : urls) {
            if (JpsPathUtil.isJrtUrl((String)url)) continue;
            files2.add(JpsPathUtil.urlToFile((String)url));
        }
        return files2;
    }

    @Override
    public List<String> getRootUrls(JpsOrderRootType rootType) {
        ArrayList<String> urls = new ArrayList<String>();
        for (JpsLibraryRoot root2 : this.getRoots(rootType)) {
            switch (root2.getInclusionOptions()) {
                case ROOT_ITSELF: {
                    urls.add(root2.getUrl());
                    break;
                }
                case ARCHIVES_UNDER_ROOT: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile((String)root2.getUrl()), false, urls);
                    break;
                }
                case ARCHIVES_UNDER_ROOT_RECURSIVELY: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile((String)root2.getUrl()), true, urls);
                }
            }
        }
        return urls;
    }

    private static void collectArchives(File file2, boolean recursively, List<? super String> result2) {
        Object[] children2 = file2.listFiles();
        if (children2 != null) {
            Arrays.sort(children2);
            for (Object child : children2) {
                String extension2 = FileUtilRt.getExtension((String)((File)child).getName());
                if (((File)child).isDirectory()) {
                    if (!recursively) continue;
                    JpsLibraryImpl.collectArchives((File)child, recursively, result2);
                    continue;
                }
                if (!AR_EXTENSIONS.contains(extension2)) continue;
                result2.add(JpsPathUtil.getLibraryRootUrl((File)child));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/library/impl/JpsLibraryImpl";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/library/impl/JpsLibraryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asTyped";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeUrl";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

