/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.fir;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.fir.KtSourceFileDiagnosticPos;
import org.jetbrains.kotlin.cli.common.fir.SequentialFilePositionFinder;
import org.jetbrains.kotlin.cli.common.fir.SequentialPositionFinder;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocationWithRange;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.rendering.RootDiagnosticRendererFactory;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\rJ*\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010H\u0002J(\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter;", "", "<init>", "()V", "reportToMessageCollector", "", "diagnosticsCollector", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "renderDiagnosticName", "throwFirstErrorAsException", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "reportByFile", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "", "reportDiagnosticToMessageCollector", "diagnostic", "location", "reporter", "throwErrorDiagnosticAsException", "InFileDiagnosticsComparator", "cli"})
@SourceDebugExtension(value={"SMAP\nFirDiagnosticsCompilerResultsReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDiagnosticsCompilerResultsReporter.kt\norg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1761#2,3:254\n1761#2,3:257\n1761#2,3:260\n1285#2,2:263\n1299#2,4:265\n1#3:269\n*S KotlinDebug\n*F\n+ 1 FirDiagnosticsCompilerResultsReporter.kt\norg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter\n*L\n31#1:254,3\n32#1:257,3\n33#1:260,3\n71#1:263,2\n71#1:265,4\n*E\n"})
public final class FirDiagnosticsCompilerResultsReporter {
    @NotNull
    public static final FirDiagnosticsCompilerResultsReporter INSTANCE = new FirDiagnosticsCompilerResultsReporter();

    private FirDiagnosticsCompilerResultsReporter() {
    }

    public final boolean reportToMessageCollector(@NotNull BaseDiagnosticsCollector diagnosticsCollector, @NotNull MessageCollector messageCollector2, boolean renderDiagnosticName) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        AnalyzerWithCompilerReport.Companion companion;
        boolean bl4;
        block11: {
            boolean bl5;
            KtDiagnostic it;
            Iterable $this$any$iv;
            boolean $i$f$any;
            block10: {
                boolean bl6;
                block9: {
                    Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
                    Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
                    boolean it2 = bl4 = this.reportByFile(diagnosticsCollector, (Function2<? super KtDiagnostic, ? super CompilerMessageSourceLocation, Unit>)((Function2)(arg_0, arg_1) -> FirDiagnosticsCompilerResultsReporter.reportToMessageCollector$lambda$0(messageCollector2, renderDiagnosticName, arg_0, arg_1)));
                    boolean bl7 = false;
                    Iterable iterable = diagnosticsCollector.getDiagnostics();
                    companion = AnalyzerWithCompilerReport.Companion;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (KtDiagnostic)element$iv;
                            boolean bl8 = false;
                            if (!Intrinsics.areEqual((Object)it.getFactory(), FirErrors.INSTANCE.getINCOMPATIBLE_CLASS())) continue;
                            bl6 = true;
                            break block9;
                        }
                        bl6 = false;
                    }
                }
                bl3 = bl6;
                $this$any$iv = diagnosticsCollector.getDiagnostics();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KtDiagnostic)element$iv;
                        boolean bl9 = false;
                        if (!Intrinsics.areEqual((Object)it.getFactory(), FirErrors.INSTANCE.getPRE_RELEASE_CLASS())) continue;
                        bl5 = true;
                        break block10;
                    }
                    bl5 = false;
                }
            }
            bl2 = bl5;
            $this$any$iv = diagnosticsCollector.getDiagnostics();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KtDiagnostic)element$iv;
                    boolean bl10 = false;
                    if (!Intrinsics.areEqual((Object)it.getFactory(), FirErrors.INSTANCE.getIR_WITH_UNSTABLE_ABI_COMPILED_CLASS())) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean bl11 = bl;
        companion.reportSpecialErrors(bl3, bl2, bl11, messageCollector2);
        return bl4;
    }

    public final boolean throwFirstErrorAsException(@NotNull BaseDiagnosticsCollector diagnosticsCollector, @NotNull MessageRenderer messageRenderer) {
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        Intrinsics.checkNotNullParameter((Object)messageRenderer, (String)"messageRenderer");
        return this.reportByFile(diagnosticsCollector, (Function2<? super KtDiagnostic, ? super CompilerMessageSourceLocation, Unit>)((Function2)(arg_0, arg_1) -> FirDiagnosticsCompilerResultsReporter.throwFirstErrorAsException$lambda$5(messageRenderer, arg_0, arg_1)));
    }

    public static /* synthetic */ boolean throwFirstErrorAsException$default(FirDiagnosticsCompilerResultsReporter firDiagnosticsCompilerResultsReporter, BaseDiagnosticsCollector baseDiagnosticsCollector, MessageRenderer messageRenderer, int n, Object object) {
        if ((n & 2) != 0) {
            MessageRenderer messageRenderer2 = MessageRenderer.PLAIN_RELATIVE_PATHS;
            Intrinsics.checkNotNullExpressionValue((Object)messageRenderer2, (String)"PLAIN_RELATIVE_PATHS");
            messageRenderer = messageRenderer2;
        }
        return firDiagnosticsCompilerResultsReporter.throwFirstErrorAsException(baseDiagnosticsCollector, messageRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean reportByFile(BaseDiagnosticsCollector diagnosticsCollector, Function2<? super KtDiagnostic, ? super CompilerMessageSourceLocation, Unit> report2) {
        boolean hasErrors = false;
        for (String filePath : diagnosticsCollector.getDiagnosticsByFilePath().keySet()) {
            Lazy positionFinder = LazyKt.lazy(() -> FirDiagnosticsCompilerResultsReporter.reportByFile$lambda$6(filePath));
            try {
                Map map;
                List diagnosticList;
                List list = diagnosticsCollector.getDiagnosticsByFilePath().get(filePath);
                if (list == null) {
                    list = diagnosticList = CollectionsKt.emptyList();
                }
                if ((SequentialFilePositionFinder)positionFinder.getValue() != null) {
                    Iterator range;
                    TreeSet<Integer> treeSet;
                    boolean bl = false;
                    TreeSet<Integer> $this$reportByFile_u24lambda_u249_u24lambda_u247 = treeSet = new TreeSet<Integer>();
                    boolean bl2 = false;
                    for (KtDiagnostic diagnostic : diagnosticList) {
                        if (diagnostic instanceof KtPsiDiagnostic) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)DiagnosticUtils.firstRange(diagnostic.getTextRanges()), (String)"firstRange(...)");
                        $this$reportByFile_u24lambda_u249_u24lambda_u247.add(range.getStartOffset());
                        $this$reportByFile_u24lambda_u249_u24lambda_u247.add(range.getEndOffset());
                    }
                    TreeSet<Integer> sortedOffsets = treeSet;
                    Iterable $this$associateWith$iv = sortedOffsets;
                    boolean $i$f$associateWith = false;
                    LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                    Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                    boolean $i$f$associateWithTo = false;
                    range = $this$associateWithTo$iv$iv.iterator();
                    while (range.hasNext()) {
                        void it;
                        SequentialFilePositionFinder finder;
                        Object element$iv$iv = range.next();
                        int n = ((Number)element$iv$iv).intValue();
                        Object e = element$iv$iv;
                        Map map2 = result$iv;
                        boolean bl3 = false;
                        KtSourceFileDiagnosticPos ktSourceFileDiagnosticPos = SequentialPositionFinder.findNextPosition$default(finder, (int)it, false, 2, null);
                        map2.put(e, ktSourceFileDiagnosticPos);
                    }
                    map = result$iv;
                } else {
                    map = null;
                }
                Map offsetsToPositions = map;
                for (KtDiagnostic diagnostic : CollectionsKt.sortedWith((Iterable)diagnosticList, (Comparator)InFileDiagnosticsComparator.INSTANCE)) {
                    CompilerMessageSourceLocation compilerMessageSourceLocation;
                    CompilerMessageSourceLocation compilerMessageSourceLocation2;
                    if (diagnostic instanceof KtPsiDiagnostic) {
                        PsiFile file = ((KtPsiDiagnostic)((Object)diagnostic)).getElement().getPsi().getContainingFile();
                        compilerMessageSourceLocation2 = MessageUtil.psiFileToMessageLocation(file, file.getName(), DiagnosticUtils.getLineAndColumnRange(file, ((KtPsiDiagnostic)((Object)diagnostic)).getTextRanges()));
                    } else {
                        CompilerMessageLocationWithRange compilerMessageLocationWithRange;
                        if (offsetsToPositions != null) {
                            TextRange range;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)DiagnosticUtils.firstRange(diagnostic.getTextRanges()), (String)"firstRange(...)");
                            Object v = offsetsToPositions.get(range.getStartOffset());
                            Intrinsics.checkNotNull(v);
                            KtSourceFileDiagnosticPos start = (KtSourceFileDiagnosticPos)v;
                            Object v2 = offsetsToPositions.get(range.getEndOffset());
                            Intrinsics.checkNotNull(v2);
                            KtSourceFileDiagnosticPos end = (KtSourceFileDiagnosticPos)v2;
                            compilerMessageLocationWithRange = MessageUtil.createMessageLocation(filePath, start.getLineContent(), start.getLine(), start.getColumn(), end.getLine(), end.getColumn());
                        } else {
                            compilerMessageLocationWithRange = null;
                        }
                        compilerMessageSourceLocation2 = compilerMessageLocationWithRange;
                    }
                    if ((compilerMessageSourceLocation = compilerMessageSourceLocation2) == null) continue;
                    CompilerMessageSourceLocation location = compilerMessageSourceLocation;
                    boolean bl = false;
                    report2.invoke((Object)diagnostic, (Object)location);
                    hasErrors = hasErrors || diagnostic.getSeverity() == Severity.ERROR;
                }
            }
            finally {
                if (!positionFinder.isInitialized()) continue;
                SequentialFilePositionFinder sequentialFilePositionFinder = (SequentialFilePositionFinder)positionFinder.getValue();
                if (sequentialFilePositionFinder == null) continue;
                sequentialFilePositionFinder.close();
            }
        }
        return hasErrors;
    }

    private final void reportDiagnosticToMessageCollector(KtDiagnostic diagnostic, CompilerMessageSourceLocation location, MessageCollector reporter, boolean renderDiagnosticName) {
        String string;
        CompilerMessageSeverity severity = AnalyzerWithCompilerReport.Companion.convertSeverity(diagnostic.getSeverity());
        KtDiagnosticRenderer renderer = RootDiagnosticRendererFactory.INSTANCE.invoke(diagnostic);
        String message2 = renderer.render(diagnostic);
        boolean bl = renderDiagnosticName;
        if (bl) {
            string = '[' + diagnostic.getFactoryName() + "] " + message2;
        } else if (!bl) {
            string = message2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String textToRender = string;
        reporter.report(severity, textToRender, location);
    }

    private final void throwErrorDiagnosticAsException(KtDiagnostic diagnostic, CompilerMessageSourceLocation location, MessageRenderer messageRenderer) {
        if (diagnostic.getSeverity() == Severity.ERROR) {
            CompilerMessageSeverity severity = AnalyzerWithCompilerReport.Companion.convertSeverity(diagnostic.getSeverity());
            KtDiagnosticRenderer renderer = RootDiagnosticRendererFactory.INSTANCE.invoke(diagnostic);
            String diagnosticText = messageRenderer.render(severity, renderer.render(diagnostic), location);
            throw new IllegalStateException(diagnostic.getFactory().getName() + ": " + diagnosticText);
        }
    }

    private static final Unit reportToMessageCollector$lambda$0(MessageCollector $messageCollector, boolean $renderDiagnosticName, KtDiagnostic diagnostic, CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        INSTANCE.reportDiagnosticToMessageCollector(diagnostic, location, $messageCollector, $renderDiagnosticName);
        return Unit.INSTANCE;
    }

    private static final Unit throwFirstErrorAsException$lambda$5(MessageRenderer $messageRenderer, KtDiagnostic diagnostic, CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        INSTANCE.throwErrorDiagnosticAsException(diagnostic, location, $messageRenderer);
        return Unit.INSTANCE;
    }

    private static final SequentialFilePositionFinder reportByFile$lambda$6(String $filePath) {
        File file;
        String string = $filePath;
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            file = new File(p0);
        } else {
            file = null;
        }
        File file2 = file;
        return file2 != null && file2.isFile() ? new SequentialFilePositionFinder(file2) : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter$InFileDiagnosticsComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "o1", "o2", "cli"})
    private static final class InFileDiagnosticsComparator
    implements Comparator<KtDiagnostic> {
        @NotNull
        public static final InFileDiagnosticsComparator INSTANCE = new InFileDiagnosticsComparator();

        private InFileDiagnosticsComparator() {
        }

        @Override
        public int compare(@NotNull KtDiagnostic o1, @NotNull KtDiagnostic o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            TextRange textRange = DiagnosticUtils.firstRange(o1.getTextRanges());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"firstRange(...)");
            TextRange range1 = textRange;
            TextRange textRange2 = DiagnosticUtils.firstRange(o2.getTextRanges());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"firstRange(...)");
            TextRange range2 = textRange2;
            return !Intrinsics.areEqual((Object)range1, (Object)range2) ? DiagnosticUtils.TEXT_RANGE_COMPARATOR.compare(range1, range2) : o1.getFactory().getName().compareTo(o2.getFactory().getName());
        }
    }
}

