/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.nullCheck;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInlinerKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NotNullBasicValue;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullBasicValue;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\fH\u0002J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016J\f\u0010\u000f\u001a\u00020\u000b*\u00020\tH\u0002J\f\u0010\u0010\u001a\u00020\u000b*\u00020\tH\u0002J \u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/NullabilityInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "<init>", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "newOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isReferenceType", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "unaryOperation", "value", "isTypeOf", "isReifiedSafeAs", "naryOperation", "values", "", "merge", "v", "w", "mergeNotNullValuesOfSameKind", "Lorg/jetbrains/kotlin/codegen/optimization/common/StrictBasicValue;", "backend"})
@SourceDebugExtension(value={"SMAP\nNullabilityInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NullabilityInterpreter.kt\norg/jetbrains/kotlin/codegen/optimization/nullCheck/NullabilityInterpreter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class NullabilityInterpreter
extends OptimizationBasicInterpreter {
    @NotNull
    private final GenerationState generationState;

    public NullabilityInterpreter(@NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
        this.generationState = generationState;
    }

    @Override
    @Nullable
    public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
        BasicValue defaultResult;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        BasicValue basicValue = defaultResult = super.newOperation(insn);
        Type resultType = basicValue != null ? basicValue.getType() : null;
        return insn.getOpcode() == 1 && !this.isTypeOf(insn) ? (BasicValue)NullBasicValue.INSTANCE : (insn.getOpcode() == 187 ? (BasicValue)new NotNullBasicValue(resultType) : (insn.getOpcode() == 18 && this.isReferenceType(resultType) ? (BasicValue)new NotNullBasicValue(resultType) : (PopBackwardPropagationTransformerKt.isUnitInstance(insn) ? (BasicValue)new NotNullBasicValue(resultType) : defaultResult)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReferenceType(Type $this$isReferenceType) {
        Type type = $this$isReferenceType;
        if (type == null) return false;
        Integer n = type.getSort();
        Integer it = n;
        boolean bl = false;
        Integer n2 = it;
        int n3 = 10;
        if (n2 != null) {
            if (n2 == n3) return true;
        }
        Integer n4 = it;
        n3 = 9;
        if (n4 == null) return false;
        if (n4 != n3) return false;
        return true;
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @Nullable BasicValue value2) {
        BasicValue basicValue;
        BasicValue defaultResult;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        BasicValue basicValue2 = defaultResult = super.unaryOperation(insn, value2);
        Type resultType = basicValue2 != null ? basicValue2.getType() : null;
        switch (insn.getOpcode()) {
            case 192: {
                if (this.isReifiedSafeAs(insn)) {
                    basicValue = new StrictBasicValue(resultType);
                    break;
                }
                basicValue = value2;
                break;
            }
            case 188: 
            case 189: {
                basicValue = new NotNullBasicValue(resultType);
                break;
            }
            default: {
                basicValue = defaultResult;
            }
        }
        return basicValue;
    }

    private final boolean isTypeOf(AbstractInsnNode $this$isTypeOf) {
        AbstractInsnNode abstractInsnNode = $this$isTypeOf.getPrevious();
        MethodInsnNode methodInsnNode = abstractInsnNode instanceof MethodInsnNode ? (MethodInsnNode)abstractInsnNode : null;
        if (methodInsnNode == null) {
            return false;
        }
        MethodInsnNode marker = methodInsnNode;
        AbstractInsnNode abstractInsnNode2 = $this$isTypeOf.getPrevious();
        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode2, (String)"getPrevious(...)");
        return ReifiedTypeInliner.Companion.isOperationReifiedMarker(abstractInsnNode2) && ReifiedTypeInlinerKt.getOperationKind(marker) == ReifiedTypeInliner.OperationKind.TYPE_OF;
    }

    private final boolean isReifiedSafeAs(AbstractInsnNode $this$isReifiedSafeAs) {
        AbstractInsnNode abstractInsnNode = $this$isReifiedSafeAs.getPrevious();
        MethodInsnNode methodInsnNode = abstractInsnNode instanceof MethodInsnNode ? (MethodInsnNode)abstractInsnNode : null;
        if (methodInsnNode == null) {
            return false;
        }
        MethodInsnNode marker = methodInsnNode;
        return ReifiedTypeInliner.Companion.isOperationReifiedMarker((AbstractInsnNode)marker) && ReifiedTypeInlinerKt.getOperationKind(marker) == ReifiedTypeInliner.OperationKind.SAFE_AS;
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values2) {
        BasicValue basicValue;
        BasicValue defaultResult;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        BasicValue basicValue2 = defaultResult = super.naryOperation(insn, values2);
        Type resultType = basicValue2 != null ? basicValue2.getType() : null;
        if (BoxingInterpreterKt.isBoxing(insn, this.generationState)) {
            basicValue = new NotNullBasicValue(resultType);
        } else if (BoxingInterpreterKt.isIteratorMethodCallOfProgression(insn, values2)) {
            Type type = values2.get(0).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            basicValue = ProgressionIteratorBasicValue.Companion.byProgressionClassType(insn, type);
        } else {
            basicValue = BoxingInterpreterKt.isNextMethodCallOfProgressionIterator(insn, values2) ? (BasicValue)new NotNullBasicValue(resultType) : (PseudoInsnsKt.isPseudo(insn, PseudoInsn.AS_NOT_NULL) ? (BasicValue)new NotNullBasicValue(values2.get(0).getType()) : defaultResult);
        }
        return basicValue;
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        BasicValue basicValue;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        if (v == NullBasicValue.INSTANCE) {
            basicValue = w == NullBasicValue.INSTANCE ? (StrictBasicValue)NullBasicValue.INSTANCE : StrictBasicValue.REFERENCE_VALUE;
        } else if (w == NullBasicValue.INSTANCE) {
            basicValue = StrictBasicValue.REFERENCE_VALUE;
        } else if (v instanceof ProgressionIteratorBasicValue) {
            BasicValue basicValue2 = w;
            if (basicValue2 instanceof ProgressionIteratorBasicValue) {
                basicValue = this.mergeNotNullValuesOfSameKind((StrictBasicValue)v, (StrictBasicValue)w);
            } else if (basicValue2 instanceof NotNullBasicValue) {
                basicValue = NotNullBasicValue.Companion.getNOT_NULL_REFERENCE_VALUE();
            } else {
                BasicValue basicValue3 = super.merge(v, w);
                basicValue = basicValue3;
                Intrinsics.checkNotNullExpressionValue((Object)basicValue3, (String)"merge(...)");
            }
        } else if (v instanceof NotNullBasicValue) {
            BasicValue basicValue4 = w;
            if (basicValue4 instanceof ProgressionIteratorBasicValue) {
                basicValue = NotNullBasicValue.Companion.getNOT_NULL_REFERENCE_VALUE();
            } else if (basicValue4 instanceof NotNullBasicValue) {
                basicValue = this.mergeNotNullValuesOfSameKind((StrictBasicValue)v, (StrictBasicValue)w);
            } else {
                BasicValue basicValue5 = super.merge(v, w);
                basicValue = basicValue5;
                Intrinsics.checkNotNullExpressionValue((Object)basicValue5, (String)"merge(...)");
            }
        } else {
            BasicValue basicValue6 = super.merge(v, w);
            basicValue = basicValue6;
            Intrinsics.checkNotNullExpressionValue((Object)basicValue6, (String)"merge(...)");
        }
        return basicValue;
    }

    private final StrictBasicValue mergeNotNullValuesOfSameKind(StrictBasicValue v, StrictBasicValue w) {
        return Intrinsics.areEqual((Object)v.getType(), (Object)w.getType()) ? v : (StrictBasicValue)NotNullBasicValue.Companion.getNOT_NULL_REFERENCE_VALUE();
    }
}

