/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.vavr.VavrAdaptersKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0002*+Bk\b\u0002\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006\u0012\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b\u0012\"\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r`\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fB#\b\u0016\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0004\b\u000e\u0010\u0010J%\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0016J\u001b\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0015\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b J\r\u0010!\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b%J\u0017\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b)R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "", "classesByQName", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassIdToJavaClass;", "typeParameters", "Lio/vavr/collection/Map;", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "Lorg/jetbrains/kotlin/util/vavr/ImmutableMap;", "innerClasses", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$InnerClassInfo;", "<init>", "(Lkotlin/jvm/functions/Function1;Lio/vavr/collection/Map;Lio/vavr/collection/Map;)V", "(Lkotlin/jvm/functions/Function1;)V", "addInnerClass", "", "innerInternalName", "outerInternalName", "simpleName", "addInnerClass$resolution_common_jvm", "addTypeParameters", "newTypeParameters", "", "addTypeParameters$resolution_common_jvm", "resolveClass", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$Result;", "classId", "resolveTypeParameter", "name", "resolveTypeParameter$resolution_common_jvm", "copyForMember", "copyForMember$resolution_common_jvm", "mapInternalNameToClassId", "internalName", "mapInternalNameToClassId$resolution_common_jvm", "convertNestedClassInternalNameWithSimpleHeuristic", "convertNestedClassInternalNameWithSimpleHeuristic$resolution_common_jvm", "resolveByInternalName", "resolveByInternalName$resolution_common_jvm", "Result", "InnerClassInfo", "resolution.common.jvm"})
@SourceDebugExtension(value={"SMAP\nClassifierResolutionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifierResolutionContext.kt\norg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1803#2,3:122\n1563#2:125\n1634#2,3:126\n*S KotlinDebug\n*F\n+ 1 ClassifierResolutionContext.kt\norg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext\n*L\n53#1:122,3\n87#1:125\n87#1:126,3\n*E\n"})
public final class ClassifierResolutionContext {
    @NotNull
    private final Function1<ClassId, JavaClass> classesByQName;
    @NotNull
    private Map<String, JavaTypeParameter> typeParameters;
    @NotNull
    private Map<String, InnerClassInfo> innerClasses;

    private ClassifierResolutionContext(Function1<? super ClassId, ? extends JavaClass> classesByQName, Map<String, JavaTypeParameter> typeParameters2, Map<String, InnerClassInfo> innerClasses) {
        this.classesByQName = classesByQName;
        this.typeParameters = typeParameters2;
        this.innerClasses = innerClasses;
    }

    public ClassifierResolutionContext(@NotNull Function1<? super ClassId, ? extends JavaClass> classesByQName) {
        Intrinsics.checkNotNullParameter(classesByQName, (String)"classesByQName");
        HashMap hashMap = HashMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"empty(...)");
        Map map = hashMap;
        HashMap hashMap2 = HashMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashMap2, (String)"empty(...)");
        this(classesByQName, map, hashMap2);
    }

    public final void addInnerClass$resolution_common_jvm(@NotNull String innerInternalName, @NotNull String outerInternalName, @NotNull String simpleName) {
        Intrinsics.checkNotNullParameter((Object)innerInternalName, (String)"innerInternalName");
        Intrinsics.checkNotNullParameter((Object)outerInternalName, (String)"outerInternalName");
        Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
        Map<String, InnerClassInfo> map = this.innerClasses.put(innerInternalName, new InnerClassInfo(outerInternalName, simpleName));
        Intrinsics.checkNotNullExpressionValue(map, (String)"put(...)");
        this.innerClasses = map;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTypeParameters$resolution_common_jvm(@NotNull Collection<? extends JavaTypeParameter> newTypeParameters) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter(newTypeParameters, (String)"newTypeParameters");
        if (newTypeParameters.isEmpty()) {
            return;
        }
        Iterable iterable = newTypeParameters;
        Map<String, JavaTypeParameter> map = this.typeParameters;
        ClassifierResolutionContext classifierResolutionContext = this;
        boolean $i$f$fold = false;
        Map<String, void> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void typeParameter;
            JavaTypeParameter javaTypeParameter = (JavaTypeParameter)element$iv;
            void acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(acc.put(typeParameter.getName().getIdentifier(), typeParameter), (String)"put(...)");
        }
        classifierResolutionContext.typeParameters = accumulator$iv;
    }

    private final Result resolveClass(ClassId classId) {
        return new Result((JavaClassifier)this.classesByQName.invoke((Object)classId), classId.asSingleFqName().asString());
    }

    @NotNull
    public final Result resolveTypeParameter$resolution_common_jvm(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new Result(VavrAdaptersKt.getOrNull(this.typeParameters, name2), name2);
    }

    @NotNull
    public final ClassifierResolutionContext copyForMember$resolution_common_jvm() {
        return new ClassifierResolutionContext(this.classesByQName, this.typeParameters, this.innerClasses);
    }

    @NotNull
    public final ClassId mapInternalNameToClassId$resolution_common_jvm(@NotNull String internalName) {
        InnerClassInfo innerClassInfo;
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        if (StringsKt.contains$default((CharSequence)internalName, (char)'$', (boolean)false, (int)2, null) && (innerClassInfo = VavrAdaptersKt.getOrNull(this.innerClasses, internalName)) != null && Name.isValidIdentifier(innerClassInfo.getSimpleName())) {
            ClassId outerClassId = this.mapInternalNameToClassId$resolution_common_jvm(innerClassInfo.getOuterInternalName());
            Name name2 = Name.identifier(innerClassInfo.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            return outerClassId.createNestedClassId(name2);
        }
        return ClassId.Companion.topLevel(new FqName(StringsKt.replace$default((String)internalName, (char)'/', (char)'.', (boolean)false, (int)4, null)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassId convertNestedClassInternalNameWithSimpleHeuristic$resolution_common_jvm(@NotNull String internalName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        SmartList<Integer> splitPoints = new SmartList<Integer>();
        int n = ((CharSequence)internalName).length();
        for (int p = 0; p < n; ++p) {
            char c = internalName.charAt(p);
            if (c != '$' || p <= 0 || internalName.charAt(p - 1) == '/' || p >= internalName.length() - 1 || internalName.charAt(p + 1) == '$') continue;
            splitPoints.add(p);
        }
        if (splitPoints.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)-1), (Iterable)splitPoints), (Iterable)CollectionsKt.plus((Collection)splitPoints, (Object)internalName.length()));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer from2 = (Integer)pair.component1();
            Integer to = (Integer)pair.component2();
            int n2 = from2 + 1;
            Intrinsics.checkNotNull((Object)to);
            String string = internalName.substring(n2, to);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(string);
        }
        List substrings = (List)destination$iv$iv;
        FqName outerFqName = new FqName(StringsKt.replace$default((String)((String)substrings.get(0)), (char)'/', (char)'.', (boolean)false, (int)4, null));
        FqName packageFqName = outerFqName.parent();
        FqName relativeName = new FqName(outerFqName.shortName().asString() + '.' + CollectionsKt.joinToString$default((Iterable)substrings.subList(1, substrings.size()), (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
        return new ClassId(packageFqName, relativeName, false);
    }

    @NotNull
    public final Result resolveByInternalName$resolution_common_jvm(@NotNull String internalName) {
        ClassId realName;
        Result heuristicResult;
        ClassId heuristicName;
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        Result result2 = this.resolveClass(this.mapInternalNameToClassId$resolution_common_jvm(internalName));
        if (result2.getClassifier() == null && StringsKt.contains$default((CharSequence)internalName, (char)'$', (boolean)false, (int)2, null) && (heuristicName = this.convertNestedClassInternalNameWithSimpleHeuristic$resolution_common_jvm(internalName)) != null && (heuristicResult = this.resolveClass(heuristicName)).getClassifier() instanceof BinaryJavaClass && Intrinsics.areEqual((Object)heuristicName, (Object)(realName = ((BinaryJavaClass)heuristicResult.getClassifier()).getContext$resolution_common_jvm().mapInternalNameToClassId$resolution_common_jvm(internalName)))) {
            return heuristicResult;
        }
        return result2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$InnerClassInfo;", "", "outerInternalName", "", "simpleName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getOuterInternalName", "()Ljava/lang/String;", "getSimpleName", "resolution.common.jvm"})
    private static final class InnerClassInfo {
        @NotNull
        private final String outerInternalName;
        @NotNull
        private final String simpleName;

        public InnerClassInfo(@NotNull String outerInternalName, @NotNull String simpleName) {
            Intrinsics.checkNotNullParameter((Object)outerInternalName, (String)"outerInternalName");
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            this.outerInternalName = outerInternalName;
            this.simpleName = simpleName;
        }

        @NotNull
        public final String getOuterInternalName() {
            return this.outerInternalName;
        }

        @NotNull
        public final String getSimpleName() {
            return this.simpleName;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$Result;", "", "classifier", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "qualifiedName", "", "<init>", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;Ljava/lang/String;)V", "getClassifier", "()Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "getQualifiedName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "resolution.common.jvm"})
    public static final class Result {
        @Nullable
        private final JavaClassifier classifier;
        @NotNull
        private final String qualifiedName;

        public Result(@Nullable JavaClassifier classifier, @NotNull String qualifiedName) {
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            this.classifier = classifier;
            this.qualifiedName = qualifiedName;
        }

        @Nullable
        public final JavaClassifier getClassifier() {
            return this.classifier;
        }

        @NotNull
        public final String getQualifiedName() {
            return this.qualifiedName;
        }

        @Nullable
        public final JavaClassifier component1() {
            return this.classifier;
        }

        @NotNull
        public final String component2() {
            return this.qualifiedName;
        }

        @NotNull
        public final Result copy(@Nullable JavaClassifier classifier, @NotNull String qualifiedName) {
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            return new Result(classifier, qualifiedName);
        }

        public static /* synthetic */ Result copy$default(Result result2, JavaClassifier javaClassifier, String string, int n, Object object) {
            if ((n & 1) != 0) {
                javaClassifier = result2.classifier;
            }
            if ((n & 2) != 0) {
                string = result2.qualifiedName;
            }
            return result2.copy(javaClassifier, string);
        }

        @NotNull
        public String toString() {
            return "Result(classifier=" + this.classifier + ", qualifiedName=" + this.qualifiedName + ')';
        }

        public int hashCode() {
            int result2 = this.classifier == null ? 0 : this.classifier.hashCode();
            result2 = result2 * 31 + this.qualifiedName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.classifier, (Object)result2.classifier)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.qualifiedName, (Object)result2.qualifiedName);
        }
    }
}

