/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin;

import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.mock.MockProject;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.extensions.CompilerConfigurationExtension;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.scripting.compiler.plugin.ScriptingCompilerConfigurationExtensionKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.definitions.CliScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.configuration.ScriptingConfigurationKeys;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/ScriptingCompilerConfigurationExtension;", "Lorg/jetbrains/kotlin/extensions/CompilerConfigurationExtension;", "project", "Lcom/intellij/mock/MockProject;", "baseHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "<init>", "(Lcom/intellij/mock/MockProject;Lkotlin/script/experimental/host/ScriptingHostConfiguration;)V", "getProject", "()Lcom/intellij/mock/MockProject;", "getBaseHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "updateConfiguration", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "updateFileRegistry", "kotlin-scripting-compiler"})
@SourceDebugExtension(value={"SMAP\nScriptingCompilerConfigurationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingCompilerConfigurationExtension.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/ScriptingCompilerConfigurationExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KotlinCoreEnvironment.kt\norg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment$Companion\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,120:1\n1#2:121\n1#2:123\n462#3:122\n1321#4,2:124\n*S KotlinDebug\n*F\n+ 1 ScriptingCompilerConfigurationExtension.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/ScriptingCompilerConfigurationExtension\n*L\n64#1:123\n64#1:122\n67#1:124,2\n*E\n"})
public final class ScriptingCompilerConfigurationExtension
implements CompilerConfigurationExtension {
    @NotNull
    private final MockProject project;
    @NotNull
    private final ScriptingHostConfiguration baseHostConfiguration;

    public ScriptingCompilerConfigurationExtension(@NotNull MockProject project, @NotNull ScriptingHostConfiguration baseHostConfiguration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
        this.project = project;
        this.baseHostConfiguration = baseHostConfiguration;
    }

    @NotNull
    public final MockProject getProject() {
        return this.project;
    }

    @NotNull
    public final ScriptingHostConfiguration getBaseHostConfiguration() {
        return this.baseHostConfiguration;
    }

    @Override
    public void updateConfiguration(@NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        if (!configuration2.getBoolean(ScriptingConfigurationKeys.INSTANCE.getDISABLE_SCRIPTING_PLUGIN_OPTION())) {
            CliScriptDefinitionProvider scriptDefinitionProvider;
            File projectRoot;
            File file;
            MockProject $this$updateConfiguration_u24lambda_u240 = this.project;
            boolean bl = false;
            String string = $this$updateConfiguration_u24lambda_u240.getBasePath();
            if (string == null) {
                VirtualFile virtualFile = $this$updateConfiguration_u24lambda_u240.getBaseDir();
                string = virtualFile != null ? virtualFile.getCanonicalPath() : null;
            }
            if (string != null) {
                String p0 = string;
                boolean bl2 = false;
                file = new File(p0);
            } else {
                file = projectRoot = null;
            }
            if (projectRoot != null) {
                configuration2.put(ScriptingConfigurationKeys.INSTANCE.getLEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION(), "projectRoot", projectRoot);
            }
            ScriptingHostConfiguration[] scriptingHostConfigurationArray = new ScriptingHostConfiguration[]{this.baseHostConfiguration};
            ScriptingHostConfiguration hostConfiguration = new ScriptingHostConfiguration(scriptingHostConfigurationArray, (Function1<? super ScriptingHostConfiguration.Builder, Unit>)((Function1)arg_0 -> ScriptingCompilerConfigurationExtension.updateConfiguration$lambda$2(configuration2, arg_0)));
            ClassLoader classLoader = this.getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            ScriptingCompilerConfigurationExtensionKt.configureScriptDefinitions(configuration2, hostConfiguration, classLoader);
            ScriptDefinitionProvider scriptDefinitionProvider2 = ScriptDefinitionProvider.Companion.getInstance((Project)this.project);
            CliScriptDefinitionProvider cliScriptDefinitionProvider = scriptDefinitionProvider = scriptDefinitionProvider2 instanceof CliScriptDefinitionProvider ? (CliScriptDefinitionProvider)scriptDefinitionProvider2 : null;
            if (scriptDefinitionProvider != null) {
                List list = configuration2.getList(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS_SOURCES());
                Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
                scriptDefinitionProvider.setScriptDefinitionsSources(list);
                List list2 = configuration2.getList(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS());
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getList(...)");
                scriptDefinitionProvider.setScriptDefinitions(list2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateFileRegistry() {
        CliScriptDefinitionProvider scriptDefinitionProvider;
        ScriptDefinitionProvider scriptDefinitionProvider2 = ScriptDefinitionProvider.Companion.getInstance((Project)this.project);
        CliScriptDefinitionProvider cliScriptDefinitionProvider = scriptDefinitionProvider = scriptDefinitionProvider2 instanceof CliScriptDefinitionProvider ? (CliScriptDefinitionProvider)scriptDefinitionProvider2 : null;
        if (scriptDefinitionProvider != null) {
            FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
            Intrinsics.checkNotNull((Object)fileTypeRegistry, (String)"null cannot be cast to non-null type com.intellij.core.CoreFileTypeRegistry");
            CoreFileTypeRegistry fileTypeRegistry2 = (CoreFileTypeRegistry)fileTypeRegistry;
            KotlinCoreEnvironment.Companion this_$iv = KotlinCoreEnvironment.Companion;
            boolean $i$f$underApplicationLock = false;
            Object object = this_$iv.getAPPLICATION_LOCK();
            synchronized (object) {
                void $this$forEach$iv;
                boolean bl = false;
                boolean bl2 = false;
                Sequence sequence2 = SequencesKt.filter(scriptDefinitionProvider.getKnownFilenameExtensions(), arg_0 -> ScriptingCompilerConfigurationExtension.updateFileRegistry$lambda$5$lambda$3(fileTypeRegistry2, arg_0));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    fileTypeRegistry2.registerFileType((FileType)KotlinFileType.INSTANCE, it);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private static final Map updateConfiguration$lambda$2$lambda$1(CompilerConfiguration $configuration) {
        return $configuration.getMap(ScriptingConfigurationKeys.INSTANCE.getLEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION());
    }

    private static final Unit updateConfiguration$lambda$2(CompilerConfiguration $configuration, ScriptingHostConfiguration.Builder $this$ScriptingHostConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$ScriptingHostConfiguration, (String)"$this$ScriptingHostConfiguration");
        $this$ScriptingHostConfiguration.invoke(ScriptCompilationConfigurationFromDefinitionKt.getGetEnvironment($this$ScriptingHostConfiguration), () -> ScriptingCompilerConfigurationExtension.updateConfiguration$lambda$2$lambda$1($configuration));
        return Unit.INSTANCE;
    }

    private static final boolean updateFileRegistry$lambda$5$lambda$3(CoreFileTypeRegistry $fileTypeRegistry, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)$fileTypeRegistry.getFileTypeByExtension(it), (Object)((Object)KotlinFileType.INSTANCE));
    }
}

