/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.GenerateMultifileFacadesKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/UpdateConstantFacadePropertyReferences;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "shouldGeneratePartHierarchy", "", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Z)V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getReplacementFacadeClassOrNull", "backend.jvm.lower"})
final class UpdateConstantFacadePropertyReferences
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    private final boolean shouldGeneratePartHierarchy;

    public UpdateConstantFacadePropertyReferences(@NotNull JvmBackendContext context2, boolean shouldGeneratePartHierarchy) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.shouldGeneratePartHierarchy = shouldGeneratePartHierarchy;
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        IrClass irClass2 = this.getReplacementFacadeClassOrNull(irClass);
        if (irClass2 == null) {
            return;
        }
        IrClass facadeClass = irClass2;
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, new IrElementTransformerVoid(facadeClass){
            final /* synthetic */ IrClass $facadeClass;
            {
                this.$facadeClass = $facadeClass;
            }

            public IrStatement visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return declaration;
            }

            public IrExpression visitClassReference(IrClassReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                return BuildersKt.IrClassReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), IrUtilsKt.getDefaultType(this.$facadeClass), this.$facadeClass.getSymbol(), IrUtilsKt.getDefaultType(this.$facadeClass));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IrClass getReplacementFacadeClassOrNull(IrClass irClass) {
        IrElement irElement;
        if (!Intrinsics.areEqual((Object)irClass.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_PROPERTY_REFERENCE()) && !Intrinsics.areEqual((Object)irClass.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL())) {
            return null;
        }
        IrElement callableReference = irClass.getAttributeOwnerId();
        if (callableReference instanceof IrPropertyReference) {
            Object object = ((IrPropertyReference)callableReference).getGetter();
            irElement = object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null ? (IrProperty)object.getOwner() : null;
        } else {
            if (!(callableReference instanceof IrFunctionReference)) return null;
            irElement = ((IrFunctionSymbol)((IrFunctionReference)callableReference).getSymbol()).getOwner();
        }
        if (irElement == null) {
            return null;
        }
        IrElement declaration = irElement;
        IrDeclarationParent irDeclarationParent = ((IrDeclarationBase)declaration).getParent();
        if (!(irDeclarationParent instanceof IrClass)) return null;
        IrClass irClass2 = (IrClass)irDeclarationParent;
        if (irClass2 == null) {
            return null;
        }
        IrClass parent2 = irClass2;
        IrClass facadeClass = JvmIrAttributesKt.getMultifileFacadeClassForPart(parent2);
        if (!this.shouldGeneratePartHierarchy) {
            if (!(declaration instanceof IrProperty)) return null;
            IrField irField = ((IrProperty)declaration).getBackingField();
            if (irField == null) return null;
            if (!GenerateMultifileFacadesKt.access$shouldMoveToFacade(irField)) return null;
            boolean bl = true;
            if (!bl) return null;
        }
        IrClass irClass3 = facadeClass;
        return irClass3;
    }
}

