/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryFallbackDependenciesModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.api.utils.errors.ExceptionAttachmentBuilderHelpersKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.ValueReferenceCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.LLFirBuiltinsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirAbstractSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirCommonSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirDanglingFileSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJvmSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirNativeSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCacheStorage;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirWasmSessionFactory;
import org.jetbrains.kotlin.platform.JsPlatform;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.WasmPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatform;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@LLFirInternals
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u0012j\u0002`\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0015H\u0002JK\u0010\u0016\u001a\u00020\f\"\b\b\u0000\u0010\u0017*\u00020\u000e2\u0006\u0010\r\u001a\u0002H\u00172\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u0012j\u0002`\u00132\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\f0\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010$\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u001e\u001a\u00020\u0010*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCacheStorage;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCacheStorage;)V", "(Lcom/intellij/openapi/project/Project;)V", "getStorage", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCacheStorage;", "getSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "module", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "preferBinary", "", "getBinaryLibraryCachedSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/SessionStorage;", "getDanglingFileCachedSession", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileModule;", "getCachedSession", "T", "factory", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "checkSessionValidity", "", "session", "supportsIsolatedSessionCreation", "getSupportsIsolatedSessionCreation", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Z", "createSession", "createPlatformAwareSessionFactory", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirAbstractSessionFactory;", "dispose", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n+ 2 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n+ 3 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n38#2,2:180\n38#2,2:182\n118#3,11:184\n57#3:195\n129#3,3:196\n1740#4,3:199\n1740#4,3:202\n1740#4,3:205\n1740#4,3:208\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n*L\n73#1:180,2\n90#1:182,2\n108#1:184,11\n108#1:195\n108#1:196,3\n142#1:199,3\n143#1:202,3\n144#1:205,3\n145#1:208,3\n*E\n"})
public final class LLFirSessionCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LLFirSessionCacheStorage storage;

    public LLFirSessionCache(@NotNull Project project, @NotNull LLFirSessionCacheStorage storage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.project = project;
        this.storage = storage;
    }

    @NotNull
    public final LLFirSessionCacheStorage getStorage() {
        return this.storage;
    }

    public LLFirSessionCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, LLFirSessionCacheStorage.Companion.createEmpty((Function1<? super LLFirSession, ? extends ValueReferenceCleaner<LLFirSession>>)((Function1)LLFirSessionCache::_init_$lambda$0)));
    }

    @NotNull
    public final LLFirSession getSession(@NotNull KaModule module2, boolean preferBinary) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        KaModule kaModule = module2;
        return kaModule instanceof KaBuiltinsModule && preferBinary ? (LLFirSession)LLFirBuiltinsSessionFactory.Companion.getInstance(this.project).getBuiltinsSession(module2.getTargetPlatform()) : (kaModule instanceof KaLibraryModule && preferBinary ? this.getBinaryLibraryCachedSession(module2, this.storage.getBinaryCache()) : (kaModule instanceof KaLibraryFallbackDependenciesModule ? this.getBinaryLibraryCachedSession(module2, this.storage.getLibraryFallbackDependenciesCache()) : (kaModule instanceof KaDanglingFileModule ? this.getDanglingFileCachedSession((KaDanglingFileModule)module2) : this.getCachedSession(module2, this.storage.getSourceCache(), (Function1)new Function1<KaModule, LLFirSession>((Object)this){

            public final LLFirSession invoke(KaModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
            }
        }))));
    }

    public static /* synthetic */ LLFirSession getSession$default(LLFirSessionCache lLFirSessionCache, KaModule kaModule, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lLFirSessionCache.getSession(kaModule, bl);
    }

    private final LLFirSession getBinaryLibraryCachedSession(KaModule module2, CleanableValueReferenceCache<KaModule, LLFirSession> storage) {
        return this.getCachedSession(module2, storage, arg_0 -> LLFirSessionCache.getBinaryLibraryCachedSession$lambda$1(this, module2, arg_0));
    }

    private final LLFirSession getDanglingFileCachedSession(KaDanglingFileModule module2) {
        if (KaModuleKt.isStable(module2)) {
            return this.getCachedSession((KaModule)module2, this.storage.getDanglingFileSessionCache(), (Function1)new Function1<KaModule, LLFirSession>((Object)this){

                public final LLFirSession invoke(KaModule p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
                }
            });
        }
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        LLFirSession session = this.storage.getUnstableDanglingFileSessionCache().compute(module2, (Function2<KaModule, LLFirSession, LLFirSession>)((Function2)(arg_0, arg_1) -> LLFirSessionCache.getDanglingFileCachedSession$lambda$2(this, module2, arg_0, arg_1)));
        if (session == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.checkSessionValidity(session);
        return session;
    }

    private final <T extends KaModule> LLFirSession getCachedSession(T module2, CleanableValueReferenceCache<KaModule, LLFirSession> storage, Function1<? super T, ? extends LLFirSession> factory2) {
        LLFirSession lLFirSession;
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        if (this.getSupportsIsolatedSessionCreation(module2)) {
            lLFirSession = storage.computeIfAbsent(module2, (Function1<KaModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$3(factory2, module2, arg_0)));
        } else {
            lLFirSession = storage.get(module2);
            if (lLFirSession == null) {
                LLFirSessionCache $this$getCachedSession_u24lambda_u245 = this;
                boolean bl = false;
                LLFirSession newSession = (LLFirSession)factory2.invoke(module2);
                lLFirSession = storage.computeIfAbsent(module2, (Function1<KaModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$5$lambda$4(newSession, arg_0)));
            }
        }
        LLFirSession session = lLFirSession;
        this.checkSessionValidity(session);
        return session;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSessionValidity(LLFirSession session) {
        boolean condition$iv = session.isValid();
        String attachmentName$iv = "info.txt";
        boolean $i$f$requireWithAttachment = false;
        if (!condition$iv) {
            void $this$requireWithAttachment_u24lambda_u242$iv;
            void $this$buildAttachment$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            boolean bl = false;
            String string = "A session acquired via `getSession` should always be valid.";
            KotlinIllegalArgumentExceptionWithAttachments exception$iv = new KotlinIllegalArgumentExceptionWithAttachments(string);
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = exception$iv;
            String name$iv$iv = attachmentName$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = name$iv$iv;
            void var12_14 = $this$buildAttachment$iv$iv;
            boolean bl2 = false;
            void $this$checkSessionValidity_u24lambda_u247 = $this$requireWithAttachment_u24lambda_u242$iv;
            boolean bl3 = false;
            ExceptionAttachmentBuilderHelpersKt.withKaModuleEntry((ExceptionAttachmentBuilder)$this$checkSessionValidity_u24lambda_u247, "module", session.getKtModule());
            var12_14.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw exception$iv;
        }
    }

    private final boolean getSupportsIsolatedSessionCreation(KaModule $this$supportsIsolatedSessionCreation) {
        return !($this$supportsIsolatedSessionCreation instanceof KaDanglingFileModule);
    }

    private final LLFirSession createSession(KaModule module2) {
        LLFirSession lLFirSession;
        LLFirAbstractSessionFactory sessionFactory = this.createPlatformAwareSessionFactory(module2);
        KaModule kaModule = module2;
        if (kaModule instanceof KaSourceModule) {
            lLFirSession = sessionFactory.createSourcesSession((KaSourceModule)module2);
        } else if (kaModule instanceof KaBuiltinsModule) {
            lLFirSession = sessionFactory.createResolvableLibrarySession(module2);
        } else if (kaModule instanceof KaLibraryModule) {
            lLFirSession = sessionFactory.createResolvableLibrarySession(module2);
        } else if (kaModule instanceof KaLibrarySourceModule) {
            lLFirSession = sessionFactory.createResolvableLibrarySession(module2);
        } else if (kaModule instanceof KaLibraryFallbackDependenciesModule) {
            lLFirSession = sessionFactory.createBinaryLibrarySession(module2);
        } else if (kaModule instanceof KaScriptModule) {
            lLFirSession = sessionFactory.createScriptSession((KaScriptModule)module2);
        } else if (kaModule instanceof KaDanglingFileModule) {
            LLFirSession contextSession = this.getSession(((KaDanglingFileModule)module2).getContextModule(), false);
            lLFirSession = sessionFactory.createDanglingFileSession((KaDanglingFileModule)module2, contextSession);
        } else if (kaModule instanceof KaNotUnderContentRootModule) {
            lLFirSession = sessionFactory.createNotUnderContentRootResolvableSession((KaNotUnderContentRootModule)module2);
        } else {
            throw new IllegalStateException(("Unexpected module kind: " + Reflection.getOrCreateKotlinClass(module2.getClass()).getSimpleName()).toString());
        }
        return lLFirSession;
    }

    private final LLFirAbstractSessionFactory createPlatformAwareSessionFactory(KaModule module2) {
        LLFirAbstractSessionFactory lLFirAbstractSessionFactory;
        SimplePlatform it;
        boolean bl;
        boolean $i$f$all;
        Iterable $this$all$iv;
        TargetPlatform targetPlatform;
        block18: {
            targetPlatform = module2.getTargetPlatform();
            $this$all$iv = targetPlatform;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (SimplePlatform)element$iv;
                    boolean bl2 = false;
                    if (it instanceof JvmPlatform) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            lLFirAbstractSessionFactory = new LLFirJvmSessionFactory(this.project);
        } else {
            boolean bl3;
            block19: {
                $this$all$iv = targetPlatform;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (SimplePlatform)element$iv;
                        boolean bl4 = false;
                        if (it instanceof JsPlatform) continue;
                        bl3 = false;
                        break block19;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                lLFirAbstractSessionFactory = new LLFirJsSessionFactory(this.project);
            } else {
                boolean bl5;
                block20: {
                    $this$all$iv = targetPlatform;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (SimplePlatform)element$iv;
                            boolean bl6 = false;
                            if (it instanceof WasmPlatform) continue;
                            bl5 = false;
                            break block20;
                        }
                        bl5 = true;
                    }
                }
                if (bl5) {
                    lLFirAbstractSessionFactory = new LLFirWasmSessionFactory(this.project);
                } else {
                    boolean bl7;
                    block21: {
                        $this$all$iv = targetPlatform;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                it = (SimplePlatform)element$iv;
                                boolean bl8 = false;
                                if (it instanceof NativePlatform) continue;
                                bl7 = false;
                                break block21;
                            }
                            bl7 = true;
                        }
                    }
                    lLFirAbstractSessionFactory = bl7 ? (LLFirAbstractSessionFactory)new LLFirNativeSessionFactory(this.project) : (LLFirAbstractSessionFactory)new LLFirCommonSessionFactory(this.project);
                }
            }
        }
        return lLFirAbstractSessionFactory;
    }

    public void dispose() {
    }

    private static final ValueReferenceCleaner _init_$lambda$0(LLFirSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LLFirSessionCleaner(it.getRequestedDisposableOrNull$low_level_api_fir());
    }

    private static final LLFirSession getBinaryLibraryCachedSession$lambda$1(LLFirSessionCache this$0, KaModule $module, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createPlatformAwareSessionFactory($module).createBinaryLibrarySession($module);
    }

    private static final LLFirSession getDanglingFileCachedSession$lambda$2(LLFirSessionCache this$0, KaDanglingFileModule $module, KaModule kaModule, LLFirSession existingSession) {
        Intrinsics.checkNotNullParameter((Object)kaModule, (String)"<unused var>");
        return existingSession instanceof LLFirDanglingFileSession && !((LLFirDanglingFileSession)existingSession).getHasFileModifications() ? existingSession : this$0.createSession($module);
    }

    private static final LLFirSession getCachedSession$lambda$3(Function1 $factory, KaModule $module, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LLFirSession)$factory.invoke((Object)$module);
    }

    private static final LLFirSession getCachedSession$lambda$5$lambda$4(LLFirSession $newSession, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $newSession;
    }

    public static final /* synthetic */ LLFirSession access$createSession(LLFirSessionCache $this, KaModule module2) {
        return $this.createSession(module2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    @SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,179:1\n31#2,2:180\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion\n*L\n40#1:180,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LLFirSessionCache> serviceClass$iv = LLFirSessionCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LLFirSessionCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

