/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueKt;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubOrigin;

public class KtPropertyElementType
extends KtStubElementType<KotlinPropertyStub, KtProperty> {
    public KtPropertyElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtPropertyElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtProperty.class, KotlinPropertyStub.class);
    }

    @NotNull
    public KotlinPropertyStub createStub(@NotNull KtProperty psi, StubElement parentStub) {
        if (psi == null) {
            KtPropertyElementType.$$$reportNull$$$0(1);
        }
        assert (!psi.isLocal()) : String.format("Should not store local property: %s, parent %s", psi.getText(), psi.getParent() != null ? psi.getParent().getText() : "<no parent>");
        Boolean hasBackingField = StubUtils.searchForHasBackingFieldComment$psi(psi);
        return new KotlinPropertyStubImpl((StubElement<? extends PsiElement>)parentStub, StringRef.fromString((String)psi.getName()), psi.isVar(), psi.isTopLevel(), psi.hasDelegate(), psi.hasDelegateExpression(), psi.hasInitializer(), psi.getReceiverTypeReference() != null, psi.getTypeReference() != null, KtPsiUtilKt.safeFqNameForLazyResolve(psi), null, null, hasBackingField);
    }

    public void serialize(@NotNull KotlinPropertyStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub2 == null) {
            KtPropertyElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            KtPropertyElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub2.getName());
        dataStream.writeBoolean(stub2.isVar());
        dataStream.writeBoolean(stub2.isTopLevel());
        dataStream.writeBoolean(stub2.hasDelegate());
        dataStream.writeBoolean(stub2.hasDelegateExpression());
        dataStream.writeBoolean(stub2.hasInitializer());
        dataStream.writeBoolean(stub2.isExtension());
        dataStream.writeBoolean(stub2.hasReturnTypeRef());
        FqName fqName = stub2.getFqName();
        dataStream.writeName(fqName != null ? fqName.asString() : null);
        if (stub2 instanceof KotlinPropertyStubImpl) {
            KotlinPropertyStubImpl stubImpl = (KotlinPropertyStubImpl)stub2;
            ConstantValue<?> constantInitializer = ((KotlinPropertyStubImpl)stub2).getConstantInitializer();
            KotlinConstantValueKt.serializeConstantValue(constantInitializer, dataStream);
            KotlinStubOrigin.serialize(stubImpl.getOrigin(), dataStream);
        }
        StubUtils.writeNullableBoolean$psi(dataStream, stub2.getHasBackingField());
    }

    @NotNull
    public KotlinPropertyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtPropertyElementType.$$$reportNull$$$0(4);
        }
        StringRef name2 = dataStream.readName();
        boolean isVar = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        boolean hasDelegate = dataStream.readBoolean();
        boolean hasDelegateExpression = dataStream.readBoolean();
        boolean hasInitializer = dataStream.readBoolean();
        boolean hasReceiverTypeRef = dataStream.readBoolean();
        boolean hasReturnTypeRef = dataStream.readBoolean();
        StringRef fqNameAsString = dataStream.readName();
        FqName fqName = fqNameAsString != null ? new FqName(fqNameAsString.toString()) : null;
        ConstantValue<?> constantInitializer = KotlinConstantValueKt.deserializeConstantValue(dataStream);
        KotlinStubOrigin stubOrigin = KotlinStubOrigin.deserialize(dataStream);
        Boolean hasBackingFiled = StubUtils.readNullableBoolean$psi(dataStream);
        return new KotlinPropertyStubImpl((StubElement<? extends PsiElement>)parentStub, name2, isVar, isTopLevel, hasDelegate, hasDelegateExpression, hasInitializer, hasReceiverTypeRef, hasReturnTypeRef, fqName, constantInitializer, stubOrigin, hasBackingFiled);
    }

    @Override
    public void indexStub(@NotNull KotlinPropertyStub stub2, @NotNull IndexSink sink) {
        if (stub2 == null) {
            KtPropertyElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            KtPropertyElementType.$$$reportNull$$$0(6);
        }
        StubIndexService.getInstance().indexProperty(stub2, sink);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

