/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.ApplicableVariants;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ComparisonChain;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u000eB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\u000fB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\u0010B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\u0011B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\u0012B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\u0013B\t\b\u0016\u00a2\u0006\u0004\b\f\u0010\u0014J\u0006\u0010/\u001a\u00020\u0005J\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=J\u000e\u0010[\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010)\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010*J\u0010\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\\\u001a\u00020]2\u0006\u0010T\u001a\u00020UJ\u0006\u0010\\\u001a\u00020]J\u0011\u0010^\u001a\u0002052\u0006\u0010_\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010`\u001a\u00020C2\b\u0010_\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010a\u001a\u000205H\u0016J\b\u0010b\u001a\u00020\u0005H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b9\u00107R\u0011\u0010:\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b;\u00107R\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001c\u0010H\u001a\u0004\u0018\u00010IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001c\u0010N\u001a\u0004\u0018\u00010OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u001c\u0010T\u001a\u0004\u0018\u00010UX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010Y\u00a8\u0006c"}, d2={"Lcom/android/tools/lint/detector/api/Incident;", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "message", "", "location", "Lcom/android/tools/lint/detector/api/Location;", "scope", "", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "<init>", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/Object;Lcom/android/tools/lint/detector/api/LintFix;)V", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;)V", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;Lcom/android/tools/lint/detector/api/LintFix;)V", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;Lcom/android/tools/lint/detector/api/LintFix;)V", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/Object;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/Object;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;Lcom/android/tools/lint/detector/api/LintFix;)V", "()V", "getIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "setIssue", "(Lcom/android/tools/lint/detector/api/Issue;)V", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "getLocation", "()Lcom/android/tools/lint/detector/api/Location;", "setLocation", "(Lcom/android/tools/lint/detector/api/Location;)V", "getScope", "()Ljava/lang/Object;", "setScope", "(Ljava/lang/Object;)V", "getFix", "()Lcom/android/tools/lint/detector/api/LintFix;", "setFix", "(Lcom/android/tools/lint/detector/api/LintFix;)V", "project", "Lcom/android/tools/lint/detector/api/Project;", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "setProject", "(Lcom/android/tools/lint/detector/api/Project;)V", "getDisplayPath", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "line", "", "getLine", "()I", "startOffset", "getStartOffset", "endOffset", "getEndOffset", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "getSeverity", "()Lcom/android/tools/lint/detector/api/Severity;", "setSeverity", "(Lcom/android/tools/lint/detector/api/Severity;)V", "wasAutoFixed", "", "getWasAutoFixed", "()Z", "setWasAutoFixed", "(Z)V", "applicableVariants", "Lcom/android/tools/lint/detector/api/ApplicableVariants;", "getApplicableVariants", "()Lcom/android/tools/lint/detector/api/ApplicableVariants;", "setApplicableVariants", "(Lcom/android/tools/lint/detector/api/ApplicableVariants;)V", "clientProperties", "Lcom/android/tools/lint/detector/api/LintMap;", "getClientProperties", "()Lcom/android/tools/lint/detector/api/LintMap;", "setClientProperties", "(Lcom/android/tools/lint/detector/api/LintMap;)V", "context", "Lcom/android/tools/lint/detector/api/Context;", "getContext$lint_api", "()Lcom/android/tools/lint/detector/api/Context;", "setContext$lint_api", "(Lcom/android/tools/lint/detector/api/Context;)V", "overrideSeverity", "at", "report", "", "compareTo", "other", "equals", "hashCode", "toString", "lint-api"})
public final class Incident
implements Comparable<Incident> {
    @NotNull
    private Issue issue;
    @NotNull
    private String message;
    @NotNull
    private Location location;
    @Nullable
    private Object scope;
    @Nullable
    private LintFix fix;
    @Nullable
    private Project project;
    @NotNull
    private Severity severity;
    private boolean wasAutoFixed;
    @Nullable
    private ApplicableVariants applicableVariants;
    @Nullable
    private LintMap clientProperties;
    @Nullable
    private transient Context context;

    public Incident(@NotNull Issue issue, @NotNull String message2, @NotNull Location location2, @Nullable Object scope, @Nullable LintFix fix) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        this.issue = issue;
        this.message = message2;
        this.location = location2;
        this.scope = scope;
        this.fix = fix;
        this.severity = this.issue.getDefaultSeverity();
    }

    public /* synthetic */ Incident(Issue issue, String string, Location location2, Object object, LintFix lintFix, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            object = location2.getSource();
        }
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        this(issue, string, location2, object, lintFix);
    }

    @NotNull
    public final Issue getIssue() {
        return this.issue;
    }

    public final void setIssue(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"<set-?>");
        this.issue = issue;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.message = string;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    public final void setLocation(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"<set-?>");
        this.location = location2;
    }

    @Nullable
    public final Object getScope() {
        return this.scope;
    }

    public final void setScope(@Nullable Object object) {
        this.scope = object;
    }

    @Nullable
    public final LintFix getFix() {
        return this.fix;
    }

    public final void setFix(@Nullable LintFix lintFix) {
        this.fix = lintFix;
    }

    public Incident(@NotNull Issue issue, @NotNull String message2, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        this(issue, message2, location2, (Object)null, null);
    }

    public Incident(@NotNull Issue issue, @NotNull String message2, @NotNull Location location2, @Nullable LintFix fix) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        this(issue, message2, location2, (Object)null, fix);
    }

    public Incident(@NotNull Issue issue, @NotNull Location location2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this(issue, message2, location2, (Object)null, null);
    }

    public Incident(@NotNull Issue issue, @NotNull Location location2, @NotNull String message2, @Nullable LintFix fix) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this(issue, message2, location2, (Object)null, fix);
    }

    public Incident(@NotNull Issue issue, @NotNull Object scope, @NotNull Location location2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this(issue, message2, location2, scope, null);
    }

    public Incident(@NotNull Issue issue, @NotNull Object scope, @NotNull Location location2, @NotNull String message2, @Nullable LintFix fix) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this(issue, message2, location2, scope, fix);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@Nullable Project project) {
        this.project = project;
    }

    @NotNull
    public final String getDisplayPath() {
        Object object = this.project;
        if (object == null || (object = ((Project)object).getDisplayPath(this.getFile())) == null) {
            String string = this.getFile().getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        }
        return object;
    }

    @NotNull
    public final File getFile() {
        return this.location.getFile();
    }

    public final int getLine() {
        Position position = this.location.getStart();
        return position != null ? position.getLine() : -1;
    }

    public final int getStartOffset() {
        Position position = this.location.getStart();
        return position != null ? position.getOffset() : -1;
    }

    public final int getEndOffset() {
        Position position = this.location.getEnd();
        return position != null ? position.getOffset() : this.getStartOffset();
    }

    @NotNull
    public final Severity getSeverity() {
        return this.severity;
    }

    public final void setSeverity(@NotNull Severity severity) {
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"<set-?>");
        this.severity = severity;
    }

    public final boolean getWasAutoFixed() {
        return this.wasAutoFixed;
    }

    public final void setWasAutoFixed(boolean bl) {
        this.wasAutoFixed = bl;
    }

    @Nullable
    public final ApplicableVariants getApplicableVariants() {
        return this.applicableVariants;
    }

    public final void setApplicableVariants(@Nullable ApplicableVariants applicableVariants) {
        this.applicableVariants = applicableVariants;
    }

    @Nullable
    public final LintMap getClientProperties() {
        return this.clientProperties;
    }

    public final void setClientProperties(@Nullable LintMap lintMap) {
        this.clientProperties = lintMap;
    }

    @Nullable
    public final Context getContext$lint_api() {
        return this.context;
    }

    public final void setContext$lint_api(@Nullable Context context2) {
        this.context = context2;
    }

    public Incident() {
        this(IssueRegistry.LINT_ERROR, "<missing>", Location.NONE);
    }

    @NotNull
    public final Incident issue(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        if (Intrinsics.areEqual((Object)this.issue, (Object)IssueRegistry.LINT_ERROR)) {
            this.severity = issue.getDefaultSeverity();
        }
        this.issue = issue;
        return this;
    }

    @NotNull
    public final Incident message(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.message = message2;
        return this;
    }

    @NotNull
    public final Incident location(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        this.location = location2;
        return this;
    }

    @NotNull
    public final Incident overrideSeverity(@NotNull Severity severity) {
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        this.severity = severity;
        return this;
    }

    @NotNull
    public final Incident at(@NotNull Object scope) {
        Location location2;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Context context2 = this.context;
        if (context2 == null) {
            throw new IllegalStateException("This method can only be used when the Incident(context) is used".toString());
        }
        Context context3 = context2;
        this.scope = scope;
        Object object = scope;
        if (object instanceof UElement) {
            JavaContext javaContext = context3 instanceof JavaContext ? (JavaContext)context3 : null;
            if (javaContext == null) {
                throw new IllegalStateException("Associated context must be a JavaContext".toString());
            }
            JavaContext javaContext2 = javaContext;
            location2 = scope instanceof UClass || scope instanceof UMethod ? javaContext2.getNameLocation((UDeclaration)scope) : javaContext2.getLocation((UElement)scope);
        } else if (object instanceof PsiElement) {
            JavaContext javaContext = context3 instanceof JavaContext ? (JavaContext)context3 : null;
            if (javaContext == null) {
                throw new IllegalStateException("Associated context must be a JavaContext".toString());
            }
            JavaContext javaContext3 = javaContext;
            Location location3 = scope instanceof PsiClass || scope instanceof PsiMethod ? javaContext3.getNameLocation((PsiElement)scope) : javaContext3.getLocation((PsiElement)scope);
            location2 = javaContext3.getLocation((PsiElement)scope);
        } else if (object instanceof Node) {
            XmlContext xmlContext = context3 instanceof XmlContext ? (XmlContext)context3 : null;
            if (xmlContext == null) {
                throw new IllegalStateException("Associated context must be a JavaContext".toString());
            }
            XmlContext xmlContext2 = xmlContext;
            location2 = xmlContext2.getLocation((Node)scope);
        } else if (context3 instanceof GradleContext) {
            location2 = ((GradleContext)context3).getLocation(scope);
        } else {
            throw new IllegalStateException(("Could not compute a location for scope element " + scope + "; if necessary use one of the Context.getLocation methods").toString());
        }
        this.location = location2;
        return this;
    }

    @NotNull
    public final Incident scope(@Nullable Object scope) {
        this.scope = scope;
        return this;
    }

    @NotNull
    public final Incident project(@Nullable Project project) {
        this.project = project;
        return this;
    }

    @NotNull
    public final Incident fix(@Nullable LintFix fix) {
        this.fix = fix;
        return this;
    }

    public final void report(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        context2.report(this);
    }

    public final void report() {
        Context context2 = this.context;
        if (context2 == null) {
            throw new IllegalStateException("This method can only be used when the Incident(context) is used".toString());
        }
        Context context3 = context2;
        context3.report(this);
    }

    @Override
    public int compareTo(@NotNull Incident other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String fileName1 = this.getFile().getName();
        String fileName2 = other.getFile().getName();
        Position start1 = this.location.getStart();
        Position start2 = other.location.getStart();
        Position position = start1;
        Integer col1 = position != null ? Integer.valueOf(position.getColumn()) : null;
        Position position2 = start2;
        Integer col2 = position2 != null ? Integer.valueOf(position2.getColumn()) : null;
        Location secondary1 = this.location.getSecondary();
        Location secondary2 = other.location.getSecondary();
        Location location2 = secondary1;
        File secondFile1 = location2 != null ? location2.getFile() : null;
        Location location3 = secondary2;
        File secondFile2 = location3 != null ? location3.getFile() : null;
        Comparator comparator = Comparator.nullsLast(Comparator.naturalOrder());
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"nullsLast(...)");
        Comparator nullableIntComparator = comparator;
        Position position3 = this.location.getEnd();
        Position position4 = other.location.getEnd();
        Position position5 = this.location.getEnd();
        Position position6 = other.location.getEnd();
        return ComparisonChain.start().compare((Comparable)this.issue.getCategory(), (Comparable)other.issue.getCategory()).compare((Object)this.issue.getPriority(), (Object)other.issue.getPriority(), Comparator.reverseOrder()).compare((Comparable)((Object)this.issue.getId()), (Comparable)((Object)other.issue.getId())).compare((Comparable)((Object)other.severity), (Comparable)((Object)this.severity)).compare((Object)fileName1, (Object)fileName2, Comparator.nullsLast(Comparator.naturalOrder())).compare(this.getLine(), other.getLine()).compare((Comparable)((Object)this.message), (Comparable)((Object)other.message)).compare((Object)this.getFile(), (Object)other.getFile(), Comparator.nullsLast(Comparator.naturalOrder())).compare((Object)col1, (Object)col2, nullableIntComparator).compare((Object)secondFile1, (Object)secondFile2, Comparator.nullsLast(Comparator.naturalOrder())).compare((Object)(position3 != null ? Integer.valueOf(position3.getLine()) : null), (Object)(position4 != null ? Integer.valueOf(position4.getLine()) : null), nullableIntComparator).compare((Object)(position5 != null ? Integer.valueOf(position5.getColumn()) : null), (Object)(position6 != null ? Integer.valueOf(position6.getColumn()) : null), nullableIntComparator).result();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other == null || !Intrinsics.areEqual(this.getClass(), other.getClass()) ? false : this.compareTo((Incident)other) == 0;
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 31 * result + this.getFile().getPath().hashCode();
        result = 31 * result + this.getLine();
        return result;
    }

    @NotNull
    public String toString() {
        Object object = this.project;
        if (object == null || (object = ((Project)object).getDisplayPath(this.getFile())) == null) {
            object = this.getFile();
        }
        return "Incident(\n issue='" + this.issue + "',\n message='" + this.message + "',\n file=" + object + ",\n line=" + this.getLine() + "\n)";
    }
}

